import { Component } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "../../services/model.service";
import * as i2 from "../../services/sti-user-service";
export class StiAboutWindowComponent {
    get align() {
        return "start";
    }
    get version() {
        return this.model.assemblyInfo
            ? this.model.assemblyInfo["version"].slice(0, this.model.assemblyInfo["version"].lastIndexOf("."))
            : "2022.4.1";
    }
    get releaseDate() {
        return this.model.assemblyInfo ? this.model.assemblyInfo["creationDate"] : " 27 Semptember 2022";
    }
    get copyright() {
        return this.model.assemblyInfo ? this.model.assemblyInfo["copyright"] : "";
    }
    get userMail() {
        return this.userService.currentUser
            ? this.userService.currentUser.userName
            : this.model.userName
                ? this.model.userName
                : "";
    }
    get hasLicense() {
        return this.userService.licenseProducts.find((product) => product.ident == "Ultimate" ||
            product.ident == "FormsWeb" ||
            product.ident == 1 ||
            product.ident == 4 ||
            product.ident == "BICloud" ||
            product.ident == 18);
    }
    constructor(model, userService) {
        this.model = model;
        this.userService = userService;
    }
    close() {
        this.model.showAboutWindow = false;
    }
    ngOnInit() { }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiAboutWindowComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiUserService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: StiAboutWindowComponent, selector: "sti-about-window-component", ngImport: i0, template: `
    <div class="about-window">
      <div class="close-bar">
        <div class="close-button" (click)="close()"><img [src]="model.getImage('images.Other.CloseForm.png')" /></div>
      </div>
      <div class="content">
        <span [style.margin-bottom]="'20px'" [style.color]="'rgb(0,112,184)'" [style.font-size]="'24px'"
          >Stimulsoft PDF Forms</span
        >
        <img [src]="model.getImage('images.Other.About.png')" alt="" />
        <span [style.margin-top]="'20px'">{{ copyright }}</span>
        <span>Version: {{ version }} from {{ releaseDate }}, Angular</span>
        <span> All rights reserved</span>
        <span [style.font-weight]="'bold'" [style.color]="!hasLicense ? 'red' : ''">{{
          userMail + (userMail && !hasLicense ? ", " : "") + (!hasLicense ? "Trial Version" : "")
        }}</span>
        <a href="http://stimulsoft.com" target="_blank">www.stimulsoft.com</a>
      </div>
    </div>
  `, isInline: true, styles: ["a{margin-top:15px;font-size:12px;color:#3a90ff}span{margin:10px;font-size:12px}.about-window{-webkit-touch-callout:none;-webkit-user-select:none;font-family:Arial;position:absolute;z-index:1000;left:calc(50% - 275px);top:calc(50% - 190px);background-color:#fff;width:550px;height:380px;border-radius:5px;border:1px solid rgb(25,71,138);-moz-box-shadow:0px 0px 7px rgba(0,0,0,.6);-webkit-box-shadow:0px 0px 7px rgb(0 0 0 / 60%);box-shadow:0 0 7px #0000004d;padding:0}.close-bar{height:30px;width:100%;display:flex;flex-direction:row-reverse}.close-button{padding:0;margin:0;border-top-right-radius:5px;height:30px;width:30px;background-color:#fff;display:flex;align-items:center;justify-content:center}.close-button img{height:16px;width:16px}.close-button:hover{background-color:#e81123}.close-button:hover img{filter:brightness(0) invert(1)}.content{display:flex;flex-direction:column;height:100%;align-items:center}img{height:100px;width:100px}\n"] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiAboutWindowComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-about-window-component", template: `
    <div class="about-window">
      <div class="close-bar">
        <div class="close-button" (click)="close()"><img [src]="model.getImage('images.Other.CloseForm.png')" /></div>
      </div>
      <div class="content">
        <span [style.margin-bottom]="'20px'" [style.color]="'rgb(0,112,184)'" [style.font-size]="'24px'"
          >Stimulsoft PDF Forms</span
        >
        <img [src]="model.getImage('images.Other.About.png')" alt="" />
        <span [style.margin-top]="'20px'">{{ copyright }}</span>
        <span>Version: {{ version }} from {{ releaseDate }}, Angular</span>
        <span> All rights reserved</span>
        <span [style.font-weight]="'bold'" [style.color]="!hasLicense ? 'red' : ''">{{
          userMail + (userMail && !hasLicense ? ", " : "") + (!hasLicense ? "Trial Version" : "")
        }}</span>
        <a href="http://stimulsoft.com" target="_blank">www.stimulsoft.com</a>
      </div>
    </div>
  `, styles: ["a{margin-top:15px;font-size:12px;color:#3a90ff}span{margin:10px;font-size:12px}.about-window{-webkit-touch-callout:none;-webkit-user-select:none;font-family:Arial;position:absolute;z-index:1000;left:calc(50% - 275px);top:calc(50% - 190px);background-color:#fff;width:550px;height:380px;border-radius:5px;border:1px solid rgb(25,71,138);-moz-box-shadow:0px 0px 7px rgba(0,0,0,.6);-webkit-box-shadow:0px 0px 7px rgb(0 0 0 / 60%);box-shadow:0 0 7px #0000004d;padding:0}.close-bar{height:30px;width:100%;display:flex;flex-direction:row-reverse}.close-button{padding:0;margin:0;border-top-right-radius:5px;height:30px;width:30px;background-color:#fff;display:flex;align-items:center;justify-content:center}.close-button img{height:16px;width:16px}.close-button:hover{background-color:#e81123}.close-button:hover img{filter:brightness(0) invert(1)}.content{display:flex;flex-direction:column;height:100%;align-items:center}img{height:100px;width:100px}\n"] }]
        }], ctorParameters: () => [{ type: i1.StiModelService }, { type: i2.StiUserService }] });
//# sourceMappingURL=data:application/json;base64,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