import { Component, Input } from "@angular/core";
import { StiComboBoxColumnItem } from "../../../../../elements/table/columns/StiComboBoxColumnItem";
import { StiLabelColumnItem } from "../../../../../elements/table/columns/StiLabelColumnItem";
import { StiNumberBoxColumnItem } from "../../../../../elements/table/columns/StiNumberBoxColumnItem";
import { StiColumnItem } from "../../../../../elements/table/StiColumnItem";
import { StiTotalsFieldItem } from "../../../../../elements/table/StiTotalsFieldItem";
import { StiLocalizationService } from "../../../../../services/sti-localization.service";
import { StiNumberType } from "../../../../../system/enums";
import { SlideInOutAnimation } from "../../../../animations/animations";
import * as i0 from "@angular/core";
import * as i1 from "../../../../../services/model.service";
import * as i2 from "../../../../../services/sti-helper.service";
import * as i3 from "../../../../../services/theme.service";
import * as i4 from "../../../../../services/sti-localization.service";
import * as i5 from "@angular/common";
import * as i6 from "../../sti-bool-editor/sti-bool-editor.component";
import * as i7 from "../../sti-color-editor/sti-color-editor.component";
import * as i8 from "../../sti-enum-editor/sti-enum-editor.component";
import * as i9 from "../../sti-font-editor/sti-font-editor.component";
import * as i10 from "../../sti-multiline-string-editor/sti-multiline-string-editor.component";
import * as i11 from "../../sti-number-editor/sti-number-editor.component";
import * as i12 from "../../sti-text-editor/sti-text-editor.component";
import * as i13 from "../../sti-horizontal-alignment-editor/sti-horizontal-alignment-editor";
import * as i14 from "../../sti-select-button-editor.component";
import * as i15 from "../../../../sti-divider/sti-divider.component";
export class StiTableColumnEditorComponent {
    constructor(model, helper, theme, loc) {
        this.model = model;
        this.helper = helper;
        this.theme = theme;
        this.loc = loc;
        this.properties = [];
    }
    ngOnInit() {
        this.updateProperties();
        this.model.needToRefreshInnerProperties.subscribe(() => this.updateProperties());
    }
    needToDisable(property) {
        if (this.column instanceof StiLabelColumnItem || this.column instanceof StiTotalsFieldItem) {
            if (this.column.prefix.length > 0 && property.property == "suffix") {
                return true;
            }
            else if (this.column.suffix.length > 0 && property.property == "prefix") {
                return true;
            }
            else {
                return false;
            }
        }
        else {
            return false;
        }
    }
    updateProperties() {
        this.properties = [];
        if (this.column instanceof StiColumnItem) {
            this.properties.push({ type: "enum", property: "type", label: this.loc.getP("Type") });
            this.properties.push({ type: "TextEditor", property: "label", label: this.loc.getP("Label") });
            if (this.column instanceof StiLabelColumnItem) {
                this.properties.push({ type: "TextEditor", property: "expression", label: this.loc.getP("Expression") });
            }
            this.properties.push({ type: "divider" });
            this.properties.push({ type: "FontEditor", property: "font", label: this.loc.getP("Header") });
            this.properties.push({ type: "color", property: "headerBackColor", label: this.loc.getP("BackColor") });
            this.properties.push({ type: "color", property: "headerForeColor", label: this.loc.getP("ForeColor") });
            this.properties.push({
                type: "horizontalAlignment",
                property: "headerAlignment",
                label: this.loc.getP("Alignment"),
            });
            this.properties.push({
                type: "checkbox",
                property: "useWordWrap",
                checkbox: StiLocalizationService.get("PropertyEnum", "StiTextSizeModeWordWrap"),
                label: " ",
            });
            this.properties.push({ type: "divider" });
            if (!(this.column instanceof StiComboBoxColumnItem)) {
                this.properties.push({
                    type: "horizontalAlignment",
                    property: "cellAlignment",
                    label: this.loc.getP("Cell") + " " + this.loc.getP("Alignment"),
                });
            }
            if (this.column instanceof StiComboBoxColumnItem) {
                this.properties.push({
                    type: "MultilineEditor",
                    property: "comboBoxOptions",
                    label: this.loc.getP("Options"),
                });
            }
            if (this.column instanceof StiNumberBoxColumnItem || this.column instanceof StiLabelColumnItem) {
                if (this.column instanceof StiNumberBoxColumnItem) {
                    this.properties.push({
                        type: "enum",
                        property: "numberType",
                        label: StiLocalizationService.get("PropertyMain", "ValueType"),
                    });
                }
                this.properties.push({
                    type: "enum",
                    property: "thousandSeparator",
                    label: this.loc.get2("Export", "Separator").replace(":", ""),
                });
                this.properties.push({
                    type: "Number",
                    property: "decimalDigits",
                    label: this.loc.get2("FormFormatEditor", "DecimalDigits").replace(":", ""),
                });
                if (this.column instanceof StiLabelColumnItem) {
                    this.properties.push({
                        type: "TextEditor",
                        property: "prefix",
                        label: StiLocalizationService.get("PropertyMain", "Prefix"),
                    });
                    this.properties.push({
                        type: "TextEditor",
                        property: "suffix",
                        label: StiLocalizationService.get("PropertyMain", "Suffix"),
                    });
                }
                if (this.column instanceof StiNumberBoxColumnItem && this.column.numberType == StiNumberType.Decimal) {
                    this.properties.push({
                        type: "TextEditor",
                        property: "unitLabel",
                        label: StiLocalizationService.get("PropertyMain", "Unit"),
                    });
                    this.properties.push({
                        type: "enum",
                        property: "unitAlignment",
                        label: StiLocalizationService.get("PropertyMain", "UnitAlignment"),
                    });
                }
                else if (this.column instanceof StiNumberBoxColumnItem && this.column.numberType == StiNumberType.Currency) {
                    this.properties.push({
                        type: "enum",
                        property: "currency",
                        label: StiLocalizationService.get("FormFormatEditor", "Currency"),
                    });
                    this.properties.push({
                        type: "enum",
                        property: "unitAlignment",
                        label: StiLocalizationService.get("PropertyMain", "UnitAlignment"),
                    });
                    this.properties.push({
                        type: "labelFormat",
                        property: "currencyLabelFormat",
                        label: StiLocalizationService.get("PropertyMain", "ShowAs"),
                    });
                }
            }
            this.properties.push({ type: "color", property: "backgroundColor", label: this.loc.getP("BackColor") });
            this.properties.push({ type: "color", property: "cellBackColor", label: this.loc.getP("CellBackColor") });
            this.properties.push({ type: "color", property: "cellForeColor", label: this.loc.getP("CellForeColor") });
            if (!(this.column instanceof StiLabelColumnItem)) {
                this.properties.push({ type: "color", property: "cellBorderColor", label: this.loc.getP("BorderColor") });
            }
        }
        else if (this.column instanceof StiTotalsFieldItem) {
            this.properties.push({ type: "TextEditor", property: "header", label: this.loc.getP("Header") });
            this.properties.push({ type: "TextEditor", property: "expression", label: this.loc.getP("Expression") });
            this.properties.push({
                type: "horizontalAlignment",
                property: "headerAlignment",
                label: this.loc.getP("HeaderAlignment"),
            });
            this.properties.push({
                type: "horizontalAlignment",
                property: "valueAlignment",
                label: this.loc.getP("Value") + " " + this.loc.getP("Alignment"),
            });
            this.properties.push({ type: "color", property: "headerColor", label: " " });
            this.properties.push({
                type: "enum",
                property: "thousandSeparator",
                label: this.loc.get2("Export", "Separator").replace(":", ""),
            });
            this.properties.push({
                type: "Number",
                property: "decimalDigits",
                label: this.loc.get2("FormFormatEditor", "DecimalDigits").replace(":", ""),
            });
            this.properties.push({
                type: "TextEditor",
                property: "prefix",
                label: StiLocalizationService.get("PropertyMain", "Prefix"),
            });
            this.properties.push({
                type: "TextEditor",
                property: "suffix",
                label: StiLocalizationService.get("PropertyMain", "Suffix"),
            });
        }
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiTableColumnEditorComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiHelperService }, { token: i3.StiThemeService }, { token: i4.StiLocalizationService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: StiTableColumnEditorComponent, selector: "sti-table-column-editor", inputs: { column: "column", state: "state", index: "index", expression: "expression" }, ngImport: i0, template: `
    <div [@slideInOut]="state ? 'in' : 'out'" class="column-editor">
      <table class="sti-clear" [style]="{ width: '100%' }">
        <tr *ngFor="let property of properties">
          <td *ngIf="property.label" [style.vertical-align]="property.type == 'FontEditor' ? 'top' : ''">
            <div class="label" [style.margin-top.px]="index == '0' ? 5 : 0">
              {{ property.label }}
            </div>
          </td>
          <td [colSpan]="property.type === 'divider' ? 8 : ''">
            <sti-font-editor
              *ngIf="property.type === 'FontEditor'"
              [object]="column"
              [property]="property"
            ></sti-font-editor>
            <sti-text-editor
              *ngIf="property.type === 'TextEditor'"
              [object]="column"
              [property]="property"
              [disabled]="needToDisable(property)"
            ></sti-text-editor>
            <sti-horizontal-alignment-editor
              [property]="property"
              *ngIf="property.type === 'horizontalAlignment'"
              [style]="{ width: '95%' }"
              [object]="column"
            ></sti-horizontal-alignment-editor>
            <sti-color-editor
              *ngIf="property.type === 'color'"
              [obj]="column"
              [property]="property"
              [style]="{ width: '95%' }"
            ></sti-color-editor>
            <sti-enum-editor
              *ngIf="property.type === 'enum'"
              [property]="property"
              [style]="{ width: '95%' }"
              [object]="column"
              [index]="index"
            ></sti-enum-editor>
            <sti-bool-editor
              [property]="property"
              *ngIf="property.type === 'checkbox'"
              [style]="{ width: '95%' }"
              [object]="column"
            ></sti-bool-editor>
            <sti-multiline-string-editor
              *ngIf="property.type === 'MultilineEditor'"
              [property]="property"
              [object]="column"
            ></sti-multiline-string-editor>
            <sti-number-editor
              *ngIf="property.type === 'Number'"
              [obj]="column"
              [property]="property"
            ></sti-number-editor>
            <sti-select-button-editor
              *ngIf="property.type === 'labelFormat'"
              [propertyType]="property.type"
              [object]="column"
              [property]="property.property"
            >
            </sti-select-button-editor>
            <sti-divider *ngIf="property.type === 'divider'"></sti-divider>
          </td>
        </tr>
      </table>
    </div>
    <style>
      tr {
        padding: 3px 0px 3px 0px;
      }
      .label {
        font-size: 13px;
        font-weight: normal;
        min-width: 150px;
        white-space: nowrap;
        color: var(--property-label-color);
        -webkit-touch-callout: none;
        -webkit-user-select: none;
      }
      .column-editor {
        overflow: hidden;
      }
      img {
        height: 16px;
        width: 16px;
        vertical-align: bottom;
      }
    </style>
  `, isInline: true, styles: ["\n      tr {\n        padding: 3px 0px 3px 0px;\n      }\n      .label {\n        font-size: 13px;\n        font-weight: normal;\n        min-width: 150px;\n        white-space: nowrap;\n        color: var(--property-label-color);\n        -webkit-touch-callout: none;\n        -webkit-user-select: none;\n      }\n      .column-editor {\n        overflow: hidden;\n      }\n      img {\n        height: 16px;\n        width: 16px;\n        vertical-align: bottom;\n      }\n    "], dependencies: [{ kind: "directive", type: i5.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i5.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i6.StiBoolEditorComponent, selector: "sti-bool-editor", inputs: ["property", "object"] }, { kind: "component", type: i7.StiColorEditorComponent, selector: "sti-color-editor", inputs: ["property", "textColor", "obj"] }, { kind: "component", type: i8.StiEnumEditorComponent, selector: "sti-enum-editor", inputs: ["property", "object", "index"] }, { kind: "component", type: i9.StiFontEditorComponent, selector: "sti-font-editor", inputs: ["property", "object"] }, { kind: "component", type: i10.StiMultilineStringEditorComponent, selector: "sti-multiline-string-editor", inputs: ["property", "object"] }, { kind: "component", type: i11.StiNumberEditorComponent, selector: "sti-number-editor", inputs: ["property", "obj"] }, { kind: "component", type: i12.StiTextEditorComponent, selector: "sti-text-editor", inputs: ["property", "object", "disabled"] }, { kind: "component", type: i13.StiHorizontalAlignmentEditorComponent, selector: "sti-horizontal-alignment-editor", inputs: ["property", "object"] }, { kind: "component", type: i14.StiSelectButtonEditorComponent, selector: "sti-select-button-editor", inputs: ["propertyType", "property", "object"] }, { kind: "component", type: i15.StiDividerComponent, selector: "sti-divider" }], animations: [SlideInOutAnimation] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiTableColumnEditorComponent, decorators: [{
            type: Component,
            args: [{
                    selector: "sti-table-column-editor",
                    template: `
    <div [@slideInOut]="state ? 'in' : 'out'" class="column-editor">
      <table class="sti-clear" [style]="{ width: '100%' }">
        <tr *ngFor="let property of properties">
          <td *ngIf="property.label" [style.vertical-align]="property.type == 'FontEditor' ? 'top' : ''">
            <div class="label" [style.margin-top.px]="index == '0' ? 5 : 0">
              {{ property.label }}
            </div>
          </td>
          <td [colSpan]="property.type === 'divider' ? 8 : ''">
            <sti-font-editor
              *ngIf="property.type === 'FontEditor'"
              [object]="column"
              [property]="property"
            ></sti-font-editor>
            <sti-text-editor
              *ngIf="property.type === 'TextEditor'"
              [object]="column"
              [property]="property"
              [disabled]="needToDisable(property)"
            ></sti-text-editor>
            <sti-horizontal-alignment-editor
              [property]="property"
              *ngIf="property.type === 'horizontalAlignment'"
              [style]="{ width: '95%' }"
              [object]="column"
            ></sti-horizontal-alignment-editor>
            <sti-color-editor
              *ngIf="property.type === 'color'"
              [obj]="column"
              [property]="property"
              [style]="{ width: '95%' }"
            ></sti-color-editor>
            <sti-enum-editor
              *ngIf="property.type === 'enum'"
              [property]="property"
              [style]="{ width: '95%' }"
              [object]="column"
              [index]="index"
            ></sti-enum-editor>
            <sti-bool-editor
              [property]="property"
              *ngIf="property.type === 'checkbox'"
              [style]="{ width: '95%' }"
              [object]="column"
            ></sti-bool-editor>
            <sti-multiline-string-editor
              *ngIf="property.type === 'MultilineEditor'"
              [property]="property"
              [object]="column"
            ></sti-multiline-string-editor>
            <sti-number-editor
              *ngIf="property.type === 'Number'"
              [obj]="column"
              [property]="property"
            ></sti-number-editor>
            <sti-select-button-editor
              *ngIf="property.type === 'labelFormat'"
              [propertyType]="property.type"
              [object]="column"
              [property]="property.property"
            >
            </sti-select-button-editor>
            <sti-divider *ngIf="property.type === 'divider'"></sti-divider>
          </td>
        </tr>
      </table>
    </div>
    <style>
      tr {
        padding: 3px 0px 3px 0px;
      }
      .label {
        font-size: 13px;
        font-weight: normal;
        min-width: 150px;
        white-space: nowrap;
        color: var(--property-label-color);
        -webkit-touch-callout: none;
        -webkit-user-select: none;
      }
      .column-editor {
        overflow: hidden;
      }
      img {
        height: 16px;
        width: 16px;
        vertical-align: bottom;
      }
    </style>
  `,
                    animations: [SlideInOutAnimation],
                }]
        }], ctorParameters: () => [{ type: i1.StiModelService }, { type: i2.StiHelperService }, { type: i3.StiThemeService }, { type: i4.StiLocalizationService }], propDecorators: { column: [{
                type: Input
            }], state: [{
                type: Input
            }], index: [{
                type: Input
            }], expression: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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