import { Component, Input } from "@angular/core";
import { Enum } from "../../../../system/Enum";
import { StiBodyBrush, StiQRCodeBodyShapeType, StiQRCodeErrorCorrectionLevel, StiQRCodeEyeBallShapeType, StiQRCodeEyeFrameShapeType, StiQRCodeSize, } from "../../../../system/enums";
import * as i0 from "@angular/core";
import * as i1 from "../../../../services/model.service";
import * as i2 from "../../../../services/sti-helper.service";
import * as i3 from "../sti-dropdown-editor/sti-dropdown-editor.component";
export class StiSimpleEnumEditorComponent {
    get type() {
        if (this.property.property == "matrixSize") {
            return StiQRCodeSize[this.helper.getProperty(this.object, this.property.property)];
        }
        else if (this.property.property == "errorCorrectionLevel") {
            return StiQRCodeErrorCorrectionLevel[this.helper.getProperty(this.object, this.property.property)];
        }
        else if (this.property.property.includes("BrushType")) {
            return StiBodyBrush[this.helper.getProperty(this.object, this.property.property)];
        }
        else if (this.property.property == "bodyShapeType") {
            return StiQRCodeBodyShapeType[this.helper.getProperty(this.object, this.property.property)];
        }
        else if (this.property.property == "eyeBallShapeType") {
            return StiQRCodeEyeBallShapeType[this.helper.getProperty(this.object, this.property.property)];
        }
        else if (this.property.property == "eyeFrameShapeType") {
            return StiQRCodeEyeFrameShapeType[this.helper.getProperty(this.object, this.property.property)];
        }
    }
    set type(value) {
        if (this.property.property == "matrixSize") {
            this.helper.setProperty(this.object, this.property.property, Enum.parse(StiQRCodeSize, value, false));
        }
        else if (this.property.property == "errorCorrectionLevel") {
            this.helper.setProperty(this.object, this.property.property, Enum.parse(StiQRCodeErrorCorrectionLevel, value));
        }
        else if (this.property.property.includes("BrushType")) {
            this.helper.setProperty(this.object, this.property.property, Enum.parse(StiBodyBrush, value));
        }
        else if (this.property.property == "bodyShapeType") {
            this.helper.setProperty(this.object, this.property.property, Enum.parse(StiQRCodeBodyShapeType, value));
        }
        else if (this.property.property == "eyeBallShapeType") {
            this.helper.setProperty(this.object, this.property.property, Enum.parse(StiQRCodeEyeBallShapeType, value));
        }
        else if (this.property.property == "eyeFrameShapeType") {
            this.helper.setProperty(this.object, this.property.property, Enum.parse(StiQRCodeEyeFrameShapeType, value));
        }
        this.model.needToRefreshInnerProperties.next(true);
    }
    get enum() {
        if (this.property.property == "matrixSize") {
            return this.helper.dataMatrixSize;
        }
        else if (this.property.property == "errorCorrectionLevel") {
            return this.helper.errorCorrectionLevel;
        }
        else if (this.property.property.includes("BrushType")) {
            return this.helper.bodyBrush;
        }
        else if (this.property.property == "bodyShapeType") {
            return this.helper.bodyShapeType;
        }
        else if (this.property.property == "eyeBallShapeType") {
            return this.helper.eyeBallShapeType;
        }
        else if (this.property.property == "eyeFrameShapeType") {
            return this.helper.eyeFrameShapeType;
        }
    }
    constructor(model, helper) {
        this.model = model;
        this.helper = helper;
    }
    ngOnInit() { }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiSimpleEnumEditorComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiHelperService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: StiSimpleEnumEditorComponent, selector: "sti-simple-enum-editor", inputs: { property: "property", object: "object" }, ngImport: i0, template: `
    <table class="sti-clear" [style]="{ width: '100%' }">
      <tr>
        <td colspan="2">
          <sti-dropdown-editor
            [options]="enum"
            [(value)]="type"
            class="p-inputtext-sm"
            [style]="{ width: '100%' }"
          ></sti-dropdown-editor>
        </td>
      </tr>
    </table>

    <style>
      td {
        padding: 0;
      }
      span {
        margin-left: 2px;
        color: var(--text-color);
        font-weight: normal;
      }
    </style>
  `, isInline: true, styles: ["\n      td {\n        padding: 0;\n      }\n      span {\n        margin-left: 2px;\n        color: var(--text-color);\n        font-weight: normal;\n      }\n    "], dependencies: [{ kind: "component", type: i3.StiDropdownEditorComponent, selector: "sti-dropdown-editor", inputs: ["value", "options", "optionLabel", "optionValue", "editable"], outputs: ["valueChange"] }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiSimpleEnumEditorComponent, decorators: [{
            type: Component,
            args: [{
                    selector: "sti-simple-enum-editor",
                    template: `
    <table class="sti-clear" [style]="{ width: '100%' }">
      <tr>
        <td colspan="2">
          <sti-dropdown-editor
            [options]="enum"
            [(value)]="type"
            class="p-inputtext-sm"
            [style]="{ width: '100%' }"
          ></sti-dropdown-editor>
        </td>
      </tr>
    </table>

    <style>
      td {
        padding: 0;
      }
      span {
        margin-left: 2px;
        color: var(--text-color);
        font-weight: normal;
      }
    </style>
  `,
                }]
        }], ctorParameters: () => [{ type: i1.StiModelService }, { type: i2.StiHelperService }], propDecorators: { property: [{
                type: Input
            }], object: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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