import { Component, Input } from "@angular/core";
import { StiTableElement } from "../../../../elements/StiTableElement";
import { StiCheckBoxCellItem } from "../../../../elements/table/cells/StiCheckBoxCellItem";
import { StiComboBoxCellItem } from "../../../../elements/table/cells/StiComboBoxCellItem";
import { StiNumberBoxCellItem } from "../../../../elements/table/cells/StiNumberBoxCellItem";
import { StiRadioButtonCellItem } from "../../../../elements/table/cells/StiRadioButtonCellItem";
import { StiTextBoxCellItem } from "../../../../elements/table/cells/StiTextBoxCellItem";
import { StiCheckBoxColumnItem } from "../../../../elements/table/columns/StiCheckBoxColumnItem";
import { StiComboBoxColumnItem } from "../../../../elements/table/columns/StiComboBoxColumnItem";
import { StiLabelColumnItem } from "../../../../elements/table/columns/StiLabelColumnItem";
import { StiNumberBoxColumnItem } from "../../../../elements/table/columns/StiNumberBoxColumnItem";
import { StiRadioButtonColumnItem } from "../../../../elements/table/columns/StiRadioButtonColumnItem";
import { StiTextBoxColumnItem } from "../../../../elements/table/columns/StiTextBoxColumnItem";
import * as i0 from "@angular/core";
import * as i1 from "../../../../services/model.service";
import * as i2 from "../../../../services/sti-helper.service";
import * as i3 from "../../../../services/theme.service";
import * as i4 from "@angular/forms";
import * as i5 from "../../../../directives/sti-input-text-area.directive";
export class StiMultilineStringEditorComponent {
    constructor(model, helper, theme) {
        this.model = model;
        this.helper = helper;
        this.theme = theme;
    }
    ngOnInit() { }
    get options() {
        if (this.object) {
            return this.object.comboBoxOptions;
        }
        else {
            return this.optionsElement.options ? this.optionsElement.options : this.optionsElement.rowLabels;
        }
    }
    get values() {
        return this.options.join("\n");
    }
    get optionsElement() {
        return this.model.selectedComponent.element
            ? this.model.selectedComponent.element
            : this.helper.getProperty(this.model.selectedComponent.element, this.property.property);
    }
    onInput(value) {
        let rows = this.optionsElement.rowLabels;
        if (this.object) {
            this.object.comboBoxOptions = value.split("\n");
        }
        else {
            this.optionsElement.options
                ? (this.optionsElement.options = value.split("\n"))
                : this.helper.setProperty(this.model.selectedComponent.element, this.property.property, value.split("\n"));
            if ("selectedOption" in this.optionsElement) {
                try {
                    if (this.optionsElement.options.indexOf(this.optionsElement.selectedOption) < 0) {
                        this.optionsElement.selectedOption = null;
                    }
                }
                catch {
                    this.optionsElement.selectedOption = null;
                }
            }
        }
        if (rows &&
            rows != this.optionsElement.RowLabels &&
            this.model.selectedComponent.element instanceof StiTableElement) {
            let values = value.split("\n");
            values.forEach(() => {
                this.model.selectedComponent.element.columns.forEach((column) => {
                    if (column.type == "CheckBoxColumn" && column instanceof StiCheckBoxColumnItem) {
                        column.cells.push(new StiCheckBoxCellItem("", false));
                    }
                    else if (column.type == "ComboBoxColumn" && column instanceof StiComboBoxColumnItem) {
                        column.cells.push(new StiComboBoxCellItem("", 0));
                    }
                    else if (column.type == "RadioButtonColumn" && column instanceof StiRadioButtonColumnItem) {
                        column.cells.push(new StiRadioButtonCellItem("", false));
                    }
                    else if (column.type == "TextBoxColumn" && column instanceof StiTextBoxColumnItem) {
                        column.cells.push(new StiTextBoxCellItem("", ""));
                    }
                    else if (column.type == "NumberBoxColumn" && column instanceof StiNumberBoxColumnItem) {
                        column.cells.push(new StiNumberBoxCellItem("", 0));
                    }
                    else if (column.type == "LabelColumn" && column instanceof StiLabelColumnItem) {
                        column.cells.push("");
                    }
                });
            });
        }
        this.model.formEvents.next({ name: "ValueChanged" });
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiMultilineStringEditorComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiHelperService }, { token: i3.StiThemeService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: StiMultilineStringEditorComponent, selector: "sti-multiline-string-editor", inputs: { property: "property", object: "object" }, ngImport: i0, template: `
    <table class="sti-clear" [style]="{ width: '100%' }">
      <tr [style]="{ width: '100%' }">
        <td colspan="7">
          <textarea
            stiInputTextArea
            [ngModel]="values"
            (input)="onInput($event.target.value)"
            [style]="{ width: '100%', resize: 'none' }"
            [style.height]="object ? 'max-content' : '100px'"
          ></textarea>
        </td>
      </tr>
      <style>
        tr {
          padding: 3px 0px 3px 0px;
        }
        textarea {
          font-size: 13px;
          font-weight: 600;
          padding: 2px 4px;
        }
        td {
          padding: 0;
        }
      </style>
    </table>
  `, isInline: true, styles: ["\n        tr {\n          padding: 3px 0px 3px 0px;\n        }\n        textarea {\n          font-size: 13px;\n          font-weight: 600;\n          padding: 2px 4px;\n        }\n        td {\n          padding: 0;\n        }\n      "], dependencies: [{ kind: "directive", type: i4.DefaultValueAccessor, selector: "input:not([type=checkbox])[formControlName],textarea[formControlName],input:not([type=checkbox])[formControl],textarea[formControl],input:not([type=checkbox])[ngModel],textarea[ngModel],[ngDefaultControl]" }, { kind: "directive", type: i4.NgControlStatus, selector: "[formControlName],[ngModel],[formControl]" }, { kind: "directive", type: i4.NgModel, selector: "[ngModel]:not([formControlName]):not([formControl])", inputs: ["name", "disabled", "ngModel", "ngModelOptions"], outputs: ["ngModelChange"], exportAs: ["ngModel"] }, { kind: "directive", type: i5.StiInputTextAreaDirective, selector: "[stiInputTextArea]" }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiMultilineStringEditorComponent, decorators: [{
            type: Component,
            args: [{
                    selector: "sti-multiline-string-editor",
                    template: `
    <table class="sti-clear" [style]="{ width: '100%' }">
      <tr [style]="{ width: '100%' }">
        <td colspan="7">
          <textarea
            stiInputTextArea
            [ngModel]="values"
            (input)="onInput($event.target.value)"
            [style]="{ width: '100%', resize: 'none' }"
            [style.height]="object ? 'max-content' : '100px'"
          ></textarea>
        </td>
      </tr>
      <style>
        tr {
          padding: 3px 0px 3px 0px;
        }
        textarea {
          font-size: 13px;
          font-weight: 600;
          padding: 2px 4px;
        }
        td {
          padding: 0;
        }
      </style>
    </table>
  `,
                }]
        }], ctorParameters: () => [{ type: i1.StiModelService }, { type: i2.StiHelperService }, { type: i3.StiThemeService }], propDecorators: { property: [{
                type: Input
            }], object: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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