import { Component, Input } from "@angular/core";
import StiRectangleGeometryLayout from "../../../../computed/StiRectangleGeometryLayout";
import { StiFormSettings } from "../../../../elements/settings/StiFormSettings";
import { StiLabelAlignment } from "../../../../system/enums";
import * as i0 from "@angular/core";
import * as i1 from "../../../../services/model.service";
import * as i2 from "../../../../services/sti-helper.service";
import * as i3 from "../../../../services/theme.service";
import * as i4 from "../../../../services/sti-localization.service";
import * as i5 from "@angular/common";
import * as i6 from "../../../sti-tooltip/sti-tooltip.directive";
import * as i7 from "../../../sti-select-button/sti-select-button.component";
export class StiLabelAlignmentEditorComponent {
    constructor(model, helper, theme, render, loc) {
        this.model = model;
        this.helper = helper;
        this.theme = theme;
        this.render = render;
        this.loc = loc;
        this.hasName = false;
        this.required = false;
        this.prop = { type: "verticalAlignment", property: "label.verticalAlignment", label: "verticalAlignment" };
    }
    get hasVerticalAlignment() {
        return !(this.obj instanceof StiFormSettings) && this.obj.label?.isUnchangedVAlign() ? false : true;
    }
    get obj() {
        return this.model.selectedComponent?.element ?? this.model.form.settings;
    }
    get verticalAlignment() {
        return this.helper.getProperty(this.obj, this.prop.property);
    }
    set verticalAlignment(value) {
        this.helper.setProperty(this.obj, this.prop.property, value);
    }
    get alignment() {
        return this.helper.getProperty(this.obj, this.property.property);
    }
    set alignment(value) {
        this.helper.setProperty(this.obj, this.property.property, value);
        this.model.needToRefresh.next(true);
    }
    get isTopAlignment() {
        return this.alignment && this.alignment == StiLabelAlignment.Top ? true : false;
    }
    ngOnInit() { }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiLabelAlignmentEditorComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiHelperService }, { token: i3.StiThemeService }, { token: StiRectangleGeometryLayout }, { token: i4.StiLocalizationService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: StiLabelAlignmentEditorComponent, selector: "sti-label-alignment-editor", inputs: { property: "property" }, ngImport: i0, template: `
    <table class="sti-clear" [style]="{ width: '100%' }">
      <tr>
        <td colspan="2" [style]="{ width: '38%' }">
          <sti-selectButton
            [options]="helper.labelAlignment"
            [(value)]="alignment"
            optionValue="value"
            [style]="{ height: '24px', minWidth: '90px' }"
          >
            <ng-template let-item>
              <img
                [src]="model.getImage(item.image)"
                [stiTooltip]="loc.getP(item.name)"
                tooltipPosition="bottom"
                showDelay="500"
                [style]="{ height: '16px', width: '16px' }"
              />
            </ng-template>
          </sti-selectButton>
        </td>
      </tr>
    </table>
    <table
      [style.margin-top.px]="2"
      *ngIf="!isTopAlignment && hasVerticalAlignment"
      class="sti-clear"
      [style]="{ width: '100%' }"
    >
      <tr>
        <td colspan="2" [style]="{ width: '38%' }">
          <sti-selectButton
            [options]="helper.verticalAlignment"
            [(value)]="verticalAlignment"
            optionValue="value"
            [style]="{ height: '24px', minWidth: '90px' }"
          >
            <ng-template let-item>
              <img
                [src]="model.getImage(item.image)"
                [stiTooltip]="loc.getP(item.name)"
                tooltipPosition="bottom"
                showDelay="500"
                [style]="{ height: '16px', width: '16px' }"
              />
            </ng-template>
          </sti-selectButton>
        </td>
      </tr>
    </table>

    <style>
      td {
        padding: 0;
      }
      input {
        font-size: 13px;
        font-weight: 600;
        padding: 2px 4px;
      }
      .valid {
        border-color: rgb(0, 128, 0);
      }
    </style>
  `, isInline: true, styles: ["\n      td {\n        padding: 0;\n      }\n      input {\n        font-size: 13px;\n        font-weight: 600;\n        padding: 2px 4px;\n      }\n      .valid {\n        border-color: rgb(0, 128, 0);\n      }\n    "], dependencies: [{ kind: "directive", type: i5.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "directive", type: i6.StiTooltipDirective, selector: "[stiTooltip]", inputs: ["tooltipPosition", "stiTooltip", "showDelay"] }, { kind: "component", type: i7.StiSelectButtonComponent, selector: "sti-selectButton", inputs: ["options", "value", "optionLabel", "optionValue", "multiple", "disabled"], outputs: ["onOptionClick", "onChange", "valueChange"] }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiLabelAlignmentEditorComponent, decorators: [{
            type: Component,
            args: [{
                    selector: "sti-label-alignment-editor",
                    template: `
    <table class="sti-clear" [style]="{ width: '100%' }">
      <tr>
        <td colspan="2" [style]="{ width: '38%' }">
          <sti-selectButton
            [options]="helper.labelAlignment"
            [(value)]="alignment"
            optionValue="value"
            [style]="{ height: '24px', minWidth: '90px' }"
          >
            <ng-template let-item>
              <img
                [src]="model.getImage(item.image)"
                [stiTooltip]="loc.getP(item.name)"
                tooltipPosition="bottom"
                showDelay="500"
                [style]="{ height: '16px', width: '16px' }"
              />
            </ng-template>
          </sti-selectButton>
        </td>
      </tr>
    </table>
    <table
      [style.margin-top.px]="2"
      *ngIf="!isTopAlignment && hasVerticalAlignment"
      class="sti-clear"
      [style]="{ width: '100%' }"
    >
      <tr>
        <td colspan="2" [style]="{ width: '38%' }">
          <sti-selectButton
            [options]="helper.verticalAlignment"
            [(value)]="verticalAlignment"
            optionValue="value"
            [style]="{ height: '24px', minWidth: '90px' }"
          >
            <ng-template let-item>
              <img
                [src]="model.getImage(item.image)"
                [stiTooltip]="loc.getP(item.name)"
                tooltipPosition="bottom"
                showDelay="500"
                [style]="{ height: '16px', width: '16px' }"
              />
            </ng-template>
          </sti-selectButton>
        </td>
      </tr>
    </table>

    <style>
      td {
        padding: 0;
      }
      input {
        font-size: 13px;
        font-weight: 600;
        padding: 2px 4px;
      }
      .valid {
        border-color: rgb(0, 128, 0);
      }
    </style>
  `,
                }]
        }], ctorParameters: () => [{ type: i1.StiModelService }, { type: i2.StiHelperService }, { type: i3.StiThemeService }, { type: StiRectangleGeometryLayout }, { type: i4.StiLocalizationService }], propDecorators: { property: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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