import { Component, Input } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "../../../../services/model.service";
import * as i2 from "../../../../services/sti-localization.service";
import * as i3 from "../../../../services/sti-helper.service";
import * as i4 from "../../../../services/sti-changes-service";
import * as i5 from "@angular/common";
import * as i6 from "../../../sti-universal-checkbox/sti-universal-checkbox.component";
import * as i7 from "../../../sti-tooltip/sti-tooltip.directive";
export class StiImageEditorComponent {
    constructor(model, loc, helper, changesService) {
        this.model = model;
        this.loc = loc;
        this.helper = helper;
        this.changesService = changesService;
    }
    ngOnInit() { }
    get imageUrl() {
        return this.helper.getProperty(this.object, this.property.property);
    }
    set imageUrl(value) {
        this.helper.setProperty(this.object, this.property.property, value);
        this.changesService.forceChanges();
    }
    clear() {
        this.imageUrl = "";
    }
    onFileSelected(event) {
        if (event.files && event.files[0]) {
            var reader = new FileReader();
            reader.onload = (e) => {
                if (this.property.property == "reportImage") {
                    this.imageUrl = e.target.result.slice(e.target.result.indexOf(",") + 1, e.target.result.length);
                }
                else {
                    this.imageUrl = e.target.result;
                }
            };
            reader.readAsDataURL(event.files[0]);
        }
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiImageEditorComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiLocalizationService }, { token: i3.StiHelperService }, { token: i4.StiChangesService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: StiImageEditorComponent, selector: "sti-image-editor", inputs: { property: "property", object: "object" }, ngImport: i0, template: `
    <table class="sti-clear" [style]="{ width: '95%' }">
      <tr *ngIf="property.type === 'image'" style="width: 100%;">
        <td style="width: 25px;" colspan="1">
          <div
            class="image-upload"
            [stiTooltip]="loc.get2('FormDesigner', 'LoadImage').replace('...', '')"
            tooltipPosition="bottom"
            showDelay="500"
          >
            <label (click)="imageInput.click()">
              <img [src]="model.getImage('images.Open.png')" />
            </label>
          </div>
          <input
            [style.display]="'none'"
            type="file"
            accept=".jpg, .jpeg, .png"
            (change)="onFileSelected($event.target)"
            #imageInput
          />
        </td>
        <td *ngIf="this.imageUrl" colspan="6">
          <div class="image-delete" [stiTooltip]="loc.getP('Clear')" tooltipPosition="bottom" showDelay="500">
            <label>
              <img [src]="model.getImage('images.StiSignatureClose.png')" (click)="clear()" />
            </label>
          </div>
        </td>
      </tr>
      <tr *ngIf="this.model.selectedComponent && this.imageUrl" style="width: 100%;">
        <td colspan="7">
          <sti-checkbox [(value)]="object.preserveAspectRatio" [label]="'Preserve Aspect Ratio'"></sti-checkbox>
        </td>
      </tr>
    </table>
    <style>
      td {
        padding: 0;
      }

      .image-upload {
        background-color: var(--input-color);
        width: 20px;
        height: 20px;
      }
      .image-upload:hover {
        background-color: var(--hover-color);
      }
      img {
        height: 16px;
        width: 16px;
      }
      label {
        height: 100%;
        width: 100%;
        display: flex;
        align-items: center;
        justify-content: center;
      }
      .image-delete {
        background-color: var(--input-color);
        width: 20px;
        height: 20px;
      }
      .image-delete:hover {
        background-color: var(--hover-color);
      }
    </style>
  `, isInline: true, styles: ["\n      td {\n        padding: 0;\n      }\n\n      .image-upload {\n        background-color: var(--input-color);\n        width: 20px;\n        height: 20px;\n      }\n      .image-upload:hover {\n        background-color: var(--hover-color);\n      }\n      img {\n        height: 16px;\n        width: 16px;\n      }\n      label {\n        height: 100%;\n        width: 100%;\n        display: flex;\n        align-items: center;\n        justify-content: center;\n      }\n      .image-delete {\n        background-color: var(--input-color);\n        width: 20px;\n        height: 20px;\n      }\n      .image-delete:hover {\n        background-color: var(--hover-color);\n      }\n    "], dependencies: [{ kind: "directive", type: i5.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i6.StiUniversalCheckboxComponent, selector: "sti-checkbox", inputs: ["value", "disabled", "label"], outputs: ["valueChange"] }, { kind: "directive", type: i7.StiTooltipDirective, selector: "[stiTooltip]", inputs: ["tooltipPosition", "stiTooltip", "showDelay"] }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiImageEditorComponent, decorators: [{
            type: Component,
            args: [{
                    selector: "sti-image-editor",
                    template: `
    <table class="sti-clear" [style]="{ width: '95%' }">
      <tr *ngIf="property.type === 'image'" style="width: 100%;">
        <td style="width: 25px;" colspan="1">
          <div
            class="image-upload"
            [stiTooltip]="loc.get2('FormDesigner', 'LoadImage').replace('...', '')"
            tooltipPosition="bottom"
            showDelay="500"
          >
            <label (click)="imageInput.click()">
              <img [src]="model.getImage('images.Open.png')" />
            </label>
          </div>
          <input
            [style.display]="'none'"
            type="file"
            accept=".jpg, .jpeg, .png"
            (change)="onFileSelected($event.target)"
            #imageInput
          />
        </td>
        <td *ngIf="this.imageUrl" colspan="6">
          <div class="image-delete" [stiTooltip]="loc.getP('Clear')" tooltipPosition="bottom" showDelay="500">
            <label>
              <img [src]="model.getImage('images.StiSignatureClose.png')" (click)="clear()" />
            </label>
          </div>
        </td>
      </tr>
      <tr *ngIf="this.model.selectedComponent && this.imageUrl" style="width: 100%;">
        <td colspan="7">
          <sti-checkbox [(value)]="object.preserveAspectRatio" [label]="'Preserve Aspect Ratio'"></sti-checkbox>
        </td>
      </tr>
    </table>
    <style>
      td {
        padding: 0;
      }

      .image-upload {
        background-color: var(--input-color);
        width: 20px;
        height: 20px;
      }
      .image-upload:hover {
        background-color: var(--hover-color);
      }
      img {
        height: 16px;
        width: 16px;
      }
      label {
        height: 100%;
        width: 100%;
        display: flex;
        align-items: center;
        justify-content: center;
      }
      .image-delete {
        background-color: var(--input-color);
        width: 20px;
        height: 20px;
      }
      .image-delete:hover {
        background-color: var(--hover-color);
      }
    </style>
  `,
                }]
        }], ctorParameters: () => [{ type: i1.StiModelService }, { type: i2.StiLocalizationService }, { type: i3.StiHelperService }, { type: i4.StiChangesService }], propDecorators: { property: [{
                type: Input
            }], object: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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