import { Component, Input } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "../../../../services/model.service";
import * as i2 from "../../../../services/sti-helper.service";
import * as i3 from "../../../../services/theme.service";
import * as i4 from "../../../../services/sti-localization.service";
import * as i5 from "../../../sti-tooltip/sti-tooltip.directive";
import * as i6 from "../../../sti-select-button/sti-select-button.component";
export class StiHorizontalAlignmentEditorComponent {
    constructor(model, helper, theme, loc) {
        this.model = model;
        this.helper = helper;
        this.theme = theme;
        this.loc = loc;
        this.hasName = false;
        this.required = false;
    }
    get alignment() {
        return this.helper.getProperty(this.object, this.property.property);
    }
    set alignment(value) {
        this.helper.setProperty(this.object, this.property.property, value);
    }
    ngOnInit() { }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiHorizontalAlignmentEditorComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiHelperService }, { token: i3.StiThemeService }, { token: i4.StiLocalizationService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: StiHorizontalAlignmentEditorComponent, selector: "sti-horizontal-alignment-editor", inputs: { property: "property", object: "object" }, ngImport: i0, template: `
    <table class="sti-clear" [style]="{ width: '100%' }">
      <tr>
        <td colspan="2" [style]="{ width: '38%' }">
          <sti-selectButton
            [options]="helper.justifyOptions"
            [(value)]="alignment"
            optionValue="value"
            [style]="{ height: '24px', minWidth: '90px' }"
          >
            <ng-template let-item>
              <img
                [src]="model.getImage(item.image)"
                [stiTooltip]="loc.getP(item.name)"
                tooltipPosition="bottom"
                showDelay="500"
                [style]="{ height: '16px', width: '16px' }"
              />
            </ng-template>
          </sti-selectButton>
        </td>
      </tr>
    </table>

    <style>
      td {
        padding: 0;
      }
      input {
        font-size: 13px;
        font-weight: 600;
        padding: 2px 4px;
      }
      .valid {
        border-color: rgb(0, 128, 0);
      }
    </style>
  `, isInline: true, styles: ["\n      td {\n        padding: 0;\n      }\n      input {\n        font-size: 13px;\n        font-weight: 600;\n        padding: 2px 4px;\n      }\n      .valid {\n        border-color: rgb(0, 128, 0);\n      }\n    "], dependencies: [{ kind: "directive", type: i5.StiTooltipDirective, selector: "[stiTooltip]", inputs: ["tooltipPosition", "stiTooltip", "showDelay"] }, { kind: "component", type: i6.StiSelectButtonComponent, selector: "sti-selectButton", inputs: ["options", "value", "optionLabel", "optionValue", "multiple", "disabled"], outputs: ["onOptionClick", "onChange", "valueChange"] }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiHorizontalAlignmentEditorComponent, decorators: [{
            type: Component,
            args: [{
                    selector: "sti-horizontal-alignment-editor",
                    template: `
    <table class="sti-clear" [style]="{ width: '100%' }">
      <tr>
        <td colspan="2" [style]="{ width: '38%' }">
          <sti-selectButton
            [options]="helper.justifyOptions"
            [(value)]="alignment"
            optionValue="value"
            [style]="{ height: '24px', minWidth: '90px' }"
          >
            <ng-template let-item>
              <img
                [src]="model.getImage(item.image)"
                [stiTooltip]="loc.getP(item.name)"
                tooltipPosition="bottom"
                showDelay="500"
                [style]="{ height: '16px', width: '16px' }"
              />
            </ng-template>
          </sti-selectButton>
        </td>
      </tr>
    </table>

    <style>
      td {
        padding: 0;
      }
      input {
        font-size: 13px;
        font-weight: 600;
        padding: 2px 4px;
      }
      .valid {
        border-color: rgb(0, 128, 0);
      }
    </style>
  `,
                }]
        }], ctorParameters: () => [{ type: i1.StiModelService }, { type: i2.StiHelperService }, { type: i3.StiThemeService }, { type: i4.StiLocalizationService }], propDecorators: { property: [{
                type: Input
            }], object: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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