import { Component, EventEmitter, Input, Output } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "../../../../services/model.service";
import * as i2 from "@angular/common";
export class StiDropdownEditorComponent {
    constructor(model, cdr) {
        this.model = model;
        this.cdr = cdr;
        this.valueChange = new EventEmitter();
        this.isInitialized = false;
        this.showDropdownList = false;
    }
    ngOnDestroy() {
        this.hideDropdownSubscription.unsubscribe();
    }
    get currentPreviewIndex() {
        return this.options.findIndex((option) => option instanceof Object ? option[this.valueName] == this.value : option == this.value);
    }
    get label() {
        return this.optionLabel ? this.optionLabel : "name";
    }
    get valueName() {
        return this.optionValue ? this.optionValue : "value";
    }
    blur() {
        this.cdr.reattach();
        this.cdr.detectChanges();
    }
    setContent(innerText) {
        this.cdr.detach();
        this.value = innerText;
        this.valueChange.emit(this.value);
        this.model.formEvents.next({ name: "ValueChanged" });
    }
    getLabel() {
        if (this.isInitialized) {
            return this.options[this.currentPreviewIndex] instanceof Object
                ? this.options[this.currentPreviewIndex][this.label]
                : this.currentPreviewIndex != -1
                    ? this.options[this.currentPreviewIndex]
                    : this.value;
        }
        else {
            return "";
        }
    }
    selectItem(index) {
        this.value = this.options[index] instanceof Object ? this.options[index][this.valueName] : this.options[index];
        this.valueChange.emit(this.value);
        setTimeout(() => {
            this.showDropdownList = false;
        });
    }
    ngOnInit() {
        this.isInitialized = true;
        this.hideDropdownSubscription = this.model.hideActiveDropdown.subscribe((event) => {
            if (this.showDropdownList) {
                this.showDropdownList = false;
            }
        });
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiDropdownEditorComponent, deps: [{ token: i1.StiModelService }, { token: i0.ChangeDetectorRef }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: StiDropdownEditorComponent, selector: "sti-dropdown-editor", inputs: { value: "value", options: "options", optionLabel: "optionLabel", optionValue: "optionValue", editable: "editable" }, outputs: { valueChange: "valueChange" }, ngImport: i0, template: `
    <div
      #editor
      class="sti-dropdown-editor"
      (click)="model.currentEditor = editor; editable ? '' : (showDropdownList = !showDropdownList)"
    >
      <span
        class="label"
        [attr.contenteditable]="editable ? 'plaintext-only' : false"
        (input)="setContent($event.target.textContent)"
        (blur)="blur()"
        [style.cursor]="editable ? 'text' : 'pointer'"
        [spellcheck]="false"
        >{{ getLabel() }}</span
      >
      <div
        class="button"
        [style.cursor]="'pointer'"
        (click)="model.currentEditor = editor; editable ? (showDropdownList = !showDropdownList) : ''"
      >
        <span><i class="pi pi-chevron-down"></i></span>
      </div>
      <div class="sti-dropdown-items" *ngIf="showDropdownList && model.currentEditor == editor"
      [style.maxWidth.px]="editor.offsetWidth">
        <div
          class="item {{ currentPreviewIndex == idx ? 'selected' : '' }}"
          *ngFor="let item of options; index as idx"
          (click)="selectItem(idx)"
        >
          <span class="item-label" [spellcheck]="false">{{ item[label] ? item[label] : item }}</span>
        </div>
      </div>
    </div>
  `, isInline: true, styles: [".item{cursor:pointer;font-weight:400;overflow:hidden;position:relative;white-space:nowrap;margin:0;padding:.429rem .857rem;border:0 none;color:var(--text-color);background:transparent;transition:background-color .2s,box-shadow .2s;border-radius:0}.item:hover{background-color:#dadada}.selected{background-color:#efefef}.sti-dropdown-editor{width:100%;display:flex;align-items:center;position:relative;height:24px;-webkit-user-select:none;user-select:none;background:var(--input-color);border:1px solid var(--inputBorder-color);border-radius:3px;font-size:12px;font-weight:500;color:var(--text-color)}.sti-dropdown-editor:hover{background-color:var(--hover-color)}.label{width:100%;height:100%;padding:3px 5px;min-width:22.4px}.label:focus{outline:none}.button{width:20px;height:100%;color:#bab9b8;display:flex;align-items:center;justify-content:center}.sti-dropdown-items{position:absolute;max-height:400px;overflow-y:auto;overflow-x:hidden;left:0;top:24px;background:var(--input-color);min-width:100%;z-index:1003;border:1px solid #c8c8c8;border-radius:3px;font-size:13px;box-shadow:0 3px 6px #00000029}\n"], dependencies: [{ kind: "directive", type: i2.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i2.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiDropdownEditorComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-dropdown-editor", template: `
    <div
      #editor
      class="sti-dropdown-editor"
      (click)="model.currentEditor = editor; editable ? '' : (showDropdownList = !showDropdownList)"
    >
      <span
        class="label"
        [attr.contenteditable]="editable ? 'plaintext-only' : false"
        (input)="setContent($event.target.textContent)"
        (blur)="blur()"
        [style.cursor]="editable ? 'text' : 'pointer'"
        [spellcheck]="false"
        >{{ getLabel() }}</span
      >
      <div
        class="button"
        [style.cursor]="'pointer'"
        (click)="model.currentEditor = editor; editable ? (showDropdownList = !showDropdownList) : ''"
      >
        <span><i class="pi pi-chevron-down"></i></span>
      </div>
      <div class="sti-dropdown-items" *ngIf="showDropdownList && model.currentEditor == editor"
      [style.maxWidth.px]="editor.offsetWidth">
        <div
          class="item {{ currentPreviewIndex == idx ? 'selected' : '' }}"
          *ngFor="let item of options; index as idx"
          (click)="selectItem(idx)"
        >
          <span class="item-label" [spellcheck]="false">{{ item[label] ? item[label] : item }}</span>
        </div>
      </div>
    </div>
  `, styles: [".item{cursor:pointer;font-weight:400;overflow:hidden;position:relative;white-space:nowrap;margin:0;padding:.429rem .857rem;border:0 none;color:var(--text-color);background:transparent;transition:background-color .2s,box-shadow .2s;border-radius:0}.item:hover{background-color:#dadada}.selected{background-color:#efefef}.sti-dropdown-editor{width:100%;display:flex;align-items:center;position:relative;height:24px;-webkit-user-select:none;user-select:none;background:var(--input-color);border:1px solid var(--inputBorder-color);border-radius:3px;font-size:12px;font-weight:500;color:var(--text-color)}.sti-dropdown-editor:hover{background-color:var(--hover-color)}.label{width:100%;height:100%;padding:3px 5px;min-width:22.4px}.label:focus{outline:none}.button{width:20px;height:100%;color:#bab9b8;display:flex;align-items:center;justify-content:center}.sti-dropdown-items{position:absolute;max-height:400px;overflow-y:auto;overflow-x:hidden;left:0;top:24px;background:var(--input-color);min-width:100%;z-index:1003;border:1px solid #c8c8c8;border-radius:3px;font-size:13px;box-shadow:0 3px 6px #00000029}\n"] }]
        }], ctorParameters: () => [{ type: i1.StiModelService }, { type: i0.ChangeDetectorRef }], propDecorators: { value: [{
                type: Input
            }], options: [{
                type: Input
            }], optionLabel: [{
                type: Input
            }], optionValue: [{
                type: Input
            }], editable: [{
                type: Input
            }], valueChange: [{
                type: Output
            }] } });
//# sourceMappingURL=data:application/json;base64,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