import { Component, Input } from "@angular/core";
import StiRectangleGeometryLayout from "../../../../computed/StiRectangleGeometryLayout";
import * as i0 from "@angular/core";
import * as i1 from "../../../../services/model.service";
import * as i2 from "../../../../services/sti-helper.service";
import * as i3 from "../../../../services/mouse.service";
import * as i4 from "@angular/common";
export class StiComponentHeightEditorComponent {
    constructor(model, helper, render, mouseService) {
        this.model = model;
        this.helper = helper;
        this.render = render;
        this.mouseService = mouseService;
        this.buttonDown = 0;
        this.mouseOver = false;
        this.focused = false;
    }
    ngOnDestroy() {
        this.mouseUpSubscription?.unsubscribe();
    }
    get value() {
        return this.helper.getProperty(this.element, this.property.property);
    }
    set value(val) {
        this.helper.setProperty(this.element, this.property.property, this.checkValue(val));
        let container = this.model.getElementPage(this.element) ?? this.model.getElementPanel(this.element);
        this.render.insertElement(this.element, container.contentAreaWidth);
    }
    onLostFocus(object) {
        if (this.checkValue(Number(object.currentTarget.value)) != this.value) {
            this.value = Number(object.currentTarget.value);
        }
        else {
            this.model.needToRefresh.next(true);
            this.clear();
        }
        this.model.formEvents.next({ name: "ValueChanged" });
    }
    checkValue(value) {
        let container = this.model.getElementPage(this.element) ?? this.model.getElementPanel(this.element);
        let otherElements = Array.from(container.elements);
        otherElements.splice(otherElements.indexOf(this.element), 1);
        let freeAreaHeight = this.render.getFreeToBottomResizeArea(this.element, otherElements);
        let oldValue = this.helper.getProperty(this.element, this.property.property);
        let roundValue = Math.round(value / this.model.form.settings.gridVerticalStep) * this.model.form.settings.gridVerticalStep;
        if (roundValue <= this.element.geometry.minHeight) {
            return this.element.geometry.minHeight;
        }
        else if (roundValue >= oldValue + freeAreaHeight) {
            return oldValue + freeAreaHeight;
        }
        else {
            return roundValue;
        }
    }
    clear() {
        setTimeout(() => {
            this.buttonDown = 0;
        }, 0);
    }
    setIncDec(value) {
        if (this.incTimeout) {
            clearTimeout(this.incTimeout);
            this.incTimeout = null;
        }
        setTimeout(() => {
            this.value += value;
            this.buttonDown = value;
            this.incDecTimer();
            this.model.formEvents.next({ name: "ValueChanged" });
        }, 0);
    }
    incDecTimer(first = true) {
        let this_ = this;
        this.incTimeout = setTimeout(() => {
            if (this_.buttonDown != 0) {
                this_.value += this_.buttonDown;
                this_.incDecTimer(false);
                this.model.formEvents.next({ name: "ValueChanged" });
            }
        }, first ? 400 : 50);
    }
    ngOnInit() {
        this.mouseUpSubscription = this.mouseService.getDocumentMouseUp().subscribe(() => {
            this.buttonDown = 0;
        });
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiComponentHeightEditorComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiHelperService }, { token: StiRectangleGeometryLayout }, { token: i3.StiMouseService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: StiComponentHeightEditorComponent, selector: "sti-component-height-editor", inputs: { property: "property", element: "element" }, ngImport: i0, template: `
    <table class="sti-clear" [style]="{ width: '100%' }">
      <tr *ngIf="property.type === 'componentHeight'">
        <td colspan="5" [style]="{ width: '100%' }">
          <div class="number-box">
            <div class="value">
              <input
                type="number"
                (blur)="onLostFocus($event)"
                (keyup.enter)="onLostFocus($event)"
                [value]="value"
                class="p-inputnumber-button"
                [style]="{
                  width: '100%',
                  height: '100%',
                  fontSize: '12px',
                  fontWeight: '500',
                  padding: '3px 5px',
                  borderRadius: '3px'
                }"
              />
            </div>
            <div class="buttons">
              <div
                class="button-up"
                (mousedown)="setIncDec(model.form.settings.gridVerticalStep)"
                (mouseup)="clear()"
                (mouseleave)="clear()"
              >
                <i class="pi pi-angle-up"></i>
              </div>
              <div
                class="button-down"
                (mousedown)="setIncDec(-model.form.settings.gridVerticalStep)"
                (mouseup)="clear()"
                (mouseleave)="clear()"
              >
                <i class="pi pi-angle-down"></i>
              </div>
            </div>
          </div>
        </td>
      </tr>
    </table>
  `, isInline: true, styles: [".value:hover{cursor:text}.image-upload>input{display:none}.number-box{width:100%;height:24px;border:1px solid var(--inputBorder-color);border-radius:3px;background-color:var(--input-color);position:relative;display:flex}.value{outline:none;width:100%;height:100%}.value input{outline:none;background-color:var(--input-color);-moz-appearance:textfield;color:var(--text-color);border:0px}.value input[type=number]::-webkit-inner-spin-button,.value input[type=number]::-webkit-outer-spin-button{-webkit-appearance:none;margin:0;opacity:0}.value:after{content:\"\";position:absolute;right:22px;z-index:100;top:2px;width:1px;height:18px;background-color:var(--inputBorder-color)}.buttons{width:22px;height:100%;align-self:flex-end;display:flex;flex-direction:column;color:#bab9b8}.button-up{width:22px;position:relative;height:11px;border-bottom:1px solid var(--inputBorder-color);text-align:center}.button-up:hover{background-color:#d1d0cf}.button-up:active{background-color:#c3c3c3}.button-down{width:22px;position:relative;height:11px;text-align:center}.button-down:hover{background-color:#d1d0cf}.button-down:active{background-color:#c3c3c3}i{position:absolute;left:5px;height:8px;width:8px}\n"], dependencies: [{ kind: "directive", type: i4.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiComponentHeightEditorComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-component-height-editor", template: `
    <table class="sti-clear" [style]="{ width: '100%' }">
      <tr *ngIf="property.type === 'componentHeight'">
        <td colspan="5" [style]="{ width: '100%' }">
          <div class="number-box">
            <div class="value">
              <input
                type="number"
                (blur)="onLostFocus($event)"
                (keyup.enter)="onLostFocus($event)"
                [value]="value"
                class="p-inputnumber-button"
                [style]="{
                  width: '100%',
                  height: '100%',
                  fontSize: '12px',
                  fontWeight: '500',
                  padding: '3px 5px',
                  borderRadius: '3px'
                }"
              />
            </div>
            <div class="buttons">
              <div
                class="button-up"
                (mousedown)="setIncDec(model.form.settings.gridVerticalStep)"
                (mouseup)="clear()"
                (mouseleave)="clear()"
              >
                <i class="pi pi-angle-up"></i>
              </div>
              <div
                class="button-down"
                (mousedown)="setIncDec(-model.form.settings.gridVerticalStep)"
                (mouseup)="clear()"
                (mouseleave)="clear()"
              >
                <i class="pi pi-angle-down"></i>
              </div>
            </div>
          </div>
        </td>
      </tr>
    </table>
  `, styles: [".value:hover{cursor:text}.image-upload>input{display:none}.number-box{width:100%;height:24px;border:1px solid var(--inputBorder-color);border-radius:3px;background-color:var(--input-color);position:relative;display:flex}.value{outline:none;width:100%;height:100%}.value input{outline:none;background-color:var(--input-color);-moz-appearance:textfield;color:var(--text-color);border:0px}.value input[type=number]::-webkit-inner-spin-button,.value input[type=number]::-webkit-outer-spin-button{-webkit-appearance:none;margin:0;opacity:0}.value:after{content:\"\";position:absolute;right:22px;z-index:100;top:2px;width:1px;height:18px;background-color:var(--inputBorder-color)}.buttons{width:22px;height:100%;align-self:flex-end;display:flex;flex-direction:column;color:#bab9b8}.button-up{width:22px;position:relative;height:11px;border-bottom:1px solid var(--inputBorder-color);text-align:center}.button-up:hover{background-color:#d1d0cf}.button-up:active{background-color:#c3c3c3}.button-down{width:22px;position:relative;height:11px;text-align:center}.button-down:hover{background-color:#d1d0cf}.button-down:active{background-color:#c3c3c3}i{position:absolute;left:5px;height:8px;width:8px}\n"] }]
        }], ctorParameters: () => [{ type: i1.StiModelService }, { type: i2.StiHelperService }, { type: StiRectangleGeometryLayout }, { type: i3.StiMouseService }], propDecorators: { property: [{
                type: Input
            }], element: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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