import { Component, Input } from "@angular/core";
import { StiBodyBrush } from "../../../../system/enums";
import { SlideInOutAnimation } from "../../../animations/animations";
import * as i0 from "@angular/core";
import * as i1 from "../../../../services/model.service";
import * as i2 from "../../../../services/sti-helper.service";
import * as i3 from "../../../../services/theme.service";
import * as i4 from "../../../../services/sti-localization.service";
import * as i5 from "@angular/common";
import * as i6 from "../sti-bool-editor/sti-bool-editor.component";
import * as i7 from "../sti-color-editor/sti-color-editor.component";
import * as i8 from "../sti-enum-editor/sti-enum-editor.component";
import * as i9 from "../sti-number-editor/sti-number-editor.component";
import * as i10 from "../sti-simple-enum-editor/sti-simple-enum-editor.component";
export class StiBarcodeShapeEditorComponent {
    constructor(model, helper, theme, loc) {
        this.model = model;
        this.helper = helper;
        this.theme = theme;
        this.loc = loc;
        this.properties = [];
    }
    ngOnInit() {
        this.updateProperties();
        this.model.needToRefreshInnerProperties.subscribe(() => this.updateProperties());
        //
    }
    updateProperties() {
        this.properties = [];
        this.properties.push({
            type: "simpleEnum",
            property: `${this.getStartType(this.property.property)}BrushType`,
            label: this.loc.getP(`${this.getMiddleType(this.property.property)}Brush`),
        });
        if (this.object[`${this.getStartType(this.property.property)}BrushType`] == StiBodyBrush.Solid ||
            this.object[`${this.getStartType(this.property.property)}BrushType`] == StiBodyBrush.Glass) {
            this.properties.push({
                type: "color",
                property: `${this.getStartType(this.property.property)}BrushColor`,
                label: this.loc.getP("Color"),
            });
        }
        if (this.object[`${this.getStartType(this.property.property)}BrushType`] == StiBodyBrush.Hatch) {
            this.properties.push({
                type: "color",
                property: `${this.getStartType(this.property.property)}BrushForeColor`,
                label: this.loc.getP("ForeColor"),
            });
            this.properties.push({
                type: "color",
                property: `${this.getStartType(this.property.property)}BrushBackColor`,
                label: this.loc.getP("BackColor"),
            });
            this.properties.push({
                type: "enum",
                property: `${this.getStartType(this.property.property)}BrushHatchStyle`,
                label: this.loc.getP("Style"),
            });
        }
        if (this.object[`${this.getStartType(this.property.property)}BrushType`] == StiBodyBrush.Gradient ||
            this.object[`${this.getStartType(this.property.property)}BrushType`] == StiBodyBrush.Glare) {
            this.properties.push({
                type: "Number",
                property: `${this.getStartType(this.property.property)}BrushAngle`,
                label: this.loc.getP("Angle"),
            });
            this.properties.push({
                type: "color",
                property: `start${this.getMiddleType(this.property.property)}BrushColor`,
                label: this.loc.getP("StartColor"),
            });
            this.properties.push({
                type: "color",
                property: `end${this.getMiddleType(this.property.property)}BrushColor`,
                label: this.loc.getP("EndColor"),
            });
        }
        this.properties.push({
            type: "simpleEnum",
            property: `${this.getStartType(this.property.property)}ShapeType`,
            label: this.loc.getP(`${this.getMiddleType(this.property.property)}Shape`),
        });
        if (this.object[`${this.getStartType(this.property.property)}BrushType`] == StiBodyBrush.Glare) {
            this.properties.push({
                type: "Number",
                property: `${this.getStartType(this.property.property)}BrushFocus`,
                label: this.loc.getP("Focus"),
            });
        }
        if (this.object[`${this.getStartType(this.property.property)}BrushType`] == StiBodyBrush.Glass) {
            this.properties.push({
                type: "Number",
                property: `${this.getStartType(this.property.property)}BrushBlend`,
                label: this.loc.getP("Blend"),
            });
            this.properties.push({
                type: "checkbox",
                property: `${this.getStartType(this.property.property)}BrushDrawHatch`,
                label: this.loc.getP("DrawHatch"),
            });
        }
    }
    getMiddleType(property) {
        if (property == "showBodyBrushEditor") {
            return "Body";
        }
        else if (property == "showEyeBallBrushEditor") {
            return "EyeBall";
        }
        else {
            return "EyeFrame";
        }
    }
    getStartType(property) {
        if (property == "showBodyBrushEditor") {
            return "body";
        }
        else if (property == "showEyeBallBrushEditor") {
            return "eyeBall";
        }
        else {
            return "eyeFrame";
        }
    }
    get content() {
        return this.helper.getProperty(this.model.selectedComponent.element, this.property.property);
    }
    set content(value) {
        this.helper.setProperty(this.model.selectedComponent.element, this.property.property, value);
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiBarcodeShapeEditorComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiHelperService }, { token: i3.StiThemeService }, { token: i4.StiLocalizationService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: StiBarcodeShapeEditorComponent, selector: "sti-barcode-shape-editor", inputs: { property: "property", state: "state", object: "object" }, ngImport: i0, template: `
    <div [@slideInOut]="state ? 'in' : 'out'" class="barcode-editor">
      <table class="sti-clear" [style]="{ width: '100%' }">
        <tr *ngFor="let prop of properties; index as i">
          <td *ngIf="prop.label">
            <div class="label" [style.margin-top.px]="i == '0' ? 5 : 0">
              {{ prop.label }}
            </div>
          </td>
          <td [style.width]="'100%'">
            <sti-color-editor
              *ngIf="prop.type === 'color'"
              [property]="prop"
              [style]="{ width: '95%' }"
              [obj]="object"
            ></sti-color-editor>
            <sti-simple-enum-editor
              *ngIf="prop.type === 'simpleEnum'"
              [property]="prop"
              [object]="object"
              [style]="{ width: '100%' }"
            ></sti-simple-enum-editor>
            <sti-enum-editor
              *ngIf="prop.type === 'enum'"
              [property]="prop"
              [style]="{ width: '95%' }"
              [object]="object"
            ></sti-enum-editor>
            <sti-bool-editor
              [property]="prop"
              *ngIf="prop.type === 'checkbox'"
              [style]="{ width: '95%' }"
            ></sti-bool-editor>
            <sti-number-editor *ngIf="prop.type === 'Number'" [obj]="object" [property]="prop"></sti-number-editor>
          </td>
        </tr>
      </table>
    </div>
    <style>
      tr {
        padding: 3px 0px 3px 0px;
      }
      .label {
        font-size: 13px;
        font-weight: normal;
        min-width: 120px;
        white-space: nowrap;
        color: var(--text-color);
        -webkit-touch-callout: none;
        -webkit-user-select: none;
      }
      .barcode-editor {
        overflow: hidden;
      }
    </style>
  `, isInline: true, styles: ["\n      tr {\n        padding: 3px 0px 3px 0px;\n      }\n      .label {\n        font-size: 13px;\n        font-weight: normal;\n        min-width: 120px;\n        white-space: nowrap;\n        color: var(--text-color);\n        -webkit-touch-callout: none;\n        -webkit-user-select: none;\n      }\n      .barcode-editor {\n        overflow: hidden;\n      }\n    "], dependencies: [{ kind: "directive", type: i5.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i5.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i6.StiBoolEditorComponent, selector: "sti-bool-editor", inputs: ["property", "object"] }, { kind: "component", type: i7.StiColorEditorComponent, selector: "sti-color-editor", inputs: ["property", "textColor", "obj"] }, { kind: "component", type: i8.StiEnumEditorComponent, selector: "sti-enum-editor", inputs: ["property", "object", "index"] }, { kind: "component", type: i9.StiNumberEditorComponent, selector: "sti-number-editor", inputs: ["property", "obj"] }, { kind: "component", type: i10.StiSimpleEnumEditorComponent, selector: "sti-simple-enum-editor", inputs: ["property", "object"] }], animations: [SlideInOutAnimation] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiBarcodeShapeEditorComponent, decorators: [{
            type: Component,
            args: [{
                    selector: "sti-barcode-shape-editor",
                    template: `
    <div [@slideInOut]="state ? 'in' : 'out'" class="barcode-editor">
      <table class="sti-clear" [style]="{ width: '100%' }">
        <tr *ngFor="let prop of properties; index as i">
          <td *ngIf="prop.label">
            <div class="label" [style.margin-top.px]="i == '0' ? 5 : 0">
              {{ prop.label }}
            </div>
          </td>
          <td [style.width]="'100%'">
            <sti-color-editor
              *ngIf="prop.type === 'color'"
              [property]="prop"
              [style]="{ width: '95%' }"
              [obj]="object"
            ></sti-color-editor>
            <sti-simple-enum-editor
              *ngIf="prop.type === 'simpleEnum'"
              [property]="prop"
              [object]="object"
              [style]="{ width: '100%' }"
            ></sti-simple-enum-editor>
            <sti-enum-editor
              *ngIf="prop.type === 'enum'"
              [property]="prop"
              [style]="{ width: '95%' }"
              [object]="object"
            ></sti-enum-editor>
            <sti-bool-editor
              [property]="prop"
              *ngIf="prop.type === 'checkbox'"
              [style]="{ width: '95%' }"
            ></sti-bool-editor>
            <sti-number-editor *ngIf="prop.type === 'Number'" [obj]="object" [property]="prop"></sti-number-editor>
          </td>
        </tr>
      </table>
    </div>
    <style>
      tr {
        padding: 3px 0px 3px 0px;
      }
      .label {
        font-size: 13px;
        font-weight: normal;
        min-width: 120px;
        white-space: nowrap;
        color: var(--text-color);
        -webkit-touch-callout: none;
        -webkit-user-select: none;
      }
      .barcode-editor {
        overflow: hidden;
      }
    </style>
  `,
                    animations: [SlideInOutAnimation],
                }]
        }], ctorParameters: () => [{ type: i1.StiModelService }, { type: i2.StiHelperService }, { type: i3.StiThemeService }, { type: i4.StiLocalizationService }], propDecorators: { property: [{
                type: Input
            }], state: [{
                type: Input
            }], object: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3RpLWJhcmNvZGUtc2hhcGUtZWRpdG9yLmNvbXBvbmVudC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uLy4uLy4uLy4uLy4uL3Byb2plY3RzL3N0aW11bHNvZnQtZm9ybXMvc3JjL2xpYi9jb21wb25lbnRzL3Byb3BlcnR5R3JpZC9lZGl0b3JzL3N0aS1iYXJjb2RlLXNoYXBlLWVkaXRvci9zdGktYmFyY29kZS1zaGFwZS1lZGl0b3IuY29tcG9uZW50LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBLE9BQU8sRUFBRSxTQUFTLEVBQUUsS0FBSyxFQUFVLE1BQU0sZUFBZSxDQUFDO0FBT3pELE9BQU8sRUFBRSxZQUFZLEVBQUUsTUFBTSwwQkFBMEIsQ0FBQztBQUN4RCxPQUFPLEVBQUUsbUJBQW1CLEVBQUUsTUFBTSxnQ0FBZ0MsQ0FBQzs7Ozs7Ozs7Ozs7O0FBOERyRSxNQUFNLE9BQU8sOEJBQThCO0lBTXpDLFlBQ1MsS0FBc0IsRUFDdEIsTUFBd0IsRUFDeEIsS0FBc0IsRUFDdEIsR0FBMkI7UUFIM0IsVUFBSyxHQUFMLEtBQUssQ0FBaUI7UUFDdEIsV0FBTSxHQUFOLE1BQU0sQ0FBa0I7UUFDeEIsVUFBSyxHQUFMLEtBQUssQ0FBaUI7UUFDdEIsUUFBRyxHQUFILEdBQUcsQ0FBd0I7UUFON0IsZUFBVSxHQUFHLEVBQUUsQ0FBQztJQU9wQixDQUFDO0lBRUosUUFBUTtRQUNOLElBQUksQ0FBQyxnQkFBZ0IsRUFBRSxDQUFDO1FBQ3hCLElBQUksQ0FBQyxLQUFLLENBQUMsNEJBQTRCLENBQUMsU0FBUyxDQUFDLEdBQUcsRUFBRSxDQUFDLElBQUksQ0FBQyxnQkFBZ0IsRUFBRSxDQUFDLENBQUM7UUFDakYsRUFBRTtJQUNKLENBQUM7SUFDRCxnQkFBZ0I7UUFDZCxJQUFJLENBQUMsVUFBVSxHQUFHLEVBQUUsQ0FBQztRQUNyQixJQUFJLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQztZQUNuQixJQUFJLEVBQUUsWUFBWTtZQUNsQixRQUFRLEVBQUUsR0FBRyxJQUFJLENBQUMsWUFBWSxDQUFDLElBQUksQ0FBQyxRQUFRLENBQUMsUUFBUSxDQUFDLFdBQVc7WUFDakUsS0FBSyxFQUFFLElBQUksQ0FBQyxHQUFHLENBQUMsSUFBSSxDQUFDLEdBQUcsSUFBSSxDQUFDLGFBQWEsQ0FBQyxJQUFJLENBQUMsUUFBUSxDQUFDLFFBQVEsQ0FBQyxPQUFPLENBQUM7U0FDM0UsQ0FBQyxDQUFDO1FBQ0gsSUFDRSxJQUFJLENBQUMsTUFBTSxDQUFDLEdBQUcsSUFBSSxDQUFDLFlBQVksQ0FBQyxJQUFJLENBQUMsUUFBUSxDQUFDLFFBQVEsQ0FBQyxXQUFXLENBQUMsSUFBSSxZQUFZLENBQUMsS0FBSztZQUMxRixJQUFJLENBQUMsTUFBTSxDQUFDLEdBQUcsSUFBSSxDQUFDLFlBQVksQ0FBQyxJQUFJLENBQUMsUUFBUSxDQUFDLFFBQVEsQ0FBQyxXQUFXLENBQUMsSUFBSSxZQUFZLENBQUMsS0FBSyxFQUMxRixDQUFDO1lBQ0QsSUFBSSxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUM7Z0JBQ25CLElBQUksRUFBRSxPQUFPO2dCQUNiLFFBQVEsRUFBRSxHQUFHLElBQUksQ0FBQyxZQUFZLENBQUMsSUFBSSxDQUFDLFFBQVEsQ0FBQyxRQUFRLENBQUMsWUFBWTtnQkFDbEUsS0FBSyxFQUFFLElBQUksQ0FBQyxHQUFHLENBQUMsSUFBSSxDQUFDLE9BQU8sQ0FBQzthQUM5QixDQUFDLENBQUM7UUFDTCxDQUFDO1FBQ0QsSUFBSSxJQUFJLENBQUMsTUFBTSxDQUFDLEdBQUcsSUFBSSxDQUFDLFlBQVksQ0FBQyxJQUFJLENBQUMsUUFBUSxDQUFDLFFBQVEsQ0FBQyxXQUFXLENBQUMsSUFBSSxZQUFZLENBQUMsS0FBSyxFQUFFLENBQUM7WUFDL0YsSUFBSSxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUM7Z0JBQ25CLElBQUksRUFBRSxPQUFPO2dCQUNiLFFBQVEsRUFBRSxHQUFHLElBQUksQ0FBQyxZQUFZLENBQUMsSUFBSSxDQUFDLFFBQVEsQ0FBQyxRQUFRLENBQUMsZ0JBQWdCO2dCQUN0RSxLQUFLLEVBQUUsSUFBSSxDQUFDLEdBQUcsQ0FBQyxJQUFJLENBQUMsV0FBVyxDQUFDO2FBQ2xDLENBQUMsQ0FBQztZQUNILElBQUksQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDO2dCQUNuQixJQUFJLEVBQUUsT0FBTztnQkFDYixRQUFRLEVBQUUsR0FBRyxJQUFJLENBQUMsWUFBWSxDQUFDLElBQUksQ0FBQyxRQUFRLENBQUMsUUFBUSxDQUFDLGdCQUFnQjtnQkFDdEUsS0FBSyxFQUFFLElBQUksQ0FBQyxHQUFHLENBQUMsSUFBSSxDQUFDLFdBQVcsQ0FBQzthQUNsQyxDQUFDLENBQUM7WUFDSCxJQUFJLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQztnQkFDbkIsSUFBSSxFQUFFLE1BQU07Z0JBQ1osUUFBUSxFQUFFLEdBQUcsSUFBSSxDQUFDLFlBQVksQ0FBQyxJQUFJLENBQUMsUUFBUSxDQUFDLFFBQVEsQ0FBQyxpQkFBaUI7Z0JBQ3ZFLEtBQUssRUFBRSxJQUFJLENBQUMsR0FBRyxDQUFDLElBQUksQ0FBQyxPQUFPLENBQUM7YUFDOUIsQ0FBQyxDQUFDO1FBQ0wsQ0FBQztRQUNELElBQ0UsSUFBSSxDQUFDLE1BQU0sQ0FBQyxHQUFHLElBQUksQ0FBQyxZQUFZLENBQUMsSUFBSSxDQUFDLFFBQVEsQ0FBQyxRQUFRLENBQUMsV0FBVyxDQUFDLElBQUksWUFBWSxDQUFDLFFBQVE7WUFDN0YsSUFBSSxDQUFDLE1BQU0sQ0FBQyxHQUFHLElBQUksQ0FBQyxZQUFZLENBQUMsSUFBSSxDQUFDLFFBQVEsQ0FBQyxRQUFRLENBQUMsV0FBVyxDQUFDLElBQUksWUFBWSxDQUFDLEtBQUssRUFDMUYsQ0FBQztZQUNELElBQUksQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDO2dCQUNuQixJQUFJLEVBQUUsUUFBUTtnQkFDZCxRQUFRLEVBQUUsR0FBRyxJQUFJLENBQUMsWUFBWSxDQUFDLElBQUksQ0FBQyxRQUFRLENBQUMsUUFBUSxDQUFDLFlBQVk7Z0JBQ2xFLEtBQUssRUFBRSxJQUFJLENBQUMsR0FBRyxDQUFDLElBQUksQ0FBQyxPQUFPLENBQUM7YUFDOUIsQ0FBQyxDQUFDO1lBQ0gsSUFBSSxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUM7Z0JBQ25CLElBQUksRUFBRSxPQUFPO2dCQUNiLFFBQVEsRUFBRSxRQUFRLElBQUksQ0FBQyxhQUFhLENBQUMsSUFBSSxDQUFDLFFBQVEsQ0FBQyxRQUFRLENBQUMsWUFBWTtnQkFDeEUsS0FBSyxFQUFFLElBQUksQ0FBQyxHQUFHLENBQUMsSUFBSSxDQUFDLFlBQVksQ0FBQzthQUNuQyxDQUFDLENBQUM7WUFDSCxJQUFJLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQztnQkFDbkIsSUFBSSxFQUFFLE9BQU87Z0JBQ2IsUUFBUSxFQUFFLE1BQU0sSUFBSSxDQUFDLGFBQWEsQ0FBQyxJQUFJLENBQUMsUUFBUSxDQUFDLFFBQVEsQ0FBQyxZQUFZO2dCQUN0RSxLQUFLLEVBQUUsSUFBSSxDQUFDLEdBQUcsQ0FBQyxJQUFJLENBQUMsVUFBVSxDQUFDO2FBQ2pDLENBQUMsQ0FBQztRQUNMLENBQUM7UUFDRCxJQUFJLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQztZQUNuQixJQUFJLEVBQUUsWUFBWTtZQUNsQixRQUFRLEVBQUUsR0FBRyxJQUFJLENBQUMsWUFBWSxDQUFDLElBQUksQ0FBQyxRQUFRLENBQUMsUUFBUSxDQUFDLFdBQVc7WUFDakUsS0FBSyxFQUFFLElBQUksQ0FBQyxHQUFHLENBQUMsSUFBSSxDQUFDLEdBQUcsSUFBSSxDQUFDLGFBQWEsQ0FBQyxJQUFJLENBQUMsUUFBUSxDQUFDLFFBQVEsQ0FBQyxPQUFPLENBQUM7U0FDM0UsQ0FBQyxDQUFDO1FBQ0gsSUFBSSxJQUFJLENBQUMsTUFBTSxDQUFDLEdBQUcsSUFBSSxDQUFDLFlBQVksQ0FBQyxJQUFJLENBQUMsUUFBUSxDQUFDLFFBQVEsQ0FBQyxXQUFXLENBQUMsSUFBSSxZQUFZLENBQUMsS0FBSyxFQUFFLENBQUM7WUFDL0YsSUFBSSxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUM7Z0JBQ25CLElBQUksRUFBRSxRQUFRO2dCQUNkLFFBQVEsRUFBRSxHQUFHLElBQUksQ0FBQyxZQUFZLENBQUMsSUFBSSxDQUFDLFFBQVEsQ0FBQyxRQUFRLENBQUMsWUFBWTtnQkFDbEUsS0FBSyxFQUFFLElBQUksQ0FBQyxHQUFHLENBQUMsSUFBSSxDQUFDLE9BQU8sQ0FBQzthQUM5QixDQUFDLENBQUM7UUFDTCxDQUFDO1FBQ0QsSUFBSSxJQUFJLENBQUMsTUFBTSxDQUFDLEdBQUcsSUFBSSxDQUFDLFlBQVksQ0FBQyxJQUFJLENBQUMsUUFBUSxDQUFDLFFBQVEsQ0FBQyxXQUFXLENBQUMsSUFBSSxZQUFZLENBQUMsS0FBSyxFQUFFLENBQUM7WUFDL0YsSUFBSSxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUM7Z0JBQ25CLElBQUksRUFBRSxRQUFRO2dCQUNkLFFBQVEsRUFBRSxHQUFHLElBQUksQ0FBQyxZQUFZLENBQUMsSUFBSSxDQUFDLFFBQVEsQ0FBQyxRQUFRLENBQUMsWUFBWTtnQkFDbEUsS0FBSyxFQUFFLElBQUksQ0FBQyxHQUFHLENBQUMsSUFBSSxDQUFDLE9BQU8sQ0FBQzthQUM5QixDQUFDLENBQUM7WUFDSCxJQUFJLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQztnQkFDbkIsSUFBSSxFQUFFLFVBQVU7Z0JBQ2hCLFFBQVEsRUFBRSxHQUFHLElBQUksQ0FBQyxZQUFZLENBQUMsSUFBSSxDQUFDLFFBQVEsQ0FBQyxRQUFRLENBQUMsZ0JBQWdCO2dCQUN0RSxLQUFLLEVBQUUsSUFBSSxDQUFDLEdBQUcsQ0FBQyxJQUFJLENBQUMsV0FBVyxDQUFDO2FBQ2xDLENBQUMsQ0FBQztRQUNMLENBQUM7SUFDSCxDQUFDO0lBQ00sYUFBYSxDQUFDLFFBQVE7UUFDM0IsSUFBSSxRQUFRLElBQUkscUJBQXFCLEVBQUUsQ0FBQztZQUN0QyxPQUFPLE1BQU0sQ0FBQztRQUNoQixDQUFDO2FBQU0sSUFBSSxRQUFRLElBQUksd0JBQXdCLEVBQUUsQ0FBQztZQUNoRCxPQUFPLFNBQVMsQ0FBQztRQUNuQixDQUFDO2FBQU0sQ0FBQztZQUNOLE9BQU8sVUFBVSxDQUFDO1FBQ3BCLENBQUM7SUFDSCxDQUFDO0lBQ00sWUFBWSxDQUFDLFFBQVE7UUFDMUIsSUFBSSxRQUFRLElBQUkscUJBQXFCLEVBQUUsQ0FBQztZQUN0QyxPQUFPLE1BQU0sQ0FBQztRQUNoQixDQUFDO2FBQU0sSUFBSSxRQUFRLElBQUksd0JBQXdCLEVBQUUsQ0FBQztZQUNoRCxPQUFPLFNBQVMsQ0FBQztRQUNuQixDQUFDO2FBQU0sQ0FBQztZQUNOLE9BQU8sVUFBVSxDQUFDO1FBQ3BCLENBQUM7SUFDSCxDQUFDO0lBQ0QsSUFBVyxPQUFPO1FBQ2hCLE9BQU8sSUFBSSxDQUFDLE1BQU0sQ0FBQyxXQUFXLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxPQUFPLEVBQUUsSUFBSSxDQUFDLFFBQVEsQ0FBQyxRQUFRLENBQUMsQ0FBQztJQUMvRixDQUFDO0lBQ0QsSUFBVyxPQUFPLENBQUMsS0FBSztRQUN0QixJQUFJLENBQUMsTUFBTSxDQUFDLFdBQVcsQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLGlCQUFpQixDQUFDLE9BQU8sRUFBRSxJQUFJLENBQUMsUUFBUSxDQUFDLFFBQVEsRUFBRSxLQUFLLENBQUMsQ0FBQztJQUMvRixDQUFDOytHQXhIVSw4QkFBOEI7bUdBQTlCLDhCQUE4QixvSUExRC9COzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0dBdURULDR2Q0FDVyxDQUFDLG1CQUFtQixDQUFDOzs0RkFFdEIsOEJBQThCO2tCQTVEMUMsU0FBUzttQkFBQztvQkFDVCxRQUFRLEVBQUUsMEJBQTBCO29CQUNwQyxRQUFRLEVBQUU7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7R0F1RFQ7b0JBQ0QsVUFBVSxFQUFFLENBQUMsbUJBQW1CLENBQUM7aUJBQ2xDO3NMQUVVLFFBQVE7c0JBQWhCLEtBQUs7Z0JBQ0csS0FBSztzQkFBYixLQUFLO2dCQUNHLE1BQU07c0JBQWQsS0FBSyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IENvbXBvbmVudCwgSW5wdXQsIE9uSW5pdCB9IGZyb20gXCJAYW5ndWxhci9jb3JlXCI7XHJcbmltcG9ydCB7IFN0aUJhcmNvZGVFbGVtZW50IH0gZnJvbSBcIi4uLy4uLy4uLy4uL2VsZW1lbnRzL1N0aUJhcmNvZGVFbGVtZW50XCI7XHJcbmltcG9ydCB7IFN0aU1vZGVsU2VydmljZSB9IGZyb20gXCIuLi8uLi8uLi8uLi9zZXJ2aWNlcy9tb2RlbC5zZXJ2aWNlXCI7XHJcbmltcG9ydCB7IFN0aUVkaXRvclByb3BlcnR5IH0gZnJvbSBcIi4uLy4uLy4uLy4uL3NlcnZpY2VzL29iamVjdHNcIjtcclxuaW1wb3J0IHsgU3RpSGVscGVyU2VydmljZSB9IGZyb20gXCIuLi8uLi8uLi8uLi9zZXJ2aWNlcy9zdGktaGVscGVyLnNlcnZpY2VcIjtcclxuaW1wb3J0IHsgU3RpTG9jYWxpemF0aW9uU2VydmljZSB9IGZyb20gXCIuLi8uLi8uLi8uLi9zZXJ2aWNlcy9zdGktbG9jYWxpemF0aW9uLnNlcnZpY2VcIjtcclxuaW1wb3J0IHsgU3RpVGhlbWVTZXJ2aWNlIH0gZnJvbSBcIi4uLy4uLy4uLy4uL3NlcnZpY2VzL3RoZW1lLnNlcnZpY2VcIjtcclxuaW1wb3J0IHsgU3RpQm9keUJydXNoIH0gZnJvbSBcIi4uLy4uLy4uLy4uL3N5c3RlbS9lbnVtc1wiO1xyXG5pbXBvcnQgeyBTbGlkZUluT3V0QW5pbWF0aW9uIH0gZnJvbSBcIi4uLy4uLy4uL2FuaW1hdGlvbnMvYW5pbWF0aW9uc1wiO1xyXG5cclxuQENvbXBvbmVudCh7XHJcbiAgc2VsZWN0b3I6IFwic3RpLWJhcmNvZGUtc2hhcGUtZWRpdG9yXCIsXHJcbiAgdGVtcGxhdGU6IGBcclxuICAgIDxkaXYgW0BzbGlkZUluT3V0XT1cInN0YXRlID8gJ2luJyA6ICdvdXQnXCIgY2xhc3M9XCJiYXJjb2RlLWVkaXRvclwiPlxyXG4gICAgICA8dGFibGUgY2xhc3M9XCJzdGktY2xlYXJcIiBbc3R5bGVdPVwieyB3aWR0aDogJzEwMCUnIH1cIj5cclxuICAgICAgICA8dHIgKm5nRm9yPVwibGV0IHByb3Agb2YgcHJvcGVydGllczsgaW5kZXggYXMgaVwiPlxyXG4gICAgICAgICAgPHRkICpuZ0lmPVwicHJvcC5sYWJlbFwiPlxyXG4gICAgICAgICAgICA8ZGl2IGNsYXNzPVwibGFiZWxcIiBbc3R5bGUubWFyZ2luLXRvcC5weF09XCJpID09ICcwJyA/IDUgOiAwXCI+XHJcbiAgICAgICAgICAgICAge3sgcHJvcC5sYWJlbCB9fVxyXG4gICAgICAgICAgICA8L2Rpdj5cclxuICAgICAgICAgIDwvdGQ+XHJcbiAgICAgICAgICA8dGQgW3N0eWxlLndpZHRoXT1cIicxMDAlJ1wiPlxyXG4gICAgICAgICAgICA8c3RpLWNvbG9yLWVkaXRvclxyXG4gICAgICAgICAgICAgICpuZ0lmPVwicHJvcC50eXBlID09PSAnY29sb3InXCJcclxuICAgICAgICAgICAgICBbcHJvcGVydHldPVwicHJvcFwiXHJcbiAgICAgICAgICAgICAgW3N0eWxlXT1cInsgd2lkdGg6ICc5NSUnIH1cIlxyXG4gICAgICAgICAgICAgIFtvYmpdPVwib2JqZWN0XCJcclxuICAgICAgICAgICAgPjwvc3RpLWNvbG9yLWVkaXRvcj5cclxuICAgICAgICAgICAgPHN0aS1zaW1wbGUtZW51bS1lZGl0b3JcclxuICAgICAgICAgICAgICAqbmdJZj1cInByb3AudHlwZSA9PT0gJ3NpbXBsZUVudW0nXCJcclxuICAgICAgICAgICAgICBbcHJvcGVydHldPVwicHJvcFwiXHJcbiAgICAgICAgICAgICAgW29iamVjdF09XCJvYmplY3RcIlxyXG4gICAgICAgICAgICAgIFtzdHlsZV09XCJ7IHdpZHRoOiAnMTAwJScgfVwiXHJcbiAgICAgICAgICAgID48L3N0aS1zaW1wbGUtZW51bS1lZGl0b3I+XHJcbiAgICAgICAgICAgIDxzdGktZW51bS1lZGl0b3JcclxuICAgICAgICAgICAgICAqbmdJZj1cInByb3AudHlwZSA9PT0gJ2VudW0nXCJcclxuICAgICAgICAgICAgICBbcHJvcGVydHldPVwicHJvcFwiXHJcbiAgICAgICAgICAgICAgW3N0eWxlXT1cInsgd2lkdGg6ICc5NSUnIH1cIlxyXG4gICAgICAgICAgICAgIFtvYmplY3RdPVwib2JqZWN0XCJcclxuICAgICAgICAgICAgPjwvc3RpLWVudW0tZWRpdG9yPlxyXG4gICAgICAgICAgICA8c3RpLWJvb2wtZWRpdG9yXHJcbiAgICAgICAgICAgICAgW3Byb3BlcnR5XT1cInByb3BcIlxyXG4gICAgICAgICAgICAgICpuZ0lmPVwicHJvcC50eXBlID09PSAnY2hlY2tib3gnXCJcclxuICAgICAgICAgICAgICBbc3R5bGVdPVwieyB3aWR0aDogJzk1JScgfVwiXHJcbiAgICAgICAgICAgID48L3N0aS1ib29sLWVkaXRvcj5cclxuICAgICAgICAgICAgPHN0aS1udW1iZXItZWRpdG9yICpuZ0lmPVwicHJvcC50eXBlID09PSAnTnVtYmVyJ1wiIFtvYmpdPVwib2JqZWN0XCIgW3Byb3BlcnR5XT1cInByb3BcIj48L3N0aS1udW1iZXItZWRpdG9yPlxyXG4gICAgICAgICAgPC90ZD5cclxuICAgICAgICA8L3RyPlxyXG4gICAgICA8L3RhYmxlPlxyXG4gICAgPC9kaXY+XHJcbiAgICA8c3R5bGU+XHJcbiAgICAgIHRyIHtcclxuICAgICAgICBwYWRkaW5nOiAzcHggMHB4IDNweCAwcHg7XHJcbiAgICAgIH1cclxuICAgICAgLmxhYmVsIHtcclxuICAgICAgICBmb250LXNpemU6IDEzcHg7XHJcbiAgICAgICAgZm9udC13ZWlnaHQ6IG5vcm1hbDtcclxuICAgICAgICBtaW4td2lkdGg6IDEyMHB4O1xyXG4gICAgICAgIHdoaXRlLXNwYWNlOiBub3dyYXA7XHJcbiAgICAgICAgY29sb3I6IHZhcigtLXRleHQtY29sb3IpO1xyXG4gICAgICAgIC13ZWJraXQtdG91Y2gtY2FsbG91dDogbm9uZTtcclxuICAgICAgICAtd2Via2l0LXVzZXItc2VsZWN0OiBub25lO1xyXG4gICAgICB9XHJcbiAgICAgIC5iYXJjb2RlLWVkaXRvciB7XHJcbiAgICAgICAgb3ZlcmZsb3c6IGhpZGRlbjtcclxuICAgICAgfVxyXG4gICAgPC9zdHlsZT5cclxuICBgLFxyXG4gIGFuaW1hdGlvbnM6IFtTbGlkZUluT3V0QW5pbWF0aW9uXSxcclxufSlcclxuZXhwb3J0IGNsYXNzIFN0aUJhcmNvZGVTaGFwZUVkaXRvckNvbXBvbmVudCBpbXBsZW1lbnRzIE9uSW5pdCB7XHJcbiAgQElucHV0KCkgcHJvcGVydHk6IFN0aUVkaXRvclByb3BlcnR5O1xyXG4gIEBJbnB1dCgpIHN0YXRlOiBib29sZWFuO1xyXG4gIEBJbnB1dCgpIG9iamVjdDogU3RpQmFyY29kZUVsZW1lbnQ7XHJcbiAgcHVibGljIHByb3BlcnRpZXMgPSBbXTtcclxuXHJcbiAgY29uc3RydWN0b3IoXHJcbiAgICBwdWJsaWMgbW9kZWw6IFN0aU1vZGVsU2VydmljZSxcclxuICAgIHB1YmxpYyBoZWxwZXI6IFN0aUhlbHBlclNlcnZpY2UsXHJcbiAgICBwdWJsaWMgdGhlbWU6IFN0aVRoZW1lU2VydmljZSxcclxuICAgIHB1YmxpYyBsb2M6IFN0aUxvY2FsaXphdGlvblNlcnZpY2VcclxuICApIHt9XHJcblxyXG4gIG5nT25Jbml0KCk6IHZvaWQge1xyXG4gICAgdGhpcy51cGRhdGVQcm9wZXJ0aWVzKCk7XHJcbiAgICB0aGlzLm1vZGVsLm5lZWRUb1JlZnJlc2hJbm5lclByb3BlcnRpZXMuc3Vic2NyaWJlKCgpID0+IHRoaXMudXBkYXRlUHJvcGVydGllcygpKTtcclxuICAgIC8vXHJcbiAgfVxyXG4gIHVwZGF0ZVByb3BlcnRpZXMoKSB7XHJcbiAgICB0aGlzLnByb3BlcnRpZXMgPSBbXTtcclxuICAgIHRoaXMucHJvcGVydGllcy5wdXNoKHtcclxuICAgICAgdHlwZTogXCJzaW1wbGVFbnVtXCIsXHJcbiAgICAgIHByb3BlcnR5OiBgJHt0aGlzLmdldFN0YXJ0VHlwZSh0aGlzLnByb3BlcnR5LnByb3BlcnR5KX1CcnVzaFR5cGVgLFxyXG4gICAgICBsYWJlbDogdGhpcy5sb2MuZ2V0UChgJHt0aGlzLmdldE1pZGRsZVR5cGUodGhpcy5wcm9wZXJ0eS5wcm9wZXJ0eSl9QnJ1c2hgKSxcclxuICAgIH0pO1xyXG4gICAgaWYgKFxyXG4gICAgICB0aGlzLm9iamVjdFtgJHt0aGlzLmdldFN0YXJ0VHlwZSh0aGlzLnByb3BlcnR5LnByb3BlcnR5KX1CcnVzaFR5cGVgXSA9PSBTdGlCb2R5QnJ1c2guU29saWQgfHxcclxuICAgICAgdGhpcy5vYmplY3RbYCR7dGhpcy5nZXRTdGFydFR5cGUodGhpcy5wcm9wZXJ0eS5wcm9wZXJ0eSl9QnJ1c2hUeXBlYF0gPT0gU3RpQm9keUJydXNoLkdsYXNzXHJcbiAgICApIHtcclxuICAgICAgdGhpcy5wcm9wZXJ0aWVzLnB1c2goe1xyXG4gICAgICAgIHR5cGU6IFwiY29sb3JcIixcclxuICAgICAgICBwcm9wZXJ0eTogYCR7dGhpcy5nZXRTdGFydFR5cGUodGhpcy5wcm9wZXJ0eS5wcm9wZXJ0eSl9QnJ1c2hDb2xvcmAsXHJcbiAgICAgICAgbGFiZWw6IHRoaXMubG9jLmdldFAoXCJDb2xvclwiKSxcclxuICAgICAgfSk7XHJcbiAgICB9XHJcbiAgICBpZiAodGhpcy5vYmplY3RbYCR7dGhpcy5nZXRTdGFydFR5cGUodGhpcy5wcm9wZXJ0eS5wcm9wZXJ0eSl9QnJ1c2hUeXBlYF0gPT0gU3RpQm9keUJydXNoLkhhdGNoKSB7XHJcbiAgICAgIHRoaXMucHJvcGVydGllcy5wdXNoKHtcclxuICAgICAgICB0eXBlOiBcImNvbG9yXCIsXHJcbiAgICAgICAgcHJvcGVydHk6IGAke3RoaXMuZ2V0U3RhcnRUeXBlKHRoaXMucHJvcGVydHkucHJvcGVydHkpfUJydXNoRm9yZUNvbG9yYCxcclxuICAgICAgICBsYWJlbDogdGhpcy5sb2MuZ2V0UChcIkZvcmVDb2xvclwiKSxcclxuICAgICAgfSk7XHJcbiAgICAgIHRoaXMucHJvcGVydGllcy5wdXNoKHtcclxuICAgICAgICB0eXBlOiBcImNvbG9yXCIsXHJcbiAgICAgICAgcHJvcGVydHk6IGAke3RoaXMuZ2V0U3RhcnRUeXBlKHRoaXMucHJvcGVydHkucHJvcGVydHkpfUJydXNoQmFja0NvbG9yYCxcclxuICAgICAgICBsYWJlbDogdGhpcy5sb2MuZ2V0UChcIkJhY2tDb2xvclwiKSxcclxuICAgICAgfSk7XHJcbiAgICAgIHRoaXMucHJvcGVydGllcy5wdXNoKHtcclxuICAgICAgICB0eXBlOiBcImVudW1cIixcclxuICAgICAgICBwcm9wZXJ0eTogYCR7dGhpcy5nZXRTdGFydFR5cGUodGhpcy5wcm9wZXJ0eS5wcm9wZXJ0eSl9QnJ1c2hIYXRjaFN0eWxlYCxcclxuICAgICAgICBsYWJlbDogdGhpcy5sb2MuZ2V0UChcIlN0eWxlXCIpLFxyXG4gICAgICB9KTtcclxuICAgIH1cclxuICAgIGlmIChcclxuICAgICAgdGhpcy5vYmplY3RbYCR7dGhpcy5nZXRTdGFydFR5cGUodGhpcy5wcm9wZXJ0eS5wcm9wZXJ0eSl9QnJ1c2hUeXBlYF0gPT0gU3RpQm9keUJydXNoLkdyYWRpZW50IHx8XHJcbiAgICAgIHRoaXMub2JqZWN0W2Ake3RoaXMuZ2V0U3RhcnRUeXBlKHRoaXMucHJvcGVydHkucHJvcGVydHkpfUJydXNoVHlwZWBdID09IFN0aUJvZHlCcnVzaC5HbGFyZVxyXG4gICAgKSB7XHJcbiAgICAgIHRoaXMucHJvcGVydGllcy5wdXNoKHtcclxuICAgICAgICB0eXBlOiBcIk51bWJlclwiLFxyXG4gICAgICAgIHByb3BlcnR5OiBgJHt0aGlzLmdldFN0YXJ0VHlwZSh0aGlzLnByb3BlcnR5LnByb3BlcnR5KX1CcnVzaEFuZ2xlYCxcclxuICAgICAgICBsYWJlbDogdGhpcy5sb2MuZ2V0UChcIkFuZ2xlXCIpLFxyXG4gICAgICB9KTtcclxuICAgICAgdGhpcy5wcm9wZXJ0aWVzLnB1c2goe1xyXG4gICAgICAgIHR5cGU6IFwiY29sb3JcIixcclxuICAgICAgICBwcm9wZXJ0eTogYHN0YXJ0JHt0aGlzLmdldE1pZGRsZVR5cGUodGhpcy5wcm9wZXJ0eS5wcm9wZXJ0eSl9QnJ1c2hDb2xvcmAsXHJcbiAgICAgICAgbGFiZWw6IHRoaXMubG9jLmdldFAoXCJTdGFydENvbG9yXCIpLFxyXG4gICAgICB9KTtcclxuICAgICAgdGhpcy5wcm9wZXJ0aWVzLnB1c2goe1xyXG4gICAgICAgIHR5cGU6IFwiY29sb3JcIixcclxuICAgICAgICBwcm9wZXJ0eTogYGVuZCR7dGhpcy5nZXRNaWRkbGVUeXBlKHRoaXMucHJvcGVydHkucHJvcGVydHkpfUJydXNoQ29sb3JgLFxyXG4gICAgICAgIGxhYmVsOiB0aGlzLmxvYy5nZXRQKFwiRW5kQ29sb3JcIiksXHJcbiAgICAgIH0pO1xyXG4gICAgfVxyXG4gICAgdGhpcy5wcm9wZXJ0aWVzLnB1c2goe1xyXG4gICAgICB0eXBlOiBcInNpbXBsZUVudW1cIixcclxuICAgICAgcHJvcGVydHk6IGAke3RoaXMuZ2V0U3RhcnRUeXBlKHRoaXMucHJvcGVydHkucHJvcGVydHkpfVNoYXBlVHlwZWAsXHJcbiAgICAgIGxhYmVsOiB0aGlzLmxvYy5nZXRQKGAke3RoaXMuZ2V0TWlkZGxlVHlwZSh0aGlzLnByb3BlcnR5LnByb3BlcnR5KX1TaGFwZWApLFxyXG4gICAgfSk7XHJcbiAgICBpZiAodGhpcy5vYmplY3RbYCR7dGhpcy5nZXRTdGFydFR5cGUodGhpcy5wcm9wZXJ0eS5wcm9wZXJ0eSl9QnJ1c2hUeXBlYF0gPT0gU3RpQm9keUJydXNoLkdsYXJlKSB7XHJcbiAgICAgIHRoaXMucHJvcGVydGllcy5wdXNoKHtcclxuICAgICAgICB0eXBlOiBcIk51bWJlclwiLFxyXG4gICAgICAgIHByb3BlcnR5OiBgJHt0aGlzLmdldFN0YXJ0VHlwZSh0aGlzLnByb3BlcnR5LnByb3BlcnR5KX1CcnVzaEZvY3VzYCxcclxuICAgICAgICBsYWJlbDogdGhpcy5sb2MuZ2V0UChcIkZvY3VzXCIpLFxyXG4gICAgICB9KTtcclxuICAgIH1cclxuICAgIGlmICh0aGlzLm9iamVjdFtgJHt0aGlzLmdldFN0YXJ0VHlwZSh0aGlzLnByb3BlcnR5LnByb3BlcnR5KX1CcnVzaFR5cGVgXSA9PSBTdGlCb2R5QnJ1c2guR2xhc3MpIHtcclxuICAgICAgdGhpcy5wcm9wZXJ0aWVzLnB1c2goe1xyXG4gICAgICAgIHR5cGU6IFwiTnVtYmVyXCIsXHJcbiAgICAgICAgcHJvcGVydHk6IGAke3RoaXMuZ2V0U3RhcnRUeXBlKHRoaXMucHJvcGVydHkucHJvcGVydHkpfUJydXNoQmxlbmRgLFxyXG4gICAgICAgIGxhYmVsOiB0aGlzLmxvYy5nZXRQKFwiQmxlbmRcIiksXHJcbiAgICAgIH0pO1xyXG4gICAgICB0aGlzLnByb3BlcnRpZXMucHVzaCh7XHJcbiAgICAgICAgdHlwZTogXCJjaGVja2JveFwiLFxyXG4gICAgICAgIHByb3BlcnR5OiBgJHt0aGlzLmdldFN0YXJ0VHlwZSh0aGlzLnByb3BlcnR5LnByb3BlcnR5KX1CcnVzaERyYXdIYXRjaGAsXHJcbiAgICAgICAgbGFiZWw6IHRoaXMubG9jLmdldFAoXCJEcmF3SGF0Y2hcIiksXHJcbiAgICAgIH0pO1xyXG4gICAgfVxyXG4gIH1cclxuICBwdWJsaWMgZ2V0TWlkZGxlVHlwZShwcm9wZXJ0eSkge1xyXG4gICAgaWYgKHByb3BlcnR5ID09IFwic2hvd0JvZHlCcnVzaEVkaXRvclwiKSB7XHJcbiAgICAgIHJldHVybiBcIkJvZHlcIjtcclxuICAgIH0gZWxzZSBpZiAocHJvcGVydHkgPT0gXCJzaG93RXllQmFsbEJydXNoRWRpdG9yXCIpIHtcclxuICAgICAgcmV0dXJuIFwiRXllQmFsbFwiO1xyXG4gICAgfSBlbHNlIHtcclxuICAgICAgcmV0dXJuIFwiRXllRnJhbWVcIjtcclxuICAgIH1cclxuICB9XHJcbiAgcHVibGljIGdldFN0YXJ0VHlwZShwcm9wZXJ0eSkge1xyXG4gICAgaWYgKHByb3BlcnR5ID09IFwic2hvd0JvZHlCcnVzaEVkaXRvclwiKSB7XHJcbiAgICAgIHJldHVybiBcImJvZHlcIjtcclxuICAgIH0gZWxzZSBpZiAocHJvcGVydHkgPT0gXCJzaG93RXllQmFsbEJydXNoRWRpdG9yXCIpIHtcclxuICAgICAgcmV0dXJuIFwiZXllQmFsbFwiO1xyXG4gICAgfSBlbHNlIHtcclxuICAgICAgcmV0dXJuIFwiZXllRnJhbWVcIjtcclxuICAgIH1cclxuICB9XHJcbiAgcHVibGljIGdldCBjb250ZW50KCkge1xyXG4gICAgcmV0dXJuIHRoaXMuaGVscGVyLmdldFByb3BlcnR5KHRoaXMubW9kZWwuc2VsZWN0ZWRDb21wb25lbnQuZWxlbWVudCwgdGhpcy5wcm9wZXJ0eS5wcm9wZXJ0eSk7XHJcbiAgfVxyXG4gIHB1YmxpYyBzZXQgY29udGVudCh2YWx1ZSkge1xyXG4gICAgdGhpcy5oZWxwZXIuc2V0UHJvcGVydHkodGhpcy5tb2RlbC5zZWxlY3RlZENvbXBvbmVudC5lbGVtZW50LCB0aGlzLnByb3BlcnR5LnByb3BlcnR5LCB2YWx1ZSk7XHJcbiAgfVxyXG59XHJcbiJdfQ==