import { Component, Input } from "@angular/core";
import { StiForm } from "../../../elements/StiForm";
import { StiFormPageElement } from "../../../elements/StiFormPageElement";
import { StiFormElement } from "../../../elements/base/StiFormElement";
import { StiPanelElement } from "../../../elements/StiPanelElement";
import * as i0 from "@angular/core";
import * as i1 from "../../../services/model.service";
import * as i2 from "../../../services/sti-toolbox.service";
import * as i3 from "@angular/common";
export class StiFormsTreeItemComponent {
    get innerItems() {
        return this.item?.pages ?? this.item?.elements;
    }
    get isFormElement() {
        return this.item instanceof StiForm;
    }
    get isPageElement() {
        return this.item instanceof StiFormPageElement;
    }
    hasSelectedComponent(element) {
        if (element instanceof StiFormPageElement || element instanceof StiPanelElement) {
            if (element.allElements.find((element) => element == this.model.selectedComponent?.element)) {
                return true;
            }
            else {
                return false;
            }
        }
        else {
            return false;
        }
    }
    get isLastIndex() {
        if (this.item instanceof StiFormElement) {
            let parentElement = this.model.getElementPage(this.item) ?? this.model.getElementPanel(this.item);
            return parentElement?.elements?.indexOf(this.item) == parentElement?.elements?.length - 1;
        }
        else {
            return true;
        }
    }
    showInnerComponents() {
        return this.item?.pages ? true : this.model.showComponentsTab;
    }
    selectItem() {
        if (this.item instanceof StiForm) {
            this.model.selectedPage = null;
            this.model.selectedComponent = null;
        }
        else if (this.item instanceof StiFormPageElement) {
            this.model.selectedPage = this.item;
        }
        else {
            this.model.needToSelectedComponent.next(this.item);
        }
        this.scrollToElement();
    }
    scrollToElement() {
        if (this.item instanceof StiForm) {
            return;
        }
        let workspace = document.getElementsByTagName("sti-workspace")[0];
        let page = this.item instanceof StiFormPageElement ? this.item : this.model.getElementPageForScroll(this.item);
        let pageElement = document.getElementById(page.guid);
        let pageElementRect = pageElement.getBoundingClientRect();
        let index = this.model.form.pages.indexOf(page);
        workspace.scrollTop = pageElementRect.height * index + (index != 0 ? 20 * this.model.zoom : 0);
    }
    isCurrentSelectedItem() {
        if (this.item instanceof StiFormPageElement) {
            return this.model.selectedPage == this.item;
        }
        else if (this.item instanceof StiForm) {
            return !this.model.selectedPage && !this.model.selectedComponent;
        }
        else {
            return this.model?.selectedComponent?.element == this.item;
        }
    }
    getItemLabel() {
        if (this.item && this.item instanceof StiForm) {
            return this.item?.formName;
        }
        else {
            return this.item?.name;
        }
    }
    getIconSrc() {
        let path;
        if (this.item && this.item instanceof StiForm) {
            path = "images.Other.StiForm.png";
        }
        else if (this.item instanceof StiFormPageElement) {
            path = "images.Page.StiPage.png";
        }
        else {
            let toolboxElement = this.toolboxService?.elements?.find((elem) => elem.id == this.toolboxService?.getToolboxId(this.item?.type));
            path = toolboxElement?.image;
        }
        return this.model.getImage(path);
    }
    constructor(model, toolboxService) {
        this.model = model;
        this.toolboxService = toolboxService;
        this.showInnerTree = false;
    }
    ngOnDestroy() {
        if (this.innerItems) {
            let itemStateObj = this.model.formTreeInnerItemsStates?.find((item) => item?.element == this.item);
            if (itemStateObj && itemStateObj.state != this.showInnerTree) {
                itemStateObj.state = this.showInnerTree;
            }
            else {
                this.model.formTreeInnerItemsStates.push({ element: this.item, state: this.showInnerTree });
            }
        }
    }
    ngOnInit() {
        if (this.model.formTreeInnerItemsStates.find((item) => item?.element == this.item)) {
            this.showInnerTree = this.model.formTreeInnerItemsStates.find((item) => item?.element == this.item).state;
        }
        if (this.item instanceof StiForm) {
            this.showInnerTree = true;
        }
        if (this.showTree) {
            this.showInnerTree = true;
        }
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiFormsTreeItemComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiToolboxService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: StiFormsTreeItemComponent, selector: "sti-forms-tree-item", inputs: { item: "item", index: "index", showTree: "showTree" }, ngImport: i0, template: `<div class="item-container" [style.left.px]="isFormElement ? 5 : !isPageElement && innerItems ? 13 : 15">
    <div class="tree-item">
      <div class="tree-lines" [style.width.px]="innerItems ? 15 : 13">
        <div
          class="inner-elements-button"
          *ngIf="innerItems && showInnerComponents()"
          (click)="this.showInnerTree = !this.showInnerTree"
        >
          <img
            [src]="
              showInnerTree
                ? model.getImage('images.Other.IconCloseItem.png')
                : model.getImage('images.Other.IconOpenItem.png')
            "
          />
        </div>
      </div>
      <div class="item-content {{ isCurrentSelectedItem() ? 'current' : '' }}" (click)="selectItem()">
        <div class="item-icon"><img [src]="getIconSrc()" /></div>
        <div class="item-label">{{ getItemLabel() }}</div>
      </div>
    </div>
    <div class="inner-items" *ngIf="innerItems && showInnerTree && showInnerComponents()">
      <sti-forms-tree-item
        *ngFor="let innerItem of innerItems; let i = index"
        [item]="innerItem"
        [index]="i"
        [showTree]="hasSelectedComponent(innerItem)"
      ></sti-forms-tree-item>
    </div>
  </div>`, isInline: true, styles: [".item-icon{height:17px}.item-content{border-radius:3px;display:flex;align-items:center;height:23px;padding:3px}.current{background-color:#d3d3d3}.horizontal-line{position:absolute;height:1px;width:11px;left:11px;top:11px;background-color:#d3d3d3}.vertical-line{position:absolute;height:11px;width:1px;left:11px;top:0;background-color:#d3d3d3}.tree-lines{height:100%;position:relative;width:23px;display:flex;align-items:center}.item-label{margin-left:3px}.item-container{position:relative;top:0;font-size:11px;color:#444;font-family:Arial;-moz-user-select:none;-khtml-user-select:none;-webkit-user-select:none;display:flex;flex-direction:column}.tree-item{display:flex;align-items:center;height:23px}img{height:16px;width:16px}.inner-elements-button{display:flex;justify-content:flex-end}.inner-elements-button img{height:12px;width:12px;margin-top:1px;margin-right:3px}\n"], dependencies: [{ kind: "directive", type: i3.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i3.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: StiFormsTreeItemComponent, selector: "sti-forms-tree-item", inputs: ["item", "index", "showTree"] }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiFormsTreeItemComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-forms-tree-item", template: `<div class="item-container" [style.left.px]="isFormElement ? 5 : !isPageElement && innerItems ? 13 : 15">
    <div class="tree-item">
      <div class="tree-lines" [style.width.px]="innerItems ? 15 : 13">
        <div
          class="inner-elements-button"
          *ngIf="innerItems && showInnerComponents()"
          (click)="this.showInnerTree = !this.showInnerTree"
        >
          <img
            [src]="
              showInnerTree
                ? model.getImage('images.Other.IconCloseItem.png')
                : model.getImage('images.Other.IconOpenItem.png')
            "
          />
        </div>
      </div>
      <div class="item-content {{ isCurrentSelectedItem() ? 'current' : '' }}" (click)="selectItem()">
        <div class="item-icon"><img [src]="getIconSrc()" /></div>
        <div class="item-label">{{ getItemLabel() }}</div>
      </div>
    </div>
    <div class="inner-items" *ngIf="innerItems && showInnerTree && showInnerComponents()">
      <sti-forms-tree-item
        *ngFor="let innerItem of innerItems; let i = index"
        [item]="innerItem"
        [index]="i"
        [showTree]="hasSelectedComponent(innerItem)"
      ></sti-forms-tree-item>
    </div>
  </div>`, styles: [".item-icon{height:17px}.item-content{border-radius:3px;display:flex;align-items:center;height:23px;padding:3px}.current{background-color:#d3d3d3}.horizontal-line{position:absolute;height:1px;width:11px;left:11px;top:11px;background-color:#d3d3d3}.vertical-line{position:absolute;height:11px;width:1px;left:11px;top:0;background-color:#d3d3d3}.tree-lines{height:100%;position:relative;width:23px;display:flex;align-items:center}.item-label{margin-left:3px}.item-container{position:relative;top:0;font-size:11px;color:#444;font-family:Arial;-moz-user-select:none;-khtml-user-select:none;-webkit-user-select:none;display:flex;flex-direction:column}.tree-item{display:flex;align-items:center;height:23px}img{height:16px;width:16px}.inner-elements-button{display:flex;justify-content:flex-end}.inner-elements-button img{height:12px;width:12px;margin-top:1px;margin-right:3px}\n"] }]
        }], ctorParameters: () => [{ type: i1.StiModelService }, { type: i2.StiToolboxService }], propDecorators: { item: [{
                type: Input
            }], index: [{
                type: Input
            }], showTree: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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