import { Component } from "@angular/core";
import { StiFormPageElement } from "../../../elements/StiFormPageElement";
import * as i0 from "@angular/core";
import * as i1 from "../../../services/model.service";
import * as i2 from "../../../services/sti-toolbox.service";
import * as i3 from "../../../services/sti-localization.service";
import * as i4 from "@angular/common";
export class StiFormElementsDropdownComponent {
    constructor(model, toolboxService, loc) {
        this.model = model;
        this.toolboxService = toolboxService;
        this.loc = loc;
        this.items = [
            { name: "Form", label: "Form" },
            { name: "Page", label: "Page" },
        ];
    }
    ngOnDestroy() {
        this.changeSubscription.unsubscribe();
    }
    selectItem(item) {
        if (item?.label == "Form") {
            this.model.selectedPage = null;
            this.model.selectedComponent = null;
            setTimeout(() => {
                this.model.needToRefresh.next(true);
            });
        }
        else if (item?.element instanceof StiFormPageElement) {
            this.model.selectedPage = item.element;
            setTimeout(() => {
                this.model.needToRefresh.next(true);
            });
        }
        else {
            this.model.needToSelectedComponent.next(item.element);
            setTimeout(() => {
                this.model.needToRefresh.next(true);
            });
        }
    }
    getItemText(item) {
        return item ? `${item?.name} : ${item?.label}` : "";
    }
    getCurrentItemText() {
        if (this.items) {
            if (this.model?.selectedComponent) {
                let item = this.items?.find((item) => item?.element == this.model.selectedComponent?.element);
                return this.getItemText(item);
            }
            else if (this.model?.selectedPage) {
                let item = this.items?.find((item) => item?.element == this.model.selectedPage);
                return this.getItemText(item);
            }
            else {
                let item = this.items?.find((item) => item?.label == "Form");
                return this.getItemText(item);
            }
        }
    }
    fillItems() {
        this.items = [];
        this.items.push({ name: this.model.form?.formName ? this.model.form?.formName : "Form", label: "Form" });
        this.model.form?.pages?.forEach((page) => {
            this.items.push({ name: page.name, label: this.getLabel(page), element: page });
            page.allElements.forEach((elem) => {
                this.items.push({ name: elem.name, label: this.getLabel(elem), element: elem });
            });
        });
    }
    showDropdown() {
        if (!this.model.showFormElementsList) {
            this.fillItems();
            this.model.showFormElementsList = true;
        }
        else {
            this.model.showFormElementsList = false;
        }
    }
    getLabel(element) {
        let toolboxElement = this.toolboxService?.elements?.find((elem) => elem.id == this.toolboxService.getToolboxId(element.type));
        return element.type == "StiPageElement"
            ? this.loc.get2("Components", "StiPage")
            : this.loc.get2(toolboxElement?.category ? toolboxElement?.category : "Components", toolboxElement?.caption) ??
                element.type;
    }
    isSelected(item) {
        if (this.model.selectedComponent) {
            return item.element == this.model.selectedComponent.element;
        }
        else if (this.model.selectedPage) {
            return item.element == this.model.selectedPage;
        }
        else {
            return item.label == "Form";
        }
    }
    sortItems(items) {
        let sortedItems = [];
        items.forEach((item) => {
            sortedItems.push(item);
        });
        return sortedItems.sort(function (a, b) {
            const nameA = a.name.toUpperCase();
            const nameB = b.name.toUpperCase();
            if (nameA < nameB) {
                return -1;
            }
            if (nameA > nameB) {
                return 1;
            }
            return 0;
        });
    }
    ngOnInit() {
        this.fillItems();
        this.changeSubscription = this.model.formEvents.subscribe((e) => {
            if (e.name == "FormChanged" || e.name == "SelectedComponentChanged" || e.name == "SelectedPageChanged") {
                this.fillItems();
            }
        });
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiFormElementsDropdownComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiToolboxService }, { token: i3.StiLocalizationService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: StiFormElementsDropdownComponent, selector: "sti-form-elements-dropdown", ngImport: i0, template: `
    <div class="form-elements-dropdown-container">
      <div class="form-elements-dropdown" #dropdown (click)="showDropdown()">
        <span>{{ getCurrentItemText() }}</span>
        <i class="pi pi-chevron-down"></i>
        <div
          class="form-elements-list-container"
          *ngIf="items && model.showFormElementsList"
          [style.width.px]="dropdown.offsetWidth"
        >
          <div
            class="form-elements-list-item {{ isSelected(item) ? 'selected' : '' }}"
            *ngFor="let item of model.sortFormElementsList ? sortItems(items) : items"
            (click)="selectItem(item)"
          >
            <span>{{ getItemText(item) }}</span>
          </div>
        </div>
      </div>
      <div
        class="sort-button {{ model.sortFormElementsList ? 'selected' : '' }}"
        (click)="model.sortFormElementsList = !model.sortFormElementsList"
      >
        <img [src]="model.getImage('images.Other.Alphabetical.png')" />
      </div>
    </div>
  `, isInline: true, styles: ["i{margin-top:2px}.selected{background-color:#eee}.form-elements-list-item{font-size:13px;padding-left:5px;height:28px;display:flex;align-items:center;border-radius:3px}.form-elements-dropdown-container{display:flex;width:100%;margin:5px 0 4px}.form-elements-list-container{position:absolute;max-height:300px;background-color:#fff;padding:1px;top:24px;left:0;width:250px;z-index:99999;border:1px solid #c8c8c8;overflow-y:auto;overflow-x:hidden;border-radius:3px;font-size:13px;box-shadow:0 3px 6px #00000029}.form-elements-dropdown{width:100%;position:relative;display:flex;min-width:300px;height:24px;-webkit-user-select:none;align-items:center;background-color:#fff;margin-left:5px;border-radius:3px;border:1px solid var(--inputBorder-color)}.form-elements-dropdown:hover,.form-elements-list-item:hover{background-color:var(--hover-color);cursor:pointer}.form-elements-dropdown span{font-family:-apple-system,BlinkMacSystemFont,Segoe UI,Roboto,Helvetica,Arial,sans-serif,\"Apple Color Emoji\",\"Segoe UI Emoji\",Segoe UI Symbol;font-size:12px;font-weight:500;color:var(--text-color);flex:1;padding-left:5px}i{color:#bab9b8;margin-right:5px}img{width:16px;height:16px;margin:0 4px}.sort-button{border-radius:3px;display:flex;align-items:center;justify-content:center;margin:0 5px}.sort-button:hover{background-color:var(--hover-color)}\n"], dependencies: [{ kind: "directive", type: i4.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i4.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiFormElementsDropdownComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-form-elements-dropdown", template: `
    <div class="form-elements-dropdown-container">
      <div class="form-elements-dropdown" #dropdown (click)="showDropdown()">
        <span>{{ getCurrentItemText() }}</span>
        <i class="pi pi-chevron-down"></i>
        <div
          class="form-elements-list-container"
          *ngIf="items && model.showFormElementsList"
          [style.width.px]="dropdown.offsetWidth"
        >
          <div
            class="form-elements-list-item {{ isSelected(item) ? 'selected' : '' }}"
            *ngFor="let item of model.sortFormElementsList ? sortItems(items) : items"
            (click)="selectItem(item)"
          >
            <span>{{ getItemText(item) }}</span>
          </div>
        </div>
      </div>
      <div
        class="sort-button {{ model.sortFormElementsList ? 'selected' : '' }}"
        (click)="model.sortFormElementsList = !model.sortFormElementsList"
      >
        <img [src]="model.getImage('images.Other.Alphabetical.png')" />
      </div>
    </div>
  `, styles: ["i{margin-top:2px}.selected{background-color:#eee}.form-elements-list-item{font-size:13px;padding-left:5px;height:28px;display:flex;align-items:center;border-radius:3px}.form-elements-dropdown-container{display:flex;width:100%;margin:5px 0 4px}.form-elements-list-container{position:absolute;max-height:300px;background-color:#fff;padding:1px;top:24px;left:0;width:250px;z-index:99999;border:1px solid #c8c8c8;overflow-y:auto;overflow-x:hidden;border-radius:3px;font-size:13px;box-shadow:0 3px 6px #00000029}.form-elements-dropdown{width:100%;position:relative;display:flex;min-width:300px;height:24px;-webkit-user-select:none;align-items:center;background-color:#fff;margin-left:5px;border-radius:3px;border:1px solid var(--inputBorder-color)}.form-elements-dropdown:hover,.form-elements-list-item:hover{background-color:var(--hover-color);cursor:pointer}.form-elements-dropdown span{font-family:-apple-system,BlinkMacSystemFont,Segoe UI,Roboto,Helvetica,Arial,sans-serif,\"Apple Color Emoji\",\"Segoe UI Emoji\",Segoe UI Symbol;font-size:12px;font-weight:500;color:var(--text-color);flex:1;padding-left:5px}i{color:#bab9b8;margin-right:5px}img{width:16px;height:16px;margin:0 4px}.sort-button{border-radius:3px;display:flex;align-items:center;justify-content:center;margin:0 5px}.sort-button:hover{background-color:var(--hover-color)}\n"] }]
        }], ctorParameters: () => [{ type: i1.StiModelService }, { type: i2.StiToolboxService }, { type: i3.StiLocalizationService }] });
//# sourceMappingURL=data:application/json;base64,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