import { Component, HostListener } from "@angular/core";
import { StiFormPageElement } from "../../elements/StiFormPageElement";
import * as i0 from "@angular/core";
import * as i1 from "../../services/model.service";
import * as i2 from "../../services/sti-export.service";
import * as i3 from "../../services/sti-localization.service";
import * as i4 from "@angular/common";
import * as i5 from "../sti-universal-checkbox/sti-universal-checkbox.component";
export class StiModalAgreeWindowComponent {
    handleKeyboardEvent(e) {
        if (e.code === "Enter") {
            this.delete();
        }
        else if (e.code === "Escape") {
            this.cancel();
        }
    }
    constructor(model, exportService, loc) {
        this.model = model;
        this.exportService = exportService;
        this.loc = loc;
    }
    delete() {
        this.model.form.pages.forEach((page) => {
            if (page === this.model.selectedPage) {
                this.model.form.pages.splice(this.model.form.pages.indexOf(page), 1);
                this.model.selectedPage = null;
            }
        });
        if (this.model.form.pages.length == 0) {
            let page1 = new StiFormPageElement(this.model.form);
            this.model.form.pages.push(page1);
            this.model.lastUsedPage = page1;
        }
        this.model.showModalWindow = false;
    }
    accept() {
        if (this.model.showModalWindow) {
            this.delete();
        }
        else {
            this.exportService.exportToPdf();
            this.exportService.showModalWindow = false;
        }
    }
    cancel() {
        this.model.showModalWindow = false;
        this.exportService.showModalWindow = false;
    }
    ngOnInit() { }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiModalAgreeWindowComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiExportService }, { token: i3.StiLocalizationService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: StiModalAgreeWindowComponent, selector: "sti-modal-agree-window", host: { listeners: { "document:keydown": "handleKeyboardEvent($event)" } }, ngImport: i0, template: `
    <div class="modal-window" [style.height]="'150px'">
      <div class="nav">
        <span>{{
          model.showModalWindow ? loc.get2("Permissions", "ItemForms") : loc.get2("MainMenu", "menuViewOptions")
        }}</span>
      </div>
      <div class="content">
        <img *ngIf="model.showModalWindow" [src]="model.getImage('images.Other.Question.png')" />
        <p *ngIf="model.showModalWindow">{{ loc.get2("Questions", "qnPageDelete") }}</p>
        <div class="options" *ngIf="exportService.showModalWindow">
          <sti-checkbox [(value)]="exportService.useReadOnly" [label]="loc.getP('ReadOnly')"></sti-checkbox>
          <sti-checkbox [(value)]="exportService.usePdfA" [label]="loc.get2('Export', 'PdfACompliance')"></sti-checkbox>
        </div>
      </div>
      <div class="buttons" [style.padding-right.px]="3" [style.align-self]="'flex-end'">
        <div class="button accept" (click)="accept()">
          <span>
            {{
              model.showModalWindow
                ? loc.get2("Buttons", "Yes").replace("&amp", "").replace(";", "")
                : loc.get2("Gui", "barname_ok")
            }}
          </span>
        </div>
        <div class="button cancel" (click)="cancel()">
          <span>
            {{
              model.showModalWindow
                ? loc.get2("Buttons", "No").replace("&amp", "").replace(";", "")
                : loc.getP("Cancel")
            }}
          </span>
        </div>
      </div>
    </div>
  `, isInline: true, styles: [".options{display:flex;flex-direction:column;justify-content:center;width:100%;padding-left:10px}sti-checkbox{margin-top:5px;margin-bottom:5px}.modal-window{-webkit-touch-callout:none;-webkit-user-select:none;position:absolute;top:calc(50% - 75px);left:calc(50% - 150px);padding:0;font-family:Segoe UI;background-color:var(--back-color);width:300px;height:110px;z-index:9999999;border-radius:5px;display:flex;flex-direction:column;outline:1px solid rgb(81,92,106);-moz-box-shadow:0px 0px 7px rgba(0,0,0,.6);-webkit-box-shadow:0px 0px 7px rgb(0 0 0 / 60%);box-shadow:0 0 7px #0000004d}.nav{width:100%;height:30px;background-color:#515c6a;border-top-left-radius:4px;border-top-right-radius:4px;display:flex;align-items:center}.nav span{width:100%;margin-left:10px;color:#fff;font-size:13px;font-family:Arial}.close{height:100%;width:40px;border-top-right-radius:5px;display:flex;align-items:center;justify-content:center}.close:hover{background-color:#c83c31}.close:active{background-color:#c42b1c}.close img{height:16px;width:16px}.content{width:100%;display:flex;align-items:center;flex:1;padding:10px}.content img{margin-left:10px;margin-right:10px;width:32px;height:32px}p{font-size:12px;font-family:Arial;color:var(--text-color)}.buttons{align-self:flex-end;padding-bottom:5px;height:32px;display:flex;padding-right:3px}.button{width:80px;height:24px;border-radius:3px;display:flex;align-items:center;justify-content:center;margin:0 5px}.button span{font-size:12px;font-family:Arial;cursor:default;margin:0;padding:0}.accept{background-color:#19478a;color:#fff}.accept:hover{background-color:#3d6298}.cancel{background-color:#ddd;color:#444}.cancel:hover{background-color:#d5d5d5}\n"], dependencies: [{ kind: "directive", type: i4.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i5.StiUniversalCheckboxComponent, selector: "sti-checkbox", inputs: ["value", "disabled", "label"], outputs: ["valueChange"] }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StiModalAgreeWindowComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-modal-agree-window", template: `
    <div class="modal-window" [style.height]="'150px'">
      <div class="nav">
        <span>{{
          model.showModalWindow ? loc.get2("Permissions", "ItemForms") : loc.get2("MainMenu", "menuViewOptions")
        }}</span>
      </div>
      <div class="content">
        <img *ngIf="model.showModalWindow" [src]="model.getImage('images.Other.Question.png')" />
        <p *ngIf="model.showModalWindow">{{ loc.get2("Questions", "qnPageDelete") }}</p>
        <div class="options" *ngIf="exportService.showModalWindow">
          <sti-checkbox [(value)]="exportService.useReadOnly" [label]="loc.getP('ReadOnly')"></sti-checkbox>
          <sti-checkbox [(value)]="exportService.usePdfA" [label]="loc.get2('Export', 'PdfACompliance')"></sti-checkbox>
        </div>
      </div>
      <div class="buttons" [style.padding-right.px]="3" [style.align-self]="'flex-end'">
        <div class="button accept" (click)="accept()">
          <span>
            {{
              model.showModalWindow
                ? loc.get2("Buttons", "Yes").replace("&amp", "").replace(";", "")
                : loc.get2("Gui", "barname_ok")
            }}
          </span>
        </div>
        <div class="button cancel" (click)="cancel()">
          <span>
            {{
              model.showModalWindow
                ? loc.get2("Buttons", "No").replace("&amp", "").replace(";", "")
                : loc.getP("Cancel")
            }}
          </span>
        </div>
      </div>
    </div>
  `, styles: [".options{display:flex;flex-direction:column;justify-content:center;width:100%;padding-left:10px}sti-checkbox{margin-top:5px;margin-bottom:5px}.modal-window{-webkit-touch-callout:none;-webkit-user-select:none;position:absolute;top:calc(50% - 75px);left:calc(50% - 150px);padding:0;font-family:Segoe UI;background-color:var(--back-color);width:300px;height:110px;z-index:9999999;border-radius:5px;display:flex;flex-direction:column;outline:1px solid rgb(81,92,106);-moz-box-shadow:0px 0px 7px rgba(0,0,0,.6);-webkit-box-shadow:0px 0px 7px rgb(0 0 0 / 60%);box-shadow:0 0 7px #0000004d}.nav{width:100%;height:30px;background-color:#515c6a;border-top-left-radius:4px;border-top-right-radius:4px;display:flex;align-items:center}.nav span{width:100%;margin-left:10px;color:#fff;font-size:13px;font-family:Arial}.close{height:100%;width:40px;border-top-right-radius:5px;display:flex;align-items:center;justify-content:center}.close:hover{background-color:#c83c31}.close:active{background-color:#c42b1c}.close img{height:16px;width:16px}.content{width:100%;display:flex;align-items:center;flex:1;padding:10px}.content img{margin-left:10px;margin-right:10px;width:32px;height:32px}p{font-size:12px;font-family:Arial;color:var(--text-color)}.buttons{align-self:flex-end;padding-bottom:5px;height:32px;display:flex;padding-right:3px}.button{width:80px;height:24px;border-radius:3px;display:flex;align-items:center;justify-content:center;margin:0 5px}.button span{font-size:12px;font-family:Arial;cursor:default;margin:0;padding:0}.accept{background-color:#19478a;color:#fff}.accept:hover{background-color:#3d6298}.cancel{background-color:#ddd;color:#444}.cancel:hover{background-color:#d5d5d5}\n"] }]
        }], ctorParameters: () => [{ type: i1.StiModelService }, { type: i2.StiExportService }, { type: i3.StiLocalizationService }], propDecorators: { handleKeyboardEvent: [{
                type: HostListener,
                args: ["document:keydown", ["$event"]]
            }] } });
//# sourceMappingURL=data:application/json;base64,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