import { Component } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "../../services/model.service";
import * as i2 from "../../services/sti-helper.service";
import * as i3 from "../../services/sti-form-events-service";
import * as i4 from "../../services/sti-localization.service";
import * as i5 from "../../services/sti-undo-service";
import * as i6 from "../../services/sti-clipboard-sevice";
import * as i7 from "@angular/common";
export class ContextMenuWindowComponent {
    constructor(model, helper, formEvents, loc, undoService, clipboardService) {
        this.model = model;
        this.helper = helper;
        this.formEvents = formEvents;
        this.loc = loc;
        this.undoService = undoService;
        this.clipboardService = clipboardService;
    }
    ngOnInit() { }
    pasteElement(event) {
        this.model.showContextMenu = false;
        this.clipboardService.pasteElement(event);
    }
    copyElement() {
        this.model.showContextMenu = false;
        this.clipboardService.copyElement();
    }
    cutElement() {
        this.model.showContextMenu = false;
        this.clipboardService.cutElement();
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: ContextMenuWindowComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiHelperService }, { token: i3.FormEventsService }, { token: i4.StiLocalizationService }, { token: i5.StiUndoService }, { token: i6.StiClipboardService }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: ContextMenuWindowComponent, selector: "sti-context-menu-window", ngImport: i0, template: `
    <div [style.left.px]="model.contextMenuX" [style.top.px]="model.contextMenuY" class="context-menu">
      <div
        *ngIf="(model.selectedComponent || clipboardService.hasCopy) && !model.selectedPage"
        class="context-menu-container"
      >
        <div
          class="context-menu-item {{ undoService.undos.length < 2 ? 'disabled' : '' }}"
          (click)="undoService.undo(); model.showContextMenu = false"
        >
          <img [src]="model.getImage('images.Ribbon.Undo.png')" /><span>{{
            loc.get2("MainMenu", "menuEditUndo").replace("&amp", "").replace(";", "")
          }}</span>
        </div>
        <div
          class="context-menu-item {{ undoService.redos.length < 1 ? 'disabled' : '' }}"
          (click)="undoService.redo(); model.showContextMenu = false"
        >
          <img [src]="model.getImage('images.Ribbon.Redo.png')" /><span>{{
            loc.get2("MainMenu", "menuEditRedo").replace("&amp", "").replace(";", "")
          }}</span>
        </div>
        <div
          class="context-menu-item {{ !clipboardService.hasCopy ? 'disabled' : '' }}"
          (click)="pasteElement($event)"
        >
          <img [src]="model.getImage('images.Ribbon.Paste.png')" /><span>{{
            loc.get2("MainMenu", "menuEditPaste").replace("&amp", "").replace(";", "")
          }}</span>
        </div>
        <div class="context-menu-item {{ clipboardService.canCopy ? 'disabled' : '' }}" (click)="copyElement()">
          <img [src]="model.getImage('images.Ribbon.Copy.png')" /><span>{{
            loc.get2("MainMenu", "menuEditCopy").replace("&amp", "").replace(";", "")
          }}</span>
        </div>
        <div class="context-menu-item {{ clipboardService.canCopy ? 'disabled' : '' }}" (click)="cutElement()">
          <img [src]="model.getImage('images.Ribbon.Cut.png')" /><span>{{
            loc.get2("MainMenu", "menuEditCut").replace("&amp", "").replace(";", "")
          }}</span>
        </div>
        <div class="context-menu-item" (click)="formEvents.deleteComponent()">
          <img [src]="model.getImage('images.Ribbon.Delete.png')" /><span>{{ loc.get2("Buttons", "Delete") }}</span>
        </div>
      </div>

      <!-- //////////////////////////////////////////////////////////////////// -->

      <div *ngIf="model.selectedPage" class="context-menu-container">
        <div *ngIf="clipboardService.hasCopy" class="context-menu-item" (click)="pasteElement($event)">
          <img [src]="model.getImage('images.Ribbon.Paste.png')" /><span>{{
            loc.get2("MainMenu", "menuEditPaste").replace("&amp", "").replace(";", "")
          }}</span>
        </div>
        <div class="context-menu-item {{ !formEvents.canMoveUp ? 'disabled' : '' }}" (click)="formEvents.moveUp()">
          <img [src]="model.getImage('images.Page.MovePageUp.png')" /><span>{{
            loc.get2("QueryBuilder", "MoveUp")
          }}</span>
        </div>
        <div class="context-menu-item {{ !formEvents.canMoveDown ? 'disabled' : '' }}" (click)="formEvents.moveDown()">
          <img [src]="model.getImage('images.Page.MovePageDown.png')" /><span>{{
            loc.get2("QueryBuilder", "MoveDown")
          }}</span>
        </div>
        <div class="context-menu-item" (click)="formEvents.insertBefore()">
          <img [src]="model.getImage('images.Page.InsertPageBefore.png')" /><span>{{
            loc.get2("TableRibbon", "InsertAbove")
          }}</span>
        </div>
        <div class="context-menu-item" (click)="formEvents.insertAfter()">
          <img [src]="model.getImage('images.Page.InsertPageAfter.png')" /><span>{{
            loc.get2("TableRibbon", "InsertBelow")
          }}</span>
        </div>
        <div class="context-menu-item {{ !formEvents.canClear ? 'disabled' : '' }}" (click)="formEvents.clear()">
          <img [src]="model.getImage('images.Page.ClearContent.png')" /><span>{{
            loc.get2("MainMenu", "menuEditClearContents")
          }}</span>
        </div>
        <div class="context-menu-item {{ !formEvents.canDelete ? 'disabled' : '' }}" (click)="formEvents.delete()">
          <img [src]="model.getImage('images.Page.DeletePage.png')" /><span>{{
            loc.get2("FormViewer", "PageDelete")
          }}</span>
        </div>
      </div>
    </div>
  `, isInline: true, styles: [".context-menu{position:absolute;z-index:999999999999999;background-color:var(--back-color);min-height:20px;max-height:380px;min-width:200px;display:flex;border:1px solid #c6c6c6;color:#444;-moz-box-shadow:0px 0px 7px rgba(0,0,0,.6);-webkit-box-shadow:0px 0px 7px rgb(0 0 0 / 60%);box-shadow:0 0 7px #0000004d;cursor:default;font-family:Arial;font-size:12px;padding:1px}.context-menu-container{height:100%;width:100%;display:flex;flex-direction:column;-webkit-user-select:none}.context-menu-item{display:flex;width:100%;height:26px;align-items:center;border-radius:3px}.context-menu-item:hover{background-color:#dadada}.context-menu-item img{height:16px;width:16px;margin-left:10px;margin-right:10px}.context-menu-item span{margin-right:10px}.disabled{opacity:.5;pointer-events:none}\n"], dependencies: [{ kind: "directive", type: i7.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }] }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: ContextMenuWindowComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-context-menu-window", template: `
    <div [style.left.px]="model.contextMenuX" [style.top.px]="model.contextMenuY" class="context-menu">
      <div
        *ngIf="(model.selectedComponent || clipboardService.hasCopy) && !model.selectedPage"
        class="context-menu-container"
      >
        <div
          class="context-menu-item {{ undoService.undos.length < 2 ? 'disabled' : '' }}"
          (click)="undoService.undo(); model.showContextMenu = false"
        >
          <img [src]="model.getImage('images.Ribbon.Undo.png')" /><span>{{
            loc.get2("MainMenu", "menuEditUndo").replace("&amp", "").replace(";", "")
          }}</span>
        </div>
        <div
          class="context-menu-item {{ undoService.redos.length < 1 ? 'disabled' : '' }}"
          (click)="undoService.redo(); model.showContextMenu = false"
        >
          <img [src]="model.getImage('images.Ribbon.Redo.png')" /><span>{{
            loc.get2("MainMenu", "menuEditRedo").replace("&amp", "").replace(";", "")
          }}</span>
        </div>
        <div
          class="context-menu-item {{ !clipboardService.hasCopy ? 'disabled' : '' }}"
          (click)="pasteElement($event)"
        >
          <img [src]="model.getImage('images.Ribbon.Paste.png')" /><span>{{
            loc.get2("MainMenu", "menuEditPaste").replace("&amp", "").replace(";", "")
          }}</span>
        </div>
        <div class="context-menu-item {{ clipboardService.canCopy ? 'disabled' : '' }}" (click)="copyElement()">
          <img [src]="model.getImage('images.Ribbon.Copy.png')" /><span>{{
            loc.get2("MainMenu", "menuEditCopy").replace("&amp", "").replace(";", "")
          }}</span>
        </div>
        <div class="context-menu-item {{ clipboardService.canCopy ? 'disabled' : '' }}" (click)="cutElement()">
          <img [src]="model.getImage('images.Ribbon.Cut.png')" /><span>{{
            loc.get2("MainMenu", "menuEditCut").replace("&amp", "").replace(";", "")
          }}</span>
        </div>
        <div class="context-menu-item" (click)="formEvents.deleteComponent()">
          <img [src]="model.getImage('images.Ribbon.Delete.png')" /><span>{{ loc.get2("Buttons", "Delete") }}</span>
        </div>
      </div>

      <!-- //////////////////////////////////////////////////////////////////// -->

      <div *ngIf="model.selectedPage" class="context-menu-container">
        <div *ngIf="clipboardService.hasCopy" class="context-menu-item" (click)="pasteElement($event)">
          <img [src]="model.getImage('images.Ribbon.Paste.png')" /><span>{{
            loc.get2("MainMenu", "menuEditPaste").replace("&amp", "").replace(";", "")
          }}</span>
        </div>
        <div class="context-menu-item {{ !formEvents.canMoveUp ? 'disabled' : '' }}" (click)="formEvents.moveUp()">
          <img [src]="model.getImage('images.Page.MovePageUp.png')" /><span>{{
            loc.get2("QueryBuilder", "MoveUp")
          }}</span>
        </div>
        <div class="context-menu-item {{ !formEvents.canMoveDown ? 'disabled' : '' }}" (click)="formEvents.moveDown()">
          <img [src]="model.getImage('images.Page.MovePageDown.png')" /><span>{{
            loc.get2("QueryBuilder", "MoveDown")
          }}</span>
        </div>
        <div class="context-menu-item" (click)="formEvents.insertBefore()">
          <img [src]="model.getImage('images.Page.InsertPageBefore.png')" /><span>{{
            loc.get2("TableRibbon", "InsertAbove")
          }}</span>
        </div>
        <div class="context-menu-item" (click)="formEvents.insertAfter()">
          <img [src]="model.getImage('images.Page.InsertPageAfter.png')" /><span>{{
            loc.get2("TableRibbon", "InsertBelow")
          }}</span>
        </div>
        <div class="context-menu-item {{ !formEvents.canClear ? 'disabled' : '' }}" (click)="formEvents.clear()">
          <img [src]="model.getImage('images.Page.ClearContent.png')" /><span>{{
            loc.get2("MainMenu", "menuEditClearContents")
          }}</span>
        </div>
        <div class="context-menu-item {{ !formEvents.canDelete ? 'disabled' : '' }}" (click)="formEvents.delete()">
          <img [src]="model.getImage('images.Page.DeletePage.png')" /><span>{{
            loc.get2("FormViewer", "PageDelete")
          }}</span>
        </div>
      </div>
    </div>
  `, styles: [".context-menu{position:absolute;z-index:999999999999999;background-color:var(--back-color);min-height:20px;max-height:380px;min-width:200px;display:flex;border:1px solid #c6c6c6;color:#444;-moz-box-shadow:0px 0px 7px rgba(0,0,0,.6);-webkit-box-shadow:0px 0px 7px rgb(0 0 0 / 60%);box-shadow:0 0 7px #0000004d;cursor:default;font-family:Arial;font-size:12px;padding:1px}.context-menu-container{height:100%;width:100%;display:flex;flex-direction:column;-webkit-user-select:none}.context-menu-item{display:flex;width:100%;height:26px;align-items:center;border-radius:3px}.context-menu-item:hover{background-color:#dadada}.context-menu-item img{height:16px;width:16px;margin-left:10px;margin-right:10px}.context-menu-item span{margin-right:10px}.disabled{opacity:.5;pointer-events:none}\n"] }]
        }], ctorParameters: () => [{ type: i1.StiModelService }, { type: i2.StiHelperService }, { type: i3.FormEventsService }, { type: i4.StiLocalizationService }, { type: i5.StiUndoService }, { type: i6.StiClipboardService }] });
//# sourceMappingURL=data:application/json;base64,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