import { Component, Input, ViewChild, Output, EventEmitter } from '@angular/core';
import { ProxyService } from './proxy.service';
import { EMPTY, catchError } from 'rxjs';
import { FileSaverService } from './file.saver.service';
import * as i0 from "@angular/core";
import * as i1 from "./proxy.service";
import * as i2 from "@angular/common/http";
export class StimulsoftDesignerComponent {
    constructor(proxy, httpClient) {
        this.proxy = proxy;
        this.httpClient = httpClient;
        /**
         * Occurs when designer loaded
         */
        this.designerLoaded = new EventEmitter();
        this.id = 'aDesigner' + (Math.random() * 10000000).toString();
        this.scriptLoading = false;
        this.loaded = false;
    }
    ngOnDestroy() {
        if (this.chartScripts) {
            this.head.removeChild(this.chartScripts);
        }
        let options = this.designerEl.nativeElement?.firstChild?.jsObject?.options;
        try {
            clearTimeout(options.timerAjax);
        }
        catch { }
        try {
            clearTimeout(options.timerUpdateCache);
        }
        catch { }
        try {
            clearTimeout(options.timerAutoSave);
        }
        catch { }
    }
    ngOnInit() {
        this.addScript();
    }
    ngOnChanges(changes) {
        this.addScript();
    }
    addScript() {
        if (this.scriptLoading)
            return;
        this.scriptLoading = true;
        if (this.chartScripts) {
            this.head.removeChild(this.chartScripts);
        }
        this.chartScripts = document.createElement('Script');
        this.chartScripts.setAttribute('type', 'text/javascript');
        this.head.appendChild(this.chartScripts);
        let observable = this.httpClient.get(this.requestUrl, { responseType: 'text' }).pipe(catchError((error) => {
            console.log(error);
            this.scriptLoading = false;
            return EMPTY;
        }));
        observable.subscribe(data => {
            if (!this.loaded) {
                try {
                    this.chartScripts.innerHTML = data;
                    const options = new Stimulsoft.Designer.StiDesignerOptions();
                    this.loaded = true;
                    setTimeout(() => {
                        this.scriptLoading = false;
                    });
                    this.showDesigner();
                    this.designerLoadedF();
                }
                catch {
                    this.scriptLoading = false;
                }
            }
        });
    }
    designerLoadedF() {
        let jsObject = this.designerEl.nativeElement?.firstChild?.jsObject;
        if (!jsObject) {
            setTimeout(() => {
                this.designerLoadedF();
            });
            return;
        }
        this.designerLoaded.next(null);
    }
    showDesigner() {
        const options = new Stimulsoft.Designer.StiDesignerOptions();
        let defaultOptions = Stimulsoft?.Designer?.defaultOptions;
        if (defaultOptions) {
            for (let k in defaultOptions)
                options[k] = defaultOptions[k];
            options.useAliasesDictionary = defaultOptions.dictionary.useAliases;
        }
        if (this.width) {
            options.width = this.width;
        }
        if (this.height) {
            options.height = this.height;
        }
        this.designer = new Stimulsoft.Designer.StiDesigner(options, 'StiDesigner', false);
        this.proxy.postParametersFunction_ = this.postParametersFunction;
        this.designerEl.nativeElement.proxy = this.proxy;
        this.designer.renderHtml(this.designerEl.nativeElement);
    }
    get head() {
        return document.getElementsByTagName('head')[0];
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StimulsoftDesignerComponent, deps: [{ token: i1.ProxyService }, { token: i2.HttpClient }], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "18.2.14", type: StimulsoftDesignerComponent, selector: "stimulsoft-designer-angular", inputs: { requestUrl: "requestUrl", width: "width", height: "height", postParametersFunction: "postParametersFunction" }, outputs: { designerLoaded: "designerLoaded" }, providers: [ProxyService, FileSaverService], viewQueries: [{ propertyName: "designerEl", first: true, predicate: ["designer"], descendants: true }], usesOnChanges: true, ngImport: i0, template: `
    <div #designer [attr.id]="id">
      <ng-content></ng-content>
    </div>
  `, isInline: true }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: StimulsoftDesignerComponent, decorators: [{
            type: Component,
            args: [{ selector: 'stimulsoft-designer-angular', template: `
    <div #designer [attr.id]="id">
      <ng-content></ng-content>
    </div>
  `, providers: [ProxyService, FileSaverService] }]
        }], ctorParameters: () => [{ type: i1.ProxyService }, { type: i2.HttpClient }], propDecorators: { designerEl: [{
                type: ViewChild,
                args: ['designer']
            }], designerLoaded: [{
                type: Output
            }], requestUrl: [{
                type: Input
            }], width: [{
                type: Input
            }], height: [{
                type: Input
            }], postParametersFunction: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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