import { Injectable } from '@angular/core';
import * as i0 from "@angular/core";
export class FileSaverService {
    constructor() {
        this._global = typeof window === 'object' && window.window === window
            ? window : typeof self === 'object' && self.self === self
            ? self : /*typeof global === 'object' && global.global === global
          ? global
          : */
            this;
        // Detect WebView inside a native macOS app by ruling out all browsers
        // We just need to check for 'Safari' because all other browsers (besides Firefox) include that too
        // https://www.whatismybrowser.com/guides/the-latest-user-agent/macos
        this.isMacOSWebView = this._global.navigator && /Macintosh/.test(navigator.userAgent) && /AppleWebKit/.test(navigator.userAgent) && !/Safari/.test(navigator.userAgent);
        this.saveAs = this._global.saveAs || (
        // probably in some web worker
        (typeof window !== 'object' || window !== this._global)
            ? function saveAs() { }
            // Use download attribute first if possible (#193 Lumia mobile) unless this is a macOS WebView
            : ('download' in HTMLAnchorElement.prototype && !this.isMacOSWebView)
                ? function saveAs(blob, name, opts) {
                    let URL = this._global.URL || this._global.webkitURL;
                    let a = document.createElement('a');
                    name = name || blob.name || 'download';
                    a.download = name;
                    a.rel = 'noopener'; // tabnabbing
                    // TODO: detect chrome extensions & packaged apps
                    // a.target = '_blank'
                    if (typeof blob === 'string') {
                        // Support regular links
                        a.href = blob;
                        if (a.origin !== location.origin) {
                            this.corsEnabled(a.href)
                                ? this.download(blob, name, opts)
                                : this.click(a, a.target = '_blank');
                        }
                        else {
                            this.click(a);
                        }
                    }
                    else {
                        // Support blobs
                        a.href = URL.createObjectURL(blob);
                        let this_ = this;
                        setTimeout(function () { URL.revokeObjectURL(a.href); }, 4E4); // 40s
                        setTimeout(function () { this_.click(a); }, 0);
                    }
                }
                // Use msSaveOrOpenBlob as a second approach
                : 'msSaveOrOpenBlob' in navigator
                    ? function saveAs(blob, name, opts) {
                        name = name || blob.name || 'download';
                        if (typeof blob === 'string') {
                            if (this.corsEnabled(blob)) {
                                this.download(blob, name, opts);
                            }
                            else {
                                let a = document.createElement('a');
                                a.href = blob;
                                a.target = '_blank';
                                let this_ = this;
                                setTimeout(function () { this_.click(a); });
                            }
                        }
                        else {
                            navigator.msSaveOrOpenBlob(this.bom(blob, opts), name);
                        }
                    }
                    // Fallback to using FileReader and a popup
                    : function saveAs(blob, name, opts, popup) {
                        // Open a popup immediately do go around popup blocker
                        // Mostly only available on user interaction and the fileReader is async so...
                        popup = popup || open('', '_blank');
                        if (popup) {
                            popup.document.title =
                                popup.document.body.innerText = 'downloading...';
                        }
                        if (typeof blob === 'string')
                            return this.download(blob, name, opts);
                        let force = blob.type === 'application/octet-stream';
                        let isSafari = /constructor/i.test(this._global.HTMLElement) || this._global.safari;
                        let isChromeIOS = /CriOS\/[\d]+/.test(navigator.userAgent);
                        if ((isChromeIOS || (force && isSafari) || this.isMacOSWebView) && typeof FileReader !== 'undefined') {
                            // Safari doesn't allow downloading of blob URLs
                            let reader = new FileReader();
                            reader.onloadend = function () {
                                let url = reader.result;
                                url = isChromeIOS ? url : url.replace(/^data:[^;]*;/, 'data:attachment/file;');
                                if (popup)
                                    popup.location.href = url;
                                else
                                    location = url;
                                popup = null; // reverse-tabnabbing #460
                            };
                            reader.readAsDataURL(blob);
                        }
                        else {
                            let URL = this._global.URL || this._global.webkitURL;
                            let url = URL.createObjectURL(blob);
                            if (popup)
                                popup.location = url;
                            else
                                location.href = url;
                            popup = null; // reverse-tabnabbing #460
                            setTimeout(function () { URL.revokeObjectURL(url); }, 4E4); // 40s
                        }
                    });
        this._global.saveAs = this.saveAs.saveAs = this.saveAs;
        /*if (typeof module !== 'undefined') {
          module.exports = this.saveAs;
        }*/
    }
    bom(blob, opts) {
        if (typeof opts === 'undefined')
            opts = { autoBom: false };
        else if (typeof opts !== 'object') {
            console.warn('Deprecated: Expected third argument to be a object');
            opts = { autoBom: !opts };
        }
        // prepend BOM for UTF-8 XML and text/* types (including HTML)
        // note: your browser will automatically convert UTF-16 U+FEFF to EF BB BF
        if (opts.autoBom && /^\s*(?:text\/\S*|application\/xml|\S*\/\S*\+xml)\s*;.*charset\s*=\s*utf-8/i.test(blob.type)) {
            return new Blob([String.fromCharCode(0xFEFF), blob], { type: blob.type });
        }
        return blob;
    }
    download(url, name, opts) {
        let xhr = new XMLHttpRequest();
        xhr.open('GET', url);
        xhr.responseType = 'blob';
        let this_ = this;
        xhr.onload = function () {
            this_.saveAs(xhr.response, name, opts);
        };
        xhr.onerror = function () {
            console.error('could not download file');
        };
        xhr.send();
    }
    corsEnabled(url) {
        let xhr = new XMLHttpRequest();
        // use sync to avoid popup blocker
        xhr.open('HEAD', url, false);
        try {
            xhr.send();
        }
        catch (e) { }
        return xhr.status >= 200 && xhr.status <= 299;
    }
    // `a.click()` doesn't work for all browsers (#465)
    click(node) {
        try {
            node.dispatchEvent(new MouseEvent('click'));
        }
        catch (e) {
            let evt = document.createEvent('MouseEvents');
            evt.initMouseEvent('click', true, true, window, 0, 0, 0, 80, 20, false, false, false, false, 0, null);
            node.dispatchEvent(evt);
        }
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: FileSaverService, deps: [], target: i0.ɵɵFactoryTarget.Injectable }); }
    static { this.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: FileSaverService }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "18.2.14", ngImport: i0, type: FileSaverService, decorators: [{
            type: Injectable
        }], ctorParameters: () => [] });
//# sourceMappingURL=data:application/json;base64,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