﻿
StiMobileDesigner.prototype.InitializeReportPanel = function () {
    var jsObject = this;
    var reportPanel = this.ChildWorkPanel("reportPanel");
    reportPanel.style.display = "none";

    var mainTable = reportPanel.mainTableClassic = this.CreateHTMLTable();
    mainTable.style.display = jsObject.options.ribbonType == "Classic" ? "" : "none";
    mainTable.addCell(this.ReportPanelReportSetupBlock());
    mainTable.addCell(this.GroupBlockSeparator());
    reportPanel.appendChild(mainTable);

    this.InitializeReportPanelSingleLine(reportPanel);

    reportPanel.changeByRibbonType = function () {
        this.mainTableSingleLine.style.display = jsObject.options.ribbonType != "Classic" ? "" : "none";
        this.mainTableClassic.style.display = jsObject.options.ribbonType == "Classic" ? "" : "none";
        this.setHeightByRibbonType();
    }

    reportPanel.updateControls = function () {
        var buttonNames = ["reportPanelReportSetup", "reportPanelPreviewSettings", "reportPanelExportSettings", "reportPanelGlobalization", "reportPanelProperties"];

        for (var i = 0; i < buttonNames.length; i++) {
            var button = jsObject.options.buttons[buttonNames[i]];
            if (button) {
                button.setEnabled(jsObject.options.report != null);

                if (buttonNames[i] == "reportPanelPreviewSettings") {
                    button.setMarkerVisibleState(button.isEnabled && jsObject.PreviewSettingsIsNotDefault());
                }
                if (buttonNames[i] == "reportPanelExportSettings" && !jsObject.options.jsMode) {
                    button.setMarkerVisibleState(button.isEnabled && jsObject.ExportSettingsIsNotDefault());
                }
                if (buttonNames[i] == "reportPanelGlobalization") {
                    button.setMarkerVisibleState(false);
                    var report = jsObject.options.report;

                    if (button.isEnabled && report) {
                        if (report.properties.globalizationStringsIsDefault != null) {
                            button.setMarkerVisibleState(!report.properties.globalizationStringsIsDefault);
                        }
                        else {
                            var globalButton = button;
                            jsObject.SendCommandGetGlobalizationStrings(function (answer) {
                                report.properties.globalizationStringsIsDefault = answer.globalizationStrings && answer.globalizationStrings.length == 0;
                                globalButton.setMarkerVisibleState(!report.properties.globalizationStringsIsDefault);
                            });
                        }
                    }
                }
            }
        }
        jsObject.options.controls.groupBlockReportSetup.button.setEnabled(jsObject.options.report != null);

        reportPanel.updateSingleLineControls();
    }
}

//Report Setup
StiMobileDesigner.prototype.ReportPanelReportSetupBlock = function () {
    var jsObject = this;
    var reportSetupText = this.loc.MainMenu.menuFileReportSetup.replace("...", "").replace("&", "");
    var reportSetupGroupBlock = this.GroupBlock("groupBlockReportSetup", reportSetupText, true, null);
    var innerTable = this.GroupBlockInnerTable();
    reportSetupGroupBlock.container.appendChild(innerTable);
    innerTable.style.height = "100%";

    reportSetupGroupBlock.button.action = function () {
        jsObject.InitializeReportSetupForm(function (reportSetupForm) {
            reportSetupForm.show();
        });
    }

    //Report Setup
    var reportSetupButton = this.ReportPanelBigButton("reportPanelReportSetup", reportSetupText, "ReportPanel.ReportSetup.png", [reportSetupText, this.GetHelpLink("report")], 60);
    innerTable.addCell(reportSetupButton).style.padding = "2px";
    reportSetupButton.action = function () {
        jsObject.InitializeReportSetupForm(function (reportSetupForm) {
            reportSetupForm.show();
        });
    }

    //Separator
    var sep1 = this.HomePanelSeparator();
    sep1.style.height = this.options.isTouchDevice ? "90px" : "70px";
    innerTable.addCell(sep1);

    //Preview Settings
    var previewSettingsButton = this.ReportPanelBigButton("reportPanelPreviewSettings", this.loc.PropertyMain.PreviewSettings, "ReportPanel.Preview.png", [this.loc.PropertyMain.PreviewSettings, this.GetHelpLink("report")], 60);
    innerTable.addCell(previewSettingsButton).style.padding = "2px";
    previewSettingsButton.action = function () {
        jsObject.InitializePreviewSettingsForm(function (form) {
            form.show();
        });
    }

    //Export Settings
    if (!this.options.jsMode) {
        var exportSettingsButton = this.ReportPanelBigButton("reportPanelExportSettings", this.loc.PropertyMain.ExportSettings, "ReportPanel.ExportSettings.png", [this.loc.PropertyMain.ExportSettings, this.GetHelpLink("report")], 60);
        innerTable.addCell(exportSettingsButton).style.padding = "2px";
        exportSettingsButton.action = function () {
            jsObject.InitializeExportSettingsForm(function (form) {
                form.show();
            });
        }
    }

    //Globalization
    var globalizationButton = this.ReportPanelBigButton("reportPanelGlobalization", this.loc.PropertyCategory.GlobalizationCategory, "ReportPanel.Globalization.png", [this.loc.PropertyCategory.GlobalizationCategory, this.GetHelpLink("report")], 75);
    innerTable.addCell(globalizationButton).style.padding = "2px";
    globalizationButton.action = function () {
        jsObject.SendCommandGetGlobalizationStrings(function (answer) {
            jsObject.InitializeGlobalizationEditorForm(function (globalizationEditorForm) {
                globalizationEditorForm.show(answer);
            })
        });
    }

    //Separator2
    var sep2 = this.HomePanelSeparator();
    sep2.style.height = this.options.isTouchDevice ? "90px" : "70px";
    innerTable.addCell(sep2);

    //Properties
    var propertiesButton = this.ReportPanelBigButton("reportPanelProperties", this.loc.Panels.Properties, "ReportPanel.Properties.png", [this.loc.Panels.Properties, this.GetHelpLink("report")], 60);
    innerTable.addCell(propertiesButton).style.padding = "2px";
    propertiesButton.action = function () {
        jsObject.options.paintPanel.action();
    }

    return reportSetupGroupBlock;
}

StiMobileDesigner.prototype.ReportPanelBigButton = function (name, caption, imageName, toolTip, maxWidth, minWidth) {
    var button = this.StandartBigButton(name, null, caption, imageName, toolTip, maxWidth, minWidth);
    if (button.cellImage) {
        button.cellImage.style.padding = "2px 2px 0px 2px";
        button.cellImage.style.height = "30px";
    }
    if (button.caption) {
        button.caption.style.padding = "0 2px 0 2px";
        button.caption.style.height = "37px";
        button.caption.style.verticalAlign = "top";
    }
    return button;
}

StiMobileDesigner.prototype.PreviewSettingsIsNotDefault = function () {
    if (this.options.report && this.options.defaultPreviewSettings) {
        var defaultSettings = this.options.defaultPreviewSettings;
        var currentSettings = this.options.report.properties.previewSettings;

        for (var propName in currentSettings) {
            if (defaultSettings[propName] != null && defaultSettings[propName] != currentSettings[propName]) {
                return true;
            }
        }
    }
    return false;
}

StiMobileDesigner.prototype.ExportSettingsIsNotDefault = function () {
    var report = this.options.report;
    if (report && report.properties.exportSettings) {
        return (report.properties.exportSettings.Report.length > 0 || report.properties.exportSettings.Dashboard.length > 0);
    }
    return false;
}