﻿
StiMobileDesigner.prototype.PropertyColorControl = function (name, toolTip, width, showFromStyle) {
    var propertyColorControl = this.ColorControl(name, toolTip, true);
    propertyColorControl.isColorControl = true;
    propertyColorControl.showFromStyle = showFromStyle;
    var jsObject = this;

    //Ovveride New Button
    var newButton = this.SmallButton(name + "Button", null, "", "BrushSolid.png", toolTip, "Down", "stiDesignerPropertiesBrushControlButton");
    newButton.style.width = (width + 4) + "px";
    newButton.caption.style.width = "100%";
    newButton.colorControl = propertyColorControl;

    newButton.onclick = null;
    newButton.ontouchend = null;
    newButton.style.background = "transparent";

    var colorBar = document.createElement("div");
    colorBar.className = "stiBrushControlColorBar";

    var imageCell = newButton.image.parentElement;
    imageCell.removeChild(newButton.image);
    imageCell.appendChild(colorBar);
    newButton.image = colorBar;

    var textField = propertyColorControl.textField = this.TextBox(null, width - 62, 18);
    textField.style.background = "transparent";
    textField.style.border = "0";
    textField.style.textOverflow = "ellipsis";
    newButton.caption.appendChild(textField);

    textField.action = function () {
        propertyColorControl.setKey(jsObject.ParseStringToRGBColor(this.value), propertyColorControl.isDbsElement);
        propertyColorControl.action();
        jsObject.SaveRecentColorsToCookies(jsObject.ParseStringToRGBColor(this.value));
    }

    //DropDownButton
    var dropDownButton = this.SmallButton(null, null, null, "Arrows.SmallArrowDown.png", null, null, "stiDesignerDropDownListButton", null, { width: 8, height: 8 });
    dropDownButton.imageCell.style.padding = "0px";
    dropDownButton.innerTable.style.width = "100%";
    dropDownButton.style.width = (this.options.controlsButtonsWidth + 2) + "px";
    dropDownButton.style.height = (this.options.controlsHeight - 3) + "px";
    dropDownButton.style.border = "0";

    newButton.arrowCell.innerHTML = "";
    newButton.arrowCell.appendChild(dropDownButton);
    newButton.arrowCell.style.padding = "0";

    dropDownButton.action = function () {
        propertyColorControl.button.action();
    }

    //Override Old Button
    var oldButtonCell = propertyColorControl.button.parentElement;
    oldButtonCell.removeChild(propertyColorControl.button);
    oldButtonCell.appendChild(newButton);
    propertyColorControl.button = newButton;

    //Override Methods
    propertyColorControl.button.action = function () {
        var colorDialog = jsObject.options.menus.colorDialog || jsObject.InitializeColorDialog();
        colorDialog.rightToLeft = this.colorControl.rightToLeft;
        colorDialog.noFillButton.caption.innerHTML = (propertyColorControl.isDbsElement || propertyColorControl.showFromStyle) && !colorDialog.visible
            ? jsObject.loc.FormStyleDesigner.FromStyle
            : jsObject.loc.PropertyColor.Transparent;

        colorDialog.changeVisibleState(!colorDialog.visible, this);
    }

    propertyColorControl.button.choosedColor = function (key) {
        this.colorControl.setKey(key);
        this.colorControl.action();
        jsObject.SaveRecentColorsToCookies(key);
    };

    propertyColorControl.setKey = function (key, isDbsElement) {
        var notLocalizeValues = this.ownerIsProperty && jsObject.options.propertiesPanel && !jsObject.options.propertiesPanel.localizePropertyGrid;
        this.key = key;
        this.isDbsElement = isDbsElement;
        if (key == "StiEmptyValue") {
            this.button.image.style.opacity = 0;
            this.button.caption.innerHTML = "";
            return;
        }
        this.button.image.style.opacity = 1;
        var color;
        if (key == "transparent")
            color = "255,255,255";
        else {
            var colors = key.split(",");
            if (colors.length == 4) {
                this.button.image.style.opacity = jsObject.StrToInt(colors[0]) / 255;
                colors.splice(0, 1);
            }
            color = colors[0] + "," + colors[1] + "," + colors[2];
        }

        this.button.image.style.background = "rgb(" + color + ")";
        var colorName = jsObject.GetColorNameByRGB(this.key, notLocalizeValues);
        var hexColor = this.key == "transparent" || this.key == "0,255,255,255" ? jsObject.loc.PropertyColor.Transparent : jsObject.RgbColorStrToHexColor(this.key).toUpperCase();
        textField.value = ((isDbsElement || propertyColorControl.showFromStyle) && (key == "transparent" || key == "0,255,255,255")) ? (notLocalizeValues ? "FromStyle" : jsObject.loc.FormStyleDesigner.FromStyle) : (colorName || hexColor);
    };

    return propertyColorControl;
}