﻿
StiMobileDesigner.prototype.PagePropertiesGroup = function () {
    var jsObject = this;
    var pagePropertiesGroup = this.PropertiesGroup("pagePropertiesGroup", this.loc.Toolbars.TabPage);
    pagePropertiesGroup.style.display = "none";

    //Page Size
    var pageSizeItems = [];
    for (var sizeNumber in this.options.paperSizes) {
        if (this.options.paperSizes[sizeNumber] != "none")
            pageSizeItems.push(this.Item("pageSizePropertyItem" + sizeNumber, this.options.paperSizes[sizeNumber], null, sizeNumber.toString()));
    }
    var pageSizeControl = this.PropertyDropDownList("controlPropertyPageSize", this.options.propertyControlWidth, pageSizeItems, true, false);
    pageSizeControl.action = function () {
        jsObject.options.currentPage.properties.paperSize = this.key;
        if (this.key != "0") {
            var pageWidth = jsObject.ConvertPixelToUnit(jsObject.PaperSizesInPixels[parseInt(this.key)][0]).toFixed(1);
            var pageHeight = jsObject.ConvertPixelToUnit(jsObject.PaperSizesInPixels[parseInt(this.key)][1]).toFixed(1);
            if (Math.round(pageWidth) == pageWidth) pageWidth = Math.round(pageWidth);
            if (Math.round(pageHeight) == pageHeight) pageHeight = Math.round(pageHeight);
            var orientation = jsObject.options.currentPage.properties.orientation;
            jsObject.options.currentPage.properties.unitWidth = (orientation == "Portrait") ? pageWidth.toString() : pageHeight.toString();
            jsObject.options.currentPage.properties.unitHeight = (orientation == "Portrait") ? pageHeight.toString() : pageWidth.toString();
        }
        jsObject.SendCommandSendProperties(jsObject.options.currentPage, ["paperSize", "unitWidth", "unitHeight"]);
    }
    pagePropertiesGroup.container.appendChild(this.Property("paperSize", this.loc.PropertyMain.PaperSize, pageSizeControl));

    //Page Width
    var pageWidthControl = this.PropertyTextBox("controlPropertyPageWidth", this.options.propertyNumbersControlWidth);
    pageWidthControl.action = function () {
        this.value = Math.abs(jsObject.StrToDouble(this.value));
        jsObject.options.currentPage.properties.unitWidth = this.value;
        jsObject.options.currentPage.properties.paperSize = "0";
        jsObject.SendCommandSendProperties(jsObject.options.currentPage, ["unitWidth", "paperSize"]);
    }
    pagePropertiesGroup.container.appendChild(this.Property("pageWidth", this.loc.PropertyMain.PageWidth, pageWidthControl));

    //Page Height
    var pageHeightControl = this.PropertyTextBox("controlPropertyPageHeight", this.options.propertyNumbersControlWidth);
    pageHeightControl.action = function () {
        this.value = Math.abs(jsObject.StrToDouble(this.value));
        jsObject.options.currentPage.properties.unitHeight = this.value;
        jsObject.options.currentPage.properties.paperSize = "0";
        jsObject.SendCommandSendProperties(jsObject.options.currentPage, ["unitHeight", "paperSize"]);
    }
    pagePropertiesGroup.container.appendChild(this.Property("pageHeight", this.loc.PropertyMain.PageHeight, pageHeightControl));

    //Page Orientation
    var pageOrientationControl = this.PropertyDropDownList("controlPropertyPageOrientation", this.options.propertyControlWidth, this.GetPageOrientationItems(false), true, false);
    pageOrientationControl.action = function () {
        jsObject.options.currentPage.properties.orientation = this.key;
        jsObject.SendCommandSendProperties(jsObject.options.currentPage, ["orientation"]);
    }
    pagePropertiesGroup.container.appendChild(this.Property("pageOrientation", this.loc.PropertyMain.Orientation, pageOrientationControl, "Orientation"));

    //Page Margins
    var pageMarginsControl = this.PropertyMarginsControl("controlPropertyPageMargins", this.options.propertyControlWidth + 61);
    pageMarginsControl.action = function () {
        jsObject.options.currentPage.properties.unitMargins = this.getValue(true);
        jsObject.SendCommandSendProperties(jsObject.options.currentPage, ["unitMargins"]);
    }
    pagePropertiesGroup.container.appendChild(this.Property("pageMargins", this.loc.PropertyMain.Margins, pageMarginsControl, "Margins"));

    //NumberOfCopies
    var pageNumberOfCopiesControl = this.PropertyTextBox("controlPropertyPageNumberOfCopies", this.options.propertyNumbersControlWidth);
    pageNumberOfCopiesControl.action = function () {
        this.value = Math.abs(jsObject.StrToInt(this.value));
        jsObject.ApplyPropertyValue("numberOfCopies", this.value);
    }
    pagePropertiesGroup.container.appendChild(this.Property("pageNumberOfCopies", this.loc.PropertyMain.NumberOfCopies, pageNumberOfCopiesControl));

    //Watermark Style
    var controlPropertyWatermarkStyle = this.PropertyDropDownList("controlPropertyWatermarkStyle", this.options.propertyControlWidth, this.GetWatermarkStyleItems(), true, false);
    controlPropertyWatermarkStyle.action = function () {
        jsObject.ApplyPropertyValue("watermarkStyle", this.key);
    }
    pagePropertiesGroup.container.appendChild(this.Property("watermarkStyle", this.loc.PropertyMain.WatermarkStyle, controlPropertyWatermarkStyle));

    //Watermark Button
    var watermarkButtonBlock = this.PropertyBlockWithButton("propertiesWatermarkButtonBlock", "PageWatermark.png", this.loc.PropertyMain.Watermark + "...");
    pagePropertiesGroup.container.appendChild(watermarkButtonBlock);

    watermarkButtonBlock.button.action = function () {
        jsObject.InitializePageSetupForm(function (pageSetupForm) {
            pageSetupForm.changeVisibleState(true);
            pageSetupForm.setMode("Watermark");
        });
    }

    return pagePropertiesGroup;
}