﻿
StiMobileDesigner.prototype.ColumnsPropertiesGroup = function () {
    var jsObject = this;
    var columnsPropertiesGroup = this.PropertiesGroup("columnsPropertiesGroup", this.loc.PropertyMain.Columns);
    columnsPropertiesGroup.style.display = "none";

    //Columns
    var columnsControl = this.PropertyTextBox("controlPropertyColumns", this.options.propertyNumbersControlWidth);
    columnsControl.action = function () {
        this.value = jsObject.StrToCorrectPositiveInt(this.value);
        jsObject.ApplyPropertyValue("columns", this.value);
    }
    columnsPropertiesGroup.container.appendChild(this.Property("columns", this.loc.FormPageSetup.NumberOfColumns, columnsControl));

    //Column Width
    var columnWidthControl = this.PropertyTextBox("controlPropertyColumnWidth", this.options.propertyNumbersControlWidth);
    columnWidthControl.action = function () {
        this.value = Math.abs(jsObject.StrToDouble(this.value));
        jsObject.ApplyPropertyValue("columnWidth", this.value);
    }
    columnsPropertiesGroup.container.appendChild(this.Property("columnWidth", this.loc.PropertyMain.ColumnWidth, columnWidthControl));

    //Column Gaps
    var columnGapsControl = this.PropertyTextBox("controlPropertyColumnGaps", this.options.propertyNumbersControlWidth);
    columnGapsControl.action = function () {
        this.value = Math.abs(jsObject.StrToDouble(this.value));
        jsObject.ApplyPropertyValue("columnGaps", this.value);
    }
    columnsPropertiesGroup.container.appendChild(this.Property("columnGaps", this.loc.PropertyMain.ColumnGaps, columnGapsControl));

    //Column Direction
    var controlPropertyColumnDirection = this.PropertyDropDownList("controlPropertyColumnDirection", this.options.propertyControlWidth, this.GetColumnDirectionItems(), true, false);
    controlPropertyColumnDirection.action = function () {
        jsObject.ApplyPropertyValue("columnDirection", this.key);
    }
    columnsPropertiesGroup.container.appendChild(this.Property("columnDirection", this.loc.PropertyMain.ColumnDirection, controlPropertyColumnDirection));

    //GapAfterLastColumn
    var gapAfterLastColumnControl = this.CheckBox("controlPropertyGapAfterLastColumn");
    gapAfterLastColumnControl.action = function () {
        jsObject.ApplyPropertyValue("gapAfterLastColumn", this.isChecked);
    }
    columnsPropertiesGroup.container.appendChild(this.Property("gapAfterLastColumn", this.loc.PropertyMain.GapAfterLastColumn, gapAfterLastColumnControl));

    //RightToLeft
    var rightToLeftControl = this.CheckBox("controlPropertyRightToLeft");
    rightToLeftControl.action = function () {
        jsObject.ApplyPropertyValue("rightToLeft", this.isChecked);
    }
    columnsPropertiesGroup.container.appendChild(this.Property("rightToLeft", this.loc.PropertyMain.RightToLeft, rightToLeftControl));

    //Min Rows In Column
    var minRowsInColumnControl = this.PropertyTextBox("controlPropertyMinRowsInColumn", this.options.propertyNumbersControlWidth);
    minRowsInColumnControl.action = function () {
        this.value = jsObject.StrToCorrectPositiveInt(this.value);
        jsObject.ApplyPropertyValue("minRowsInColumn", this.value);
    }
    columnsPropertiesGroup.container.appendChild(this.Property("minRowsInColumn", this.loc.PropertyMain.MinRowsInColumn, minRowsInColumnControl));

    return columnsPropertiesGroup;
}