﻿
StiMobileDesigner.prototype.InitializePropertiesSettingsMenu = function () {
    var jsObject = this;
    var menu = this.VerticalMenu("propertiesSettingsMenu", this.options.propertiesPanel.propertiesToolBar.controls["Settings"], "Down");
    menu.controls = {};

    var settingsControls = [
        ["showComponents", this.CheckBoxMenuItem(null, this.loc.Buttons.ShowSpecific.replace("{0}", this.loc.Report.Components))],
        ["showFind", this.CheckBoxMenuItem(null, this.loc.Buttons.ShowSpecific.replace("{0}", this.loc.FormViewer.Find))],
        ["separator"],
        ["localizeProperties", this.CheckBoxMenuItem(null, this.loc.FormDesigner.LocalizePropertyGrid)]
    ]

    for (var i = 0; i < settingsControls.length; i++) {
        var controlName = settingsControls[i][0];
        if (controlName.indexOf("separator") >= 0) {
            menu.innerContent.appendChild(this.VerticalMenuSeparator(menu, controlName));
            continue;
        }
        var control = settingsControls[i][1];
        menu.controls[controlName] = control;
        menu.innerContent.appendChild(control);
    }

    if (this.options.cloudMode || this.options.standaloneJsMode) {
        menu.innerContent.appendChild(this.VerticalMenuSeparator(menu, "separator2"));

        var itemsNames = [
            ["Beginner", this.loc.Report.Basic],
            ["BICreator", this.loc.Report.Standard],
            ["Developer", this.loc.Report.Professional]
        ];

        for (var i = 0; i < itemsNames.length; i++) {
            var control = this.CheckBoxMenuItem(null, itemsNames[i][1])
            control.key = itemsNames[i][0];
            menu.controls[control.key] = control;
            menu.innerContent.appendChild(control);

            control.select = function () {
                for (var k = 0; k < itemsNames.length; k++) {
                    menu.controls[itemsNames[k][0]].setChecked(false);
                }
                this.setChecked(true);
            }

            control.action = function () {
                this.select();
                jsObject.ApplyDesignerSpecification(this.key);
            }
        }
    }

    menu.controls.localizeProperties.action = function () {
        jsObject.options.propertiesPanel.localizePropertyGrid = this.isChecked;
        StiMobileDesigner.SetCookie("StimulsoftMobileDesignerLocalizePropertyGrid", this.isChecked ? "true" : "false");
        jsObject.options.propertiesPanel.updatePropertiesCaptions();
        jsObject.options.propertiesPanel.updatePropertiesValues();
    }

    menu.controls.showComponents.action = function () {
        jsObject.options.showPropertiesComponents = this.isChecked;
        StiMobileDesigner.SetCookie("StimulsoftMobileDesignerShowPropertiesComponents", this.isChecked ? "true" : "false");
        jsObject.options.propertiesPanel.topControlsPanel.updateControlsStates();
    }

    menu.controls.showFind.action = function () {
        jsObject.options.showPropertiesFind = this.isChecked;
        StiMobileDesigner.SetCookie("StimulsoftMobileDesignerShowPropertiesFind", this.isChecked ? "true" : "false");
        jsObject.options.propertiesPanel.topControlsPanel.updateControlsStates();
    }

    menu.onshow = function () {
        menu.controls.localizeProperties.setChecked(jsObject.options.propertiesPanel.localizePropertyGrid);
        menu.controls.showComponents.setChecked(jsObject.options.showPropertiesComponents);
        menu.controls.showFind.setChecked(jsObject.options.showPropertiesFind);

        if ((jsObject.options.cloudMode || jsObject.options.standaloneJsMode)) {
            menu.controls.Beginner.setChecked(false);
            menu.controls.BICreator.setChecked(false);
            menu.controls.Developer.setChecked(false);

            if (menu.controls[jsObject.options.designerSpecification])
                menu.controls[jsObject.options.designerSpecification].select();
        }
    }

    return menu;
}