
StiMobileDesigner.prototype.LoginWithGoogle = function (ownerButton, actionName) {
    var jsObject = this;
    var authForm = this.options.forms.authForm;
    var profilePanel = this.options.profilePanel;
    var errorForm = jsObject.options.forms.errorMessageForm || jsObject.InitializeErrorMessageForm();

    var clearAllCookies = function () {
        StiMobileDesigner.RemoveCookie("sti_OAuthCode");
        StiMobileDesigner.RemoveCookie("sti_OAuthError");
    };

    var progress = function (visibleState) {
        if (ownerButton.progressMarker) {
            ownerButton.progressMarker.changeVisibleState(visibleState);
        }
    }

    clearAllCookies();

    jsObject.SendCommandToDesignerServer("GetGoogleAuthorizationUrl", {}, function (answer) {
        jsObject.openNewWindow(StiBase64.decode(answer.url), null, "width=600,height=700");

        //waiting google authorize result
        if (authForm || profilePanel) {
            var closeFormsTimer = 0;
            var waitResultTimer = setInterval(function () {
                if (!((authForm && authForm.visible) || (profilePanel && profilePanel.visible))) closeFormsTimer++;
                if (closeFormsTimer > 10) clearInterval(waitResultTimer);

                var authCode = StiMobileDesigner.GetCookie("sti_OAuthCode");
                var error = StiMobileDesigner.GetCookie("sti_OAuthError");

                if (authCode || error) {
                    clearAllCookies();
                    clearInterval(waitResultTimer);

                    if (authCode) {
                        if (actionName == "AddLoginWithGoogle") {
                            jsObject.SendCloudCommand("UserAddLoginWithGoogleV2", { GoogleAuthCode: authCode, Source: "CloudDesigner" },
                                function (data) {
                                    if (profilePanel && profilePanel.visible) {
                                        profilePanel.updateGoogleEmail(data.ResultGoogleId);
                                    }
                                },
                                function (data) {
                                    errorForm.show(jsObject.formatResultMsg(data));
                                }
                            );
                        }
                        else {
                            progress(true);

                            var params = {
                                GoogleAuthCode: authCode,
                                Source: "CloudDesigner",
                                WebDeviceId: jsObject.getDeviceID()
                            }

                            jsObject.SendCloudCommand("UserGoogleLogin", params,
                                function (data) {
                                    progress(false);

                                    var processGoogleAuthEmailIsUsed = function (data) {
                                        authForm.googleId = data.ResultGoogleId;
                                        authForm.googleEncryptingToken = data.ResultGoogleToken;
                                        authForm.googleEmail = data.ResultGoogleEmail;
                                        authForm.changeMode("enterPassword");
                                    }

                                    var processGoogleAuthResultSuccess = function (data) {
                                        authForm.loginComplete(data.ResultSessionKey, data.ResultUserKey);
                                    }

                                    if (data.ResultGoogleEmailIsEmpty) {
                                        if (data.ResultGoogleId && data.ResultGoogleToken) {
                                            var emailForm = jsObject.options.forms.enterEmailForm || jsObject.InitializeEnterEmailForm();

                                            emailForm.show(function (email) {
                                                var params = {
                                                    UserName: email,
                                                    GoogleId: data.ResultGoogleId,
                                                    GoogleToken: data.ResultGoogleToken,
                                                    Source: "CloudDesigner",
                                                    WebDeviceId: jsObject.getDeviceID()
                                                }
                                                progress(true);

                                                jsObject.SendCloudCommand("UserGoogleLogin", params,
                                                    function (data) {
                                                        progress(false);

                                                        if (data.ResultSuccess && data.ResultSessionKey && data.ResultUserKey) {
                                                            processGoogleAuthResultSuccess(data);
                                                        }
                                                        else {
                                                            errorForm.show(jsObject.formatResultMsg(data));
                                                        }
                                                    },
                                                    function (data) {
                                                        progress(false);
                                                        errorForm.show(jsObject.formatResultMsg(data));
                                                    });
                                            });
                                        }
                                    }
                                    else if (data.ResultSuccess && data.ResultSessionKey && data.ResultUserKey) {
                                        processGoogleAuthResultSuccess(data);
                                    }
                                },
                                function (data) {
                                    progress(false);

                                    if (data.ResultNotice && data.ResultNotice.CustomMessage == jsObject.loc.Notices.YourTrialHasExpired) {
                                        jsObject.showTrialHasExpiredNotice();
                                    }
                                    else {
                                        errorForm.show(jsObject.formatResultMsg(data));
                                    }
                                });
                        }
                    }
                    else {
                        errorForm.show(error);
                    }
                }
            }, 500);
        }
    });
}