﻿
StiMobileDesigner.prototype.InitializeYourPlanForm = function () {
    var jsObject = this;
    var form = this.BaseForm("yourPlan", this.loc.Cloud.YourPlan, 3);
    form.buttonOk.caption.innerText = this.loc.Buttons.Upgrade;
    form.buttonCancel.caption.innerText = this.loc.Buttons.Close;

    form.show = function () {
        var workspace = jsObject.options.cloudParameters.workspace;
        while (form.container.childNodes[0]) form.container.removeChild(form.container.childNodes[0]);

        if (workspace) {
            var resultQuota = workspace.ResultQuota;
            var header = document.createElement("div");
            header.className = "stiDesignerFormBlockHeader";
            header.style.padding = "12px";
            header.style.fontSize = "13px";
            header.style.fontWeight = "bold";
            header.innerText = resultQuota.PlanName || resultQuota.PlanIdent
            form.container.appendChild(header);

            var table = jsObject.CreateHTMLTable();
            table.style.marginTop = "12px";
            table.style.width = "100%";
            form.container.appendChild(table);

            table.addTextCell("Creators").className = "stiIndicatorBlockCaption";
            table.addCell(jsObject.IndicatorBlock(resultQuota.UsedCreatorsCount, resultQuota.AvailableCreatorsCount, null, "A creator is a person who has an account on the server, has access from the client-side, registered as an editor, and uses the product to work with report templates and dashboards - create, edit, view, delete, etc."));

            table.addTextCellInNextRow("Refreshes").className = "stiIndicatorBlockCaption";
            table.addCellInLastRow(jsObject.IndicatorBlock(resultQuota.UsedRefreshesCount, resultQuota.MaxRefreshesCount, null, "The number of refreshes for all dashboards, reports, and data in general. One refresh means viewing a dashboard, rendering a report, data update."));

            var sep = jsObject.FormSeparator();
            sep.style.margin = "6px 0 6px 0";
            table.addCellInNextRow(sep).setAttribute("colspan", "2");

            table.addTextCellInNextRow("Items").className = "stiIndicatorBlockCaption";
            table.addCellInLastRow(jsObject.IndicatorBlock(0, 100, "Unlim", "An item is any file uploaded or created in a workspace of your account — these are report and dashboard templates, rendered documents, file data, exported documents, images, etc."));

            table.addTextCellInNextRow("Max File size").className = "stiIndicatorBlockCaption";
            table.addCellInLastRow(jsObject.IndicatorBlock(0, 100, jsObject.GetHumanFileSize(jsObject.GetCurrentPlanLimitValue("MaxFileSize"), true), "The maximum size of a single file allowed for upload to cloud storage. This restriction is imposed on any files - templates, file data, built and exported documents."));

            table.addTextCellInNextRow("Max Report pages").className = "stiIndicatorBlockCaption";
            table.addCellInLastRow(jsObject.IndicatorBlock(0, 100, jsObject.GetCurrentPlanLimitValue("MaxReportPages"), "The maximum number of pages allowed in one rendered report. Upon reaching the limit, the report rendering will interrupt on the last available page."));

            table.addTextCellInNextRow("Max Data rows").className = "stiIndicatorBlockCaption";
            table.addCellInLastRow(jsObject.IndicatorBlock(0, 100, jsObject.GetHumanCount(jsObject.GetCurrentPlanLimitValue("MaxDataRows"), true), "The maximum number of data rows in one table, or the total number of data rows used to render one report or dashboard, or the maximum number of lines in one data cache. There are no restrictions on the number of columns in the data row."));

            table.addTextCellInNextRow("Max Resources").className = "stiIndicatorBlockCaption";
            table.addCellInLastRow(jsObject.IndicatorBlock(0, 100, jsObject.GetCurrentPlanLimitValue("MaxResources"), "The maximum count of resources allowed to be stored within one template. As template resources, you can use data files, images, and other available formats."));

            table.addTextCellInNextRow("Max Resource Size").className = "stiIndicatorBlockCaption";
            table.addCellInLastRow(jsObject.IndicatorBlock(0, 100, jsObject.GetHumanFileSize(jsObject.GetCurrentPlanLimitValue("MaxResourceSize"), true), "The maximum total size of resources allowed to be stored within one template. As template resources, you can use data files, images, and other available formats."));

            var sep2 = jsObject.FormSeparator();
            sep2.style.margin = "6px 0 6px 0";
            form.container.appendChild(sep2);

            var textBlock = jsObject.SimpleTextContainer("  If you're looking to expand your <a href='https://www.stimulsoft.com/en/documentation/compare-subscription-plans' target='_blank' >Stimulsoft BI Cloud resources</a>, we recommend upgrading your subscription plan. By doing so, you can enjoy increased capacity and access to a broader range of features.", 380);
            textBlock.className = "stiFormDescription";
            textBlock.style.padding = "20px 25px 20px 25px";
            textBlock.style.lineHeight = "1.3";
            form.container.appendChild(textBlock);

            var sep3 = jsObject.FormSeparator();
            sep3.style.margin = "6px 0 6px 0";
            form.container.appendChild(sep3);

            this.changeVisibleState(true);
        }
    }

    form.action = function () {
        this.changeVisibleState(false);
        var url = "https://www.stimulsoft.com/" + (jsObject.options.helpLanguage || "en") + "/online-store#cloud/cloud";
        jsObject.openNewWindow(url);
    }

    return form;
}

StiMobileDesigner.prototype.IndicatorBlock = function (value, quota, text, tooltip) {
    var block = document.createElement("div");
    block.className = "stiIndicatorBlock";

    var table = this.CreateHTMLTable();
    table.style.position = "absolute";
    table.addTextCell(text || (value + " / " + quota)).className = "stiIndicatorBlockTextCell";
    block.appendChild(table);

    var progress = document.createElement("div");
    progress.className = "stiIndicatorBlockProgress";
    progress.style.width = quota > 0 ? parseInt(value / quota * 100) + "%" : "0";
    block.appendChild(progress);

    if (tooltip) {
        block.setAttribute("title", tooltip);
    }

    if (quota > 0 && value / quota > 0.9) {
        block.style.background = "transparent";
        block.style.border = "1px solid red";
        progress.style.background = "red";
        progress.style.opacity = "0.4";
    }

    return block;
}