﻿
StiMobileDesigner.prototype.ThemeColorButton = function (color, name, groupName, value) {
    var button = $("<div class='stiThemeColorButton' style='background-color:" + color + "'><div class='stiThemeColorButtonIn'></div></div>")[0];
    button.jsObject = this;
    button.name = name != null ? name : this.generateKey();
    button.id = button.name;
    if (name != null) this.options.buttons[name] = button;
    button.groupName = groupName;
    button.isSelected = false;
    button.value = value;
    button.options = this.options;
    button.color = color;

    button.onclick = function () {
        if (button.groupName) {
            for (var bName in this.options.buttons) {
                if (this.options.buttons[bName].groupName == button.groupName) {
                    this.options.buttons[bName].setSelected(false);
                }
            }
        }
        this.setSelected(true);
        this.action();
    }

    button.setSelected = function (selected) {
        button.isSelected = selected;
        button.style.borderColor = selected ? "#f29436" : "";
        button.firstChild.style.border = selected ? "1px solid #ffe294" : "";
    }

    button.action = function () { }

    return button;
}

StiMobileDesigner.prototype.ThemeAutoToneButton = function (name, groupName) {
    var button = this.ThemeColorButton("", name, groupName);
    button.style.background = "linear-gradient(90deg, #ffffff, #333333)";
    button.setAttribute("title", this.loc.PropertyEnum.StiThemeAppearanceAuto);
    button.value = "Auto";

    return button;
}

StiMobileDesigner.prototype.ThemeCustomAccentButton = function (name, groupName, value) {
    var jsObject = this;
    var button = this.ThemeColorButton("", name, groupName, value);
    button.style.background = "#ffffff";
    button.setAttribute("title", this.loc.FormColorBoxPopup.Custom);
    button.value = value;

    button.action = function () {
        var colorDialog = jsObject.options.menus.colorDialog || jsObject.InitializeColorDialog();
        colorDialog.rightToLeft = true;
        colorDialog.noFillButton.style.display = colorDialog.noFillSep.style.display = "none";
        colorDialog.changeVisibleState(!colorDialog.visible, this);

        colorDialog.onhide = function () {
            colorDialog.hideExpression();
            colorDialog.noFillButton.style.display = colorDialog.noFillSep.style.display = "";
        }
    }

    button.choosedColor = function (key) {
        this.setKey(key);
        this.setSelected(true);
    };

    button.setKey = function (key) {
        this.key = key;
        var color;

        if (key == "transparent") {
            color = "255,255,255";
        }
        else if (key != null) {
            var colors = key.split(",");
            if (colors.length == 4) colors.splice(0, 1);
            color = colors[0] + "," + colors[1] + "," + colors[2];
        }

        this.style.background = "rgb(" + color + ")";
    };

    return button;
}