
StiMobileDesigner.prototype.ConnectToGoogleDrive = function (ownerForm, callbackFunc) {
    var jsObject = this;

    if (jsObject.googleDriveConnectParams) {
        jsObject.SendCommandToDesignerServer("RefreshGoogleDriveTokens", { googleDriveConnectParams: jsObject.googleDriveConnectParams }, function (answer) {
            if (answer.accessToken) {
                jsObject.googleDriveConnectParams.accessToken = answer.accessToken;
                jsObject.googleDriveConnectParams.refreshToken = answer.refreshToken;
                callbackFunc(true);
            }
            else {
                jsObject.googleDriveConnectParams = null;
                callbackFunc(false);
            }
        });
    }
    else {
        var clearAllCookies = function () {
            StiMobileDesigner.RemoveCookie("sti_OAuthCode");
            StiMobileDesigner.RemoveCookie("sti_OAuthError");
        };

        clearAllCookies();

        jsObject.SendCommandToDesignerServer("GetGoogleDriveAuthorizationUrl", {}, function (answer) {
            jsObject.openNewWindow(StiBase64.decode(answer.url), null, "width=600,height=700");

            //waiting google authorize result
            var closeFormsTimer = 0;
            var waitResultTimer = setInterval(function () {
                if (ownerForm && !ownerForm.visible) closeFormsTimer++;
                if (closeFormsTimer > 10) clearInterval(waitResultTimer);

                var authCode = StiMobileDesigner.GetCookie("sti_OAuthCode");
                var error = StiMobileDesigner.GetCookie("sti_OAuthError");

                if (authCode || error) {
                    clearAllCookies();
                    clearInterval(waitResultTimer);

                    if (authCode) {
                        jsObject.SendCommandToDesignerServer("GetGoogleDriveTokens", { authCode: authCode },
                            function (answer) {
                                if (answer.accessToken) {
                                    jsObject.googleDriveConnectParams = {
                                        authCode: authCode,
                                        accessToken: answer.accessToken,
                                        refreshToken: answer.refreshToken,
                                        userEmail: answer.userEmail
                                    }
                                    callbackFunc(true);
                                }
                                else {
                                    callbackFunc(false);
                                }
                            });
                    }
                    else {
                        (jsObject.options.forms.errorMessageForm || jsObject.InitializeErrorMessageForm()).show(error);
                        callbackFunc(false);
                    }
                }
            }, 500);
        });
    }
}

StiMobileDesigner.prototype.GetGoogleDriveItems = function (ownerForm, parentId, itemIdents, callbackFunc) {
    var jsObject = this;

    jsObject.ConnectToGoogleDrive(ownerForm, function (success) {
        if (success && jsObject.googleDriveConnectParams) {
            jsObject.SendCommandToDesignerServer("GetGoogleDriveItems", { googleDriveConnectParams: jsObject.googleDriveConnectParams, parentId: parentId, itemIdents: itemIdents },
                function (data) {
                    callbackFunc(data);
                },
                function () {
                    callbackFunc();
                });
        }
        else {
            callbackFunc();
        }
    });
}

StiMobileDesigner.prototype.CreateGoogleDriveFolder = function (ownerForm, parentId, folderName, callbackFunc) {
    var jsObject = this;

    jsObject.ConnectToGoogleDrive(ownerForm, function (success) {
        if (success && jsObject.googleDriveConnectParams) {
            jsObject.SendCommandToDesignerServer("CreateGoogleDriveFolder", { googleDriveConnectParams: jsObject.googleDriveConnectParams, parentId: parentId, folderName: folderName },
                function (data) {
                    callbackFunc(data);
                },
                function () {
                    callbackFunc();
                });
        }
        else {
            callbackFunc();
        }
    });
}

StiMobileDesigner.prototype.LoadReportFromGoogleDrive = function (ownerForm, fileId, fileName) {
    var jsObject = this;

    jsObject.ConnectToGoogleDrive(ownerForm, function (success) {
        if (success && jsObject.googleDriveConnectParams) {
            var params = {
                fileId: fileId,
                designerOptions: StiMobileDesigner.GetCookie("StimulsoftMobileDesignerOptions"),
                compilationAccess: jsObject.options.compilationAccess,
                googleDriveConnectParams: jsObject.googleDriveConnectParams
            };

            jsObject.SendCommandToDesignerServer("LoadReportFromGoogleDrive", params,
                function (answer) {
                    if (answer.formContent) {
                        if (!jsObject.options.formsDesignerFrame) {
                            answer.loadingCompleted = false;
                        }

                        jsObject.CloseReport();
                        jsObject.InitializeFormsDesignerFrame(function (frame) {
                            frame.openForm(fileName, answer.formContent);
                        });
                    }
                    else if (answer.reportObject && answer.reportGuid) {
                        if (jsObject.options.formsDesignerFrame) {
                            jsObject.options.formsDesignerFrame.close();
                        }

                        jsObject.CloseReport();
                        jsObject.options.reportGuid = answer.reportGuid;

                        if (answer.canNotOpenReport) {
                            var errorMessageForm = jsObject.options.forms.errorMessageForm || jsObject.InitializeErrorMessageForm();
                            errorMessageForm.show(jsObject.loc.HelpDesigner.CompilationAccess3, "Warning");
                        }
                        else {
                            var reportObject = jsObject.ParseReport(answer.reportObject);
                            jsObject.LoadReport(reportObject);
                            jsObject.SetWindowTitle(fileName + " - " + jsObject.loc.FormDesigner.title);

                            if (jsObject.options.report && answer.askBeforeOpenReport) {
                                var messageForm = jsObject.MessageFormForCompilationAccess();
                                messageForm.changeVisibleState(true);

                                messageForm.action = function (state) {
                                    if (state && jsObject.options.report.properties.calculationMode != "Interpretation") {
                                        jsObject.options.report.properties.calculationMode = "Interpretation";
                                        jsObject.SendCommandSetReportProperties(["calculationMode"]);
                                    }
                                    if (messageForm.doNotAskMe.isChecked) {
                                        jsObject.options.compilationAccess = "Allow";
                                        StiMobileDesigner.SetCookie("StimulsoftMobileDesignerCompilationAccess", "Allow");
                                    }
                                }
                            }
                        }
                    }
                });
        }
    });
}

StiMobileDesigner.prototype.SaveReportToGoogleDrive = function (ownerForm, fileName, folderId, fileId, callbackFunc) {
    var jsObject = this;

    jsObject.ConnectToGoogleDrive(ownerForm, function (success) {
        if (success && jsObject.googleDriveConnectParams) {
            if (!jsObject.EndsWith(fileName.toLowerCase(), ".mrt")) {
                fileName += ".mrt";
            }
            var params = {
                fileName: fileName,
                folderId: folderId,
                googleDriveConnectParams: jsObject.googleDriveConnectParams
            };
            if (fileId) params.fileId = fileId;

            jsObject.SendCommandToDesignerServer("SaveReportToGoogleDrive", params,
                function (answer) {
                    callbackFunc();
                });
        }
    });
}