﻿
StiMobileDesigner.prototype.InitializeHomePanelSingleLine = function (homePanel) {
    var jsObject = this;

    var mainTable = homePanel.mainTableSingleLine = this.CreateHTMLTable();
    mainTable.style.display = jsObject.options.ribbonType == "SingleLine" ? "" : "none";
    mainTable.style.height = (jsObject.options.ribbonSingleLineHeight - 2) + "px";
    mainTable.addCell(this.HomePanelSingleLineUndoAndCopyBlock());
    mainTable.addCell(this.RibbonPanelSingleLineSeparator());
    mainTable.addCell(this.HomePanelSingleLineFontBlock());
    mainTable.addCell(this.RibbonPanelSingleLineSeparator());
    mainTable.addCell(this.HomePanelSingleLineAlignmentBlock());
    mainTable.addCell(this.RibbonPanelSingleLineSeparator());
    mainTable.addCell(this.HomePanelSingleLineBordersBlock());
    mainTable.addCell(this.RibbonPanelSingleLineSeparator());
    mainTable.addCell(this.HomePanelSingleLineFormatBlock());
    mainTable.addCell(this.RibbonPanelSingleLineSeparator());
    mainTable.addCell(this.HomePanelSingleLineStyleBlock());
    homePanel.appendChild(mainTable);

        
    homePanel.updateSingleLineControls = function () {
        var controls = jsObject.options.controls;
        var buttons = jsObject.options.buttons;
        var report = jsObject.options.report;
        var currentObject = jsObject.options.selectedObject || jsObject.GetCommonObject(jsObject.options.selectedObjects);
        if (!currentObject) return;
        var props = currentObject.properties;
        var styleObject = currentObject ? jsObject.getStyleObject(props.componentStyle) : null;

        //Clipboard
        var canRemove = report && ((props.restrictions && (props.restrictions == "All" || props.restrictions.indexOf("AllowDelete") >= 0)) || !props.restrictions);
        var isNotReportOrPage = report && currentObject.typeComponent != "StiPage" && currentObject.typeComponent != "StiReport";

        var copyPasteMenu = jsObject.options.menus.copyPasteHomeSingle;
        copyPasteMenu.items.removeComponent.setEnabled(isNotReportOrPage && canRemove);
        copyPasteMenu.items.copyComponent.setEnabled(isNotReportOrPage && !jsObject.IsTableCell(jsObject.options.selectedObjects || currentObject));
        copyPasteMenu.items.cutComponent.setEnabled(isNotReportOrPage && canRemove && !jsObject.IsTableCell(jsObject.options.selectedObjects || currentObject));
        copyPasteMenu.items.pasteComponent.setEnabled(report && currentObject.typeComponent != "StiReport");

        //Font        
        var fontArray = (report && props["font"]) ? props["font"].split("!") : null;
        controls.homePanelSingleFontName.setEnabled(fontArray != null && !styleObject.allowUseFont && !props.allowHtmlTags);
        if (controls.homePanelSingleFontName.isEnabled) controls.homePanelSingleFontName.setKey(fontArray[0]);
        controls.homePanelSingleFontSize.setEnabled(fontArray != null && !styleObject.allowUseFont && !props.allowHtmlTags);
        if (controls.homePanelSingleFontSize.isEnabled) controls.homePanelSingleFontSize.setKey(fontArray[1]);
        buttons.homePanelSingleFontBold.setEnabled(fontArray != null && !styleObject.allowUseFont && currentObject.typeComponent != "StiProgressElement" && !props.allowHtmlTags);
        if (buttons.homePanelSingleFontBold.isEnabled) buttons.homePanelSingleFontBold.setSelected(fontArray[2] == "StiEmptyValue" ? false : fontArray[2] == "1");
        buttons.homePanelSingleFontItalic.setEnabled(fontArray != null && !styleObject.allowUseFont && currentObject.typeComponent != "StiProgressElement" && !props.allowHtmlTags);
        if (buttons.homePanelSingleFontItalic.isEnabled) buttons.homePanelSingleFontItalic.setSelected(fontArray[3] == "StiEmptyValue" ? false : fontArray[3] == "1");
        buttons.homePanelSingleFontUnderline.setEnabled(fontArray != null && !styleObject.allowUseFont && currentObject.typeComponent != "StiProgressElement" && !props.allowHtmlTags);
        if (buttons.homePanelSingleFontUnderline.isEnabled) buttons.homePanelSingleFontUnderline.setSelected(fontArray[4] == "StiEmptyValue" ? false : fontArray[4] == "1");
        buttons.homePanelSingleFontStrikeout.setEnabled(fontArray != null && !styleObject.allowUseFont && currentObject.typeComponent != "StiProgressElement" && currentObject.typeComponent != "StiTextElement" && !props.allowHtmlTags);
        if (buttons.homePanelSingleFontStrikeout.isEnabled) buttons.homePanelSingleFontStrikeout.setSelected(fontArray[5] == "StiEmptyValue" ? false : fontArray[5] == "1");
        var textBrush = report ? (props["textBrush"] || props["foreColor"]) : null;
        controls.homePanelSingleTextColor.setEnabled(textBrush != null && !styleObject.allowUseTextBrush && currentObject.typeComponent != "StiProgressElement" && !props.allowHtmlTags);

        //dbs table element cells        
        if (currentObject.typeComponent == "StiTableElement") {
            var editTableElementForm = jsObject.options.forms.editTableElementForm;
            if (editTableElementForm && editTableElementForm.visible && editTableElementForm.controls.dataContainer.selectedItem) {
                textBrush = editTableElementForm.controls.dataContainer.selectedItem.itemObject.foreColor;
                controls.homePanelSingleTextColor.setEnabled(true);
            }
        }

        if (controls.homePanelSingleTextColor.isEnabled)
            controls.homePanelSingleTextColor.setKey(textBrush == "StiEmptyValue" ? textBrush : jsObject.GetColorFromBrushStr(textBrush), currentObject.isDashboardElement);
        else
            controls.homePanelSingleTextColor.setKey("255,255,255");

        //Alignment
        var vertAlignment = (report && props["vertAlignment"]) ? props["vertAlignment"] : null;
        var enableVertAlign = vertAlignment && !styleObject.allowUseVertAlignment;

        buttons.vertAlignButtonSingle.setEnabled(enableVertAlign);

        if (enableVertAlign) {
            buttons.homePanelSingleAlignTop.setSelected(vertAlignment != "StiEmptyValue" && vertAlignment == "Top");
            buttons.homePanelSingleAlignMiddle.setSelected(vertAlignment != "StiEmptyValue" && vertAlignment == "Center");
            buttons.homePanelSingleAlignBottom.setSelected(vertAlignment != "StiEmptyValue" && vertAlignment == "Bottom");
        }

        buttons.homePanelSingleWordWrap.setEnabled(report && props["wordWrap"] != null);
        if (buttons.homePanelSingleWordWrap.isEnabled) buttons.homePanelSingleWordWrap.setSelected(props["wordWrap"] != "StiEmptyValue" && props["wordWrap"]);
        buttons.homePanelSingleTextAngle.setEnabled(report && props["textAngle"] != null && props["textAngle"] != "StiEmptyValue");

        var horAlignment = (report && props["horAlignment"]) ? props["horAlignment"] : null;

        //dbs table element cells        
        if (currentObject.typeComponent == "StiTableElement") {
            var editTableElementForm = jsObject.options.forms.editTableElementForm;
            if (editTableElementForm && editTableElementForm.visible && editTableElementForm.controls.dataContainer.selectedItem) {
                horAlignment = editTableElementForm.controls.dataContainer.selectedItem.itemObject.horAlignment;
            }
        }

        if (currentObject.typeComponent == "StiPivotTableElement") {
            var editPivotTableForm = jsObject.options.forms.editPivotTableElementForm;
            if (editPivotTableForm && editPivotTableForm.visible && editPivotTableForm.getSelectedItem()) {
                horAlignment = editPivotTableForm.getSelectedItem().itemObject.horAlignment;
            }
        }

        var enableHorAlign = horAlignment && !styleObject.allowUseHorAlignment;
        var enableHorAlignWidth = currentObject.typeComponent && currentObject.typeComponent != "StiImage" && currentObject.typeComponent != "StiBarCode" && currentObject.typeComponent != "StiTableElement" &&
            currentObject.typeComponent != "StiPivotTableElement" && currentObject.typeComponent != "StiNumberBoxElement" && currentObject.typeComponent != "StiMathFormula";

        buttons.horAlignButtonSingle.setEnabled(enableHorAlign);

        if (enableHorAlign) {
            buttons.homePanelSingleAlignLeft.setSelected(horAlignment != "StiEmptyValue" && horAlignment == "Left");
            buttons.homePanelSingleAlignCenter.setSelected(horAlignment != "StiEmptyValue" && horAlignment == "Center");
            buttons.homePanelSingleAlignRight.setSelected(horAlignment != "StiEmptyValue" && horAlignment == "Right");
            buttons.homePanelSingleAlignWidth.setEnabled(enableHorAlignWidth);
            if (enableHorAlignWidth) buttons.homePanelSingleAlignWidth.setSelected(horAlignment != "StiEmptyValue" && horAlignment == "Width");
        }

        buttons.homePanelSingleLineSpacing.setEnabled(report && props["lineSpacing"] != null && props["lineSpacing"] != "StiEmptyValue");

        //Borders
        var borderArray = (report && props["border"]) ? props["border"].split("!") : null;
        var borderSides = (borderArray) ? borderArray[0].split(",") : null;
        var ignoreStyles = currentObject && !props.allowApplyStyle;
        var enableSidesButtons = borderArray != null && !styleObject.allowUseBorderSides && ignoreStyles;

        buttons.homePanelSingleBorders.setEnabled(enableSidesButtons);
        if (enableSidesButtons) {
            buttons.homePanelSingleBorderAll.setSelected(borderArray[0] == "StiEmptyValue" ? false : borderArray[0] == "1,1,1,1");
            buttons.homePanelSingleBorderNone.setSelected(borderArray[0] == "StiEmptyValue" ? false : borderArray[0] == "0,0,0,0");
            buttons.homePanelSingleBorderLeft.setSelected(borderSides && borderSides[0] != "StiEmptyValue" ? borderSides[0] == "1" : false);
            buttons.homePanelSingleBorderTop.setSelected(borderSides && borderSides[1] != "StiEmptyValue" ? borderSides[1] == "1" : false);
            buttons.homePanelSingleBorderRight.setSelected(borderSides && borderSides[2] != "StiEmptyValue" ? borderSides[2] == "1" : false);
            buttons.homePanelSingleBorderBottom.setSelected(borderSides && borderSides[3] != "StiEmptyValue" ? borderSides[3] == "1" : false);
        }

        buttons.homePanelSingleAdvancedBorders.style.display = jsObject.options.menus.bordersHomeSingle.advancedSeparator.style.display = !currentObject.isDashboard ? "" : "none";

        buttons.homePanelSingleShadow.setEnabled((borderArray != null && borderArray.length > 4 && !styleObject.allowUseBorderFormatting && ignoreStyles) || (currentObject && props.shadowVisible != null));
        if (buttons.homePanelSingleShadow.isEnabled) buttons.homePanelSingleShadow.setSelected(props.shadowVisible != null ? props.shadowVisible : (borderArray[4] == "StiEmptyValue" ? false : borderArray[4] == "1"));

        var borderColor = report ? ((borderArray ? borderArray[2] : null) || props["shapeBorderColor"]) : null;
        controls.homePanelSingleBorderColor.setEnabled(borderColor != null && !styleObject.allowUseBorderFormatting && ignoreStyles);
        if (controls.homePanelSingleBorderColor.isEnabled) controls.homePanelSingleBorderColor.setKey(borderColor)
        else controls.homePanelSingleBorderColor.setKey("255,255,255");

        var backGroundColor = report ? (props["brush"] || props["backColor"]) : null;
        controls.homePanelSingleBackgroundColor.setEnabled(backGroundColor && !styleObject.allowUseBrush && ignoreStyles);

        if (controls.homePanelSingleBackgroundColor.isEnabled)
            controls.homePanelSingleBackgroundColor.setKey(jsObject.GetColorFromBrushStr(backGroundColor), currentObject.isDashboardElement || currentObject.isDashboard);
        else
            controls.homePanelSingleBackgroundColor.setKey("255,255,255");

        var borderStyle = report ? ((borderArray ? borderArray[3] : null) || props["shapeBorderStyle"]) : null;
        controls.homePanelSingleBorderStyle.setEnabled(borderStyle != null && !styleObject.allowUseBorderFormatting && ignoreStyles);
        if (controls.homePanelSingleBorderStyle.isEnabled) controls.homePanelSingleBorderStyle.setKey(borderStyle)
        else controls.homePanelSingleBorderStyle.setKey("0");

        //TextFormat
        var textFormat = (report && currentObject.typeComponent != "StiReport" && props["textFormat"]) ? props["textFormat"] : null;

        //dbs table element cells        
        if (currentObject.typeComponent == "StiTableElement") {
            var editTableElementForm = jsObject.options.forms.editTableElementForm;
            if (editTableElementForm && editTableElementForm.visible && editTableElementForm.controls.dataContainer.selectedItem) {
                textFormat = editTableElementForm.controls.dataContainer.selectedItem.itemObject.textFormat;
            }
        }

        //dbs pivot table element cells        
        if (currentObject.typeComponent == "StiPivotTableElement") {
            var editPivotTableElementForm = jsObject.options.forms.editPivotTableElementForm;
            if (editPivotTableElementForm && editPivotTableElementForm.visible && editPivotTableElementForm.getSelectedItem()) {
                textFormat = editPivotTableElementForm.getSelectedItem().itemObject.textFormat;
            }
        }

        buttons.homePanelSingleTextFormat.setEnabled(textFormat != null);
        if (buttons.homePanelSingleTextFormat.isEnabled) buttons.homePanelSingleTextFormat.setKey(textFormat.type)
        else buttons.homePanelSingleTextFormat.setKey("StiGeneralFormatService");

        //Conditions
        buttons.homePanelSingleConditions.setEnabled(report && (props.conditions != null || props.chartConditions != null || props.indicatorConditions != null || props.progressConditions != null || props.tableConditions != null || props.pivotTableConditions != null));

        var conditionsPresent = currentObject.properties.conditions ||
            (currentObject.properties.chartConditions && currentObject.properties.chartConditions.length > 0) ||
            (currentObject.properties.indicatorConditions && currentObject.properties.indicatorConditions.length > 0) ||
            (currentObject.properties.progressConditions && currentObject.properties.progressConditions.length > 0) ||
            (currentObject.properties.tableConditions && currentObject.properties.tableConditions.length > 0) ||
            (currentObject.properties.pivotTableConditions && currentObject.properties.pivotTableConditions.length > 0);

        buttons.homePanelSingleConditions.setMarkerVisibleState(buttons.homePanelSingleConditions.isEnabled && conditionsPresent);

        //Interaction
        buttons.homePanelSingleInteractions.setEnabled(report && (currentObject.properties["dashboardInteraction"] != null || currentObject.properties["interaction"] != null));

        buttons.homePanelSingleInteractions.setMarkerVisibleState(buttons.homePanelSingleInteractions.isEnabled && jsObject.InteractionsPresent(currentObject));

        //Style        
        if (jsObject.options.ribbonType == "SingleLine") {
            var style = null;

            if (report && report.stylesCollection && currentObject.typeComponent != "StiReport") {
                if (currentObject.typeComponent == "StiChart") {
                    style = currentObject.properties.chartStyle;
                }
                else if (currentObject.typeComponent == "StiGauge") {
                    style = currentObject.properties.gaugeStyle;
                }
                else if (currentObject.typeComponent == "StiMap") {
                    style = currentObject.properties.mapStyle;
                }
                else if (currentObject.typeComponent == "StiCrossTab") {
                    style = {
                        crossTabStyleIndex: currentObject.properties.crossTabFields.crossTabStyleIndex,
                        crossTabStyle: currentObject.properties.crossTabFields.crossTabStyle
                    }
                }
                else if (currentObject.typeComponent == "StiTable") {
                    style = {
                        styleName: currentObject.properties.componentStyle,
                        styleId: currentObject.properties.styleId
                    }
                }
                else if ((currentObject.isDashboard || currentObject.isDashboardElement) && currentObject.typeComponent) {
                    if (currentObject.properties.elementStyle || currentObject.properties.customStyleName) {
                        style = {
                            ident: currentObject.properties.elementStyle,
                            name: currentObject.properties.customStyleName
                        }
                    }
                    else if (currentObject.typeComponent == "StiTextElement" || currentObject.typeComponent == "StiImageElement" || currentObject.typeComponent == "StiPanelElement" || currentObject.typeComponent == "StiWebContentElement") {
                        style = currentObject.properties.style;
                        if (style == "") style = "[None]";
                    }
                    else {
                        style = null;
                    }
                }
                else {
                    style = currentObject.properties.componentStyle;
                }
            }

            controls.homePanelSingleStyle.setEnabled(style != null);

            if (controls.homePanelSingleStyle.isEnabled)
                controls.homePanelSingleStyle.setKey(style);
            else
                controls.homePanelSingleStyle.setKey("[None]");
        }
    }
}

//Undo and Copy
StiMobileDesigner.prototype.HomePanelSingleLineUndoAndCopyBlock = function () {
    var jsObject = this;
    var table = this.CreateHTMLTable();

    if (this.options.showSaveButton) {
        //Save
        var saveButton = this.SingleLineRibbonButton("saveReportHotButtonSingle", null, null, "Save.png", [this.loc.MainMenu.menuFileReportSave.replace("&", ""), this.GetHelpLink("default")]);
        saveButton.style.margin = "0 2px 0 4px";
        table.addCell(saveButton);

        saveButton.action = function () {
            jsObject.ActionSaveReport();
        }
    }

    //Undo
    if (!jsObject.options.standaloneJsMode) {
        var undoRedoButton = this.SingleLineRibbonButton("undoRedoButtonSingle", null, null, "Toolbar.Undo.png", [this.loc.MainMenu.menuEditUndo.replace("&", ""), this.GetHelpLink("default")], "Down");
        undoRedoButton.style.margin = this.options.showSaveButton ? "0 2px 0 2px" : "0 2px 0 4px";
        table.addCell(undoRedoButton);

        var undoRedoMenu = this.VerticalMenu("undoRedoHomeSingle", undoRedoButton, "Down", this.GetUndoRedoItems());

        undoRedoButton.action = function () {
            undoRedoMenu.changeVisibleState(!undoRedoMenu.visible);
        }

        undoRedoMenu.action = function (menuItem) {
            this.changeVisibleState(false);
            var button = jsObject.options.buttons[menuItem.key];
            if (button) button.action();
        }
    }

    //Copy
    var copyPasteButton = this.SingleLineRibbonButton("copyPasteButtonSingle", null, null, "PasteSmall.png", [this.loc.Toolbars.ToolbarClipboard, this.GetHelpLink("default")], "Down");
    copyPasteButton.style.margin = "0 2px 0 2px";
    table.addCell(copyPasteButton);

    var copyPasteMenu = this.VerticalMenu("copyPasteHomeSingle", copyPasteButton, "Down", this.GetCopyPasteItems());

    copyPasteButton.action = function () {
        copyPasteMenu.changeVisibleState(!copyPasteMenu.visible);
    }

    copyPasteMenu.action = function (menuItem) {
        this.changeVisibleState(false);
        var button = jsObject.options.buttons[menuItem.key];
        if (button) button.action();
    }

    return table;
}

//Font
StiMobileDesigner.prototype.HomePanelSingleLineFontBlock = function () {
    var jsObject = this;
    var table = this.CreateHTMLTable();

    var controls = [
        [this.FontList("homePanelSingleFontName", 105, null, null, [this.loc.HelpDesigner.FontName, this.GetHelpLink("font")]), "homePanelFontName"],
        [this.DropDownList("homePanelSingleFontSize", 50, [this.loc.HelpDesigner.FontSize, this.GetHelpLink("font")], this.GetFontSizeItems(), false), "homePanelFontSize"],
        [this.SingleLineRibbonButton("homePanelSingleFontBold", null, null, "Bold.png", [this.loc.HelpDesigner.FontStyleBold, this.GetHelpLink("font")]), "homePanelFontBold"],
        [this.SingleLineRibbonButton("homePanelSingleFontItalic", null, null, "Italic.png", [this.loc.HelpDesigner.FontStyleItalic, this.GetHelpLink("font")]), "homePanelFontItalic"],
        [this.SingleLineRibbonButton("homePanelSingleFontUnderline", null, null, "Underline.png", [this.loc.HelpDesigner.FontStyleUnderline, this.GetHelpLink("font")]), "homePanelFontUnderline"],
        [this.SingleLineRibbonButton("homePanelSingleFontStrikeout", null, null, "Strikeout.png", [this.loc.HelpDesigner.FontStyleStrikeout, this.GetHelpLink("font")]), "homePanelFontStrikeout"],
        [this.ColorControlWithImage("homePanelSingleTextColor", "TextColor.png", [this.loc.HelpDesigner.TextColor, this.GetHelpLink("font")], true, true), "homePanelTextColor", "control"]
    ]

    for (var i = 0; i < controls.length; i++) {
        var control = controls[i][0];
        control.cloneName = controls[i][1];
        control.typeControl = controls[i][2];
        control.style.margin = "0 2px 0 2px";
        table.addCell(control); 

        control.action = function () {
            var cloneControl = jsObject.options.buttons[this.cloneName] || jsObject.options.controls[this.cloneName];
            if (cloneControl) {
                if ("setKey" in cloneControl) {
                    cloneControl.setKey(this.key);
                }
                else {
                    this.setSelected(!this.isSelected);
                }
                cloneControl.action();
            }
        }
    }

    return table;
}

//Alignment
StiMobileDesigner.prototype.HomePanelSingleLineAlignmentBlock = function () {
    var jsObject = this;
    var table = this.CreateHTMLTable();

    //Hor Align
    var horAlignButton = this.SingleLineRibbonButton("horAlignButtonSingle", null, null, "AlignLeft.png", [this.loc.PropertyMain.HorAlignment, this.GetHelpLink("default")], "Down");
    horAlignButton.style.margin = "0 2px 0 2px";
    table.addCell(horAlignButton);

    var horAlignMenu = this.VerticalMenu("horAlignHomeSingle", horAlignButton, "Down", []);
    var horTable = this.CreateHTMLTable();
    horTable.style.margin = "0 2px 0 2px";
    horAlignMenu.innerContent.appendChild(horTable);

    var horAligns = ["Left", "Center", "Right", "Width"];
    for (var i = 0; i < horAligns.length; i++) {
        var button = this.SingleLineRibbonButton("homePanelSingleAlign" + horAligns[i], "homePanelSingleHorAlign", null, "Align" + horAligns[i] + ".png");
        button.cloneName = "homePanelAlign" + horAligns[i];
        horTable.addCell(button).style.padding = "4px 2px 4px 2px";

        button.action = function () {
            horAlignMenu.changeVisibleState(false);
            this.setSelected(true);
            var cloneControl = jsObject.options.buttons[this.cloneName];
            if (cloneControl) cloneControl.action();
        }
    }

    horAlignButton.action = function () {
        horAlignMenu.changeVisibleState(!horAlignMenu.visible);
    }

    //Vert Align
    var vertAlignButton = this.SingleLineRibbonButton("vertAlignButtonSingle", null, null, "AlignMiddle.png", [this.loc.PropertyMain.VertAlignment, this.GetHelpLink("default")], "Down");
    vertAlignButton.style.margin = "0 2px 0 2px";
    table.addCell(vertAlignButton);

    var vertAlignMenu = this.VerticalMenu("vertAlignHomeSingle", vertAlignButton, "Down", []);
    var vertTable = this.CreateHTMLTable();
    vertTable.style.margin = "0 2px 0 2px";
    vertAlignMenu.innerContent.appendChild(vertTable);

    var vertAligns = ["Top", "Middle", "Bottom"];
    for (var i = 0; i < vertAligns.length; i++) {
        var button = this.SingleLineRibbonButton("homePanelSingleAlign" + vertAligns[i], "homePanelSingleVertAlign", null, "Align" + vertAligns[i] + ".png");
        button.cloneName = "homePanelAlign" + vertAligns[i];
        vertTable.addCell(button).style.padding = "4px 2px 4px 2px";

        button.action = function () {
            vertAlignMenu.changeVisibleState(false);
            this.setSelected(true);
            var cloneControl = jsObject.options.buttons[this.cloneName];
            if (cloneControl) cloneControl.action();
        }
    }

    vertAlignButton.action = function () {
        vertAlignMenu.changeVisibleState(!vertAlignMenu.visible);
    }

    //Angle
    var angleButton = this.SingleLineRibbonButton("homePanelSingleTextAngle", null, null, "RotateText.png", [this.loc.HelpDesigner.Angle, this.GetHelpLink("alignment")], "Down");
    angleButton.style.margin = "0 2px 0 2px";
    table.addCell(angleButton);

    var angleMenu = this.VerticalMenu("homePanelSingleTextAngleMenu", angleButton, "Down", this.GetTextAngleItems())

    angleMenu.action = function (menuItem) {
        this.changeVisibleState(false);
        jsObject.options.menus.homePanelTextAngleMenu.action(menuItem);
    }

    angleMenu.onshow = function () {
        var currentObject = jsObject.options.selectedObject || jsObject.GetCommonObject(jsObject.options.selectedObjects);
        var angleValue = currentObject.properties.textAngle ? jsObject.StrToDouble(currentObject.properties.textAngle) : null;
        for (var itemName in this.items) {
            this.items[itemName].setSelected(angleValue != null && jsObject.StrToDouble(this.items[itemName].key) == angleValue);
        }
    }

    angleButton.action = function () {
        angleMenu.changeVisibleState(!angleMenu.visible);
    }

    //WordWrap
    var wordWrapButton = this.SingleLineRibbonButton("homePanelSingleWordWrap", null, null, "WordWrap.png", [this.loc.PropertyMain.WordWrap, this.GetHelpLink("alignment")]);
    wordWrapButton.style.margin = "0 2px 0 2px";
    table.addCell(wordWrapButton);

    wordWrapButton.action = function () {
        this.setSelected(!this.isSelected);
        jsObject.options.buttons.homePanelWordWrap.action();
    }

    //LineSpacing
    var lineSpacingButton = this.SingleLineRibbonButton("homePanelSingleLineSpacing", null, null, "LineSpacing.png", [this.loc.HelpDesigner.LineSpacing, this.GetHelpLink("alignment")], "Down");
    lineSpacingButton.style.margin = "0 2px 0 2px";
    table.addCell(lineSpacingButton);

    var lineSpacingMenu = this.VerticalMenu("homePanelSingleLineSpacingMenu", lineSpacingButton, "Down", this.GetLineSpacingItems())

    lineSpacingMenu.action = function (menuItem) {
        this.changeVisibleState(false);
        jsObject.options.menus.homePanelLineSpacingMenu.action(menuItem);
    }

    lineSpacingMenu.onshow = function () {
        var currentObject = jsObject.options.selectedObject || jsObject.GetCommonObject(jsObject.options.selectedObjects);
        var lineSpacingValue = currentObject.properties.lineSpacing ? jsObject.StrToDouble(currentObject.properties.lineSpacing) : null;
        for (var itemName in this.items) {
            this.items[itemName].setSelected(lineSpacingValue != null && jsObject.StrToDouble(this.items[itemName].key) == lineSpacingValue);
        }
    }

    lineSpacingButton.action = function () {
        lineSpacingMenu.changeVisibleState(!lineSpacingMenu.visible);
    }

    return table;
}

//Borders
StiMobileDesigner.prototype.HomePanelSingleLineBordersBlock = function () {
    var jsObject = this;
    var table = this.CreateHTMLTable();

    //Sides
    var bordersButton = this.SingleLineRibbonButton("homePanelSingleBorders", null, null, "BorderAll.png", [this.loc.PropertyMain.Borders, this.GetHelpLink("default")], "Down");
    bordersButton.style.margin = "0 2px 0 2px";
    table.addCell(bordersButton);

    var bordersMenu = this.VerticalMenu("bordersHomeSingle", bordersButton, "Down", []);
    bordersMenu.innerContent.style.padding = "2px";

    var sides = ["All", "None", "Left", "Top", "Right", "Bottom"];

    for (var i = 0; i < sides.length; i++) {
        var button = this.SingleLineRibbonButton("homePanelSingleBorder" + sides[i], sides[i] == "All" || sides[i] == "None" ? "homePanelSingleBorders" : null, this.loc.PropertyEnum["StiBorderSides" + sides[i]], "Border" + sides[i] + ".png");
        button.side = sides[i];
        button.cloneName = "homePanelBorder" + sides[i];
        button.style.margin = "2px";
        bordersMenu.innerContent.appendChild(button);
        

        if (sides[i] == "None") {
            bordersMenu.innerContent.appendChild(this.VerticalMenuSeparator());
        }

        button.action = function () {
            this.setSelected(this.side == "All" || this.side == "None" ? true : !this.isSelected);

            var cloneControl = jsObject.options.buttons[this.cloneName];
            if (cloneControl) cloneControl.action(true);
        }
    }

    var editButton = this.SingleLineRibbonButton("homePanelSingleAdvancedBorders", null, this.loc.Scheduler.AdvancedSettings, "EditButton.png");
    editButton.style.margin = "2px";

    editButton.action = function () {
        bordersMenu.changeVisibleState(false);
        jsObject.ExecuteAction("groupBlockBordersButton");
    }

    var sep = bordersMenu.advancedSeparator = this.VerticalMenuSeparator();
    bordersMenu.innerContent.appendChild(sep);
    bordersMenu.innerContent.appendChild(editButton);

    bordersButton.action = function () {
        bordersMenu.changeVisibleState(!bordersMenu.visible);
    }

    //Shadow
    var shadowButton = this.SingleLineRibbonButton("homePanelSingleShadow", null, null, "Shadow.png", [this.loc.HelpDesigner.Shadow, this.GetHelpLink("border")]);
    shadowButton.style.margin = "0 2px 0 2px";
    table.addCell(shadowButton);

    shadowButton.action = function () {
        this.setSelected(!this.isSelected);
        jsObject.options.buttons.homePanelShadow.action();
    }

    //BackgroundColor
    var backgroundColor = this.ColorControlWithImage("homePanelSingleBackgroundColor", "BackgroundColor.png", [this.loc.HelpDesigner.Background, this.GetHelpLink("border")], null, true);
    backgroundColor.style.margin = "0 2px 0 2px";
    table.addCell(backgroundColor);

    backgroundColor.action = function () {
        jsObject.options.controls.homePanelBackgroundColor.setKey(this.key);
        jsObject.options.controls.homePanelBackgroundColor.action();
    }

    //BorderColor
    var borderColor = this.ColorControlWithImage("homePanelSingleBorderColor", "BorderColor.png", [this.loc.HelpDesigner.BorderColor, this.GetHelpLink("border")], null, true);
    borderColor.style.margin = "0 2px 0 2px";
    table.addCell(borderColor);

    borderColor.action = function () {
        jsObject.options.controls.homePanelBorderColor.setKey(this.key);
        jsObject.options.controls.homePanelBorderColor.action();
    }

    //BorderStyle
    var borderStyle = this.ImageList("homePanelSingleBorderStyle", false, true, [this.loc.HelpDesigner.BorderStyle, this.GetHelpLink("border")], this.GetBorderStyleItems());
    borderStyle.style.margin = "0 2px 0 2px";
    table.addCell(borderStyle);

    borderStyle.action = function () {
        jsObject.options.controls.homePanelBorderStyle.setKey(this.key);
        jsObject.options.controls.homePanelBorderStyle.action();
    }

    return table;
}

//Format
StiMobileDesigner.prototype.HomePanelSingleLineFormatBlock = function () {
    var jsObject = this;
    var table = this.CreateHTMLTable();

    var formatButton = this.SmallButton("homePanelSingleTextFormat", null, this.loc.FormFormatEditor.General, null, [this.loc.HelpDesigner.TextFormat, this.GetHelpLink("textformat")], "Down", "stiDesignerSmallButtonWithBorder");
    formatButton.style.margin = "0 2px 0 2px";
    table.addCell(formatButton);

    var items = this.GetTextFormatItems(true, true);
    items.push("separator");
    items.push(this.Item("Editor", this.loc.Scheduler.AdvancedSettings, "EditButton.png", "Editor"));

    var formatMenu = this.VerticalMenu("homePanelSingleTextFormatMenu", formatButton, "Down", items);

    formatButton.action = function () {
        formatMenu.changeVisibleState(!formatMenu.visible);
    }

    formatButton.setKey = function (key) {
        this.key = key;

        if (formatMenu.items[key]) {
            this.caption.innerHTML = formatMenu.items[key].caption.innerHTML;
        }
    }

    formatMenu.onshow = function () {
        for (var itemName in this.items) {
            if ("setSelected" in this.items[itemName]) {
                this.items[itemName].setSelected(formatButton.key == this.items[itemName].key);
            }
        }
    }

    formatMenu.action = function (menuItem) {
        this.changeVisibleState(false);
        if (menuItem.key == "Editor") {
            jsObject.options.buttons.groupBlockTextFormatButton.action();
        }
        else {
            formatButton.setKey(menuItem.key);
            jsObject.options.controls.homePanelTextFormat.setKey(menuItem.key);
            jsObject.options.controls.homePanelTextFormat.action();
        }
    }

    return table;
}

//Style
StiMobileDesigner.prototype.HomePanelSingleLineStyleBlock = function () {
    var jsObject = this;
    var table = this.CreateHTMLTable();

    var buttons = [
        [this.SingleLineRibbonButton("homePanelSingleConditions", null, null, "Conditions.png", [this.loc.HelpDesigner.biConditions, this.GetHelpLink("conditions")], null, null, null, null, null, true), "conditionsButton"],
        [this.SingleLineRibbonButton("homePanelSingleInteractions", null, null, "Interaction.png", [this.loc.HelpDesigner.Interaction, this.GetHelpLink("interactions")], null, null, null, null, null, true), "homePanelInteractionsButton"],
        [this.SingleLineRibbonButton("homePanelSingleCopyStyle", null, null, "CopyStyle.png", [this.loc.Toolbox.Style, this.GetHelpLink("default")]), "copyStyleButton"],
        [this.SingleLineRibbonButton("homePanelSingleStyleDesigner", null, null, "Styles.StiComponentStyle.png", [this.loc.HelpDesigner.StyleDesigner, this.GetHelpLink("styleDesigner")]), "styleDesignerButton"]
    ]

    for (var i = 0; i < buttons.length; i++) {
        var button = buttons[i][0];
        button.cloneName = buttons[i][1];
        button.style.margin = "0 2px 0 2px";
        table.addCell(button);

        button.action = function () {
            var cloneButton = jsObject.options.buttons[this.cloneName];
            if (cloneButton) cloneButton.action();
        }
    }

    var styleControl = this.StylesControl("homePanelSingleStyle");

    if (jsObject.options.ribbonType == "SingleLine") {
        styleControl.setKey("[None]");
    }

    styleControl.style.margin = "0 2px 0 2px";
    styleControl.innerButton.style.minHeight = "auto";
    styleControl.innerButton.style.height = "28px";
    styleControl.innerButton.style.padding = "0";
    styleControl.innerButton.innerTable.style.height = "100%";
    styleControl.innerButton.cellArrow.style.display = "none";

    styleControl.styleBox.maxHeight = 22;
    styleControl.styleBox.style.maxHeight = styleControl.styleBox.maxHeight + "px";

    table.addCell(styleControl);

    styleControl.action = function () {
        jsObject.options.controls.homePanelStyle.setKey(this.key);
        jsObject.options.controls.homePanelStyle.action();
        jsObject.options.controls.homePanelStyle.styleInnerBox.innerHTML = "";
    }

    return table;
}

StiMobileDesigner.prototype.RibbonPanelSingleLineSeparator = function () {
    var separator = document.createElement("div");
    separator.style.width = "1px";
    separator.style.margin = "0 2px 0 2px";
    separator.style.height = this.options.isTouchDevice ? "28px" : "23px";
    separator.className = "stiDesignerHomePanelSeparator";

    return separator;
}