﻿
StiMobileDesigner.prototype.InitializeVariableItemsForm_ = function () {
    var jsObject = this;
    var form = this.BaseForm("variableItemsForm", this.loc.PropertyMain.Items, 3, this.GetHelpLink("variableItems"));
    form.controls = {};
    form.container.style.minWidth = "575px";

    var dataGridColums;
    var dataGridControl;

    //Footer Controls
    var selColumButton = this.FormButton(null, null, this.loc.Wizards.SelectColumns);
    selColumButton.style.display = "inline-block";
    selColumButton.style.margin = "12px";

    selColumButton.action = function () {
        jsObject.InitializeSelectColumnsForVariableForm(function (selColumForm) {
            selColumForm.changeVisibleState(true);

            selColumForm.action = function () {
                selColumForm.changeVisibleState(false);

                jsObject.SendCommandToDesignerServer("GetVariableItemsFromDataColumn", {
                    keysColumn: selColumForm.controls.keys.textBox.value,
                    valuesColumn: selColumForm.controls.values.textBox.value
                }, function (answer) {
                    dataGridControl.clear();

                    var encodeValue = function (val) {
                        return (val != null ? StiBase64.encode(val.toString()) : "");
                    }

                    if (answer.items) {
                        var varItems = [];
                        for (var i = 0; i < answer.items.length; i++) {
                            varItems.push({
                                key: encodeValue(answer.items[i].key),
                                keyTo: null,
                                value: encodeValue(answer.items[i].value),
                                checked: true,
                                type: "value"
                            });
                        }
                        form.convertVariableItemsToDataGridValues(varItems);
                    }
                });
            }
        });
    }

    var footerTable = this.CreateHTMLTable();
    footerTable.style.width = "100%";
    var buttonsPanel = form.buttonsPanel;
    form.removeChild(buttonsPanel);
    form.appendChild(footerTable);
    footerTable.addCell(selColumButton).style.textAlign = "left";
    footerTable.addCell();
    footerTable.addCell(form.buttonOk).style.width = "1px";
    footerTable.addCell(form.buttonCancel).style.width = "1px";

    //Properties Controls
    var proprtiesTable = this.CreateHTMLTable();
    proprtiesTable.style.width = "100%";
    form.container.appendChild(proprtiesTable);

    var properties = [
        ["dataSource", this.loc.PropertyMain.DataSource, this.DropDownList("editVariableFormDataSource", 180, null, this.GetVariableDataSourceItems(), true), "6px 12px 6px 12px"],
        ["selection", this.loc.PropertyMain.InitialSelection, this.DropDownList("editVariableFormSelection", 180, null, this.GetVariableSelectionItems(), true), "6px 12px 6px 12px"],
        ["headerDataBindings", null, this.FormBlockHeader(this.loc.PropertyMain.DataBindings, "6px 6px 6px 12px"), "6px 0 6px 0"],
        ["keys", this.loc.PropertyMain.Keys, this.DataControl(null, 180, true), "6px 12px 6px 12px"],
        ["values", this.loc.PropertyMain.Labels, this.DataControl(null, 180, true), "6px 12px 6px 12px"],
        ["sortDirectionKeys", null, this.DropDownList("editVariableFormSortDirectionKeys", 180, null, this.GetVariableSortDirectionItems(), true), "6px 12px 6px 0"],
        ["sortDirectionValues", null, this.DropDownList("editVariableFormSortDirectionValues", 180, null, this.GetVariableSortDirectionItems(), true), "6px 12px 6px 0"],
        ["filterExpression", this.loc.PropertyMain.Filter, this.ExpressionControl("editVariableFormFilterExpression", 378, null, null, true, null, null, false, ["DataSource.Field > 4", "DataSource.Field == Variable"], null, 40), "6px 12px 6px 12px"],
        ["checkedColumnExpression", this.loc.PropertyMain.Checked, this.ExpressionControl("editVariableFormCheckedExp", 180, null, null, true, null, null, false, ["DataSource.Field > 4", "DataSource.Field == Variable"], null, 40), "6px 12px 6px 12px"],
        ["checkedSelectDataSource", null, this.CheckBox(null, this.loc.FormTitles.DataSourceSelectForm), "6px 12px 10px 0"],
        ["checkedColumnDataSource", null, this.DropDownList("editVariableFormCheckedColumnDataSource", 180, null, [], true), "6px 12px 6px 0"],
        ["headerDependentValue", null, this.FormBlockHeader(this.loc.PropertyMain.DependentValue, "6px 6px 6px 12px"), "6px 0 6px 0"],
        ["dependentVariable", this.loc.PropertyMain.Variable, this.DropDownList("editVariableFormDependentVariable", 180, null, [], true), "6px 12px 6px 12px"],
        ["dependentColumn", this.loc.PropertyMain.DependentColumn, this.DataControl(null, 180, true), "6px 12px 6px 12px"],
        ["headerEnterDataManually", null, this.FormBlockHeader(this.loc.Report.EnterDataManually, "6px 6px 6px 12px"), "6px 0 6px 0"]
    ]

    for (var i = 0; i < properties.length; i++) {
        var propertyName = properties[i][0];
        form.controls[propertyName + "Row"] = proprtiesTable.addRow();

        if (properties[i][1] != null) {
            var textCell = proprtiesTable.addTextCellInLastRow(properties[i][1]);
            textCell.className = "stiDesignerTextForFormControls";
            textCell.style.whiteSpace = "normal";
            textCell.style.minWidth = "130px";
        }

        var control = properties[i][2];
        control.propertyName = propertyName;
        control.style.margin = properties[i][3];
        form.controls[propertyName] = control;
        var controlCell = proprtiesTable.addCellInLastRow(control);
        if (properties[i][1] == null) controlCell.setAttribute("colspan", 2);

        control.action = function () {
            if (this.propertyName == "sortDirectionKeys" && this.key != "None") {
                form.controls.sortDirectionValues.setKey("None");
            }
            else if (this.propertyName == "sortDirectionValues" && this.key != "None") {
                form.controls.sortDirectionKeys.setKey("None");
            }
            else if (this.propertyName == "dataSource" || this.propertyName == "keys" || this.propertyName == "values") {
                form.showControlsByType();
            }
            else if (this.propertyName == "checkedColumnDataSource") {
                if (this.key == "") form.controls.checkedSelectDataSource.setChecked(false);
                form.showControlsByType();
            }
            else if (this.propertyName == "checkedSelectDataSource") {
                form.showControlsByType();
                if (this.isChecked) form.controls.checkedColumnDataSource.button.action();
            }
        }
    }

    form.controls.keys.style.display = form.controls.sortDirectionKeys.style.display = "inline-block";
    form.controls.keys.parentElement.appendChild(form.controls.sortDirectionKeys);
    form.controls.sortDirectionKeysRow.style.display = "none";

    form.controls.values.style.display = form.controls.sortDirectionValues.style.display = "inline-block";
    form.controls.values.parentElement.appendChild(form.controls.sortDirectionValues);
    form.controls.sortDirectionValuesRow.style.display = "none";

    form.controls.checkedColumnExpression.style.display = form.controls.checkedSelectDataSource.style.display = form.controls.checkedColumnDataSource.style.display = "inline-block";
    form.controls.checkedColumnExpression.parentElement.style.lineHeight = "0";
    form.controls.checkedColumnExpression.parentElement.appendChild(form.controls.checkedSelectDataSource);
    form.controls.checkedColumnExpression.parentElement.appendChild(form.controls.checkedColumnDataSource);
    form.controls.checkedSelectDataSourceRow.style.display = "none";

    //Data Grid
    var dataGridPanel = form.controls.dataGridPanel = document.createElement("div");
    form.container.appendChild(dataGridPanel);

    form.convertVariableItemsToDataGridValues = function (itemsFromColumns) {
        var items = itemsFromColumns || jsObject.CopyObject(this.variableForm.variable.items);
        var dataGridValues = [];
        var basicType = this.variableForm.controls.basicType.key;
        var showChecked = basicType == "List" && !this.variableForm.controls.allowUserValues.isChecked;
        var checkedStates = this.variableForm.variable.checkedStates;

        if (items) {
            for (var i = 0; i < items.length; i++) {
                var rowArray = [];
                var rowValues = {
                    key: items[i].key != null ? StiBase64.decode(items[i].key) : null,
                    keyTo: items[i].keyTo != null ? StiBase64.decode(items[i].keyTo) : null,
                    value: StiBase64.decode(items[i].value || ""),
                    checked: itemsFromColumns ? true : (showChecked && checkedStates && i < checkedStates.length ? checkedStates[i] : false),
                    type: items[i].type == "expression"
                }
                for (var k = 0; k < dataGridColums.length; k++) {
                    var columnName = dataGridColums[k][0];
                    rowArray.push(rowValues[columnName]);
                }
                dataGridValues.push(rowArray);
            }
            dataGridControl.setValue(dataGridValues);
        }
    }

    form.convertDataGridValuesToVariableItems = function () {
        var items = [];
        var dataGridValues = dataGridControl.getValue();

        if (dataGridValues) {
            for (var i = 0; i < dataGridValues.length; i++) {
                var valuesRow = dataGridValues[i];
                var item = {};

                for (var k = 0; k < dataGridColums.length; k++) {
                    var columnName = dataGridColums[k][0];
                    if (k < valuesRow.length) {
                        item[columnName] = columnName == "type"
                            ? (valuesRow[k] ? "expression" : "value")
                            : (columnName == "checked" ? valuesRow[k] : StiBase64.encode(valuesRow[k]));
                    }
                }
                items.push(item);
            }
        }

        if (items.length == 0)
            return null;

        return items;
    }

    form.getVariablesItems = function () {
        var items = [];
        items.push(jsObject.Item("itemNone", "", null, ""));

        var variables = jsObject.GetVariablesFromDictionary(jsObject.options.report.dictionary);
        for (var i = 0; i < variables.length; i++)
            if (variables[i].name != this.variableForm.variable.name && variables[i].dependentVariable != this.variableForm.variable.name)
                items.push(jsObject.Item("item" + i, variables[i].name, null, variables[i].name));

        return items;
    }

    form.showControlsByType = function () {
        var variableForm = this.variableForm;
        var basicType = variableForm.controls.basicType.key;
        var type = variableForm.controls.type.key;
        var enabledDataSource = basicType != "Range";
        var showColumns = enabledDataSource && this.controls.dataSource.key == "Columns";
        var showItems = this.controls.dataSource.key == "Items";
        var showDependentValue = showColumns && type != "object" && (basicType == "Value" || basicType == "List");
        var enableCheckedControls = basicType == "List" && !variableForm.controls.allowUserValues.isChecked;
        
        this.controls.selectionRow.style.display = basicType == "Value" ? "" : "none";
        this.controls.headerDataBindingsRow.style.display = showColumns ? "" : "none";
        this.controls.keysRow.style.display = showColumns ? "" : "none";
        this.controls.valuesRow.style.display = showColumns ? "" : "none";
        this.controls.filterExpressionRow.style.display = showColumns ? "" : "none";
        this.controls.checkedColumnExpressionRow.style.display = showColumns ? "" : "none";
        this.controls.headerEnterDataManually.style.display = showItems ? "" : "none";
        this.controls.dataGridPanel.style.display = showItems ? "" : "none";
        this.controls.headerDependentValueRow.style.display = showDependentValue ? "" : "none";
        this.controls.dependentVariableRow.style.display = showDependentValue ? "" : "none";
        this.controls.dependentColumnRow.style.display = showDependentValue ? "" : "none";

        this.controls.dataSource.setEnabled(enabledDataSource);
        this.controls.sortDirectionKeys.setEnabled(this.controls.keys.key != "");
        this.controls.sortDirectionValues.setEnabled(this.controls.values.key != "");

        this.controls.checkedColumnExpression.setEnabled(enableCheckedControls);
        this.controls.checkedSelectDataSource.setEnabled(enableCheckedControls);
        this.controls.checkedColumnDataSource.setEnabled(enableCheckedControls);

        this.controls.checkedSelectDataSource.style.display = !this.controls.checkedSelectDataSource.isChecked ? "inline-block" : "none";
        this.controls.checkedColumnDataSource.style.display = this.controls.checkedSelectDataSource.isChecked ? "inline-block" : "none";
    }

    form.show = function (variableForm) {
        this.variableForm = variableForm;

        var basicType = variableForm.controls.basicType.key;
        var type = variableForm.controls.type.key;
        var showChecked = basicType == "List" && !variableForm.controls.allowUserValues.isChecked;
        var enabledDataSource = basicType != "Range";

        //Set controls values
        this.controls.dataSource.setKey(!enabledDataSource ? "Items" : variableForm.variable.dataSource);
        this.controls.selection.setKey(variableForm.variable.selection);
        this.controls.keys.setKey(variableForm.variable.keys);
        this.controls.values.setKey(variableForm.variable.values);
        this.controls.filterExpression.textBox.value = StiBase64.decode(variableForm.variable.filterExpression);
        this.controls.sortDirectionKeys.setKey(variableForm.variable.sortField == "Key" ? variableForm.variable.sortDirection : "None");
        this.controls.sortDirectionValues.setKey(variableForm.variable.sortField == "Label" ? variableForm.variable.sortDirection : "None");

        var dataSourceItems = [];
        dataSourceItems.push(jsObject.Item("[No]", "[" + jsObject.loc.FormFormatEditor.nameNo + "]", null, ""));
        dataSourceItems = dataSourceItems.concat(jsObject.GetDataSourceItemsFromDictionary());
        this.controls.checkedColumnDataSource.addItems(dataSourceItems);
        this.controls.checkedColumnDataSource.setKey("");

        if ("checkedColumn" in variableForm.variable) {
            var checkedColumnArray = variableForm.variable.checkedColumn.split(";");
            this.controls.checkedColumnDataSource.setKey(checkedColumnArray[0] || "");
            this.controls.checkedColumnExpression.textBox.value = checkedColumnArray.length > 1 ? checkedColumnArray[1] : "";
        }

        this.controls.checkedSelectDataSource.setChecked(this.controls.checkedColumnDataSource.key != "");
        this.controls.dependentVariable.menu.addItems(this.getVariablesItems());
        this.controls.dependentVariable.setKey(variableForm.variable.dependentValue ? variableForm.variable.dependentVariable : "");
        this.controls.dependentColumn.setKey(variableForm.variable.dependentColumn);

        //Fill data grid
        dataGridColums = [];

        var controlType = null;
        if (type == "datetime") controlType = "datepicker";
        if (type == "bool") controlType = "boolcombobox";

        if (showChecked) {
            dataGridColums.push(["checked", jsObject.loc.PropertyMain.Checked, "checkbox"]);
        }

        dataGridColums.push(["key", basicType == "Range" ? jsObject.loc.PropertyMain.RangeFrom : jsObject.loc.PropertyMain.Key, controlType]);

        if (basicType == "Range") {
            dataGridColums.push(["keyTo", jsObject.loc.PropertyMain.RangeTo, controlType]);
        }

        dataGridColums.push(["value", jsObject.loc.PropertyMain.Label]);
        dataGridColums.push(["type", jsObject.loc.PropertyMain.Expression, "checkbox"]);

        dataGridControl = jsObject.InitializeVariableManualDataControl(550, 450, dataGridColums, 15);
        dataGridControl.style.margin = "12px";

        dataGridPanel.innerHTML = "";
        dataGridPanel.appendChild(dataGridControl);

        selColumButton.style.visibility = basicType != "Range" ? "visible" : "hidden";

        this.convertVariableItemsToDataGridValues();
        this.showControlsByType();
        this.changeVisibleState(true);
    }

    form.action = function () {
        var variableForm = this.variableForm;
        var basicType = variableForm.controls.basicType.key;
        var showChecked = basicType == "List" && !variableForm.controls.allowUserValues.isChecked;

        var items = this.convertDataGridValuesToVariableItems();

        variableForm.variable.selection = this.controls.selection.key;
        variableForm.variable.dataSource = this.controls.dataSource.isEnabled ? this.controls.dataSource.key : "Items";
        variableForm.variable.keys = this.controls.keysRow.style.display == "" ? this.controls.keys.key : "";
        variableForm.variable.values = this.controls.valuesRow.style.display == "" ? this.controls.values.key : "";
        variableForm.variable.filterExpression = StiBase64.encode(this.controls.filterExpression.textBox.value);
        variableForm.variable.sortField = this.controls.sortDirectionKeys.isEnabled && this.controls.sortDirectionKeys.key != "None" ? "Key" : "Label";
        variableForm.variable.sortDirection = variableForm.variable.sortField == "Key" ? this.controls.sortDirectionKeys.key : this.controls.sortDirectionValues.key;
        variableForm.variable.checkedColumn = this.controls.checkedColumnDataSource.key + ";" + this.controls.checkedColumnExpression.textBox.value;
        variableForm.variable.dependentValue = this.controls.dependentVariableRow.style.display == "" && this.controls.dependentVariable.key != "";
        variableForm.variable.dependentVariable = this.controls.dependentVariableRow.style.display == "" ? this.controls.dependentVariable.key : "";
        variableForm.variable.dependentColumn = this.controls.dependentVariableRow.style.display == "" ? this.controls.dependentColumn.key : "";
        variableForm.variable.items = items;
        variableForm.controls.items.showValues(variableForm.getItemsValuesTable());

        if (showChecked && items) {
            variableForm.variable.checkedStates = [];
            for (var i = 0; i < items.length; i++) {
                if (items[i].checked != null) {
                    variableForm.variable.checkedStates[i] = items[i].checked;
                }
            }
        }

        variableForm.showControlsByType();
        this.changeVisibleState(false);
    }

    return form;
}

StiMobileDesigner.prototype.InitializeVariableManualDataControl = function (width, height, dataColumns, countRows) {
    var jsObject = this;
    var control = this.InitializeManualDataControl(width, height, dataColumns, countRows);

    var rowsHeight = 22;
    var leftCellWidth = 60;
    var cellWidth = ((width || 300) - leftCellWidth) / dataColumns.length;
    var mainTable = control.mainTable;
    var contextMenu = control.contextMenu;

    //override methods
    control.setRowToExpression = function (state, row) {
        row.isExpression = state;

        for (var k = 1; k < row.childNodes.length; k++) {
            var cell = row.childNodes[k];
            var columnName = cell.textBox.dataColumn;

            if (columnName == "key" || columnName == "keyTo") {
                if (cell.dateControl || cell.boolComboBox) {
                    cell.textBox.style.display = state ? "" : "none";
                }
                if (cell.dateControl) cell.dateControl.style.display = !state ? "" : "none";
                if (cell.boolComboBox) cell.boolComboBox.style.display = !state ? "" : "none";
            }
        }
    }

    control.rowIsExpression = function (row, rowValues) {
        for (var i = 1; i < row.childNodes.length; i++) {
            var cell = row.childNodes[i];
            var columnName = cell.textBox.dataColumn;
            var cellValue = rowValues[i - 1];

            if (columnName == "type" && cellValue) {
                return true;
            }
        }
        return false;
    }

    control.setValue = function (valArray) {
        this.clear();

        if (valArray) {
            for (var i = 0; i < valArray.length; i++) {
                if (i >= mainTable.tr.length - 1) {
                    control.countRows++;
                    control.addRow(control.countRows);
                }
                var row = mainTable.tr[i + 1];
                var rowValues = valArray[i];
                var isExpression = row.isExpression = control.rowIsExpression(row, rowValues);

                for (var k = 1; k < row.childNodes.length; k++) {
                    var cell = row.childNodes[k];
                    var controlType = cell.controlType;
                    var cellValue = rowValues[k - 1];
                    var columnName = cell.textBox.dataColumn;
                    var textBox = cell.textBox;

                    if (isExpression && (columnName == "key" || columnName == "keyTo")) {
                        textBox.value = cellValue;
                        textBox.style.display = "";
                        if (cell.boolComboBox) cell.boolComboBox.style.display = "none";
                        if (cell.dateControl) cell.dateControl.style.display = "none";
                    }
                    else {
                        switch (controlType) {
                            case "datepicker": {
                                var dateControl = cell.dateControl;
                                if (cellValue) dateControl.setKey(new Date(cellValue));
                                break;
                            }
                            case "boolcombobox": {
                                var boolComboBox = cell.boolComboBox;
                                boolComboBox.setKey(cellValue ? jsObject.UpperFirstChar(cellValue) : "");
                                break;
                            }
                            case "checkbox": {
                                var checkBox = cell.checkBox;
                                checkBox.setChecked(cellValue);
                                break;
                            }
                            default: {
                                textBox.value = cellValue || "";
                            }
                        }
                    }
                }
            }
        }
    }

    control.getValue = function () {
        var result = [];

        for (var i = 1; i <= control.countRows; i++) {
            var row = mainTable.tr[i];
            var emptyRow = true;
            var rowValues = [];

            for (var k = 1; k < row.childNodes.length; k++) {
                var cell = row.childNodes[k];
                var textBox = cell.textBox;
                var controlType = cell.controlType;
                var value = "";

                switch (controlType) {
                    case "datepicker": {
                        var dateControl = cell.dateControl;
                        if ((!row.isExpression && dateControl.textBox.value && dateControl.key) || (row.isExpression && textBox.value)) {
                            value = row.isExpression ? textBox.value : jsObject.DateToStringAmericanFormat(dateControl.key);
                            emptyRow = false;
                        }
                        break;
                    }
                    case "boolcombobox": {
                        var boolComboBox = cell.boolComboBox;
                        if ((!row.isExpression && boolComboBox.textBox.value && boolComboBox.key) || (row.isExpression && textBox.value)) {
                            value = row.isExpression ? textBox.value : boolComboBox.key;
                            emptyRow = false;
                        }
                        break;
                    }
                    case "checkbox": {
                        var checkBox = cell.checkBox;
                        value = checkBox.isChecked;
                        break;
                    }
                    default: {
                        if (textBox.value != "") {
                            value = textBox.value;
                            emptyRow = false;
                        }
                    }
                }

                rowValues.push(value);
            }

            if (!emptyRow) result.push(rowValues);
        }

        return result;
    }

    control.addRow = function (rowIndex) {
        var row = mainTable.insertRow(rowIndex);

        var leftCell = mainTable.addTextCellInRow(rowIndex, rowIndex)
        leftCell.className = "stiManualControlCell stiManualControlHeaderCell";
        leftCell.style.width = leftCellWidth + "px";
        leftCell.rowIndex = rowIndex;

        leftCell.onmousedown = function (event) {
            control.selectRow(this.rowIndex);
        }

        leftCell.onmouseup = function (event) {
            if (event.button == 2) {
                event.stopPropagation();
                contextMenu.currentCell = control.getCellByIndex(this.rowIndex, 1);
                contextMenu.updateItemsStates();
                var point = jsObject.FindMousePosOnMainPanel(event);
                contextMenu.show(point.xPixels + 10, point.yPixels + 20, "Down", "Right");
            }
            return false;
        }

        for (var k = 0; k < dataColumns.length; k++) {
            var textBox = jsObject.TextBox(null, cellWidth - 6, rowsHeight);
            textBox.style.border = "0";
            textBox.style.textAlign = "right";
            textBox.style.marginRight = "4px";
            textBox.rowIndex = rowIndex;
            textBox.columnIndex = k + 1;
            textBox.dataColumn = dataColumns[k][0];
            textBox.style.background = "transparent";

            var cell = mainTable.addCellInRow(rowIndex, textBox);
            cell.className = "stiManualControlCell";
            cell.style.lineHeight = "0";
            cell.style.width = cellWidth + "px";
            cell.style.height = rowsHeight + "px";
            cell.textBox = textBox;

            var controlType = dataColumns[k][2];
            if (controlType) {
                cell.controlType = controlType;
                textBox.style.display = "none";

                switch (controlType) {
                    case "datepicker": {
                        var dateControl = cell.dateControl = jsObject.DateControl(null, cellWidth);
                        dateControl.textBox.value = "";
                        dateControl.style.border = dateControl.textBox.style.border = dateControl.button.style.border = "0";
                        cell.appendChild(dateControl);
                        break;
                    }
                    case "boolcombobox": {
                        var boolComboBox = cell.boolComboBox = jsObject.DropDownList(null, cellWidth, null, jsObject.GetBoolItems(), true);
                        boolComboBox.textBox.style.border = boolComboBox.button.style.border = "0";
                        cell.appendChild(boolComboBox);
                        break;
                    }
                    case "checkbox": {
                        var checkBox = cell.checkBox = jsObject.CheckBox();
                        checkBox.style.display = "inline-block";
                        checkBox.row = row;
                        cell.appendChild(checkBox);

                        if (dataColumns[k][0] == "type") {
                            checkBox.action = function () {
                                control.setRowToExpression(this.isChecked, this.row);
                            }
                        }
                        break;
                    }
                }
            }

            if (this.visibilityParams && this.visibilityParams[dataColumns[k][0]] && !this.visibilityParams[dataColumns[k][0]].visible) {
                cell.style.display = "none";
            }

            textBox.action = function () {
                if (this.rowIndex == control.countRows) {
                    control.countRows++;
                    control.addRow(control.countRows);
                }
                control.action();
            }

            textBox.actionOnKeyEnter = function () {
                var nextCell = control.getCellByIndex(this.rowIndex + 1, this.columnIndex);
                if (nextCell) {
                    control.selectCell(nextCell);
                    nextCell.textBox.focus();
                }
            }

            textBox.onkeypress = function (event) {
                if (this.readOnly) return false;
                if (event && event.keyCode == 13) {
                    this.keyEnterPressed = true;
                    this.onblur();
                    this.actionOnKeyEnter();
                    return false;
                }
            }

            cell.setSelected = function (state) {
                this.className = state ? "stiManualControlCell stiManualControlCellSelected" : "stiManualControlCell";
                this.isSelected = state;
            }

            cell.onmousedown = function (event) {
                control.currentCell = this;

                if (jsObject.options.CTRL_pressed) {
                    this.setSelected(!this.isSelected);
                }
                else if (!(event.button == 2 && this.isSelected)) {
                    control.selectCell(this);
                }
            }

            cell.onmouseup = function (event) {
                if (event.button == 2) {
                    event.stopPropagation();
                    contextMenu.currentCell = this;
                    contextMenu.updateItemsStates();
                    var point = jsObject.FindMousePosOnMainPanel(event);
                    contextMenu.show(point.xPixels + 10, point.yPixels + 20, "Down", "Right");
                }
                return false;
            }
        }
    }

    control.moveRow = function (rowIndex, direction, columnIndex) {
        if (rowIndex < mainTable.tr.length) {
            var rowFrom = mainTable.tr[rowIndex];
            var rowTo = direction == "down" ? (rowIndex + 1 < mainTable.tr.length ? mainTable.tr[rowIndex + 1] : null) : (rowIndex - 1 > 0 ? mainTable.tr[rowIndex - 1] : null)

            if (rowFrom && rowTo) {
                for (var i = 1; i < rowFrom.childNodes.length; i++) {
                    var cellFrom = rowFrom.childNodes[i];
                    var cellTo = rowTo.childNodes[i];
                    var controlTypes = ["textBox", "dateControl", "boolComboBox", "checkBox"];

                    for (var k = 0; k < controlTypes.length; k++) {
                        var controlFrom = cellFrom[controlTypes[k]];
                        var controlTo = cellTo[controlTypes[k]];
                        if (controlFrom && controlTo) {
                            if (controlTypes[k] == "dateControl" || controlTypes[k] == "boolComboBox") {
                                var keyFrom = controlFrom.key;
                                var valueFrom = controlFrom.textBox.value;
                                controlFrom.setKey(controlTo.key);
                                controlFrom.textBox.value = controlTo.textBox.value;
                                controlTo.setKey(keyFrom);
                                controlTo.textBox.vlaue = valueFrom;
                            }
                            else if (controlTypes[k] == "checkBox") {
                                var valueFrom = controlFrom.isChecked;
                                controlFrom.setChecked(controlTo.isChecked);
                                controlTo.setChecked(valueFrom);
                            }
                            else {
                                var valueFrom = controlFrom.value;
                                controlFrom.value = controlTo.value;
                                controlTo.value = valueFrom;
                            }
                        }
                    }
                }
                var rowFromIsExpression = rowFrom.isExpression;
                control.setRowToExpression(rowTo.isExpression, rowFrom);
                control.setRowToExpression(rowFromIsExpression, rowTo);
            }
        }

        control.action();
        var selectedCell = control.getCellByIndex(direction == "down" ? rowIndex + 1 : rowIndex - 1, columnIndex);
        if (selectedCell) control.selectCell(selectedCell);
    }

    control.clear();

    return control;
}