﻿
StiMobileDesigner.prototype.InitializeParametersValuesForm_ = function () {
    var jsObject = this;
    var form = this.BaseForm("editParametersValuesForm", this.loc.FormTitles.SqlExpressionsForm, 3);

    var innerTable = this.CreateHTMLTable();
    innerTable.style.margin = "6px";
    form.container.appendChild(innerTable);

    form.show = function (formParameters, variablesParams, completeFunction) {
        form.controls = {};
        form.formParameters = formParameters;
        form.completeFunction = completeFunction;

        if (variablesParams) {
            for (var i = 0; i < variablesParams.length; i++) {
                innerTable.addRow();
                var variableName = variablesParams[i];
                var variableValue = "";

                if (variableName && variableName.indexOf("{") == 0 && jsObject.EndsWith(variableName, "}")) {
                    variableName = variableName.substring(1, variableName.length - 1);
                    var variable = jsObject.GetVariableByNameFromDictionary(variableName);
                    if (variable && variable.value && variable.type != "image" && variable.type != "object")
                        variableValue = StiBase64.decode(variable.value);
                }

                innerTable.addTextCellInLastRow(variableName).className = "stiDesignerCaptionControlsBigIntervals";
                var textBox = jsObject.TextBox(200);
                textBox.value = variableValue;
                form.controls[variablesParams[i]] = textBox;
                innerTable.addCellInLastRow(textBox).className = "stiDesignerControlCellsBigIntervals2";
            }
        }

        for (var i = 0; i < formParameters.parameters.length; i++) {
            var param = formParameters.parameters[i];
            innerTable.addRow();
            innerTable.addTextCellInLastRow(param.name).className = "stiDesignerCaptionControlsBigIntervals";
            var control = form.controls[param.name] = jsObject.TextBox(200);
            if (param.expression) {
                control.value = StiBase64.decode(param.expression);
            }
            innerTable.addCellInLastRow(form.controls[param.name]).className = "stiDesignerControlCellsBigIntervals2";
        }

        form.changeVisibleState(true);
    }

    form.action = function (parameterNames) {
        var parametersValues = {};

        for (var name in form.controls) {
            parametersValues[name] = StiBase64.encode(form.controls[name].value);
        }

        form.formParameters.parametersValues = parametersValues;
        form.completeFunction(form.formParameters);
        form.changeVisibleState(false);
    }

    return form;
}