﻿
StiMobileDesigner.prototype.InitializeHyperlinkEditorForm_ = function () {
    var jsObject = this;
    var form = this.BaseForm("hyperlinkEditorForm", this.loc.PropertyMain.Hyperlink, 2, this.GetHelpLink("dashboardInteractions"));

    var expTable = this.CreateHTMLTable();
    form.container.appendChild(expTable);
    expTable.style.display = "inline-block";

    var textArea = form.textArea = this.TextArea("textEditorOnlyTextTextArea", 500, 400);
    textArea.style.margin = "12px";
    textArea.style.fontFamily = "Courier New";
    form.container.appendChild(textArea);
    form.addBrackets = true;
    expTable.addCell(textArea);

    var expDictionaryTree = form.expDictionaryTree = jsObject.options.expDictionaryTree || this.DictionaryTree(true);
    var dictionaryPanel = form.dictionaryPanel = jsObject.DictionaryPanelForEditors(250, 400, true);
    dictionaryPanel.addDictionaryTreeToPanel(expDictionaryTree);
    dictionaryPanel.style.margin = "12px 12px 0 0";
    expTable.addCell(dictionaryPanel).style.display = "inline-block";
    textArea.addInsertButton(expDictionaryTree);

    form.addConstantsToDictionaryTree = function (control) {
        var expItems = jsObject.GetInsertExpressionItems(control.interactionIdent, control.columnNames, control.chartProps);
        if (expItems.length > 0) {
            if (expDictionaryTree.mainItems.Fields) {
                expDictionaryTree.removeChild(expDictionaryTree.mainItems.Fields);
                delete expDictionaryTree.mainItems.Fields;
            }
            var mainItemFields = expDictionaryTree.mainItems.Fields = jsObject.DictionaryTreeItem(jsObject.loc.PropertyMain.Fields, "VariableString.png", { name: "FieldsMainItem", typeItem: "FieldsMainItem" }, expDictionaryTree);
            expDictionaryTree.insertBefore(mainItemFields, expDictionaryTree.mainItems.DataSources);

            for (var i = 0; i < expItems.length; i++) {
                mainItemFields.addChild(jsObject.DictionaryTreeItem(expItems[i].key, "VariableString.png", { typeItem: "Field", name: expItems[i].key, key: expItems[i].key }, expDictionaryTree));
            }
            mainItemFields.setSelected();
            mainItemFields.setOpening(true);
        }
    }

    form.show = function (control) {        
        dictionaryPanel.addDictionaryTreeToPanel(expDictionaryTree);
        expDictionaryTree.build(jsObject.options.report.dictionary, true);
        expDictionaryTree.currentEditor = textArea;
        form.addConstantsToDictionaryTree(control);

        if (control.interactionIdent == "expandExpression") {
            form.addBrackets = false;
            form.caption.innerHTML = jsObject.loc.Dashboard.EditExpression;
        }
        else {
            form.caption.innerHTML = jsObject.loc.PropertyMain.Hyperlink;
        }

        form.textArea.value = control.textBox.value;
        form.changeVisibleState(true);
        form.textArea.focus();
    }

    form.onhide = function () {
        if (expDictionaryTree.mainItems.Fields) {
            expDictionaryTree.removeChild(expDictionaryTree.mainItems.Fields);
            delete expDictionaryTree.mainItems.Fields;
        }
    }

    return form;
}