﻿
StiMobileDesigner.prototype.InitializeGroupHeaderForm_ = function () {
    var jsObject = this;
    var groupHeaderForm = this.BaseForm("groupHeaderForm", this.loc.FormTitles.GroupConditionForm, 1);
    groupHeaderForm.dataTree = this.options.dataTree;
    groupHeaderForm.mode = "Expression";
    groupHeaderForm.controls = {};

    //Check Button
    groupHeaderForm.getDataForAI = function () {
        return {
            commandName: "textAndExpression",
            expression: StiBase64.encode((groupHeaderForm.mode == "Expression" ? groupHeaderForm.textAreaExpression : groupHeaderForm.textAreaSummaryExpression).value)
        }
    }
        
    //Main Table
    var mainTable = this.CreateHTMLTable();
    groupHeaderForm.container.appendChild(mainTable);
    groupHeaderForm.container.style.padding = "0px";
    groupHeaderForm.container.appendChild(this.FormSeparator());

    //Buttons
    var buttonProps = [
        ["Expression", "GroupHeaderForm.GroupExpression.png", this.loc.PropertyMain.Expression],
        ["DataColumn", "GroupHeaderForm.GroupDataColumn.png", this.loc.PropertyMain.DataColumn],
        ["SummaryExpression", "GroupHeaderForm.GroupSummary.png", this.loc.PropertyMain.Summary]
    ];

    //Add Panels && Buttons
    var buttonsPanel = mainTable.addCell();
    var panelsContainer = mainTable.addCell();

    buttonsPanel.style.verticalAlign = "top";
    buttonsPanel.style.paddingTop = "6px";
    groupHeaderForm.mainButtons = {};
    groupHeaderForm.panels = {};

    for (var i = 0; i < buttonProps.length; i++) {
        var panel = document.createElement("Div");
        panel.className = "stiDesignerEditFormPanel";
        panel.style.height = "400px";
        panel.style.width = "595px";

        panel.style.display = i == 0 ? "" : "none";
        panelsContainer.appendChild(panel);
        groupHeaderForm.panels[buttonProps[i][0]] = panel;

        var button = this.FormTabPanelButton(null, buttonProps[i][2], buttonProps[i][1], buttonProps[i][2], null, { width: 24, height: 24 }, 34);
        groupHeaderForm.mainButtons[buttonProps[i][0]] = button;
        buttonsPanel.appendChild(button);
        button.panelName = buttonProps[i][0];

        button.action = function () {
            groupHeaderForm.setMode(this.panelName);
        }
    }

    //Text Areas
    var expDictionaryTree = jsObject.options.expDictionaryTree || this.DictionaryTree(true);
    var textAreas = ["Expression", "SummaryExpression"];

    for (var i = 0; i < textAreas.length; i++) {
        var expTable = this.CreateHTMLTable();
        expTable.style.display = "inline-block";
        groupHeaderForm.panels[textAreas[i]].appendChild(expTable);

        var height = textAreas[i] == "Expression" ? 263 : 228;
        var textArea = groupHeaderForm["textArea" + textAreas[i]] = this.TextArea("groupHeaderForm" + textAreas[i], 300, height - 8);
        textArea.style.margin = "12px 12px 6px 12px";
        expTable.addCell(textArea);

        var dictionaryPanel = groupHeaderForm["dictionaryPanel" + textAreas[i]] = jsObject.DictionaryPanelForEditors(250, height + 62, true);
        dictionaryPanel.style.margin = "12px 12px 0 0";
        expTable.addCell(dictionaryPanel).style.display = "inline-block";

        textArea.addInsertButton(expDictionaryTree);

        var controlsTable = jsObject.CreateHTMLTable();
        groupHeaderForm.panels[textAreas[i]].appendChild(controlsTable);

        if (textAreas[i] == "Expression") {
            var sortDirection = groupHeaderForm.controls.sortDirection = this.DropDownList("groupHeaderFormSortDirection", 200, null, this.GetSortDirectionItems(), true, false, null, true);
            sortDirection.style.margin = "6px 12px 6px 30px";

            controlsTable.addTextCell(this.loc.PropertyMain.SortDirection).className = "stiDesignerTextForFormControls";
            var sortDirectionCell = groupHeaderForm.controls.sortDirectionExpressionCell = controlsTable.addCell(sortDirection);
        }
        else {
            var summarySortDirection = groupHeaderForm.controls.summarySortDirection = this.DropDownList("groupHeaderFormSummarySortDirection", 200, null, this.GetSortDirectionItems(), true, false, null, true);
            summarySortDirection.style.margin = "6px 12px 6px 30px";
            var summaryType = groupHeaderForm.controls.summaryType = this.DropDownList("groupHeaderFormSummaryType", 200, null, this.GetSummaryTypeItems(), true, false, null, true);
            summarySortDirection.style.margin = summaryType.style.margin = "6px 12px 6px 30px";

            controlsTable.addTextCell(this.loc.PropertyMain.SummarySortDirection).className = "stiDesignerTextForFormControls";
            controlsTable.addCell(summarySortDirection);

            controlsTable.addTextCellInNextRow(this.loc.PropertyMain.SummaryType).className = "stiDesignerTextForFormControls";
            controlsTable.addCellInLastRow(summaryType);
        }
    }

    //Data Columns
    var columnsCont = document.createElement("div");
    columnsCont.className = "stiSimpleContainerWithBorder";
    columnsCont.style.margin = "12px";
    columnsCont.style.overflow = "auto";
    columnsCont.style.width = "570px";
    columnsCont.style.height = "323px";
    groupHeaderForm.panels.DataColumn.appendChild(columnsCont);

    var dataColumnTable = this.CreateHTMLTable();
    dataColumnTable.style.width = "100%";
    groupHeaderForm.panels.DataColumn.appendChild(dataColumnTable);

    dataColumnTable.addTextCellInNextRow(this.loc.PropertyMain.SortDirection).className = "stiDesignerTextForFormControls";
    groupHeaderForm.controls.sortDirectionDataColumnCell = dataColumnTable.addCellInLastRow();

    groupHeaderForm.textAreaExpression.checkButtonAction = groupHeaderForm.textAreaSummaryExpression.checkButtonAction = function () {
        var checkButton = this.checkButton;
        checkButton.setEnabled(false);

        var currentEditingControl = groupHeaderForm.mode == "Expression" ? groupHeaderForm.textAreaExpression : groupHeaderForm.textAreaSummaryExpression;

        var params = {
            expression: StiBase64.encode(currentEditingControl.value),
            useAliases: jsObject.options.useAliases
        }

        jsObject.SendCommandToDesignerServer("CheckExpression", params, function (answer) {
            checkButton.setEnabled(true);

            if (answer.checkResult) {
                var message = StiBase64.decode(answer.checkResult);

                var messageForm = jsObject.MessageFormWithFixAI(jsObject.loc.Buttons.Check);
                messageForm.show(message == "OK" ? jsObject.loc.StimulAI.CheckExpressionSuccess : message, message == "OK" ? "Information" : "Warning");
                messageForm.buttonYes.style.display = jsObject.options.showStimulAI && message != "OK" ? "" : "none";

                messageForm.action = function (state) {
                    messageForm.changeVisibleState(false);

                    if (state) {
                        jsObject.InitializeStimulAIForm(function (stimulAIForm) {
                            stimulAIForm.show(groupHeaderForm, currentEditingControl, function () {
                                stimulAIForm.sendButtonAction("FixTextAndExpression");
                            });
                        });
                    }
                }
            }
        });
    };

    this.AddHintHelperToControl(groupHeaderForm.textAreaExpression, 60, true, false, ["{Expression}", "{DataSource.Field}", "{Function(DataSource.Field)}"]);
    this.AddHintHelperToControl(groupHeaderForm.textAreaSummaryExpression, 60, true, false, ["{Expression}", "{DataSource.Field}", "{Function(DataSource.Field)}"]);


    //Form Methods
    groupHeaderForm.reset = function () {
        groupHeaderForm.dataTree.setKey("");
        groupHeaderForm.textAreaExpression.value = "";
        groupHeaderForm.textAreaSummaryExpression.value = "";
        groupHeaderForm.setMode("Expression");
    }

    groupHeaderForm.setMode = function (mode) {
        groupHeaderForm.mode = mode;

        for (var panelName in groupHeaderForm.panels) {
            groupHeaderForm.panels[panelName].style.display = mode == panelName ? "" : "none";
            groupHeaderForm.mainButtons[panelName].setSelected(mode == panelName);
        }

        if (mode == "Expression") {
            groupHeaderForm.controls.sortDirectionExpressionCell.appendChild(groupHeaderForm.controls.sortDirection);
            groupHeaderForm.dictionaryPanelExpression.addDictionaryTreeToPanel(expDictionaryTree);
            expDictionaryTree.currentEditor = groupHeaderForm.textAreaExpression;
        }
        else if (mode == "SummaryExpression") {
            groupHeaderForm.dictionaryPanelSummaryExpression.addDictionaryTreeToPanel(expDictionaryTree);
            expDictionaryTree.currentEditor = groupHeaderForm.textAreaSummaryExpression;
        }
        else if (mode == "DataColumn") {
            groupHeaderForm.controls.sortDirectionDataColumnCell.appendChild(groupHeaderForm.controls.sortDirection);
        }
    }

    groupHeaderForm.show = function () {
        groupHeaderForm.changeVisibleState(true);

        expDictionaryTree.build(jsObject.options.report.dictionary, true);

        //Build Data Tree
        columnsCont.appendChild(groupHeaderForm.dataTree);
        groupHeaderForm.dataTree.build(null, null, null, true);

        groupHeaderForm.dataTree.action = function () {
            groupHeaderForm.action();
        }

        //Reset Controls
        groupHeaderForm.reset();

        var selectedObject = jsObject.options.selectedObject || jsObject.GetCommonObject(jsObject.options.selectedObjects);
        if (!selectedObject) return;

        var conditionValue = selectedObject.properties["condition"] != null && selectedObject.properties["condition"] != "StiEmptyValue"
            ? StiBase64.decode(selectedObject.properties["condition"]) : "";
        var subStringConditionValue = conditionValue.length > 1 ? conditionValue.substring(1, conditionValue.length - 1) : "";

        groupHeaderForm.textAreaExpression.value = conditionValue;

        if (groupHeaderForm.dataTree.setKey(subStringConditionValue)) {
            groupHeaderForm.setMode("DataColumn");
        }
        else {
            groupHeaderForm.setMode("Expression");
            groupHeaderForm.textAreaExpression.focus();
        }

        groupHeaderForm.textAreaSummaryExpression.value = selectedObject.properties["summaryExpression"] && selectedObject.properties["summaryExpression"] != "StiEmptyValue" ? StiBase64.decode(selectedObject.properties["summaryExpression"]) : "";
        groupHeaderForm.controls.sortDirection.setKey(selectedObject.properties["sortDirection"] != "StiEmptyValue" ? selectedObject.properties["sortDirection"] : "0");
        groupHeaderForm.controls.summarySortDirection.setKey(selectedObject.properties["summarySortDirection"] != "StiEmptyValue" ? selectedObject.properties["summarySortDirection"] : "0");
        groupHeaderForm.controls.summaryType.setKey(selectedObject.properties["summaryType"] != "StiEmptyValue" ? selectedObject.properties["summaryType"] : "13");
    }

    groupHeaderForm.action = function () {
        groupHeaderForm.changeVisibleState(false);

        var condition = groupHeaderForm.textAreaExpression.value;

        if (groupHeaderForm.mode == "DataColumn") {
            condition = (groupHeaderForm.dataTree.key ? "{" + groupHeaderForm.dataTree.key + "}" : "");
        }

        var selectedObjects = jsObject.options.selectedObjects || [jsObject.options.selectedObject];
        if (!selectedObjects) return;

        for (var i = 0; i < selectedObjects.length; i++) {
            var selectedObject = selectedObjects[i];
            selectedObject.properties.condition = StiBase64.encode(condition);
            selectedObject.properties.summaryExpression = StiBase64.encode(groupHeaderForm.textAreaSummaryExpression.value);
            selectedObject.properties.sortDirection = groupHeaderForm.controls.sortDirection.key;
            selectedObject.properties.summarySortDirection = groupHeaderForm.controls.summarySortDirection.key;
            selectedObject.properties.summaryType = groupHeaderForm.controls.summaryType.key;
        }

        jsObject.SendCommandSendProperties(selectedObjects, ["condition", "summaryExpression", "sortDirection", "summarySortDirection", "summaryType"]);
    }

    return groupHeaderForm;
}