﻿
StiMobileDesigner.prototype.InitializeExpressionEditorForm_ = function () {
    var jsObject = this;
    var form = this.InitializeBaseExpressionEditorForm("expressionEditor", this.loc.PropertyMain.Expression, 3, this.GetHelpLink("expression"));

    form.getDataForAI = function () {
        return {
            commandName: "textAndExpression",
            expression: StiBase64.encode(form.expressionTextArea.value)
        }
    }

    form.expressionTextArea.checkButtonAction = function () {
        form.expressionTextArea.checkButton.setEnabled(false);

        var params = {
            expression: StiBase64.encode(form.expressionTextArea.value),
            useAliases: jsObject.options.useAliases,
            onlyExpression: form.expressionTextArea.cutBrackets === true
        }

        jsObject.SendCommandToDesignerServer("CheckExpression", params, function (answer) {
            form.expressionTextArea.checkButton.setEnabled(true);

            if (answer.checkResult) {
                var message = StiBase64.decode(answer.checkResult);

                var messageForm = jsObject.MessageFormWithFixAI(jsObject.loc.Buttons.Check);
                messageForm.show(message == "OK" ? jsObject.loc.StimulAI.CheckExpressionSuccess : message, message == "OK" ? "Information" : "Warning");
                messageForm.buttonYes.style.display = jsObject.options.showStimulAI && message != "OK" ? "" : "none";

                messageForm.action = function (state) {
                    messageForm.changeVisibleState(false);

                    if (state) {
                        jsObject.InitializeStimulAIForm(function (stimulAIForm) {
                            stimulAIForm.show(form, form.expressionTextArea, function () {
                                stimulAIForm.sendButtonAction("FixTextAndExpression");
                            });
                        });
                    }
                }
            }
        });
    }

    return form;
}

StiMobileDesigner.prototype.InitializeBaseExpressionEditorForm = function (name, caption, level, helpUrl) {
    var jsObject = this;
    var form = this.BaseForm(name, caption, level, helpUrl);

    var showDictionaryPanel = !form.resultControl || !form.resultControl.notShowDictionary;

    //Expression
    var expTable = this.CreateHTMLTable();
    form.container.appendChild(expTable);
    expTable.style.display = "inline-block";
    var textArea = this.TextArea(null, 550, 432, true);
    textArea.style.margin = "12px";
    textArea.style.fontFamily = "Courier New";
    form.expressionTextArea = textArea;
    expTable.addCell(textArea);

    if (showDictionaryPanel) {
        var expDictionaryTree = form.expDictionaryTree = jsObject.options.expDictionaryTree || this.DictionaryTree(true);
        var dictionaryPanel = form.dictionaryPanel = jsObject.DictionaryPanelForEditors(250, 440, true);
        dictionaryPanel.addDictionaryTreeToPanel(expDictionaryTree);
        dictionaryPanel.style.margin = "12px 12px 0 0";
        expTable.addCell(dictionaryPanel).style.display = "inline-block";

        textArea.addInsertButton(expDictionaryTree);
                
        textArea.insertButton.action = function () {
            if (expDictionaryTree.selectedItem) {
                var text = expDictionaryTree.selectedItem.getResultForEditForm();
                if (form.resultControl) {
                    if (form.resultControl.checkExpressionBrackets) {
                        text = jsObject.CheckExpressionBrackets(expDictionaryTree.selectedItem.getResultForEditForm(true, true));
                    }
                    if (form.resultControl.cutBrackets && text.indexOf("{") == 0 && jsObject.EndsWith(text, "}")) {
                        text = text.substr(1, text.length - 2);
                    }
                    if (form.resultControl.eventName && jsObject.options.jsMode) {
                        //for events expression in JS
                        if (expDictionaryTree.selectedItem.itemObject.typeItem == "Function") {
                            return;
                        }
                        else if (expDictionaryTree.selectedItem.itemObject.typeItem == "SystemVariable") {
                            text = "this." + jsObject.LowerFirstChar(text);
                        }
                        else {
                            var dataArray = text.split(".");
                            if (dataArray.length == 2) {
                                text = dataArray[0] + ".getData(\"" + dataArray[1] + "\")";
                            }
                        }
                    }
                }
                textArea.insertText(text);
            }
        }

        new ResizeObserver(function () {
            if ((textArea.parentContainer || textArea).offsetHeight > 0) {
                dictionaryPanel.style.height = (textArea.parentContainer ? textArea.parentContainer.offsetHeight - 2 : textArea.offsetHeight) + "px";
            }
        }).observe(textArea);
    }

    form.onshow = function () {        
        if (textArea.restoreParent) {
            textArea.restoreParent();
        }
        if (showDictionaryPanel) {
            form.dictionaryPanel.addDictionaryTreeToPanel(form.expDictionaryTree);
            form.expDictionaryTree.build(jsObject.options.report.dictionary, true);
            form.expDictionaryTree.currentEditor = textArea;
        }
        if (form.resultControl) {
            var resultControl = form.resultControl;
            var resultTextBox = form.resultControl.textBox || resultControl;

            textArea.value = resultTextBox.useHiddenValue ? resultTextBox.hiddenValue : resultTextBox.value;
            textArea.cutBrackets = resultControl.cutBrackets;
            textArea.showCheckButton = resultControl.showCheckButton;

            var samples = resultControl.samples || (resultControl.cutBrackets ? ["DataSource.Field"] : ["{DataSource.Field}"]);

            jsObject.AddHintHelperToControl(textArea, resultControl.samples ? resultControl.samplesHeight : 40, resultControl.showCheckButton, resultControl.cutBrackets, samples, resultControl.sampleLabelText);
        }
        textArea.focus();
    }

    form.action = function () {
        if (form.resultControl) {
            var resultTextBox = form.resultControl.textBox || form.resultControl;
            resultTextBox.value = textArea.value;
            if (resultTextBox.readOnly && resultTextBox.useHiddenValue) resultTextBox.hiddenValue = textArea.value;
            if (form.resultControl.action) form.resultControl.action();
        }
        form.changeVisibleState(false);
    }

    return form;
}