﻿
StiMobileDesigner.prototype.InitializeExportSettingsForm_ = function () {
    var form = this.BaseFormPanel("exportSettingsForm", this.loc.PropertyMain.ExportSettings, 1);
    form.mode = "Report";
    form.controls = {};
    var jsObject = this;

    var hideExportsCheckBox = this.CheckBox(null, this.loc.Report.HideUnlistedExportsInTheViewer);
    hideExportsCheckBox.style.margin = "12px";

    var footerTable = this.CreateHTMLTable();
    footerTable.style.width = "100%";
    var buttonsPanel = form.buttonsPanel;
    form.removeChild(buttonsPanel);
    form.appendChild(footerTable);
    footerTable.addCell(hideExportsCheckBox).style.textAlign = "left";
    footerTable.addCell();
    footerTable.addCell(form.buttonOk).style.width = "1px";
    footerTable.addCell(form.buttonCancel).style.width = "1px";
        
    //Main Table
    var mainTable = this.CreateHTMLTable();
    mainTable.className = "stiDesignerImageFormMainPanel";
    form.container.appendChild(mainTable);
    form.container.style.padding = "0px";

    //Buttons
    var buttonProps = [
        ["Report", "PreviewSettingsForm.StiPage.png", this.loc.Components.StiReport],
        ["Dashboard", "PreviewSettingsForm.StiDashboard.png", this.loc.Components.StiDashboard]
    ];

    //Add Panels && Buttons
    var buttonsPanel = mainTable.addCell();
    var panelsContainer = mainTable.addCell();
    buttonsPanel.style.verticalAlign = "top";
    buttonsPanel.style.paddingTop = "6px";
    form.mainButtons = {};
    form.panels = {};

    for (var i = 0; i < buttonProps.length; i++) {
        var panel = document.createElement("Div");
        panel.className = "stiDesignerEditFormPanel";
        panel.style.width = panel.style.height = "auto";
        if (i != 0) panel.style.display = "none";
        panelsContainer.appendChild(panel);
        form.panels[buttonProps[i][0]] = panel;

        var button = this.FormTabPanelButton(null, buttonProps[i][2], buttonProps[i][1], buttonProps[i][2], null, { width: 24, height: 24 }, 34);
        form.mainButtons[buttonProps[i][0]] = button;
        buttonsPanel.appendChild(button);

        button.panelName = buttonProps[i][0];

        button.action = function () {
            form.setMode(this.panelName);
            form.propertiesPanel.updateControls();
        }

        //add marker
        var marker = document.createElement("div");
        marker.style.display = "none";
        marker.className = "stiUsingMarker";
        var markerInner = document.createElement("div");
        marker.appendChild(markerInner);
        button.style.position = "relative";
        button.appendChild(marker);
        button.marker = marker;
    }

    //Report
    var repToolbar = this.CreateHTMLTable();
    repToolbar.style.margin = "12px";
    form.panels.Report.appendChild(repToolbar);

    var repAddButton = this.FormButton(null, null, this.loc.Buttons.Add, null, null, null, null, null, "Down");
    var repOpenButton = this.SmallButton(null, null, null, "Open.png", this.loc.Buttons.Open);
    var repSaveButton = this.SmallButton(null, null, null, "Save.png", this.loc.Buttons.Save);
    repToolbar.addCell(repAddButton);
    repToolbar.addCell(repOpenButton).style.paddingLeft = "4px";
    repToolbar.addCell(repSaveButton).style.paddingLeft = "4px";

    repOpenButton.action = function () {
        form.loadExportSettings();
    }

    repSaveButton.action = function () {
        form.downloadExportSettings();
    }

    var repMenu = this.VerticalMenu("reportExportSettings", repAddButton, "Down", this.GetReportExportSettingsItems());

    repAddButton.action = function () {
        repMenu.changeVisibleState(!repMenu.visible);
    }

    var repContainerPanel = this.ExportSettingsContainerPanel(form);
    var repContainer = repContainerPanel.container;
    repContainerPanel.style.margin = "12px 12px 0 12px";
    form.panels.Report.appendChild(repContainerPanel);

    repMenu.action = function (menuItem) {
        repMenu.changeVisibleState(false);
        repContainer.createNewItem(false, menuItem.key);
    }

    //Dashboard
    var dbsToolbar = this.CreateHTMLTable();
    dbsToolbar.style.margin = "12px";
    form.panels.Dashboard.appendChild(dbsToolbar);

    var dbsAddButton = this.FormButton(null, null, this.loc.Buttons.Add, null, null, null, null, null, "Down");
    var dbsOpenButton = this.SmallButton(null, null, null, "Open.png", this.loc.Buttons.Open);
    var dbsSaveButton = this.SmallButton(null, null, null, "Save.png", this.loc.Buttons.Save);
    dbsToolbar.addCell(dbsAddButton);
    dbsToolbar.addCell(dbsOpenButton).style.paddingLeft = "4px";
    dbsToolbar.addCell(dbsSaveButton).style.paddingLeft = "4px";

    dbsOpenButton.action = function () {
        form.loadExportSettings();
    }

    dbsSaveButton.action = function () {
        form.downloadExportSettings();
    }

    var dbsMenu = this.VerticalMenu("dbsExportSettings", dbsAddButton, "Down", this.GetDbsExportSettingsItems());

    dbsAddButton.action = function () {
        dbsMenu.changeVisibleState(!dbsMenu.visible);
    }

    var dbsContainerPanel = this.ExportSettingsContainerPanel(form);
    var dbsContainer = dbsContainerPanel.container;
    dbsContainerPanel.style.margin = "12px 12px 0 12px";
    form.panels.Dashboard.appendChild(dbsContainerPanel);

    dbsMenu.action = function (menuItem) {
        dbsMenu.changeVisibleState(false);
        dbsContainer.createNewItem(true, menuItem.key);
    }

    //PropertiesPanel
    form.propertiesPanel = this.ExportSettingsFormPropertiesPanel(form);
    var exportSettingsPropertiesPanel = this.options.propertiesPanel.exportSettingsPropertiesPanel;
    while (exportSettingsPropertiesPanel.childNodes[0]) exportSettingsPropertiesPanel.removeChild(exportSettingsPropertiesPanel.childNodes[0]);
    this.options.propertiesPanel.exportSettingsPropertiesPanel.appendChild(form.propertiesPanel);

    //Form
    form.updateMarkers = function () {
        form.mainButtons.Report.marker.style.display = repContainer.getItemObjects().length > 0 ? "" : "none";
        form.mainButtons.Dashboard.marker.style.display = dbsContainer.getItemObjects().length > 0 ? "" : "none";
    }

    form.getSelectedItem = function () {
        return (this.mode == "Report" ? repContainer.selectedItem : dbsContainer.selectedItem);
    }

    form.updateMenuItems = function () {
        var updateItems = function (menu, container) {
            for (var name in menu.items) {
                var item = menu.items[name];
                if (item["setEnabled"]) {
                    item.setEnabled(container.getItemByName(name) == null);
                }
            }
        }
        updateItems(repMenu, repContainer);
        updateItems(dbsMenu, dbsContainer);
    }

    form.loadExportSettings = function () {
        if (jsObject.options.canOpenFiles) {
            jsObject.InitializeOpenDialog("loadExportSettingsFromFile", jsObject.StiHandleOpenExportSettings, ".json");
            jsObject.options.openDialogs.loadExportSettingsFromFile.action();
        }
    }

    form.downloadExportSettings = function () {
        jsObject.SendCommandDownloadExportSettings(form.getExportSettings());
    }

    form.setMode = function (mode) {
        form.mode = mode;
        for (var panelName in form.panels) {
            form.panels[panelName].style.display = mode == panelName ? "" : "none";
            form.mainButtons[panelName].setSelected(mode == panelName);
        }
        if (mode == "Report" && repContainer.getCountItems() > 0 && !repContainer.selectedItem) {
            repContainer.childNodes[0].action();
        }
        else if (mode == "Dashboard" && dbsContainer.getCountItems() > 0 && !dbsContainer.selectedItem) {
            dbsContainer.childNodes[0].action();
        }
    }

    form.onhide = function () {
        jsObject.options.propertiesPanel.setExportSettingsMode(false);
        clearTimeout(form.markerTimer);
    }

    form.getExportSettings = function () {
        var settings = repContainer.getItemObjects();
        settings = settings.concat(dbsContainer.getItemObjects());

        return settings;
    }

    form.fillContainers = function (exportSettings) {
        repContainer.clear();
        dbsContainer.clear();

        repContainer.addItems(exportSettings.Report);
        dbsContainer.addItems(exportSettings.Dashboard);

        form.updateMenuItems();
    }

    form.show = function () {
        form.changeVisibleState(true);
        form.mainButtons.Dashboard.style.display = jsObject.options.dashboardAssemblyLoaded ? "" : "none";
        jsObject.options.propertiesPanel.setExportSettingsMode(true);

        if (jsObject.options.report) {
            var exportSettings = jsObject.CopyObject(jsObject.options.report.properties.exportSettings);
            form.fillContainers(exportSettings);
            hideExportsCheckBox.setChecked(exportSettings.hideExports);
        }

        form.setMode("Report");

        form.updateMarkers();
        form.markerTimer = setInterval(function () {
            form.updateMarkers();
        }, 250)
    }

    form.action = function () {
        form.changeVisibleState(false);
        jsObject.SendCommandToDesignerServer("SaveExportSettings", { exportSettings: form.getExportSettings(), hideExports: hideExportsCheckBox.isChecked }, function (answer) {
            if (answer.exportSettings) {
                jsObject.options.report.properties.exportSettings = answer.exportSettings;
                jsObject.UpdatePropertiesControls();
            }
        });
    }

    return form;
}

StiMobileDesigner.prototype.ExportSettingsContainerPanel = function (exportSettingsForm) {
    var jsObject = this;
    var containerPanel = document.createElement("div");
    containerPanel.style.position = "relative";
    var container = containerPanel.container = this.EasyContainer(400, 400, true, true);
    containerPanel.appendChild(container);

    var emptyText = document.createElement("div");
    emptyText.className = "stiCreateDataHintText";
    emptyText.style.position = "absolute";
    emptyText.style.width = "100%";
    emptyText.style.top = "50%";
    emptyText.style.textAlign = "center";
    emptyText.style.display = "none";
    emptyText.innerHTML = jsObject.loc.PropertyMain.NoElements;
    containerPanel.appendChild(emptyText);

    container.createNewItem = function (isDashboard, exportFormat) {
        jsObject.SendCommandToDesignerServer("AddExportSettingsItem", { isDashboard: isDashboard, exportFormat: exportFormat }, function (answer) {
            if (answer.itemObject) {
                var itemObject = JSON.parse(answer.itemObject);
                var item = container.addItem(itemObject.exportFormat, itemObject, container.getCaptionFromExportFormat(itemObject.exportFormat), "ExportSettings." + itemObject.exportFormat + ".png");
                item.action();
            }
        });
    }

    container.addItems = function (itemObjects) {
        if (itemObjects) {
            for (var i = 0; i < itemObjects.length; i++) {
                var itemObject = JSON.parse(itemObjects[i]);
                container.addItem(itemObject.exportFormat, itemObject, container.getCaptionFromExportFormat(itemObject.exportFormat), "ExportSettings." + itemObject.exportFormat + ".png", true);
            }
        }
        container.updateEmptyText();
    }

    container.getCaptionFromExportFormat = function (exportFormat) {
        switch (exportFormat) {
            case "Pdf": return "Adobe PDF";
            case "Xps": return "Microsoft XPS";
            case "PowerPoint": return "Microsoft PowerPoint";
            case "Html": return "HTML";
            case "Excel": return "Microsoft Excel";
            case "Ods": return "OpenDocument Calc";
            case "Text": return "Text";
            case "Rtf": return "RTF";
            case "Word": return "Microsoft Word";
            case "Odt": return "OpenDocument Writer";
            case "Data": return "Data";
            case "Image": return "Image";
        }
    }

    container.getItemObjects = function () {
        var itemObjects = [];

        for (var i = 0; i < container.childNodes.length; i++) {
            itemObjects.push(container.childNodes[i].itemObject);
        }
        return itemObjects;
    }

    container.updateEmptyText = function () {
        emptyText.style.display = container.getCountItems() > 0 ? "none" : "";
    }

    container.onAction = function (action) {
        if (action == "action" || action == "add" || action == "remove") {
            exportSettingsForm.propertiesPanel.updateControls();

            if (action != "action") {
                exportSettingsForm.updateMenuItems();
            }
        }
        container.updateEmptyText();
    }


    return containerPanel;
}

StiMobileDesigner.prototype.ExportSettingsFormPropertiesPanel = function (exportSettingsForm) {
    var propertiesPanel = document.createElement("div");
    propertiesPanel.className = "stiDesignerExportSettingsFormPropertiesPanel";
    propertiesPanel.propertiesGroups = {};
    var jsObject = this;

    //Add Properties Groups
    var propertiesGroups = [
        ["common", "Common", 1],
        ["pageranges", "Page Ranges", 2],
        ["images", "Images", 1],
        ["security", "Security", 1],
        ["digitalSignature", "Digital Signature", 1],
        ["complianceMode", "Compliance Mode", 1]
    ];

    for (var i = 0; i < propertiesGroups.length; i++) {
        var propertiesGroup = this.PropertiesGroup(propertiesGroups[i][0] + "ExportSettings", propertiesGroups[i][1], null, propertiesGroups[i][2]);
        propertiesGroup.style.display = "none";
        propertiesPanel.propertiesGroups[propertiesGroups[i][0]] = propertiesGroup;
        propertiesPanel.appendChild(propertiesGroup);

        if (propertiesGroups[i][2] == 1) {
            propertiesGroup.changeOpenedState(true);
        }
    }

    //Add Properties Controls
    propertiesPanel.properties_ = {};

    var propAttributes = [
        ["AllowEditable", "Allow Editable", this.PropertyDropDownList("exportFormAllowEditable", this.options.propertyControlWidth, this.GetAllowEditableItems(), true, false), "common"],
        ["ApplyDefaultFilters", "Apply Default Filters", this.CheckBox("exportFormApplyDefaultFilters"), "common"],
        ["AutoPrint", "Auto Print", this.CheckBox("exportFormAutoPrint"), "common"],
        ["AutoPrintMode", "Auto Print Mode", this.PropertyDropDownList("exportFormAutoPrintMode", this.options.propertyControlWidth, this.GetAutoPrintModeItems(), true, false), "common"],
        ["AddPageBreaks", "Add Page Breaks", this.CheckBox("exportFormAddPageBreaks"), "common"],
        ["BorderType", "Border Type", this.PropertyDropDownList("exportFormBorderType", this.options.propertyControlWidth, this.GetBorderTypeItems(), true, false), "common"],
        ["BookmarksTreeWidth", "Bookmarks Tree Width", this.PropertyTextBox("exportFormBookmarksTreeWidth", this.options.propertyControlWidth), "common"],
        ["ChartType", "Chart Type", this.PropertyDropDownList("exportFormChartType", this.options.propertyControlWidth, this.GetChartTypeItems(), true, false), "common"],
        ["CodePage", "Code Page", this.PropertyTextBox("exportFormCodePage", this.options.propertyControlWidth), "common"],
        ["CompanyString", "Company String", this.PropertyTextBox("exportFormCompanyString", this.options.propertyControlWidth), "common"],
        ["Compressed", "Compressed", this.CheckBox("exportFormCompressed"), "common"],
        ["CompressToArchive", "Compress To Archive", this.CheckBox("exportFormCompressToArchive"), "common"],
        ["ContinuousPages", "Continuous Pages", this.CheckBox("exportFormContinuousPages"), "common"],
        ["CutEdges", "Cut Edges", this.CheckBox("exportFormCutEdges"), "common"],
        ["CutLongLines", "Cut Long Lines", this.CheckBox("exportFormCutLongLines"), "common"],
        ["CssClass", "Css Class", this.PropertyTextBox("exportFormCssClass", this.options.propertyControlWidth), "common"],
        ["CreatorString", "Creator String", this.PropertyTextBox("exportFormCreatorString", this.options.propertyControlWidth), "common"],
        ["DataType", "Data Type", this.PropertyDropDownList("exportFormDataType", this.options.propertyControlWidth, this.GetDataTypesItems(), true, false), "common"],
        ["DrawBorder", "Draw Border", this.CheckBox("exportFormDrawBorder"), "common"],
        ["EnableAnimation", "Enable Animation", this.CheckBox("exportFormEnableAnimation"), "common"],
        ["EmbeddedFonts", "Embedded Fonts", this.CheckBox("exportFormEmbeddedFonts"), "common"],
        ["ExportBookmarksMode", "Export Bookmarks Mode", this.PropertyDropDownList("exportFormExportBookmarksMode", this.options.propertyControlWidth, this.GetExportBookmarksModeItems(), true, false), "common"],
        ["ExportDataOnly", "Export Data Only", this.CheckBox("exportFormExportDataOnly"), "common"],
        ["ExportEachPageToSheet", "Export Each Page To Sheet", this.CheckBox("exportFormExportEachPageToSheet"), "common"],
        ["ExportObjectFormatting", "Export Object Formatting", this.CheckBox("exportFormExportObjectFormatting"), "common"],
        ["ExportPageBreaks", "Export Page Breaks", this.CheckBox("exportFormExportPageBreaks"), "common"],
        ["ExportModeHtml", "Export Mode", this.PropertyDropDownList("exportFormExportModeHtml", this.options.propertyControlWidth, this.GetExportModeHtmlItems(), true, false), "common"],
        ["ExportModeRtf", "Export Mode", this.PropertyDropDownList("exportFormExportModeRtf", this.options.propertyControlWidth, this.GetExportModeRtfItems(), true, false), "common"],
        ["ExportQuality", "Export Quality", this.PropertyDropDownList("exportFormExportQuality", this.options.propertyControlWidth, this.GetExportQualityItems(), true, false), "common"],
        ["DataExportMode", "Data Export Mode", this.PropertyDropDownList("exportFormExportModeData", this.options.propertyControlWidth, this.GetExportModeDataItems(), true, false), "common"],
        ["KeywordsString", "Keywords String", this.PropertyTextBox("exportFormKeywordsString", this.options.propertyControlWidth), "common"],
        ["KillSpaceGraphLines", "Kill Space Graph Lines", this.CheckBox("exportFormKillSpaceGraphLines"), "common"],
        ["KillSpaceLines", "Kill Space Lines", this.CheckBox("exportFormKillSpaceLines"), "common"],
        ["LastModifiedString", "Last Modified String", this.PropertyTextBox("exportFormLastModifiedString", this.options.propertyControlWidth), "common"],
        ["MultipleFiles", "Multiple Files", this.CheckBox("exportFormMultipleFiles"), "common"],
        ["OpenAfterExport", "Open After Export", this.CheckBox("exportFormOpenAfterExport"), "common"],
        ["PageHorAlignment", "Page HorAlignment", this.PropertyDropDownList("exportFormPageHorAlignment", this.options.propertyControlWidth, this.GetPageHorAlignmentItems(), true, false), "common"],
        ["PaperSize", "Paper Size", this.PropertyDropDownList("exportFormPaperSize", this.options.propertyControlWidth, this.GetDbsExportPaperSizesItems(), true, false), "common"],
        ["PutFeedPageCode", "Put Feed Page Code", this.CheckBox("exportFormPutFeedPageCode"), "common"],
        ["OpenLinksTarget", "Open Links Target", this.PropertyTextBox("exportFormOpenLinksTarget", this.options.propertyControlWidth), "common"],
        ["Orientation", "Orientation", this.PropertyDropDownList("exportFormOrientation", this.options.propertyControlWidth, this.GetOrientationItems(), true, false), "common"],
        ["RenderBorders", "Render Borders", this.CheckBox("exportFormRenderBorders"), "common"],
        ["RenderSingleElement", "Render Single Element", this.CheckBox("exportFormRenderSingleElement"), "common"],
        ["RenderSinglePage", "Render Single Page", this.CheckBox("exportFormRenderSinglePage"), "common"],
        ["RemoveEmptySpaceAtBottom", "Remove Empty Space At Bottom", this.CheckBox("exportFormRemoveEmptySpaceAtBottom"), "common"],
        ["PageRangeType", "Page Range Type", this.PropertyDropDownList("exportFormPageRangeType", this.options.propertyControlWidth, this.GetPageRangeTypeItems(), true, false), "pageranges", 2],
        ["CurrentPage", "Current Page", this.PropertyTextBox("exportFormCurrentPage", this.options.propertyControlWidth), "pageranges", 2],
        ["PageRanges", "Page Ranges", this.PropertyTextBox("exportFormPageRanges", this.options.propertyControlWidth), "pageranges", 2],
        ["Separator", "Separator", this.PropertyTextBox("exportFormSeparator", this.options.propertyControlWidth), "common"],
        ["Scale", "Scale", this.PropertyTextBox("exportFormScale", this.options.propertyControlWidth), "common"],
        ["ScaleMode", "Scale Mode", this.PropertyDropDownList("exportFormScaleMode", this.options.propertyControlWidth, this.GetScaleModeItems(), true, false), "common"],
        ["SkipColumnHeaders", "Skip Column Headers", this.CheckBox("exportFormSkipColumnHeaders"), "common"],
        ["SubjectNameString", "Subject Name String", this.PropertyTextBox("exportFormSubjectNameString", this.options.propertyControlWidth), "common"],
        ["TableName", "Table Name", this.PropertyTextBox("exportFormTableName", this.options.propertyControlWidth), "common"],
        ["UseDefaultSystemEncoding", "Use Default System Encoding", this.CheckBox("exportFormUseDefaultSystemEncoding"), "common"],
        ["UseOnePageHeaderAndFooter", "Use One Page Header And Footer", this.CheckBox("exportFormUseOnePageHeaderAndFooter"), "common"],
        ["UsePageHeadersAndFooters", "Use Page Headers And Footers", this.CheckBox("exportFormUsePageHeadersAndFooters"), "common"],
        ["UseUnicode", "Use Unicode", this.CheckBox("exportFormUseUnicode"), "common"],
        ["UseStylesTable", "Use Styles Table", this.CheckBox("exportFormUseStylesTable"), "common"],
        ["UseEscapeCodes", "Use Escape Codes", this.CheckBox("exportFormUseEscapeCodes"), "common"],
        ["Zoom", "Zoom", this.PropertyTextBox("exportFormZoom", this.options.propertyControlWidth), "common"],
        ["ZoomX", "Zoom X", this.PropertyTextBox("exportFormZoomX", this.options.propertyControlWidth), "common"],
        ["ZoomY", "Zoom Y", this.PropertyTextBox("exportFormZoomY", this.options.propertyControlWidth), "common"],
        ["DitheringType", "Dithering Type", this.PropertyDropDownList("exportFormDitheringType", this.options.propertyControlWidth, this.GetMonochromeDitheringTypeItems(), true, false), "images"],
        ["ExportRtfTextAsImage", "Export Rtf Text As Image", this.CheckBox("exportFormExportRtfTextAsImage"), "images"],
        ["ImageCompressionMethod", "Image Compression Method", this.PropertyDropDownList("exportFormImageCompressionMethod", this.options.propertyControlWidth, this.GetImageCompressionMethodItems(), true, false), "images"],
        ["ImageFormat", "Image Format", this.PropertyDropDownList("exportFormImageFormat", this.options.propertyControlWidth, this.GetImageFormatItems(), true, false), "images"],
        ["ImageFormatMS", "Image Format", this.PropertyDropDownList("exportFormImageFormatExcel", this.options.propertyControlWidth, this.GetMSImageFormatItems(), true, false), "images"],
        ["ImageIndexedColorPaletteSize", "Image Indexed Color Palette Size", this.PropertyTextBox("exportFormImageIndexedColorPaletteSize", this.options.propertyControlWidth), "images"],
        ["ImageQuality", "Image Quality", this.PropertyTextBox("exportFormImageQuality", this.options.propertyControlWidth), "images"],
        ["ImageResolution", "Image Resolution", this.PropertyTextBox("exportFormImageResolution", this.options.propertyControlWidth), "images"],
        ["ImageResolutionMode", "Image Resolution Mode", this.PropertyDropDownList("exportFormImageResolutionMode", this.options.propertyControlWidth, this.GetImageResolutionModeItems(), true, false), "images"],
        ["ImageType", "Image Type", this.PropertyDropDownList("exportFormImageType", this.options.propertyControlWidth, this.GetImageTypesItems(), true, false), "images"],
        ["ImageZoom", "Image Zoom", this.PropertyTextBox("exportFormImageZoom", this.options.propertyControlWidth), "images"],
        ["StoreImagesAsPng", "Store Images As Png", this.CheckBox("exportFormStoreImagesAsPng"), "images"],
        ["TiffCompressionScheme", "Tiff Compression Scheme", this.PropertyDropDownList("exportFormTiffCompressionScheme", this.options.propertyControlWidth, this.GetTiffCompressionSchemeItems(), true, false), "images"],
        ["UseEmbeddedImages", "Use Embedded Images", this.CheckBox("exportFormUseEmbeddedImages"), "images"],
        ["EncryptionPassword", "Encryption Password", this.PropertyTextBox("exportFormEncryptionPassword", this.options.propertyControlWidth), "security"],
        ["KeyLength", "Key Length", this.PropertyDropDownList("exportFormKeyLength", this.options.propertyControlWidth, this.GetEncryptionKeyLengthItems(), true, false), "security"],
        ["PasswordInputOwner", "Password Input Owner", this.PropertyTextBox("exportFormPasswordInputOwner", this.options.propertyControlWidth), "security"],
        ["PasswordInputUser", "Password Input User", this.PropertyTextBox("exportFormPasswordInputUser", this.options.propertyControlWidth), "security"],
        ["ProtectionPassword", "Protection Password", this.PropertyTextBox("exportFormProtectionPassword", this.options.propertyControlWidth), "security"],
        ["RestrictEditing", "Restrict Editing", this.PropertyDropDownList("exportFormRestrictEditing", this.options.propertyControlWidth, this.GetRestrictEditingItems(), true, false), "security"],
        ["UserAccessPriveleges", "User Access Priveleges", this.PropertyDropDownList("exportFormUserAccessPriveleges", this.options.propertyControlWidth, this.GetUserAccessPrivelegesItems(), true, false), "security"],
        ["CertificatePassword", "Certificate Password", this.PropertyTextBox("exportFormCertificatePassword", this.options.propertyControlWidth), "digitalSignature"],
        ["DigitalSignatureContactInfo", "Digital Signature Contact Info", this.PropertyTextBox("exportFormDigitalSignatureContactInfo", this.options.propertyControlWidth), "digitalSignature"],
        ["DigitalSignatureLocation", "Digital Signature Location", this.PropertyTextBox("exportFormDigitalSignatureLocation", this.options.propertyControlWidth), "digitalSignature"],
        ["DigitalSignatureReason", "Digital Signature Reason", this.PropertyTextBox("exportFormDigitalSignatureReason", this.options.propertyControlWidth), "digitalSignature"],
        ["DigitalSignatureSignedBy", "Digital Signature Signed By", this.PropertyTextBox("exportFormDigitalSignatureSignedBy", this.options.propertyControlWidth), "digitalSignature"],
        ["GetCertificateFromCryptoUI", "Get Certificate From Crypto UI", this.CheckBox("exportFormGetCertificateFromCryptoUI"), "digitalSignature"],
        ["UseDigitalSignature", "Use Digital Signature", this.CheckBox("exportFormUseDigitalSignature"), "digitalSignature"],
        ["UseLocalMachineCertificates", "Use Local Machine Certificates", this.CheckBox("exportFormUseLocalMachineCertificates"), "digitalSignature"],
        ["PdfComplianceMode", "Pdf Compliance Mode", this.PropertyDropDownList("exportFormPdfComplianceMode", this.options.propertyControlWidth, this.GetPdfComplianceModeItems(), true, false), "complianceMode"],
        ["ZUGFeRDComplianceMode", "ZUGFeRD Compliance Mode", this.PropertyDropDownList("exportFormZUGFeRDComplianceMode", this.options.propertyControlWidth, this.GetZUGFeRDComplianceModeItems(), true, false), "complianceMode"],
        ["ZUGFeRDConformanceLevel", "ZUGFeRD Conformance Level", this.PropertyTextBox("exportFormZUGFeRDConformanceLevel", this.options.propertyControlWidth), "complianceMode"]
    ]

    for (var i = 0; i < propAttributes.length; i++) {
        var control = propAttributes[i][2];
        var property = this.Property(null, propAttributes[i][1], control, null, propAttributes[i].length > 4 ? propAttributes[i][4] : 1);
        property.name = propAttributes[i][0];
        property.updateCaption();
        propertiesPanel.propertiesGroups[propAttributes[i][3]].container.appendChild(property);
        propertiesPanel.properties_[propAttributes[i][0]] = property;
        control.propertyName = propAttributes[i][0];
        control.groupName = propAttributes[i][3];

        control.action = function () {
            var selectedItem = exportSettingsForm.getSelectedItem();
            if (!selectedItem) return;

            var exportProperties = selectedItem.itemObject;
            if (!exportProperties) return;

            var propertyName = this.propertyName;

            if (propertyName == "ExportModeRtf" || propertyName == "ExportModeHtml") {
                propertyName = "ExportMode";
            }
            else if (propertyName == "ImageFormatMS") {
                propertyName = "ImageFormat";
            }
            else if (propertyName == "CurrentPage" || propertyName == "PageRanges") {
                propertyName = "PageRange";
            }
            else if (propertyName == "PageRangeType") {
                propertiesPanel.properties_.CurrentPage.style.display = this.key == "CurrentPage" ? "" : "none";
                propertiesPanel.properties_.PageRanges.style.display = this.key == "Pages" ? "" : "none";

                if (this.key == "All") exportProperties.PageRange = "All"
                else if (this.key == "CurrentPage") exportProperties.PageRange = propertiesPanel.properties_.CurrentPage.propertyControl.value;
                else if (this.key == "Pages") exportProperties.PageRange = propertiesPanel.properties_.PageRanges.propertyControl.value;
                return;
            }

            if (this["setKey"] != null) exportProperties[propertyName] = this.key;
            else if (this["getValue"] != null) exportProperties[propertyName] = this.getValue();
            else if (this["setChecked"] != null) exportProperties[propertyName] = this.isChecked ? "True" : "False";
            else if (this["value"] != null) exportProperties[propertyName] = this.value;
            else if (this["textBox"] != null && this.textBox["value"] != null) exportProperties[propertyName] = this.textBox.value;
        }
    }

    propertiesPanel.propertiesGroups.common.container.appendChild(propertiesPanel.propertiesGroups.pageranges);

    propertiesPanel.updatePropertiesCaptions = function () {
        for (var propertyName in this.properties_) {
            this.properties_[propertyName].updateCaption();
        }
    }

    propertiesPanel.updateControls = function () {
        var selectedItem = exportSettingsForm.getSelectedItem();
        var propertyValues = selectedItem ? selectedItem.itemObject : null;

        if (!propertyValues) propertyValues = {};
        var propertyRows = this.properties_;

        var exportFormat = propertyValues.exportFormat;

        for (var i = 0; i < propertiesGroups.length; i++) {
            propertiesPanel.propertiesGroups[propertiesGroups[i][0]].style.display = "none";
        }

        for (var name in propertyRows) {
            var originPropName = name;

            if ((name == "ExportModeRtf" && exportFormat == "Rtf") || (name == "ExportModeHtml" && exportFormat == "Html")) {
                originPropName = "ExportMode";
            }
            else if (name == "ImageFormatMS" && (exportFormat == "Excel" || exportFormat == "PowerPoint" || exportFormat == "Html" || exportFormat == "Odc" || exportFormat == "Word" || exportFormat == "Ods")) {
                originPropName = "ImageFormat";
            }
            else if (name == "PageRangeType" || name == "CurrentPage" || name == "PageRanges") {
                originPropName = "PageRange";
            }

            var existsProperty = typeof propertyValues[originPropName] != "undefined";

            propertyRows[name].style.display = existsProperty ? "" : "none";

            if (existsProperty) {
                var propertyValue = propertyValues[originPropName];
                var propertyControl = propertyRows[name].propertyControl;

                if (!propertyControl) continue;

                if (propertiesPanel.propertiesGroups[propertyControl.groupName]) {
                    propertiesPanel.propertiesGroups[propertyControl.groupName].style.display = "";
                }

                if (name == "PageRangeType" || name == "CurrentPage" || name == "PageRanges") {
                    var rangeType;
                    if (propertyValue == "All") rangeType = "All";
                    else if (!isNaN(parseInt(propertyValue)) && parseInt(propertyValue).toString() == propertyValue) rangeType = "CurrentPage";
                    else rangeType = "Pages";

                    if (name == "PageRangeType") {
                        propertyValue = rangeType;
                    }
                    if (name == "CurrentPage") {
                        propertyRows["CurrentPage"].style.display = rangeType == "CurrentPage" ? "" : "none";
                        if (rangeType != "CurrentPage") propertyValue = "0";
                    }
                    if (name == "PageRanges") {
                        propertyRows["PageRanges"].style.display = rangeType == "Pages" ? "" : "none";
                        if (rangeType != "Pages") propertyValue = "";
                    }
                }

                if (propertyControl["setKey"] != null) {
                    propertyControl.setKey(propertyValue);
                }
                else if (propertyControl["setValue"] != null) {
                    propertyControl.setValue(propertyValue);
                }
                else if (propertyControl["setChecked"] != null) {
                    propertyControl.setChecked(propertyValue);
                }
                else if (propertyControl["value"] != null) {
                    propertyControl.value = propertyValue;
                }
                else if (propertyControl["textBox"] != null && propertyControl.textBox["value"] != null) {
                    propertyControl.textBox.value = propertyValue;
                }
            }
        }
    }

    return propertiesPanel;
}