﻿
StiMobileDesigner.prototype.SingleLineRibbonButton = function (name, groupName, caption, imageName, toolTip, arrow, style, allwaysEnabled, imageSizes, captionAllowHtml, addMarker) {
    var button = this.SmallButton(name, groupName, caption, imageName, toolTip, arrow, style, allwaysEnabled, imageSizes, captionAllowHtml);
    button.style.height = "28px";

    if (button.imageCell) {
        button.imageCell.style.padding = (this.options.isTouchDevice && caption == null) ? "0 7px 0 7px" : (button.arrowCell ? "0 4px 0 6px" : "0 6px 0 6px");
    }

    if (button.arrowCell) {
        button.arrowCell.style.padding = caption ? (this.options.isTouchDevice ? "0 7px 0 7px" : "0 6px 0 4px") : (this.options.isTouchDevice ? "0 6px 0 0" : "0 6px 0 1px");
    }

    if (addMarker) {
        var marker = document.createElement("div");
        marker.style.display = "none";
        marker.style.width = marker.style.height = "6px";
        marker.className = "stiUsingMarker";
        marker.style.top = "calc(50% + 8px)";
        marker.style.right = "calc(50% - 3px)";

        var markerInner = document.createElement("div");
        markerInner.style.width = markerInner.style.height = "4px";
        markerInner.style.margin = "1px 0 0 1px";
        marker.appendChild(markerInner);

        button.style.position = "relative";
        button.appendChild(marker);
        button.marker = marker;

        button.setMarkerVisibleState = function (state) {
            marker.style.display = state ? "" : "none";
        }
    }

    return button;
}