﻿
//HyperlinkTextBox Control
StiMobileDesigner.prototype.HyperlinkTextBoxControl = function (name, width, height, readOnly, hyperlinkSamplePattern) {
    var jsObject = this;
    var control = this.TextBoxWithEditButton(name, width, height, readOnly, true);

    if (hyperlinkSamplePattern) {
        control.textBox.setAttribute("placeholder", hyperlinkSamplePattern);
    }

    control.button.action = function () {
        control.preOpening();

        jsObject.InitializeHyperlinkEditorForm(function (form) {
            form.show(control);

            form.action = function () {
                form.changeVisibleState(false);
                control.textBox.value = form.textArea.value;
                control.action();
            }
        });
    }

    control.preOpening = function () { };

    return control;
}

//HyperlinkTextBox Control
StiMobileDesigner.prototype.HyperlinkControlWithMenu = function (name, width, items, readOnly, hyperlinkSamplePattern) {
    var jsObject = this;

    var control = this.DropDownList(name, width, null, items, readOnly, false, null, false, null, true);
    control.cutBrackets = true;

    if (hyperlinkSamplePattern) {
        control.textBox.setAttribute("placeholder", hyperlinkSamplePattern);
    }

    control.menu.action = function (menuItem) {
        this.changeVisibleState(false);
        control.key = menuItem.key;
        control.textBox.value = "{" + menuItem.key + "}";
        control.action();
    }

    control.menu.onshow = function () { }

    control.editButton.action = function () {
        control.preOpening();

        jsObject.InitializeHyperlinkEditorForm(function (form) {
            form.show(control);

            form.action = function () {
                form.changeVisibleState(false);
                control.textBox.value = form.textArea.value;
                control.action();
            }
        });
    }

    control.preOpening = function () { };

    return control;
}

