﻿
StiMobileDesigner.prototype.GoogleDriveTree = function (ownerForm) {
    var tree = document.createElement("div");
    var jsObject = tree.jsObject = this;
    tree.style.position = "absolute";
    tree.style.top = tree.style.bottom = tree.style.left = tree.style.right = "0px";
    tree.selectedItem = null;
    tree.returnItems = {};
    tree.ownerForm = ownerForm;
    tree.sortType = "Name";
    tree.sortDirection = "Ascending";

    //Navigate Panel
    var navigatePanel = tree.navigatePanel = document.createElement("div");
    tree.appendChild(navigatePanel);

    navigatePanel.update = function (fullPathItems) {
        while (this.childNodes[0]) this.removeChild(this.childNodes[0]);
                
        var innerTable = jsObject.CreateHTMLTable();
        navigatePanel.appendChild(innerTable);

        var backButton = jsObject.SmallButton(null, null, null, "Arrows.ArrowUpBlack.png", jsObject.loc.RecentFiles.SelectToNavigateUpOneLevel);
        innerTable.addCell(backButton);

        backButton.action = function () {
            if (fullPathItems.length > 1) {
                navigatePanel.action(fullPathItems[fullPathItems.length - 2].id);
            }
        }

        backButton.setEnabled(fullPathItems && fullPathItems.length > 1);

        if (fullPathItems) {
            for (var i = 0; i < fullPathItems.length; i++) {
                var navButton = jsObject.SmallButton(null, null, fullPathItems[i].name, null, jsObject.loc.RecentFiles.SelectToNavigateUpOneLevel);
                navButton.folderId = fullPathItems[i].id;
                navButton.style.margin = "0 4px 0 4px";
                innerTable.addCell(navButton);

                navButton.action = function () {
                    navigatePanel.action(this.folderId);
                }
            }
        }
    }

    navigatePanel.action = function () { }

    //Toolbar
    var toolBar = tree.toolBar = this.CreateHTMLTable();
    tree.appendChild(toolBar);

    //Find
    var findControl = tree.findControl = this.FindControl(null, 400, 26);
    findControl.style.margin = "12px";
    toolBar.addCell(findControl);

    findControl.textBox.onchange = function () {
        findControl.action();
    }

    //New Folder
    var newFolderButton = tree.newFolderButton = jsObject.FormButton(null, null, this.loc.Cloud.FolderWindowTitleNew, null, null, null, true);
    newFolderButton.style.margin = "12px 0 12px 0";
    newFolderButton.style.height = "26px";
    toolBar.addCell(newFolderButton).style.lineHeight = "0";

    newFolderButton.action = function () {
        jsObject.InitializeNewFolderForm(function (newFolderForm) {
            newFolderForm.show(function () {
                if (newFolderForm.nameTextBox.value) {
                    tree.progress.show();

                    jsObject.CreateGoogleDriveFolder(ownerForm, tree.currentFolderId || "root", newFolderForm.nameTextBox.value, function (data) {
                        if (data.newFolderId) {
                            tree.openFolder(ownerForm, data.newFolderId, ["Report"], function (data) { });
                        }
                        else {
                            tree.progress.hide();
                        }
                    });

                    newFolderForm.changeVisibleState(false);
                }
                else {
                    var errorMessageForm = jsObject.options.forms.errorMessageForm || jsObject.InitializeErrorMessageForm();
                    errorMessageForm.show(jsObject.loc.Errors.FieldRequire.replace("{0}", jsObject.loc.PropertyMain.Name));
                }
            })
        });
    }

    var headTable = this.CreateHTMLTable();
    headTable.style.width = "calc(100% - 24px)";
    headTable.style.margin = "0 12px 0 12px";
    headTable.className = "stiDesignerCloudTreeItemBorder";
    tree.appendChild(headTable);

    var nameButton = this.GoogleDriveTreeHeaderButton(this.loc.PropertyMain.Name);
    headTable.addCell(nameButton);

    nameButton.action = function () {
        if (tree.sortType == "Name") {
            tree.sortDirection = tree.sortDirection == "Ascending" ? "Descending" : "Ascending";
        }
        else {
            tree.sortType = "Name";
            tree.sortDirection = "Ascending";
        }
        if (tree.items) tree.build(tree.items);
    }

    var dateButton = this.GoogleDriveTreeHeaderButton(this.loc.RecentFiles.DateModified);
    dateButton.style.marginRight = "30px";
    headTable.addCell(dateButton).style.textAlign = "right";

    dateButton.action = function () {
        if (tree.sortType == "ModificationDate") {
            tree.sortDirection = tree.sortDirection == "Ascending" ? "Descending" : "Ascending";
        }
        else {
            tree.sortType = "ModificationDate";
            tree.sortDirection = "Ascending";
        }
        if (tree.items) tree.build(tree.items);
    }

    var innerContainer = document.createElement("div");
    innerContainer.style.overflow = "auto";
    innerContainer.style.position = "absolute";
    innerContainer.style.top = "110px";
    innerContainer.style.bottom = "0px";

    tree.appendChild(innerContainer);
    tree.innerContainer = innerContainer;

    findControl.action = function () {
        var value = this.getValue().toLowerCase();
        for (var i = 0; i < innerContainer.childNodes.length; i++) {
            var item = innerContainer.childNodes[i];
            item.style.display = value == "" || (item.caption && item.caption.innerHTML.toLowerCase().indexOf(value) >= 0) ? "" : "none";
        }
    }

    tree.clear = function () {
        while (innerContainer.childNodes[0]) innerContainer.removeChild(innerContainer.childNodes[0]);
        tree.selectedItem = null;
    }
        
    tree.addItems = function (items) {
        if (items) {
            for (var i = 0; i < items.length; i++) {
                var item = jsObject.GoogleDriveTreeItem(tree, items[i]);
                innerContainer.appendChild(item);
            }
        }
    }

    tree.sortFolderAndFilesItems = function (items) {
        var folderItems = [];
        var fileItems = [];

        var sortFunc = tree.sortDirection == "Ascending" ? tree.sortByName : tree.sortByNameDesc;

        if (tree.sortType == "ModificationDate") {
            sortFunc = tree.sortDirection == "Ascending" ? tree.sortByDate : tree.sortByDateDesc;
        }

        items.sort(sortFunc);

        for (var i = 0; i < items.length; i++) {
            if (items[i].ident == "Folder") {
                folderItems.push(items[i]);
            }
            else {
                fileItems.push(items[i]);
            }
        }

        return {
            folders: folderItems,
            files: fileItems
        }
    }

    tree.sortByName = function (a, b, desc) {
        if (a.name && b.name) {
            if (a.name < b.name) return (desc ? 1 : -1);
            if (a.name > b.name) return (desc ? -1 : 1);
        }
        return 0
    }

    tree.sortByNameDesc = function (a, b) {
        return tree.sortByName(a, b, true);
    }

    tree.sortByDate = function (a, b, desc) {
        var dateA = new Date(a.modificationDate);
        var dateB = new Date(b.modificationDate);

        if (dateA && dateB) {
            if (dateA < dateB) return (desc ? 1 : -1);
            if (dateA > dateB) return (desc ? -1 : 1);
        }
        return 0
    }

    tree.sortByDateDesc = function (a, b) {
        return tree.sortByDate(a, b, true);
    }
        
    tree.build = function (items) {
        this.clear();
        this.items = items;

        nameButton.showSortDirection(tree.sortType == "Name" ? tree.sortDirection : null);
        dateButton.showSortDirection(tree.sortType == "ModificationDate" ? tree.sortDirection : null);

        if (items) {
            var sortedItems = this.sortFolderAndFilesItems(items);

            tree.addItems(sortedItems.folders);
            tree.addItems(sortedItems.files);

            tree.onbuildcomplete();
            findControl.action();
        }
    }

    tree.correctHeight = function (ownerForm) {
        var treeHeight = this.offsetHeight;
        var formTop = parseInt(ownerForm.style.top.replace("px", ""));
        if (formTop + ownerForm.offsetHeight > jsObject.options.mainPanel.offsetHeight) {
            var deltaY = ownerForm.offsetHeight + formTop - jsObject.options.mainPanel.offsetHeight;
            this.style.height = ((deltaY > 0 && treeHeight - deltaY > 200) ? (treeHeight - deltaY - 30) : 200) + "px";
        }
    }

    tree.openFolder = function (ownerForm, parentId, itemsIdent, callbackFunc) {
        tree.currentFolderId = parentId;
        tree.progress.show(null, null);

        jsObject.GetGoogleDriveItems(ownerForm, parentId, itemsIdent, function (data) {
            if (data.items) {
                tree.build(data.items);
                navigatePanel.update(data.fullPathItems);
            }
            tree.progress.hide();

            if (callbackFunc) callbackFunc(data);
        });
    }    

    tree.getNewFreeName = function (name, itemIdent) {
        var item = tree.checkExistItem(name, itemIdent);
        if (!item) return name;

        var i = 2;
        while (tree.checkExistItem(name + i, itemIdent)) {
            i++;
        }

        return name + i;
    }
        
    tree.checkExistItem = function (itemName, itemIdent) {
        for (var i = 0; i < this.innerContainer.childNodes.length; i++) {
            var item = this.innerContainer.childNodes[i];
            if (item.itemObject && item.itemObject.ident == itemIdent && item.itemObject.name == itemName) {
                return item.itemObject;
            }
        }
        return false;
    }

    tree.action = function (item) { }
    tree.ondblClickAction = function (item) { }
    tree.onbuildcomplete = function () { }

    return tree;
}

StiMobileDesigner.prototype.GoogleDriveTreeItem = function (tree, itemObject, itemsMax) {
    var jsObject = this;
    var caption = itemObject.name;
    var image = "CloudItems.BigFile.png";

    if (itemObject.ident == "Folder") {
        image = "Open.Folder.png";
    }
    if (itemObject.ident == "Report" || itemObject.ident == "Report") {
        image = "Open.ReportFile.png";
    }
    else if (StiMobileDesigner.checkImageSource(jsObject.options, "Resources.BigResource" + itemObject.ident + ".png")) {
        image = "Resources.BigResource" + itemObject.ident + ".png";
    }

    var button = this.SmallButton(null, null, caption, image, caption, null, null, true, { width: 32, height: 32 });
    button.style.cursor = "pointer";

    if (button.imageCell) {
        button.imageCell.style.padding = "0 10px 0 10px";
    }

    if (button.caption) {
        button.caption.style.padding = "0 20px 0 10px";
        button.caption.style.lineHeight = "1.4";
        if (tree.innerContainer && tree.innerContainer.style.width) {
            var captCont = document.createElement("div");
            button.captionContainer = captCont;
            captCont.style.overflow = "hidden";
            captCont.style.textOverflow = "ellipsis";
            captCont.style.maxWidth = (parseInt(tree.innerContainer.style.width) - 250) + "px";
            captCont.innerHTML = button.caption.innerHTML;
            button.caption.innerHTML = "";
            button.caption.appendChild(captCont);
        }
    }

    button.tree = tree;
    button.itemObject = itemObject;
    button.style.minWidth = "250px";
    button.style.height = "55px";
    button.style.margin = "0px 12px 0 12px";

    button.innerTable.style.width = "100%";
    button.innerTable.className = "stiDesignerCloudTreeItemBorder";

    var dateCell = button.innerTable.addCell();
    dateCell.style.width = "100%";
    dateCell.style.textAlign = "right";
    dateCell.style.paddingRight = "30px";
    dateCell.innerHTML = itemObject.modificationDate ? this.formatDate(new Date(itemObject.modificationDate), this.options.formatForDateControls || "dd.MM.yyyy HH:mm") : "";

    button.ondblclick = function () {
        tree.ondblClickAction(this);
    }

    button.action = function () {
        tree.action(this);
    }

    button.select = function () {
        if (tree.selectedItem) {
            tree.selectedItem.setSelected(false);
        }
        this.setSelected(true);
        tree.selectedItem = this;
    }

    return button;
}

StiMobileDesigner.prototype.GoogleDriveTreeHeaderButton = function (caption) {
    var button = this.SmallButton(null, null, caption, null, null, "Down");
    button.style.overflow = "hidden";
    button.style.padding = "0 4px 0 4px";
    button.style.display = "inline-block";

    var sortImage = button.arrow;
    StiMobileDesigner.setImageSource(sortImage, this.options, "DataTransformation.SortAsc.png");
    sortImage.style.visibility = "hidden";
    sortImage.style.width = "5px";
    sortImage.style.height = "12px";

    button.showSortDirection = function (sortDirection) {
        sortImage.style.visibility = sortDirection == "Ascending" || sortDirection == "Descending" ? "visible" : "hidden";
        StiMobileDesigner.setImageSource(sortImage, this.jsObject.options, sortDirection == "Ascending" ? "DataTransformation.SortAsc.png" : "DataTransformation.SortDesc.png");
    }

    return button;
}