﻿
StiMobileDesigner.prototype.FontList = function (name, width, height, cutMenu, toolTip) {
    var fontList = this.DropDownList(name, width, toolTip ? toolTip : this.loc.HelpDesigner.FontName, this.GetFontNamesItems(), true, false, height, cutMenu);
    fontList.isFontList = true;

    var jsObject = this;
    var innerContent = fontList.menu.innerContent;
    innerContent.style.overflow = "visible";
    innerContent.style.textAlign = "right";

    var sysFHeader = this.StandartMenuHeader(this.loc.PropertyMain.SystemFonts);
    var customFContainer = document.createElement("div");    

    var scrollContainer = document.createElement("div");
    scrollContainer.style.overflowY = "auto";
    scrollContainer.style.maxHeight = "230px";    
    scrollContainer.style.textAlign = "left";

    var addButton = jsObject.FormButton(null, null, jsObject.loc.Buttons.Add, null, null, null, true);
    addButton.style.margin = "6px 6px 3px 6px";

    addButton.action = function () {
        if (jsObject.options.dictionaryPanel.checkResourcesCount()) return;

        jsObject.InitializeEditResourceForm(function (editResourceForm) {
            var zIndex = editResourceForm.style.zIndex;
            editResourceForm.style.zIndex = "50";

            editResourceForm.controls.resourceContainer.filesMask = ".ttf,.otf,.ttc";
            editResourceForm.controls.resourceContainer.googleFileTypes = ["FontTtf", "FontOtf", "FontTtc"];            

            editResourceForm.resource = null;
            editResourceForm.changeVisibleState(true);
            editResourceForm.controls.name.value = editResourceForm.controls.alias.value = jsObject.loc.PropertyMain.Font;

            editResourceForm.onhide = function () {
                editResourceForm.controls.resourceContainer.filesMask = null;
                editResourceForm.controls.resourceContainer.googleFileTypes = null;
                editResourceForm.style.zIndex = zIndex;
            }
        });
    }

    while (innerContent.childNodes[0]) {
        scrollContainer.appendChild(innerContent.childNodes[0]);
    }

    innerContent.appendChild(scrollContainer);
    innerContent.appendChild(jsObject.FormSeparator());
    innerContent.appendChild(addButton);
    
    fontList.menu.innerContent = scrollContainer;

    if (this.options.showSystemFonts === false) {
        while (scrollContainer.childNodes[0])
            scrollContainer.removeChild(scrollContainer.childNodes[0]);
    }
    else {
        if (scrollContainer.firstChild)
            scrollContainer.insertBefore(sysFHeader, scrollContainer.firstChild);
        else
            scrollContainer.appendChild(sysFHeader);
    }

    if (scrollContainer.firstChild)
        scrollContainer.insertBefore(customFContainer, scrollContainer.firstChild);
    else
        scrollContainer.appendChild(customFContainer);

    fontList.checkEmpty = function () {
        if (jsObject.options.showSystemFonts === false) {
            if (fontList.emptyText && fontList.emptyText.parentElement) {
                fontList.emptyText.parentElement.removeChild(fontList.emptyText);
                fontList.emptyText = null;
            }
            if (jsObject.GetCountObjects(jsObject.options.resourcesFonts) == 0 &&
                (!jsObject.options.opentypeFonts || jsObject.options.opentypeFonts.length == 0) &&
                scrollContainer.childNodes.length == 1 && scrollContainer.childNodes[0] == customFContainer) {
                var emptyText = document.createElement("div");
                emptyText.className = "stiCreateDataHintText";
                emptyText.style.padding = "50px";
                emptyText.innerHTML = jsObject.loc.Report.StiEmptyBrush;
                scrollContainer.appendChild(emptyText);
                fontList.emptyText = emptyText;
            }
        }
    }

    fontList.checkFontExist = function (fontName) {
        if (jsObject.options.showSystemFonts !== false) {
            for (var i = 0; i < jsObject.options.fontNames.length; i++) {
                if (fontName == jsObject.options.fontNames[i].value) {
                    return true;
                }
            }
        }

        if (jsObject.options.resourcesFonts) {
            for (var resourceName in jsObject.options.resourcesFonts) {
                if (fontName == jsObject.options.resourcesFonts[resourceName].originalFontFamily) {
                    return true;
                }
            }
        }

        if (jsObject.options.opentypeFonts) {
            for (var i = 0; i < jsObject.options.opentypeFonts.length; i++) {
                if (fontName == jsObject.options.opentypeFonts[i]) {
                    return true;
                }
            }
        }

        return false;
    }

    fontList.menu.onshow = function () {
        while (customFContainer.childNodes[0])
            customFContainer.removeChild(customFContainer.childNodes[0]);

        var recentArray = jsObject.GetRecentArray("StimulsoftMobileDesignerRecentFonts");
        if (recentArray.length > 0) {
            var recentHeader = jsObject.StandartMenuHeader(jsObject.loc.PropertyMain.RecentFonts);
            customFContainer.appendChild(recentHeader);
            var recentCount = 0;

            for (var i = 0; i < recentArray.length; i++) {
                if (fontList.checkFontExist(recentArray[i].key)) {
                    var item = jsObject.VerticalMenuItem(fontList.menu, "fontItemRecentFont" + i, recentArray[i].caption, null, recentArray[i].key);
                    item.isRecentItem = true;
                    customFContainer.appendChild(item);
                    recentCount++;
                }
            }

            if (recentCount == 0) {
                customFContainer.removeChild(recentHeader);
            }
        }

        //Add custom fonts
        var customHeaderAdded = false;
        var customFontNames = {};
        var resourcesFonts = jsObject.options.resourcesFonts;
        var opentypeFonts = jsObject.options.opentypeFonts;

        if (resourcesFonts && jsObject.GetCountObjects(resourcesFonts) > 0) {
            customFContainer.appendChild(jsObject.StandartMenuHeader(jsObject.loc.PropertyMain.CustomFonts));
            customHeaderAdded = true;

            for (var resourceName in resourcesFonts) {
                var fontName = resourcesFonts[resourceName].originalFontFamily;

                if (!customFontNames[fontName]) {
                    var menuItem = jsObject.VerticalMenuItem(fontList.menu, "fontItemCustom" + resourceName, fontName, null, fontName);
                    customFContainer.appendChild(menuItem);
                    customFontNames[fontName] = true;
                }
            }
        }

        if (opentypeFonts && opentypeFonts.length > 0) {
            if (!customHeaderAdded) {
                customFContainer.appendChild(jsObject.StandartMenuHeader(jsObject.loc.PropertyMain.CustomFonts));
            }
            for (var i = 0; i < opentypeFonts.length; i++) {
                if (!customFontNames[opentypeFonts[i]]) {
                    var item = jsObject.VerticalMenuItem(fontList.menu, "fontItemOpentypeFont" + opentypeFonts[i], opentypeFonts[i], null, opentypeFonts[i]);
                    customFContainer.appendChild(item);
                    customFontNames[opentypeFonts[i]] = true;
                }
            }
        }

        for (var itemName in fontList.menu.items) {
            var item = fontList.menu.items[itemName];

            item.action = function () {
                fontList.menu.action(this);

                if (!this.isRecentItem) {
                    jsObject.SaveRecentFonts(this);
                }
            }
        }

        fontList.checkEmpty();
    }

    if (this.options.jsMode) {
        fontList.menu.addItems = function (items) {
            while (this.innerContent.childNodes[0]) {
                this.innerContent.removeChild(this.innerContent.childNodes[0]);
            }

            if (jsObject.options.showSystemFonts !== false) {
                this.innerContent.appendChild(sysFHeader);
            }

            if (this.innerContent.firstChild)
                this.innerContent.insertBefore(customFContainer, this.innerContent.firstChild);
            else
                this.innerContent.appendChild(customFContainer);

            if (items && items.length) {
                for (var i = 0; i < items.length; i++) {
                    var item = jsObject.VerticalMenuItem(this, items[i].name, items[i].caption, items[i].imageName, items[i].key, this.itemsStyle, items[i].haveSubMenu);
                    this.innerContent.appendChild(item);
                }
            }

            fontList.checkEmpty();
        }

        fontList.addItems = function (items) {
            fontList.items = items;
            fontList.menu.addItems(items);
        }
    }

    //Override
    fontList.setKey = function (key) {
        this.key = key;
        if (key == null) return;
        if (key == "StiEmptyValue") {
            this.textBox.value = "";
            return;
        }
        if (this.menu && this.menu.items) {
            for (var itemName in this.menu.items)
                if (key == this.menu.items[itemName].key) {
                    this.textBox.value = this.menu.items[itemName].captionText;
                    if (this.image) StiMobileDesigner.setImageSource(this.image, jsObject.options, this.menu.items[itemName].imageName);
                    return;
                }
        }
        this.textBox.value = key.toString();
    }

    return fontList;
}

StiMobileDesigner.prototype.SaveRecentFonts = function (fontItem) {
    var recentArray = this.GetRecentArray("StimulsoftMobileDesignerRecentFonts");
    var needToAdd = true;

    for (var i = 0; i < recentArray.length; i++) {
        if (recentArray[i].key == fontItem.key) {
            var temp = recentArray[i];
            recentArray.splice(i, 1);
            recentArray.splice(0, 0, temp);
            needToAdd = false;
            break;
        }
    }

    if (needToAdd && fontItem.caption) {
        recentArray.splice(0, 0, {
            caption: fontItem.caption.innerHTML,
            key: fontItem.key
        });

        if (recentArray.length > this.options.maxRecentFontsCount) {
            recentArray.pop();
        }
    }

    StiMobileDesigner.SetCookie("StimulsoftMobileDesignerRecentFonts", JSON.stringify(recentArray));
}