﻿
StiMobileDesigner.prototype.FindControl = function (name, width, height, hideButtons) {
    var jsObject = this;
    var control = this.CreateHTMLTable();
    control.isEnabled = true;
    control.className = "stiDesignerTextBoxDefault";
    control.style.borderRadius = this.allowRoundedControls() ? "3px" : "0";

    if (name) {
        this.options.controls[name] = control;
        control.name = name;
    }

    var textBox = control.textBox = this.TextBox(null, width ? (hideButtons ? width : (width - (this.options.isTouchDevice ? 30 : 26) * 2)) : 100);
    textBox.style.border = "0";
    textBox.setAttribute("placeholder", this.loc.Editor.Search);
    textBox.setAttribute("autocomplete", "off");
    control.addCell(textBox);

    var clearButton = control.clearButton = this.StandartSmallButton(null, null, null, "RemoveBlack.png", this.loc.Gui.monthcalendar_clearbutton);
    clearButton.style.visibility = "hidden";
    control.addCell(clearButton);

    var findButton = control.findButton = this.StandartSmallButton(null, null, null, "View.png");
    control.addCell(findButton);

    if (hideButtons) {
        clearButton.style.display = "none";
        findButton.style.display = "none";
    }

    if (height) {
        textBox.style.height = findButton.style.height = clearButton.style.height = (height - 2) + "px";
    }

    control.onmouseenter = function () {
        if (!this.isEnabled || jsObject.options.isTouchClick) return;
        this.className = "stiDesignerTextBoxOver";
    }

    control.onmouseleave = function () {
        if (!this.isEnabled) return;
        this.className = "stiDesignerTextBoxDefault";
    }

    control.setEnabled = function (state) {
        this.isEnabled = state;
        textBox.setEnabled(state);
        findButton.setEnabled(state);
        clearButton.setEnabled(state);
        this.className = state ? " stiDesignerTextBoxDefault" : " stiDesignerTextBoxDisabled";
    }

    textBox.action = function () {
        control.action();
    }

    findButton.action = function () {
        control.action();
    }

    clearButton.action = function () {
        textBox.value = "";
        clearButton.style.visibility = "hidden";
    }

    control.getValue = function () {
        return textBox.value;
    }

    control.setValue = function (value) {
        textBox.value = value;
    }

    control.action = function () { }

    return control;
}