﻿
//Expression Control
StiMobileDesigner.prototype.ExpressionControl = function (name, width, height, readOnly, cutBrackets, showClearButton, notShowDictionary, showCheckButton, samples, sampleLabelText, samplesHeight, hidePlaceholder) {
    var jsObject = this;
    var expControl = this.TextBoxWithEditButton(name, width, height, readOnly, showClearButton);
    expControl.cutBrackets = cutBrackets;
    expControl.samples = samples;
    expControl.sampleLabelText = sampleLabelText;
    expControl.notShowDictionary = notShowDictionary;
    expControl.showCheckButton = showCheckButton;
    expControl.samplesHeight = samplesHeight;

    if (samples && samples.length > 0 && !hidePlaceholder) {
        expControl.textBox.setAttribute("placeholder", samples[0]);
    }

    if (readOnly) {
        expControl.textBox.readOnly = readOnly;
        expControl.textBox.style.cursor = "default";
        expControl.textBox.mainControl = expControl;

        expControl.textBox.onclick = function () {
            if (!this.isTouchEndFlag)
                this.mainControl.button.onclick();
        }

        expControl.textBox.ontouchend = function () {
            var this_ = this;
            this.isTouchEndFlag = true;
            clearTimeout(this.isTouchEndTimer);
            this.mainControl.button.ontouchend();
            this.isTouchEndTimer = setTimeout(function () {
                this_.isTouchEndFlag = false;
            }, 1000);
        }
    }

    expControl.button.action = function () {
        if (name == "expandExpression") {
            jsObject.InitializeHyperlinkEditorForm(function (form) {
                expControl.interactionIdent = "expandExpression";
                form.show(expControl);

                form.action = function () {
                    form.changeVisibleState(false);
                    expControl.textBox.value = form.textArea.value;
                    expControl.action();
                }
            });

        } else {
            jsObject.InitializeExpressionEditorForm(function (form) {
                form.resultControl = expControl;
                form.changeVisibleState(true);
            });
        }
    }

    var checkButton = expControl.checkButton;

    if (checkButton) {
        expControl.getDataForAI = function () {
            return {
                commandName: "onlyExpression",
                expression: StiBase64.encode(expControl.textBox.value)
            }
        }

        checkButton.action = function () {
            checkButton.setEnabled(false);

            var params = {
                expression: StiBase64.encode(expControl.textBox.value),
                useAliases: jsObject.options.useAliases,
                onlyExpression: expControl.onlyExpression === false ? false : true
            }

            jsObject.SendCommandToDesignerServer("CheckExpression", params, function (answer) {
                checkButton.setEnabled(true);

                if (answer.checkResult) {
                    var message = StiBase64.decode(answer.checkResult);

                    var messageForm = jsObject.MessageFormWithFixAI(jsObject.loc.Buttons.Check);
                    messageForm.show(message == "OK" ? jsObject.loc.StimulAI.CheckExpressionSuccess : message, message == "OK" ? "Information" : "Warning");
                    messageForm.buttonYes.style.display = jsObject.options.showStimulAI && message != "OK" ? "" : "none";

                    messageForm.action = function (state) {
                        messageForm.changeVisibleState(false);

                        if (state) {                            
                            jsObject.InitializeStimulAIForm(function (stimulAIForm) {
                                stimulAIForm.show(null, expControl, function () {
                                    stimulAIForm.sendButtonAction("FixExpression");
                                });
                            });
                        }
                    }
                }
            });
        }
    }

    return expControl;
}

StiMobileDesigner.prototype.ExpressionControlWithMenu = function (name, width, toolTip, items, readOnly, checkExpressionBrackets, cutBrackets, showCheckButton, samples, sampleLabelText, samplesHeight, hideEditButton) {
    var jsObject = this;
    var dropDownList = this.DropDownList(name, width, toolTip, items, readOnly, false, null, false, null, !hideEditButton);
    dropDownList.cutBrackets = true;
    dropDownList.checkExpressionBrackets = true;

    var textBox = dropDownList.textBox;
    dropDownList.cutBrackets = textBox.cutBrackets = cutBrackets;
    dropDownList.samples = textBox.samples = samples;
    dropDownList.sampleLabelText = textBox.sampleLabelText = sampleLabelText;
    dropDownList.showCheckButton = textBox.showCheckButton = showCheckButton;
    dropDownList.samplesHeight = textBox.samplesHeight = samplesHeight;

    dropDownList.button.action = function () {
        dropDownList.menu.currentContainer = null;
        dropDownList.hideError();
        if (!this.dropDownList.menu.visible) {
            if (this.dropDownList.menu.isDinamic) this.dropDownList.menu.addItems(this.dropDownList.items);
            if (jsObject.options.showTooltips && this.dropDownList.toolTip && typeof (this.dropDownList.toolTip) == "object") jsObject.options.toolTip.hide();
            this.dropDownList.menu.changeVisibleState(true);
        }
        else {
            this.dropDownList.menu.changeVisibleState(false);
        }
    }

    if (dropDownList.editButton) {
        dropDownList.editButton.action = function () {
            jsObject.InitializeExpressionEditorForm(function (form) {
                form.resultControl = dropDownList.textBox;
                form.resultControl.checkExpressionBrackets = checkExpressionBrackets;
                form.changeVisibleState(true);
            });
        }
    }

    dropDownList.textBox.onmouseup = function () {
        if (jsObject.options.itemInDrag && jsObject.options.dictionaryTree.selectedItem) {
            dropDownList.textBox.value = jsObject.CheckExpressionBrackets(jsObject.options.dictionaryTree.selectedItem.getResultForEditForm(true, true));
            dropDownList.textBox.action();
        }
    }

    return dropDownList;
}