﻿
StiMobileDesigner.prototype.DataSourcesControl = function (name, width) {
    var jsObject = this;
    var control = this.DropDownList(name, width, null, [], true);

    control.key = {
        dataSource: "",
        businessObject: ""
    };

    var tree = this.DataSourcesTree();
    tree.style.minWidth = width + "px";
    tree.style.minHeight = "200px";
    tree.style.margin = "12px";
    tree.style.overflow = "auto";
    control.menu.innerContent.appendChild(tree);

    control.menu.onshow = function () {
        tree.build(true, true);

        var dataSourceItem = tree.getItem(control.key.dataSource, null, "DataSource");
        if (!dataSourceItem) {
            var fullName = control.key.businessObject;
            if (fullName && fullName != "StiEmptyValue") {
                var lastName = fullName.substring(fullName.lastIndexOf(".") + 1);
                dataSourceItem = tree.getItem(lastName, null, "BusinessObject");
            }
        }
        if (dataSourceItem) {
            dataSourceItem.setSelected();
            dataSourceItem.openTree();
        }
    }

    control.setKey = function (key) {
        this.key = key;
        this.textBox.value = (key.dataSource || key.businessObject) || jsObject.loc.Report.NotAssigned;
    }

    tree.onActionItem = function () {
        var key = {
            dataSource: "",
            businessObject: ""
        }
        if (this.selectedItem) {
            var typeItem = this.selectedItem.itemObject.typeItem;

            if (typeItem == "DataSource") {
                key.dataSource = this.selectedItem.itemObject.name
            }
            else if (typeItem == "BusinessObject") {
                key.dataSource = this.selectedItem.itemObject.name
            }

            if (typeItem == "DataSource" || typeItem == "BusinessObject" || typeItem == "NoItem") {
                control.menu.changeVisibleState(false);
            }
        }
        control.setKey(key);
        control.action();
    }

    control.action = function () { }

    return control;
}