﻿
StiMobileDesigner.prototype.Container = function (name, width, height, numerable, itemContextFunc) {
    var container = document.createElement("div");
    container.jsObject = this;
    container.className = "stiDesignerItemsContainer";
    if (width) container.style.width = width + "px";
    if (height) container.style.height = height + "px";
    container.items = [];
    container.selectedItem = null;
    container.selectedItems = [];
    container.name = name;
    container.multiSelection = false;
    container.numerable = numerable;

    container.onChange = function () { };
    container.onAction = function () { };

    container.clear = function () {
        while (this.childNodes[0]) this.removeChild(this.childNodes[0]);
        this.items = [];
        this.selectedItems = [];
        this.selectedItem = null;
        this.onChange();
    }

    container.getSelectedIndex = function (item) {
        var index = -1;
        for (var i = 0; i < container.items.length; i++) {
            if (container.items[i] == (item || container.selectedItem)) return i;
        }
        return index;
    }

    container.addItemAndNotAction = function (name, itemObject, caption, image) {
        if (!name) name = this.jsObject.generateKey();
        var item = this.jsObject.StandartSmallButton(null, null, caption || name, image);
        item.name = name;
        item.style.margin = "2px";
        item.itemObject = itemObject;

        if (this.numerable) {
            item.nCell = item.innerTable.addCell();
            item.nCell.style.width = "100%";
            item.nCell.style.textAlign = "right";
            item.nCell.style.paddingRight = "3px";
        }

        this.items.push(item);
        this.appendChild(item);
        item.container = this;

        item.action = function () {
            this.selected();
            this.container.onChange();
            this.container.onAction();
        }

        item.selected = function () {
            if (this.container.multiSelection && this.container.selectedItem != null && this.container.jsObject.options.SHIFT_pressed) {
                var from = this.container.getSelectedIndex();
                var to = this.container.getSelectedIndex(this);
                this.container.selectedItems = [];
                for (var i = 0; i < this.container.items.length; i++) {
                    var isSelected = i >= Math.min(from, to) && i <= Math.max(from, to);
                    this.container.items[i].setSelected(isSelected);
                    if (isSelected) this.container.selectedItems.push(this.container.items[i]);
                }
            } else if (this.container.multiSelection && this.container.jsObject.options.CTRL_pressed) {
                this.setSelected(!this.isSelected);
                if (!this.isSelected) {
                    this.container.selectedItem = null;
                    if (this.container.selectedItems.indexOf(this) >= 0) {
                        this.container.selectedItems.splice(this.container.selectedItems.indexOf(this), 1);
                    }
                } else {
                    this.container.selectedItem = this;
                    this.container.selectedItems.push(this);
                }
            } else {
                for (var i = 0; i < this.container.items.length; i++) {
                    this.container.items[i].setSelected(false);
                }
                this.setSelected(true);
                this.container.selectedItem = this;
                this.container.selectedItems = [this];
            }
            this.container.updateNumaration();
        };

        item.remove = function () {
            container.removeItem(this.name);
        };

        if (itemContextFunc) {
            item.onmouseup = function (event) {
                if (event.button == 2) {
                    event.stopPropagation();
                    itemContextFunc(event, this);
                }
                return false;
            }

            item.oncontextmenu = function (event) {
                return false;
            }
        }

        container.updateNumaration();

        return item;
    }

    container.addItem = function (name, itemObject) {
        var item = container.addItemAndNotAction(name, itemObject);
        item.action();

        return item;
    }

    container.removeItem = function (name) {
        var item = null;
        var i;
        for (i in this.items)
            if (this.items[i].name == name) {
                item = this.items[i];
                break;
            }
        if (item) {
            var prevItem = item.previousSibling;
            var nextItem = item.nextSibling;
            this.removeChild(item);
            this.items.splice(i, 1);
            this.selectedItem = null;
            if (this.items.length > 0) {
                if (nextItem) {
                    nextItem.setSelected(true);
                    this.selectedItem = nextItem;
                }
                else if (prevItem) {
                    prevItem.setSelected(true);
                    this.selectedItem = prevItem;
                }
                else {
                    this.items[0].setSelected(true);
                    this.selectedItem = this.items[0];
                }
            }
            this.onChange();
        }
        container.updateNumaration();
    }

    container.isContained = function (name) {
        for (var i = 0; i < this.items.length; i++) {
            if (this.items[i].name == name) return true;
        }
        return false;
    }

    container.updateNumaration = function () {
        if (container.numerable) {
            for (var i in this.items) {
                this.items[i].nCell.innerHTML = "";
            }
            for (var i = 0; i < this.selectedItems.length; i++) {
                this.selectedItems[i].nCell.innerHTML = (i + 1).toString();
            }
        }
    }

    return container;
}

StiMobileDesigner.prototype.ContainerWithBigItems = function (name, width, height, itemMaxWidth) {
    var container = this.Container(name, width, height);

    container.addItemAndNotAction = function (name, caption, imageName, itemObject) {
        var item = this.jsObject.BigButton(null, null, caption, imageName, null, null, "stiDesignerStandartBigButton", null, itemMaxWidth);
        if (item.cellImage) item.cellImage.style.padding = "5px";
        if (item.caption) item.caption.style.padding = "0 5px 5px 5px";

        item.name = name;
        item.itemObject = itemObject;
        item.container = this;
        item.style.margin = "0 6px 2px 6px";
        item.style.minHeight = "0";

        this.items.push(item);
        this.appendChild(item);

        item.action = function () {
            item.selected();
            this.container.onChange();
            this.container.onAction();
        }

        item.selected = function () {
            for (var i = 0; i < this.container.items.length; i++) {
                this.container.items[i].setSelected(false);
            }
            this.setSelected(true);
            this.container.selectedItem = this;
        };

        item.remove = function () {
            container.removeItem(this.name);
        };

        item.getIndex = function () {
            for (var i = 0; i < container.childNodes.length; i++)
                if (container.childNodes[i] == this) return i;
        };

        return item;
    }

    container.addItem = function (name, caption, imageName, itemObject) {
        var item = container.addItemAndNotAction(name, caption, imageName, itemObject);
        item.action();

        return item;
    }

    return container;
}

StiMobileDesigner.prototype.EasyContainer = function (width, height, showBorder, showRemoveIcon, cutItemsText, showEmptyText) {
    var container = document.createElement("div");
    var jsObject = container.jsObject = this;
    if (width) container.style.width = width + "px";
    if (height) container.style.height = height + "px";
    if (showBorder) container.className = "stiSimpleContainerWithBorder";
    if (showEmptyText) container.style.position = "relative";
    container.style.overflow = "auto";
    container.selectedItem = null;

    container.onAction = function () { };
    container.onSelected = function (item) { };
    container.onPreChangeSelection = function () { };
        
    container.clear = function () {
        while (this.childNodes[0]) this.removeChild(this.childNodes[0]);
        this.selectedItem = null;
        this.onAction("clear");
        this.checkEmptyPanel();
    }

    container.addItem = function (name, itemObject, caption, image, notAction) {
        if (!name) name = jsObject.generateKey();
        var item = jsObject.StandartSmallButton(null, null, caption || name, image);
        item.itemObject = itemObject;
        item.name = name;
        item.style.margin = "1px";
        container.appendChild(item);
        container.checkEmptyPanel();
        if (!notAction) container.onAction("add");

        item.action = function () {
            if (!this.removeButtonAction) {
                var isEmptyAction = container.selectedItem == this;

                if (container.selectedItem) {
                    container.onPreChangeSelection();
                    container.selectedItem.setSelected(false);
                }

                this.setSelected(true);
                container.selectedItem = this;
                container.onAction("action", isEmptyAction);
                container.onSelected(this);
            }
            this.removeButtonAction = false;
        }

        item.select = function () {
            if (container.selectedItem) container.selectedItem.setSelected(false);
            this.setSelected(true);
            container.selectedItem = this;
        }

        item.remove = function () {
            var prevItem = this.previousSibling;
            var nextItem = this.nextSibling;
            container.removeChild(this);

            if (this == container.selectedItem) {
                container.selectedItem = null;

                if (container.getCountItems() > 0) {
                    if (nextItem) {
                        nextItem.setSelected(true);
                        container.selectedItem = nextItem;
                    }
                    else if (prevItem) {
                        prevItem.setSelected(true);
                        container.selectedItem = prevItem;
                    }
                    else {
                        container.childNodes[0].setSelected(true);
                        container.selectedItem = container.childNodes[0];
                    }
                }
            }
            container.onAction("remove");
            container.checkEmptyPanel();
        };

        item.getIndex = function () {
            for (var i = 0; i < container.childNodes.length; i++)
                if (container.childNodes[i] == this) return i;
        };

        item.move = function (direction) {
            var index = this.getIndex();
            container.removeChild(this);
            var count = container.getCountItems();
            var newIndex = direction == "Up" ? index - 1 : index + 1;
            if (direction == "Up" && newIndex == -1) newIndex = 0;
            if (direction == "Down" && newIndex >= count) {
                container.appendChild(this);
                container.onAction("move");                
                return;
            }
            container.insertBefore(this, container.childNodes[newIndex]);
            container.onAction("move");
        }

        if (item.caption && (cutItemsText || showRemoveIcon)) {
            item.caption.style.width = "100%";
            item.caption.style.padding = "0";
            var captCont = document.createElement("div");
            item.captionContainer = captCont;
            captCont.style.position = "relative";
            captCont.style.overflow = "hidden";
            captCont.style.textOverflow = "ellipsis";
            captCont.style.padding = "2px 0 2px 0";
            var contWidth = width || container.width || container.maxWidth;
            if (contWidth) {
                var textMaxWidth = contWidth - (showRemoveIcon ? 40 : 10);
                if (image) textMaxWidth -= 40;
                captCont.style.maxWidth = textMaxWidth + "px";
            }
            captCont.innerHTML = caption;
            item.caption.innerHTML = "";
            item.caption.appendChild(captCont);
            item.setAttribute("title", caption);
        }

        if (showRemoveIcon) {
            item.style.border = "0";
            item.style.height = "30px";
            item.style.marginBottom = "1px";
            item.innerTable.style.width = "100%";

            var removeButton = item.removeButton = jsObject.StandartSmallButton(null, null, null, "CloseForm.png");
            removeButton.image.style.margin = "0 2px 0 2px";
            removeButton.imageCell.style.padding = jsObject.options.isTouchDevice ? "0 4px 0 4px" : "0 3px 0 3px";
            removeButton.style.margin = "1px";
            removeButton.style.height = removeButton.style.width = "26px";
            removeButton.style.display = "none";
            removeButton.innerTable.style.width = "100%";
            item.innerTable.addCell(removeButton);

            removeButton.onmouseenter = function () {
                if (!this.isEnabled || jsObject.options.isTouchClick) return;
                this.className = this.overClass;
                this.isOver = true;
                removeButton.image.style.opacity = "0.8";
            }

            removeButton.onmouseleave = function () {
                this.isOver = false;
                if (!this.isEnabled) return;
                this.className = this.isSelected ? this.selectedClass : this.defaultClass;
                removeButton.image.style.opacity = "1";
            }

            removeButton.action = function () {
                item.removeButtonAction = true;
                item.remove();
            }

            item.onmouseenter = function () {
                if (!this.isEnabled || jsObject.options.isTouchClick) return;
                this.className = this.overClass;
                this.isOver = true;
                removeButton.style.display = "";
            }

            item.onmouseleave = function () {
                this.isOver = false;
                if (!this.isEnabled) return;
                this.className = this.isSelected ? this.selectedClass : this.defaultClass;
                removeButton.style.display = "none";
            }
        }

        return item;
    }

    container.removeItem = function (name) {
        for (var i = 0; i < container.childNodes.length; i++) {
            var item = container.childNodes[i];
            if (item.name == name) {
                item.remove();
                break;
            }
        }
    }

    container.isContained = function (name) {
        for (var i = 0; i < container.childNodes.length; i++) {
            if (container.childNodes[i].name == name) return true;
        }
        return false;
    }

    container.getCountItems = function () {
        var itemsCount = 0;
        for (var i = 0; i < this.childNodes.length; i++) {
            if (this.childNodes[i].className != "stiEmptyTextPanel") {
                itemsCount++;
            }
        }
        return itemsCount;
    }

    container.getItemByName = function (name) {
        for (var i = 0; i < container.childNodes.length; i++) {
            if (container.childNodes[i].name == name) return container.childNodes[i];
        }
        return null;
    }

    container.checkEmptyPanel = function () {
        if (!showEmptyText) return;

        var itemsCount = 0;
        var emptyPanel = null;

        for (var i = 0; i < this.childNodes.length; i++) {
            if (this.childNodes[i].className == "stiEmptyTextPanel") {
                emptyPanel = this.childNodes[i];
            }
            else {
                itemsCount++;
            }
        }
        if (itemsCount > 0) {
            if (emptyPanel) this.removeChild(emptyPanel);
        }
        else {
            if (!emptyPanel) {
                emptyPanel = jsObject.EmptyTextPanel(null, jsObject.loc.PropertyMain.NoElements, null, null, null, width ? width - 4 : null);
                this.appendChild(emptyPanel);
            }
        }
    }

    return container;
}