﻿
StiMobileDesigner.prototype.InitializeElementDataFiltersForm_ = function () {
    var jsObject = this;
    var form = this.DashboardBaseForm("elementDataFiltersForm", this.loc.PropertyMain.Filters, 1, this.GetHelpLink("elementDataFilters"));
    form.isDockableToComponent = true;
    form.container.style.borderTop = "0px";
    form.caption.style.padding = "0px 10px 0 12px";
    form.hideButtonsPanel();
    form.controls = {};

    var upTable = this.CreateHTMLTable();
    upTable.style.width = "100%";
    form.container.appendChild(upTable);

    var addFilter = this.FormButton(null, null, jsObject.loc.FormBand.AddFilter.replace("&", ""));
    addFilter.style.display = "inline-block";
    addFilter.style.margin = "12px 0 0 12px";

    addFilter.action = function () {
        form.addNewFilter();
    }

    upTable.addCell(addFilter).style.width = "1px";
    upTable.addCell();

    //Operation
    var operation = form.controls.operation = this.DropDownList("elementDataFiltersOperation", 70, null, this.GetFilterOperationItems(), true, null, null, true);
    operation.style.margin = "12px 12px 0 6px";

    var operationText = form.controls.operationText = upTable.addTextCell(this.loc.PropertyMain.Operation);
    operationText.style.textAlign = "right";
    operationText.style.padding = "12px 0 0 0"
    operationText.className = "stiDesignerCaptionControls";
    upTable.addCell(operation).style.width = "1px";

    var opMessage = form.controls.operationMessage = document.createElement("div");
    opMessage.className = "stiDesignerTextContainer";
    opMessage.style.textAlign = "right";
    opMessage.style.color = "#aaaaaa";
    opMessage.style.width = "335px";
    opMessage.style.margin = "12px 12px 6px 12px";
    opMessage.innerHTML = this.loc.Dashboard.DataFilterGrouping;
    form.container.appendChild(opMessage);

    operation.action = function () {
        form.applyPropertiesToDataFilter("Operation", this.key);
    }

    var controlsTable = this.CreateHTMLTable();
    controlsTable.style.width = "350px";

    form.container.appendChild(controlsTable);
    form.container.style.padding = "0 0 6px 0";

    //Field
    var field = this.ExpressionControl(null, 250, null, true)

    var fieldMenu = this.options.menus.dataFiltersMenu || this.InitializeFilterElementFieldMenu("dataFiltersMenu", field, form);
    field.menu = fieldMenu;
    fieldMenu.parentButton = field.button;

    //Filters Container
    var filtersBlock = this.FiltersDataColumnsBlock(form, fieldMenu, "filters", null, true);
    filtersBlock.style.width = "350px";
    form.addControlRow(controlsTable, null, "filtersBlock", filtersBlock, "12px");
    form.addControlRow(controlsTable, this.loc.PropertyMain.Field, "field", field, "6px 12px 6px 12px");

    var parentFiltersContainer = filtersBlock.container.parentElement;
    var currentContainer = field.currentContainer = filtersBlock.container;

    field.button.action = function () {
        field.button.key = field.textBox.value;
        jsObject.options.dataTree.showNoneItem = false;

        jsObject.InitializeDataColumnForm(function (colForm) {
            colForm.parentButton = field.button;
            colForm.caption.innerHTML = jsObject.loc.PropertyMain.Field;
            colForm.changeVisibleState(true);

            colForm.onhide = function () {
                jsObject.options.dataTree.showNoneItem = true;
                colForm.caption.innerHTML = jsObject.loc.PropertyMain.DataColumn;
            };

            colForm.action = function () {
                this.changeVisibleState(false);
                var expression = "";
                var dataTreeSelItem = colForm.dataTree.selectedItem;

                if (dataTreeSelItem && dataTreeSelItem.itemObject && dataTreeSelItem.itemObject.typeItem == "Column") {
                    var currItem = dataTreeSelItem;
                    while (currItem.parent != null) {
                        if (expression != "") expression = "." + expression;
                        expression = currItem.itemObject.name + expression;
                        if (currItem.itemObject.typeItem == "BusinessObject" && currItem.parent != null && currItem.parent.itemObject.typeItem != "BusinessObject" || currItem.itemObject.typeItem == "DataSource") break;
                        currItem = currItem.parent;
                    }
                    if (expression) expression = jsObject.CheckExpressionBrackets(expression);
                }

                var params = {
                    command: "EditField",
                    containerName: jsObject.UpperFirstChar(currentContainer.name),
                    expression: expression,
                    itemIndex: currentContainer.getSelectedItemIndex ? currentContainer.getSelectedItemIndex() : 0,
                    isUserFilters: form.isUserFilters
                }

                form.sendCommand(params, function (answer) {
                    form.updateControls(answer.elementProperties);
                    if (form.updateElementProperties) form.updateElementProperties(answer.elementProperties);
                    form.updateSvgContent(answer.elementProperties.svgContent);
                    form.checkStartMode();

                    if (currentContainer.selectedItem) {
                        currentContainer.selectedItem.action();
                    }
                    else if (currentContainer.getCountItems) {
                        var lastItem = currentContainer.getItemByIndex(currentContainer.getCountItems() - 1);
                        if (lastItem) lastItem.select();
                    }
                    else if (currentContainer.item) {
                        currentContainer.item.action();
                    }
                });
            }
        });
    }

    form.addNewFilter = function (baseItemObject) {
        form.sendCommand({ command: "NewItem", baseItemObject: baseItemObject }, function (answer) {
            form.updateControls(answer.elementProperties);
            if (form.updateElementProperties) form.updateElementProperties(answer.elementProperties);
            form.updateSvgContent(answer.elementProperties.svgContent);
            form.checkStartMode();
            var lastItem = currentContainer.getItemByIndex(currentContainer.getCountItems() - 1);
            if (lastItem) lastItem.select();
        });
    } 

    fieldMenu.onshow = function () {
        this.currentContainer = currentContainer;

        var items = [];
        items.push(jsObject.Item("newItem", jsObject.loc.FormBand.AddFilter.replace("&", ""), "Empty16.png", "newItem"));

        items.push("separator_0");
        items.push(jsObject.Item("cutField", jsObject.loc.MainMenu.menuEditCut.replace("&", ""), "Cut.png", "cutField"));
        items.push(jsObject.Item("copyField", jsObject.loc.MainMenu.menuEditCopy.replace("&", ""), "Copy.png", "copyField"));
        items.push(jsObject.Item("pasteField", jsObject.loc.MainMenu.menuEditPaste.replace("&", ""), "Paste.png", "pasteField"));

        if (currentContainer.selectedItem) {
            items.push(jsObject.Item("removeField", jsObject.loc.Buttons.Delete, "Remove.png", "removeField"));
            items.push("separator_1");
            items.push(jsObject.Item("editField", jsObject.loc.Dashboard.EditField, "SmallEdit.png", "editField"));
        }

        this.addItems(items);

        this.items.cutField.setEnabled(currentContainer.selectedItem != null);
        this.items.copyField.setEnabled(currentContainer.selectedItem != null);
        this.items.pasteField.setEnabled(form.copiedItemObject != null);
    }

    fieldMenu.oldAction = fieldMenu.action;

    fieldMenu.action = function (menuItem) {
        var selectedItem = currentContainer.selectedItem;

        if (menuItem.key == "newItem") {
            form.addNewFilter();
        }
        else if (menuItem.key == "copyField") {
            if (selectedItem) {
                form.copiedItemObject = jsObject.CopyObject(selectedItem.itemObject);
            }
        }
        else if (menuItem.key == "cutField") {
            if (selectedItem) {
                form.copiedItemObject = jsObject.CopyObject(selectedItem.itemObject);
                selectedItem.remove();
            }
        }
        else if (menuItem.key == "pasteField") {
            if (form.copiedItemObject) {
                form.addNewFilter(form.copiedItemObject);
            }
        }
        else {
            fieldMenu.oldAction(menuItem);
        }
        fieldMenu.changeVisibleState(false);
    }
        
    //Condition
    var condition = this.DropDownList("elementDataFiltersCondition", 250, null, [], true, null, null, true);
    form.addControlRow(controlsTable, this.loc.PropertyMain.Condition, "condition", condition, "12px 12px 6px 12px", null, true, null, true);

    condition.action = function () {
        form.updateControlsVisibleStates();
        form.applyPropertiesToDataFilter("Condition", this.key);
    }

    //Value
    var valueTable = this.CreateHTMLTable();
    form.addControlRow(controlsTable, this.loc.PropertyMain.Value, "valueTable", valueTable, "12px 12px 6px 12px", null, true, null, true);

    var value = this.DropDownList("elementDataFiltersValue", 140, null, [], false, null, null, true);    
    valueTable.addCell(value);
    form.controls.value = value;

    value.action = function () {
        form.applyPropertiesToDataFilter("Value", this.key);
    }

    value.getItems = function (itemObject) {
        var items = [];
        if (itemObject) {
            if (itemObject.type == "bool") {
                items = jsObject.GetBoolItems();
            }
            else if (itemObject.values && itemObject.values.length > 0) {
                for (var i = 0; i < itemObject.values.length; i++) {
                    items.push(jsObject.Item("item" + i, itemObject.values[i], null, itemObject.values[i]));
                }
            }
        }
        return items;
    }

    value.updateItems = function (itemObject) {
        this.addItems(this.getItems(itemObject));
    }

    //Value Expression
    var valueExp = this.ExpressionControl(null, 140, null, null, true, null, null, false, ["Variable", "Expression", "15"], null, 40);
    valueTable.addCell(valueExp);
    form.controls.valueExp = valueExp;

    valueExp.action = function () {
        form.applyPropertiesToDataFilter("ValueExp", this.textBox.value);
    }

    //ValueDate
    var valueDate = this.DateControl("elementDataFiltersValueDate", 140, null, true);
    valueTable.addCell(valueDate);
    form.controls.valueDate = valueDate;

    valueDate.action = function () {
        form.applyPropertiesToDataFilter("ValueDate", jsObject.formatDate(this.key, "MM/dd/yyyy"));
    }

    var valueTable2 = this.CreateHTMLTable();
    form.addControlRow(controlsTable, this.loc.PropertyMain.To, "valueTable2", valueTable2, "12px 12px 6px 12px", null, true, null, true);

    //Value2
    var value2 = this.DropDownList("elementDataFiltersValue2", 140, null, [], false, null, null, true);
    valueTable2.addCell(value2);
    form.controls.value2 = value2;

    value2.action = function () {
        form.applyPropertiesToDataFilter("Value2", this.key);
    }

    value2.updateItems = function (itemObject) {
        this.addItems(value.getItems(itemObject));
    }

    //Value2 Expression
    var value2Exp = this.ExpressionControl(null, 140, null, null, true, null, null, false, ["Variable", "Expression", "15"], null, 40);
    valueTable2.addCell(value2Exp);
    form.controls.value2Exp = value2Exp;

    value2Exp.action = function () {
        form.applyPropertiesToDataFilter("Value2Exp", this.textBox.value);
    }

    //Value2Date
    var value2Date = this.DateControl("elementDataFiltersValue2Date", 140, null, true);
    valueTable2.addCell(value2Date);
    form.controls.value2Date = value2Date;

    value2Date.action = function () {
        form.applyPropertiesToDataFilter("Value2Date", jsObject.formatDate(this.key, "MM/dd/yyyy"));
    }

    //Expression
    var expression = this.CheckBox(null, this.loc.PropertyMain.Expression);
    expression.style.marginLeft = "8px";
    valueTable.addCell(expression);
    form.controls.expression = expression;

    expression.action = function () {
        var itemObject = filtersBlock.container.selectedItem ? filtersBlock.container.selectedItem.itemObject : null;
        if (itemObject) {
            if (this.isChecked) {
                valueExp.textBox.value = jsObject.ColumnIsDateType(itemObject.type) ? valueDate.textBox.value : value.textBox.value;
                value2Exp.textBox.value = jsObject.ColumnIsDateType(itemObject.type) ? value2Date.textBox.value : value2.textBox.value;
            }
            else if (!jsObject.ColumnIsDateType(itemObject.type)) {
                value.textBox.value = valueExp.textBox.value;
                value2.textBox.value = value2Exp.textBox.value;
            }
        }
        form.updateControlsVisibleStates();
        form.applyPropertiesToDataFilter("Expression", this.isChecked);
    }

    condition.updateItems = function (filterObject) {
        this.setEnabled(filterObject != null);

        if (filterObject) {
            var conditionItems = [];

            if (jsObject.ColumnIsNumericType(filterObject.type)) {
                conditionItems = jsObject.GetFilterConditionItems("Numeric", false);
            }
            else if (jsObject.ColumnIsDateType(filterObject.type)) {
                conditionItems = jsObject.GetFilterConditionItems("DateTime", false);
            }
            else if (filterObject.type == "bool") {
                conditionItems = jsObject.GetFilterConditionItems("Boolean", false);
            }
            else {
                conditionItems = jsObject.GetFilterConditionItems("String", false, true);
            }
            this.addItems(conditionItems);
        }
    }

    form.updateControlsVisibleStates = function () {
        var filterObject = filtersBlock.container.selectedItem ? filtersBlock.container.selectedItem.itemObject : null;
        var hideValues = condition.key == "IsNull" || condition.key == "IsNotNull" || condition.key == "IsBlank" || condition.key == "IsNotBlank";
        var showValue2 = !hideValues && (condition.key == "Between" || condition.key == "NotBetween");
        var isExpression = form.controls.expression.isChecked;
        var showDateControls = filterObject && jsObject.ColumnIsDateType(filterObject.type);

        form.controls.operation.style.display = form.controls.operationText.style.display = form.elementProperties && form.elementProperties.tableFiltersGroupsType != "None" && !form.isUserFilters ? "" : "none";
        form.controls.operationMessage.style.display = form.elementProperties && form.elementProperties.tableFiltersGroupsType == "Complex" && !form.isUserFilters ? "" : "none";
        form.controls.valueTableRow.style.display = !hideValues ? "" : "none";
        form.controls.value.style.display = !isExpression && !showDateControls ? "" : "none";
        form.controls.valueDate.style.display = !isExpression && showDateControls ? "" : "none";
        form.controls.valueExp.style.display = isExpression ? "" : "none";
        form.controls.valueTableText.innerHTML = showValue2 ? jsObject.loc.PropertyMain.From : jsObject.loc.PropertyMain.Value;
        form.controls.valueTable2Row.style.display = showValue2 ? "" : "none";
        form.controls.value2.style.display = !isExpression && !showDateControls ? "" : "none";
        form.controls.value2Date.style.display = !isExpression && showDateControls ? "" : "none";
        form.controls.value2Exp.style.display = isExpression ? "" : "none";
    }

    form.updateControls = function (elementProperties) {
        if (!elementProperties) return;
        form.elementProperties = elementProperties;
        filtersBlock.container.updateFilters(elementProperties.filters, filtersBlock.container.getSelectedItemIndex());
        operation.setKey(elementProperties.operation);
        form.updateControlsVisibleStates();
    }

    form.checkStartMode = function () {
        var itemsCount = filtersBlock.container.getCountItems();

        if (itemsCount == 0) {
            form.container.appendChild(filtersBlock.container);
            controlsTable.style.display = "none";
            filtersBlock.container.style.height = filtersBlock.container.style.maxHeight = "260px";
            filtersBlock.container.style.width = "267px";
            filtersBlock.container.style.margin = "6px 12px 6px 12px";
        }
        else {
            parentFiltersContainer.appendChild(filtersBlock.container);
            controlsTable.style.display = "";
            filtersBlock.container.style.height = "auto";
            filtersBlock.container.style.width = "auto";
            filtersBlock.container.style.margin = "0";
            filtersBlock.container.style.maxHeight = "100px";
        }
    }

    form.show = function (currentElement, isUserFilters) {
        form.caption.innerHTML = isUserFilters ? jsObject.loc.Dashboard.CustomFilter.replace("&", "").replace("...", "") : jsObject.loc.PropertyMain.Filters;
        form.changeVisibleState(true);
        form.currentElement = currentElement;
        form.isUserFilters = isUserFilters;
        form.currentPanelName = jsObject.options.propertiesPanel.getCurrentPanelName();
        if (jsObject.options.showDictionary) jsObject.options.propertiesPanel.showContainer("Dictionary");

        addFilter.setEnabled(!isUserFilters);
        filtersBlock.container.clear();
        condition.setKey("EqualTo");
        operation.setKey("AND");
        value.setKey("");
        value2.setKey("");
        expression.setChecked(false);
        form.updateControlsVisibleStates();
        form.checkStartMode();

        form.sendCommand({ command: "GetElementDataFiltersProperties", isUserFilters: isUserFilters },
            function (answer) {
                form.updateControls(answer.elementProperties);
                form.checkStartMode();
                if (filtersBlock.container.getCountItems() > 0) {
                    filtersBlock.container.getItemByIndex(0).select();
                }
            }
        );
    }

    form.onhide = function () {
        jsObject.options.propertiesPanel.showContainer(form.currentPanelName);
        form.currentElement.properties[form.isUserFilters ? "userFiltersIsPresent" : "dataFiltersIsPresent"] = form.elementProperties.filters.length > 0;
        form.currentElement.repaint();
    }

    form.getSelectedItem = function () {
        return filtersBlock.container.selectedItem;
    }

    form.applyPropertiesToDataFilter = function (propertyName, propertyValue) {
        var itemIndex = filtersBlock.container.getSelectedItemIndex();
        if (itemIndex != null) {
            form.sendCommand({ command: "SetPropertyValue", propertyName: propertyName, propertyValue: propertyValue, itemIndex: itemIndex, isUserFilters: form.isUserFilters },
                function (answer) {
                    form.updateControls(answer.elementProperties);
                    form.updateSvgContent(answer.elementProperties.svgContent);
                }
            );
        }
    }

    form.sendCommand = function (updateParameters, callbackFunction) {
        jsObject.SendCommandToDesignerServer("UpdateElementDataFilters",
            {
                componentName: form.currentElement.properties.name,
                updateParameters: updateParameters
            },
            function (answer) {
                callbackFunction(answer);
            });
    }

    form.updateSvgContent = function (svgContent) {
        this.currentElement.properties.svgContent = svgContent;
        this.currentElement.repaint();
    }

    return form;
}

StiMobileDesigner.prototype.FiltersDataColumnsBlock = function (form, contextMenu, containerName, headerText, multiItems) {
    var jsObject = this;
    var block = this.DashboardDataColumnsBlock(form, contextMenu, containerName, headerText, multiItems);
    var container = block.container;
    container.showCheckBoxes = true;

    container.updateFilters = function (filters, selectedIndex) {
        var oldScrollTop = this.scrollTop;
        this.style.height = this.offsetHeight + "px";
        this.clear();
        for (var i = 0; i < filters.length; i++) {
            var item = this.addItem(filters[i].label, null, filters[i]);
            if (item.captionContainer) item.captionContainer.style.maxWidth = "240px";
            if (item.checkBox) {
                item.checkBox.setChecked(filters[i].isEnabled);
                item.caption.style.opacity = filters[i].isEnabled ? "1" : "0.5";

                item.checkBox.action = function () {
                    if (!this.item.isSelected) this.item.action();
                    form.applyPropertiesToDataFilter("IsEnabled", this.isChecked);
                }
            }
        }
        if (selectedIndex != null && selectedIndex < filters.length && selectedIndex >= 0) {
            this.childNodes[selectedIndex].select();
        }
        this.scrollTop = oldScrollTop;
        this.style.height = "auto";
        this.style.paddingBottom = (multiItems && this.getCountItems() > 0) ? "30px" : "0px";
    }

    container.onAction = function () {
        if (this.selectedItem) {
            var itemObject = this.selectedItem.itemObject;
            form.controls.condition.updateItems(itemObject);
            form.controls.condition.setKey(itemObject.condition);
            form.controls.expression.setChecked(itemObject.isExpression);
            form.controls.field.textBox.value = itemObject.path;

            if (itemObject.isExpression) {
                form.controls.valueExp.textBox.value = itemObject.value;
                form.controls.value2Exp.textBox.value = itemObject.value2;
            }
            else if (jsObject.ColumnIsDateType(itemObject.type)) {
                form.controls.valueDate.setKey(itemObject.value ? new Date(itemObject.value) : new Date());
                form.controls.value2Date.setKey(itemObject.value2 ? new Date(itemObject.value2) : new Date());
            }
            else {
                form.controls.value.setKey(itemObject.value != null ? itemObject.value : "");
                form.controls.value2.setKey(itemObject.value2 != null ? itemObject.value2 : "");
                form.controls.value.updateItems(itemObject);
                form.controls.value2.updateItems(itemObject);
            }
            form.updateControlsVisibleStates();
        }
    }

    container.onmouseup = function (event) {
        if (event.button == 2) {
            //context menu
            event.stopPropagation();
            if (contextMenu && !form.isUserFilters) {
                var point = jsObject.FindMousePosOnMainPanel(event);
                contextMenu.currentContainer = container;
                contextMenu.show(point.xPixels + 3, point.yPixels + 3, "Down", "Right");
            }
            return false;
        }
        else if (jsObject.options.itemInDrag && !form.isUserFilters) {
            var itemObject = jsObject.CopyObject(jsObject.options.itemInDrag.originalItem.itemObject);
            if (!itemObject) return;
            var typeItem = itemObject.typeItem;

            if (typeItem == "FilterRule") {
                var toIndex = this.getOverItemIndex();
                var fromIndex = container.getItemIndex(jsObject.options.itemInDrag.originalItem);
                var commandName = jsObject.options.CTRL_pressed ? "MoveAndDuplicateFilter" : "MoveFilter";

                if (toIndex != null && fromIndex != null && fromIndex != toIndex) {
                    var params = {
                        command: commandName,
                        toIndex: toIndex,
                        fromIndex: fromIndex
                    };

                    form.sendCommand(params,
                        function (answer) {
                            container.updateFilters(answer.elementProperties.filters);
                            var selectedIndex = toIndex != null ? toIndex : container.getCountItems();
                            container.updateFilters(answer.elementProperties.filters, selectedIndex);
                            form.updateSvgContent(answer.elementProperties.svgContent);
                            form.checkStartMode();
                        }
                    );
                }
            }
            else if (typeItem == "Column" || typeItem == "DataSource" || typeItem == "BusinessObject") {
                var draggedItem = {
                    itemObject: itemObject
                };

                if (typeItem == "Column") {
                    var columnParent = jsObject.options.dictionaryTree.getCurrentColumnParent();
                    if (columnParent) {
                        draggedItem.currentParentType = columnParent.type;
                        draggedItem.currentParentName = (columnParent.type == "BusinessObject") ? jsObject.options.itemInDrag.originalItem.getBusinessObjectFullName() : columnParent.name;
                    }
                }
                else {
                    draggedItem.currentParentType = typeItem;
                    draggedItem.currentParentName = itemObject.name;
                }

                var params = {
                    command: "InsertFilters",
                    draggedItem: draggedItem
                }

                if (typeItem == "Column") {
                    params.insertIndex = this.getOverItemIndex();
                }

                form.sendCommand(params,
                    function (answer) {
                        var insertIndex = params.insertIndex != null ? params.insertIndex : answer.elementProperties.filters.length - 1;
                        container.updateFilters(answer.elementProperties.filters, insertIndex);
                        form.updateControls(answer.elementProperties);
                        form.updateSvgContent(answer.elementProperties.svgContent);
                        form.checkStartMode();
                        form.correctHeight();
                        form.correctTopPosition();
                    }
                );
            }
        }

        return false;
    }

    container.onRemove = function (itemIndex) {
        form.sendCommand({ command: "RemoveFilter", itemIndex: itemIndex, isUserFilters: form.isUserFilters },
            function (answer) {
                container.updateMeters(answer.elementProperties.filters, container.getSelectedItemIndex());
                form.updateControls(answer.elementProperties);
                form.updateSvgContent(answer.elementProperties.svgContent);
                form.checkStartMode();
            }
        );
    }

    container.oncontextmenu = function (event) {
        return false;
    }

    return block;
}