﻿
StiMobileDesigner.prototype.InitializeEditNumberBoxElementForm_ = function () {
    var form = this.DashboardBaseForm("editNumberBoxElementForm", this.loc.Components.StiNumberBox, 1, this.GetHelpLink("numberBoxElement"));
    form.isDockableToComponent = true;
    form.container.style.borderTop = "0px";
    form.caption.style.padding = "0px 10px 0 12px";
    form.hideButtonsPanel();
    var jsObject = this;

    var controlsTable = this.CreateHTMLTable();
    controlsTable.style.width = "330px";

    form.container.appendChild(controlsTable);
    form.container.style.padding = "0 0 6px 0";

    //field
    var field = this.ExpressionControlWithMenu(null, 354, null, null, true, false, true, true, null, null, null, true);
    var fieldMenu = this.options.menus.numberBoxFieldMenu || this.InitializeFilterElementFieldMenu("numberBoxFieldMenu", field, form, true, "numeric");
    field.menu = fieldMenu;
    fieldMenu.parentButton = field.button;
    field.textBox.setAttribute("placeholder", jsObject.loc.PropertyMain.Field);

    //DataColumns
    var dataColumns = [
        ["value", this.loc.PropertyMain.Value]
    ];

    for (var i = 0; i < dataColumns.length; i++) {
        var container = this.DashboardDataColumnContainer(form, dataColumns[i][0], dataColumns[i][1], null, null, fieldMenu);
        container.allowSelected = true;
        container.maxWidth = 360;
        form.addControlRow(controlsTable, null, dataColumns[i][0] + "DataColumn", container, "0px 12px " + (i == dataColumns.length - 1 ? "12px" : "0px" + " 12px"));

        container.action = function (actionName) {
            if (actionName == "rename" && this.dataColumnObject) {
                form.sendCommand({
                    command: "RenameMeter",
                    containerName: form.jsObject.UpperFirstChar(this.name),
                    newLabel: this.dataColumnObject.label
                },
                    function (answer) {
                        form.updateControls(answer.elementProperties);
                        form.updateElementProperties(answer.elementProperties);
                        form.updateSvgContent(answer.elementProperties.svgContent);
                    }
                );
                return;
            }
            if (!this.dataColumnObject) {
                form.controls.field.currentContainer = null;
                form.controls.field.textBox.value = "";
                form.controls.field.setEnabled(false);
            }
            else if (!jsObject.IsNumericColumn(this.dataColumnObject.type)) {
                this.dataColumnObject = null;
                var errorMessageForm = jsObject.options.forms.errorMessageForm || jsObject.InitializeErrorMessageForm();
                errorMessageForm.show(jsObject.loc.Dashboard.FieldTypeRestrictionHint.replace("{0}", jsObject.loc.FormFormatEditor.Number), true);
            }
            form.applyDataColumnPropertyToNumberBoxElement(this);
        }

        container.onSelected = function () {
            for (var i = 0; i < dataColumns.length; i++) {
                if (form.controls[dataColumns[i][0] + "DataColumn"] != this)
                    form.controls[dataColumns[i][0] + "DataColumn"].setSelected(false);
            }
            if (this.dataColumnObject) {
                form.controls.field.currentContainer = this;
                form.controls.field.setEnabled(true);
                form.controls.field.textBox.value = this.dataColumnObject.expression;
            }
        }
    }

    var parentValueContainer = form.controls.valueDataColumn.innerContainer.parentElement;

    form.addControlRow(controlsTable, this.loc.PropertyMain.Field, "fieldCaption", null, "6px 12px 6px 12px");
    form.addControlRow(controlsTable, null, "field", field, "6px 12px 6px 12px");

    //SelectionMode
    var selectionMode = this.DropDownList("numberBoxElementSelectionMode", 180, null, this.GetNumberBoxSelectionModeItems(), true, null, null, true);
    form.addControlRow(controlsTable, this.loc.PropertyMain.SelectionMode, "selectionMode", selectionMode, "6px 12px 6px 12px", null, true, null, true);
    selectionMode.action = function () {
        form.updateControlsVisibleStates();
        form.applyPropertiesToNumberBoxElement("SelectionMode", this.key);
    }

    //Condition
    var condition = this.DropDownList("numberBoxElementCondition", 180, null, this.GetDateConditionItems(), true, null, null, true);
    form.addControlRow(controlsTable, this.loc.PropertyMain.Condition, "condition", condition, "6px 12px 6px 12px", null, true, null, true);
    condition.action = function () {
        form.updateControlsVisibleStates();
        form.applyPropertiesToNumberBoxElement("Condition", this.key);
    }

    //Initial Values Table
    var initialValuesTable = this.CreateHTMLTable();
    form.addControlRow(controlsTable, this.loc.Dashboard.InitialValue, "initialValuesTable", initialValuesTable, "6px 12px 6px 12px", null, true, null, true);
    initialValuesTable.parentNode.style.textAlign = "right";

    var initialValue = this.ExpressionControl(null, 79, null, null, true, null, null, false, ["Variable", "Expression", "15"], null, 40);
    initialValuesTable.addCell(initialValue);
    initialValue.action = function () {
        form.applyPropertiesToNumberBoxElement("InitialValue", StiBase64.encode(this.textBox.value));
    }

    var ititialValMiddleCell = initialValuesTable.addTextCellInLastRow(" - ");
    ititialValMiddleCell.style.padding = "7px 5px 7px 5px";

    var initialToValue = this.ExpressionControl(null, 79, null, null, true, null, null, false, ["Variable", "Expression", "15"], null, 40);
    initialValuesTable.addCell(initialToValue);
    initialToValue.action = function () {
        form.applyPropertiesToNumberBoxElement("InitialToValue", StiBase64.encode(this.textBox.value));
    }

    initialValuesTable.setToRangeMode = function (state) {
        ititialValMiddleCell.style.display = initialToValue.parentElement.style.display = state ? "" : "none";
        var buttonWidth = jsObject.options.controlsButtonsWidth;
        var textBoxWidth = (state ? 79 : 180) - (buttonWidth + 2);
        initialValue.textBox.style.width = initialToValue.textBox.style.width = textBoxWidth + "px";
    }

    //MinMaxMode
    var minMaxMode = this.DropDownList("numberBoxElementMinMaxMode", 180, null, this.GetMinMaxModeItems(), true, null, null, true);
    form.addControlRow(controlsTable, this.loc.PropertyMain.Minimum + " - " + this.loc.PropertyMain.Maximum, "minMaxMode", minMaxMode, "6px 12px 6px 12px", null, true, null, true);

    minMaxMode.action = function () {
        form.updateControlsVisibleStates();
        form.applyPropertiesToNumberBoxElement("MinMaxMode", this.key);
    }

    //Min Max
    var minMaxTable = this.CreateHTMLTable();
    minMaxTable.style.maxWidth = "150px";
    minMaxTable.addTextCell(this.loc.PropertyMain.Minimum).className = "stiDesignerTextContainer";
    minMaxTable.addCell();
    minMaxTable.addTextCell(this.loc.PropertyMain.Maximum).className = "stiDesignerTextContainer";
    form.addControlRow(controlsTable, " ", "minMaxTable", minMaxTable, "6px 12px 6px 12px", null, true, null, true);

    var minControl = this.ExpressionControl(null, 79, null, null, true, null, null, false, ["Variable", "Expression", "15"], null, 40);
    minMaxTable.addCellInNextRow(minControl);

    minControl.action = function () {
        form.applyPropertiesToNumberBoxElement("Min", StiBase64.encode(this.textBox.value));
    }

    minMaxTable.addTextCellInLastRow(" - ").style.padding = "7px 5px 7px 5px";
    var maxControl = this.ExpressionControl(null, 79, null, null, true, null, null, false, ["Variable", "Expression", "15"], null, 40);
    minMaxTable.addCellInLastRow(maxControl);

    maxControl.action = function () {
        form.applyPropertiesToNumberBoxElement("Max", StiBase64.encode(this.textBox.value));
    }

    form.setValues = function () {
        selectionMode.setKey(this.numberBoxProperties.selectionMode);
        condition.setKey(this.numberBoxProperties.conditionNumberBox);
        minMaxMode.setKey(this.numberBoxProperties.minMaxMode);
        initialValue.textBox.value = StiBase64.decode(this.numberBoxProperties.initialValue);
        initialToValue.textBox.value = StiBase64.decode(this.numberBoxProperties.initialToValue);
        minControl.textBox.value = StiBase64.decode(this.numberBoxProperties.min);
        maxControl.textBox.value = StiBase64.decode(this.numberBoxProperties.max);

        var meters = this.numberBoxProperties.meters;

        for (var i = 0; i < dataColumns.length; i++) {
            var meter = meters[dataColumns[i][0]];
            var container = this.controls[dataColumns[i][0] + "DataColumn"];

            if (meter) {
                container.addColumn(meter.label, meter);
                if (container.isSelected && container.item) container.item.action();
            }
            else
                container.clear();
        }
    }

    form.checkStartMode = function () {
        var itemsCount = 0;
        for (var i = 0; i < dataColumns.length; i++) {
            var container = form.controls[dataColumns[i][0] + "DataColumn"];
            if (container.dataColumnObject) itemsCount++;
        }

        var valueContainer = form.controls.valueDataColumn.innerContainer;

        if (itemsCount == 0) {
            form.container.appendChild(valueContainer);
            controlsTable.style.display = "none";
            valueContainer.style.height = valueContainer.style.maxHeight = "210px";
            valueContainer.style.width = "267px";
            valueContainer.style.margin = "6px 12px 6px 12px";
        }
        else {
            parentValueContainer.appendChild(valueContainer);
            controlsTable.style.display = "";
            valueContainer.style.height = "30px";
            valueContainer.style.width = "auto";
            valueContainer.style.margin = "0";
        }
    }

    form.onshow = function () {
        form.currentPanelName = jsObject.options.propertiesPanel.getCurrentPanelName();
        if (jsObject.options.showDictionary) jsObject.options.propertiesPanel.showContainer("Dictionary");

        selectionMode.setKey("Single");
        condition.setKey("GreaterThanOrEqualTo");
        minMaxMode.setKey("Auto");
        initialValue.textBox.value = "";
        initialToValue.textBox.value = "";
        minControl.textBox.value = "";
        maxControl.textBox.value = "";

        field.textBox.value = "";
        field.setEnabled(false);

        for (var i = 0; i < dataColumns.length; i++) {
            var container = this.controls[dataColumns[i][0] + "DataColumn"];
            container.clear();
        }

        form.controls.valueDataColumn.setSelected(true);
        form.checkStartMode();

        form.sendCommand({ command: "GetNumberBoxElementProperties" },
            function (answer) {
                form.updateControls(answer.elementProperties);
                form.checkStartMode();
                form.correctHeight();
                form.correctTopPosition();
            }
        );
    }

    form.onhide = function () {
        jsObject.options.propertiesPanel.showContainer(form.currentPanelName);
    }

    form.updateControlsVisibleStates = function () {
        var isVariablePresent = form.numberBoxProperties.isVariablePresent;
        var isRangeVariablePresent = form.numberBoxProperties.isRangeVariablePresent;
        if (isVariablePresent) form.controls.selectionMode.setKey(isRangeVariablePresent ? "Range" : "Single");
        form.controls.selectionModeRow.style.display = !isVariablePresent ? "" : "none";
        form.controls.conditionRow.style.display = selectionMode.key == "Single" && !isVariablePresent ? "" : "none";
        initialValuesTable.setToRangeMode(isRangeVariablePresent || selectionMode.key == "Range");
        minMaxTable.style.display = minMaxMode.key == "Custom" ? "" : "none";
    }

    form.updateControls = function (numberBoxProperties) {
        if (!numberBoxProperties) return;
        form.numberBoxProperties = numberBoxProperties;
        form.setValues();
        form.updateControlsVisibleStates();
    }

    form.applyDataColumnPropertyToNumberBoxElement = function (container) {
        form.sendCommand(
            {
                command: "SetDataColumn",
                containerName: jsObject.UpperFirstChar(container.name),
                dataColumnObject: container.dataColumnObject
            },
            function (answer) {
                form.updateControls(answer.elementProperties);
                form.updateSvgContent(answer.elementProperties.svgContent);
                if (container.item) container.item.action();
                form.checkStartMode();
            }
        );
    }

    form.applyPropertiesToNumberBoxElement = function (propertyName, propertyValue) {
        form.sendCommand({ command: "SetPropertyValue", propertyName: propertyName, propertyValue: propertyValue },
            function (answer) {
                form.updateControls(answer.elementProperties);
                form.updateElementProperties(answer.elementProperties);
                form.updateSvgContent(answer.elementProperties.svgContent);
            }
        );
    }

    form.sendCommand = function (updateParameters, callbackFunction) {
        jsObject.SendCommandToDesignerServer("UpdateNumberBoxElement",
            {
                componentName: form.currentNumberBoxElement.properties.name,
                updateParameters: updateParameters
            },
            function (answer) {
                callbackFunction(answer);
            });
    }

    form.updateSvgContent = function (svgContent) {
        this.currentNumberBoxElement.properties.svgContent = svgContent;
        this.currentNumberBoxElement.repaint();
    }

    form.updateElementProperties = function (properties) {
        var jsObject = this.jsObject;
        for (var propertyName in properties) {
            this.currentNumberBoxElement.properties[propertyName] = properties[propertyName];
        }
        jsObject.options.homePanel.updateControls();
        if (jsObject.options.propertiesPanel) jsObject.options.propertiesPanel.updateControls();
    }

    return form;
}