/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.webdesigner.blockly.blocks;

import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.blockly.stiblocks.functions.StiBlocklyFunctionBlockKeyCache;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.dictionary.StiUserFunction;
import com.stimulsoft.report.dictionary.StiUserFunctionArgument;
import com.stimulsoft.report.dictionary.StiUserFunctionArgumentType;
import com.stimulsoft.webdesigner.blockly.blocks.StiBlocklyBlock;
import com.stimulsoft.webdesigner.blockly.blocks.StiBlocklyDummyInput;
import com.stimulsoft.webdesigner.blockly.blocks.StiBlocklyField;
import com.stimulsoft.webdesigner.blockly.blocks.StiBlocklyValueInput;
import java.util.List;
import java.util.stream.Collectors;

public class StiUserFunctionBlocklyBlock
extends StiBlocklyBlock {
    public StiUserFunction userFunction;

    @Override
    public String getTooltip() {
        String informationText = this.userFunction.getName() + " \\n\\n ";
        String description = this.userFunction.getDescription();
        List argumentDescriptions = this.userFunction.getArguments().stream().map(u -> u.getDescription()).collect(Collectors.toList());
        List argumentNames = this.userFunction.getArguments().stream().map(u -> u.getName()).collect(Collectors.toList());
        List argumentTypes = this.userFunction.getArguments().stream().map(u -> u.getType()).collect(Collectors.toList());
        StiUserFunctionArgumentType returnDescription = this.userFunction.getReturnType();
        informationText = informationText + description + " \\n\\n ";
        if (argumentNames != null && argumentNames.size() > 0) {
            informationText = informationText + " " + StiLocalization.Get((String)"PropertyMain", (String)"Parameters") + " \\n\\n ";
            int argIndex = 0;
            for (String arg : argumentNames) {
                if (argumentDescriptions != null && argIndex < argumentDescriptions.size() && !StiValidationUtil.isNullOrEmpty((String)((String)argumentDescriptions.get(argIndex)))) {
                    informationText = informationText + " " + arg + " - " + ((String)argumentDescriptions.get(argIndex)).replace("\"", "").replace("\r\n", "").replace("\n", "").toLowerCase() + "  \\n\\n ";
                    ++argIndex;
                    continue;
                }
                informationText = informationText + arg + " \\n\\n ";
            }
        }
        informationText = informationText + " \\n\\n " + StiLocalization.Get((String)"PropertyMain", (String)"ReturnValue") + " \\n\\n " + returnDescription;
        return informationText;
    }

    public StiUserFunctionBlocklyBlock(StiUserFunction userFunction) {
        this.id = StiBlocklyFunctionBlockKeyCache.createKey((StiUserFunction)userFunction);
        this.userFunction = userFunction;
        this.name = userFunction.getName();
        StiBlocklyDummyInput dummyInput = new StiBlocklyDummyInput();
        dummyInput.fields.add(new StiBlocklyField(userFunction.getName()));
        this.valueInputs.add(dummyInput);
        for (StiUserFunctionArgument item : userFunction.getArguments()) {
            StiBlocklyValueInput valueInput = new StiBlocklyValueInput(item.name);
            valueInput.fields.add(new StiBlocklyField(item.name));
            this.valueInputs.add(valueInput);
        }
    }
}

