/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.webdesigner.blockly.blocks;

import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.system.type.StiSystemType;
import com.stimulsoft.blockly.stiblocks.functions.StiBlocklyFunctionBlockKeyCache;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.dictionary.functions.StiFunction;
import com.stimulsoft.report.enums.StiReportLanguageType;
import com.stimulsoft.webdesigner.blockly.blocks.StiBlocklyBlock;
import com.stimulsoft.webdesigner.blockly.blocks.StiBlocklyDummyInput;
import com.stimulsoft.webdesigner.blockly.blocks.StiBlocklyField;
import com.stimulsoft.webdesigner.blockly.blocks.StiBlocklyValueInput;

public class StiFunctionBlocklyBlock
extends StiBlocklyBlock {
    public StiFunction function;

    @Override
    public String getTooltip() {
        String informationText = this.function.GetLongFunctionString(StiReportLanguageType.CSharp) + " \\n\\n ";
        String description = this.function.getDescription();
        String[] argumentDescriptions = this.function.getArgumentDescriptions();
        String[] argumentNames = this.function.getArgumentNames();
        StiSystemType[] argumentTypes = this.function.getArgumentTypes();
        String returnDescription = this.function.getReturnDescription();
        informationText = informationText + description + " \\n\\n ";
        if (argumentNames != null && argumentNames.length > 0) {
            informationText = informationText + " " + StiLocalization.Get((String)"PropertyMain", (String)"Parameters") + " \\n\\n ";
            int argIndex = 0;
            for (String arg : argumentNames) {
                if (argumentDescriptions != null && argIndex < argumentDescriptions.length) {
                    if (argumentTypes != null && argumentTypes[argIndex].isList()) {
                        informationText = informationText + argumentDescriptions[argIndex++] + " \\n\\n ";
                        continue;
                    }
                    informationText = informationText + " " + arg + " - " + argumentDescriptions[argIndex++].replace("\"", "").replace("\r\n", "").replace("\n", "").toLowerCase() + "  \\n\\n ";
                    continue;
                }
                informationText = informationText + arg + " \\n\\n ";
            }
        }
        if (!StiValidationUtil.isNullOrEmpty((String)returnDescription)) {
            informationText = informationText + " \\n\\n " + StiLocalization.Get((String)"PropertyMain", (String)"ReturnValue") + " \\n\\n ";
            informationText = informationText + returnDescription;
        }
        return informationText;
    }

    public StiFunctionBlocklyBlock(StiFunction function) {
        this.id = StiBlocklyFunctionBlockKeyCache.createKey((StiFunction)function);
        this.function = function;
        this.name = function.getFunctionName();
        String functionStr = function.GetLongFunctionString(StiReportLanguageType.CSharp);
        StiBlocklyDummyInput dummyInput = new StiBlocklyDummyInput();
        dummyInput.fields.add(new StiBlocklyField(functionStr));
        this.valueInputs.add(dummyInput);
        for (String item : function.getArgumentNames()) {
            StiBlocklyValueInput valueInput = new StiBlocklyValueInput(item);
            valueInput.fields.add(new StiBlocklyField(item));
            this.valueInputs.add(valueInput);
        }
    }
}

