/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.webdesigner;

import com.stimulsoft.base.StiAttribute;
import com.stimulsoft.base.exception.StiException;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.licenses.StiLicenseKeyValidator;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.lib.utils.StiXmlUtil;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.components.textFormats.StiCustomFormatService;
import com.stimulsoft.report.components.textFormats.StiDateFormatService;
import com.stimulsoft.report.components.textFormats.StiFormatService;
import com.stimulsoft.report.components.textFormats.StiTimeFormatService;
import com.stimulsoft.report.options.DesignerOptions;
import com.stimulsoft.report.options.EngineOptions;
import com.stimulsoft.web.cache.StiCacheOptions;
import com.stimulsoft.web.classes.StiRequestParams;
import com.stimulsoft.web.enums.StiAction;
import com.stimulsoft.web.enums.StiComponentType;
import com.stimulsoft.web.enums.StiDesignerCommand;
import com.stimulsoft.web.helper.StiCacheHelper;
import com.stimulsoft.web.helper.StiLicenseHelper;
import com.stimulsoft.web.helper.StiReportResourceHelper;
import com.stimulsoft.web.helper.StiWebResourceHelper;
import com.stimulsoft.web.html.StiHtmlElement;
import com.stimulsoft.web.proxyee.StiHttpServletRequest;
import com.stimulsoft.web.proxyee.StiHttpServletResponse;
import com.stimulsoft.webdesigner.StiWebDesigerHandler;
import com.stimulsoft.webdesigner.StiWebDesigner;
import com.stimulsoft.webdesigner.StiWebDesignerHelper;
import com.stimulsoft.webdesigner.StiWebDesignerOptions;
import com.stimulsoft.webdesigner.enums.StiDesignerComponents;
import com.stimulsoft.webdesigner.enums.StiSaveMode;
import com.stimulsoft.webdesigner.helper.StiAggrigateFunctions;
import com.stimulsoft.webdesigner.helper.StiCodePageHelper;
import com.stimulsoft.webdesigner.helper.StiColorHelper;
import com.stimulsoft.webdesigner.helper.StiCultureHelper;
import com.stimulsoft.webdesigner.helper.StiDefaultConditions;
import com.stimulsoft.webdesigner.helper.StiDesignerResourcesHelper;
import com.stimulsoft.webdesigner.helper.StiFontNames;
import com.stimulsoft.webdesigner.helper.StiHatchStyles;
import com.stimulsoft.webdesigner.helper.StiIconSetArrays;
import com.stimulsoft.webdesigner.helper.StiPaperSizes;
import com.stimulsoft.webdesigner.helper.StiSummaryTypes;
import com.stimulsoft.webdesigner.helper.StiTextFormatHelper;
import com.stimulsoft.webdesigner.helper.StiWebDesignerOptionsHelper;
import com.stimulsoft.webdesigner.helper.StiWebFontIconsHelper;
import com.stimulsoft.webdesigner.servlet.StiWebDesignerActionServletHelper;
import com.stimulsoft.webviewer.helper.StiCollectionsHelper;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.ProcessingInstruction;

public class StiWebDesignerRender {
    protected static final Logger LOG = Logger.getLogger(StiWebDesignerRender.class.getName());
    public static final String VERSION = StiAttribute.getSimpleVersion();
    private StiWebDesignerOptions options;
    private String id;
    private String clientGuid = null;

    public StiWebDesignerRender(StiWebDesignerOptions options, URL context, StiHttpServletRequest request) {
        this.options = options;
        this.id = options.getDesignerID();
        StiCacheHelper.saveOptions((Object)((Object)options), (String)this.id, (StiHttpServletRequest)request);
        String localizationFileName = options.getLocalization();
        if (options.getLocalizationStream() != null) {
            try {
                StiLocalization localization = StiLocalization.load((InputStream)options.getLocalizationStream());
                StiLocalization.setLocalization((StiLocalization)localization);
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "", e);
            }
        } else if (StiValidationUtil.isNotNullOrEmpty((String)localizationFileName)) {
            File localizationFile = new File(localizationFileName);
            if (localizationFile.exists()) {
                try {
                    StiLocalization localization = StiLocalization.load((InputStream)new FileInputStream(localizationFile));
                    StiLocalization.setLocalization((StiLocalization)localization);
                }
                catch (FileNotFoundException e) {
                    LOG.log(Level.SEVERE, "", e);
                }
                catch (StiException e) {
                    LOG.log(Level.SEVERE, "", e);
                }
            } else {
                LOG.log(Level.SEVERE, "Unable to load localization file: " + localizationFile.getAbsolutePath());
            }
        }
    }

    public String getDesigner(URL context, Object handler, StiHttpServletRequest request, StiHttpServletResponse response, Object servletContext) throws IOException, DOMException, JSONException, ParserConfigurationException {
        String viewer = StiWebDesigner.createViewer(this.options, context, null, this.id);
        String className = handler instanceof StiWebDesigerHandler ? "javax.servlet.http.HttpServletRequest" : "jakarta.servlet.http.HttpServletRequest";
        StiReport report = null;
        try {
            Method method = handler.getClass().getMethod("getEditedReport", Class.forName(className));
            method.setAccessible(true);
            report = (StiReport)method.invoke(handler, request.getRequest());
        }
        catch (Exception method) {
            // empty catch block
        }
        StiWebDesigner.setupDesign(report);
        DocumentBuilderFactory docFactory = StiXmlUtil.getBuilderFactory();
        DocumentBuilder docBuilder = null;
        docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        ProcessingInstruction disableEscaping = doc.createProcessingInstruction("javax.xml.transform.disable-output-escaping", "");
        doc.appendChild(disableEscaping);
        Element rootPanel = StiHtmlElement.createPanelHtmlElement((Document)doc);
        doc.appendChild(rootPanel);
        Element mainPanel = StiHtmlElement.createPanelHtmlElement((Document)doc);
        StiHtmlElement.setID((Element)mainPanel, (String)(this.id + "_MainPanel"));
        StiHtmlElement.setCssClass((Element)mainPanel, (String)"stiDesignerMainPanel");
        rootPanel.appendChild(mainPanel);
        if (StiValidationUtil.isNullOrEmpty((String)this.options.getWidth()) && StiValidationUtil.isNullOrEmpty((String)this.options.getHeight())) {
            StiHtmlElement.addStyle((Element)rootPanel, (String)"position", (String)"absolute");
            StiHtmlElement.addStyle((Element)rootPanel, (String)"z-index", (String)"1000000");
            StiHtmlElement.addStyle((Element)rootPanel, (String)"top", (String)"0px");
            StiHtmlElement.addStyle((Element)rootPanel, (String)"left", (String)"0px");
            StiHtmlElement.addStyle((Element)rootPanel, (String)"right", (String)"0px");
            StiHtmlElement.addStyle((Element)rootPanel, (String)"bottom", (String)"0px");
        } else {
            StiHtmlElement.addStyle((Element)mainPanel, (String)"width", (String)this.options.getWidth());
            StiHtmlElement.addStyle((Element)mainPanel, (String)"height", (String)this.options.getHeight());
        }
        String url = StiValidationUtil.isNotNullOrEmpty((String)this.options.getServer().getController()) ? this.options.getServer().getController() : context.toString();
        Element scriptEngine = StiHtmlElement.createJavascriptHtmlElement((Document)doc);
        scriptEngine.setAttribute("src", this.getResourcesUrl(context) + "DesignerScripts");
        rootPanel.appendChild(scriptEngine);
        Element scriptInit = StiHtmlElement.createJavascriptHtmlElement((Document)doc);
        scriptInit.setTextContent(String.format("var js%s = new StiMobileDesigner(%s);", this.id, this.renderJsonParameters(rootPanel, doc, context, report, request, response, handler, servletContext)));
        rootPanel.appendChild(scriptInit);
        StiHtmlElement.setID((Element)rootPanel, (String)this.id);
        return StiWebDesignerRender.serialize(doc, true) + viewer;
    }

    public String getResourcesUrl(URL context) {
        String url = StiValidationUtil.isNotNullOrEmpty((String)this.options.getServer().getController()) ? this.options.getServer().getController() : context.toString();
        return url + "/" + StiWebDesignerActionServletHelper.AJAX_SERVLET_MAPPING + "?stiweb_component=Designer&stiweb_version=" + VERSION + "&stiweb_action=Resource&a=DesignerEvent&stiweb_data=";
    }

    protected String renderJsonParameters(Element root, Document doc, URL context, StiReport report, StiHttpServletRequest request, StiHttpServletResponse response, Object handler, Object servletContext) throws IOException, JSONException {
        boolean isTrial;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        StiRequestParams requestParams = StiWebDesignerHelper.getRequestParams(request, response, null);
        if (requestParams.component != StiComponentType.Designer) {
            requestParams = StiWebDesigner.createRequestParams(this.options, this.id, this.getClientGuid());
        }
        if (requestParams.action == StiAction.RunCommand && requestParams.designer.command == StiDesignerCommand.SetLocalization) {
            this.options.setLocalization(requestParams.localization);
        }
        StiCollectionsHelper.loadLocalizationFile((StiHttpServletRequest)requestParams.httpContext, (String)this.options.getLocalizationDirectory(), (String)this.options.getLocalization());
        String productVersion = StiAttribute.getVersion().trim().replace(", Java", "");
        boolean bl = isTrial = !StiLicenseKeyValidator.isValidOnJavaFramework(null);
        if (!isTrial) {
            productVersion = productVersion + " ";
        }
        parameters.put("isJava", System.getProperty("java.runtime.version"));
        parameters.put("mobileDesignerId", this.id);
        parameters.put("viewerId", this.id + "Viewer");
        parameters.put("demoMode", false);
        parameters.put("demoVersion", !StiLicenseKeyValidator.isValidOnJavaFramework(null));
        parameters.put("theme", this.options.getTheme().name());
        parameters.put("cultureName", StiLocalization.getLocalizationCultureName());
        parameters.put("productVersion", productVersion);
        parameters.put("frameworkType", "Java");
        parameters.put("alternateValid", StiLicenseHelper.checkAnyLicense());
        parameters.put("buildDate", StiAttribute.CREATED.toString("MM/dd/yyyy hh:mm:ss a"));
        parameters.put("clientGuid", this.getClientGuid());
        parameters.put("reportGuid", this.getClientGuid());
        String url = StiValidationUtil.isNotNullOrEmpty((String)this.options.getServer().getController()) ? this.options.getServer().getController() : context.toString();
        String resourcesUrl = this.getResourcesUrl(context);
        parameters.put("useCompression", this.options.getServer().isUseCompression());
        parameters.put("passQueryParametersForResources", this.options.getServer().isPassQueryParametersForResources());
        parameters.put("requestUrl", url + "/" + StiWebDesignerActionServletHelper.AJAX_SERVLET_MAPPING + "?a={action}");
        parameters.put("stylesUrl", StiValidationUtil.isNullOrEmpty((String)this.options.getAppearance().getCustomCss()) ? resourcesUrl.replace("&stiweb_data=", "&stiweb_theme=") + this.options.getTheme().name() : this.options.getAppearance().getCustomCss());
        parameters.put("scriptsUrl", resourcesUrl);
        parameters.put("imagesUrl", resourcesUrl);
        parameters.put("requestHeaderContentType", this.options.getRequestHeaderContentType());
        parameters.put("cacheMode", "Page");
        parameters.put("requestTimeout", this.options.getServer().getRequestTimeout());
        parameters.put("cacheTimeout", "00:00:10");
        parameters.put("cacheItemPriority", "Default");
        parameters.put("showAnimation", this.options.getAppearance().isShowAnimation());
        parameters.put("defaultUnit", this.options.getAppearance().getDefaultUnit());
        parameters.put("focusingX", this.options.getBehavior().isFocusingX());
        parameters.put("focusingY", this.options.getBehavior().isFocusingY());
        parameters.put("helpLanguage", "ru".equals(StiLocalization.getLocalizationCultureName()) ? "ru" : "en");
        parameters.put("showSaveDialog", this.options.getBehavior().isShowSaveDialog());
        parameters.put("fullScreenMode", StiValidationUtil.isNullOrEmpty((String)this.options.getWidth()) && StiValidationUtil.isNullOrEmpty((String)this.options.getHeight()));
        parameters.put("haveSaveEvent", !this.options.getBehavior().isSaveWithBrowser() && this.options.getBehavior().getSaveReportMode() == StiSaveMode.Hidden);
        parameters.put("haveSaveAsEvent", !this.options.getBehavior().isSaveWithBrowser() && this.options.getBehavior().getSaveReportAsMode() == StiSaveMode.Hidden);
        parameters.put("showTooltips", this.options.getAppearance().isShowTooltips());
        parameters.put("showTooltipsHelp", this.options.getAppearance().isShowTooltipsHelp());
        parameters.put("showDialogHelp", this.options.getAppearance().isShowDialogsHelp());
        parameters.put("interfaceType", this.options.getAppearance().getInterfaceType());
        parameters.put("undoMaxLevel", this.options.getBehavior().getUndoMaxLevel());
        parameters.put("resourceIdent", "resource://");
        parameters.put("variableIdent", "variable://");
        parameters.put("blocklyIdent", "<xml xmlns=\"https://developers.google.com/blockly/xml\">");
        parameters.put("defaultDesignerOptions", StiWebDesignerOptionsHelper.getDefaultDesignerOptions());
        parameters.put("showPropertiesWhichUsedFromStyles", DesignerOptions.PropertyGrid.isShowPropertiesWhichUsedFromStyles());
        parameters.put("runWizardAfterLoad", StiOptions.Designer.getRunWizardAfterLoad());
        parameters.put("datePickerFirstDayOfWeek", this.options.getAppearance().getDatePickerFirstDayOfWeek());
        parameters.put("reportResourcesMaximumSize", EngineOptions.ReportResources.MaximumSize);
        parameters.put("allowChangeWindowTitle", this.options.getBehavior().isAllowChangeWindowTitle());
        parameters.put("saveReportMode", (Object)this.options.getBehavior().getSaveReportMode());
        parameters.put("saveReportAsMode", (Object)this.options.getBehavior().getSaveReportAsMode());
        parameters.put("checkReportBeforePreview", this.options.getBehavior().isCheckReportBeforePreview());
        parameters.put("defaultCompilationAccess", "Deny");
        if (this.options.getToolbar().componentsIntoInsertTab != null) {
            ArrayList<StiDesignerComponents> componentsArray = new ArrayList<StiDesignerComponents>();
            componentsArray.addAll(Arrays.asList(this.options.getToolbar().componentsIntoInsertTab));
            parameters.put("componentsIntoInsertTab", componentsArray);
        }
        parameters.put("loc", new JSONObject(StiLocalization.getLocalization().languageProp).toString());
        parameters.put("locFiles", StiCollectionsHelper.getLocalizationsList((StiHttpServletRequest)requestParams.httpContext, (String)this.options.getLocalizationDirectory()));
        parameters.put("images", StiDesignerResourcesHelper.getImagesArray(requestParams, resourcesUrl, false));
        parameters.put("paperSizes", StiPaperSizes.getItems());
        parameters.put("hatchStyles", StiHatchStyles.getItems());
        parameters.put("summaryTypes", StiSummaryTypes.getItems());
        parameters.put("aggrigateFunctions", StiAggrigateFunctions.getItems());
        parameters.put("fontNames", StiFontNames.getItems());
        parameters.put("conditions", StiDefaultConditions.getItems());
        parameters.put("iconSetArrays", StiIconSetArrays.getItems());
        parameters.put("dBaseCodePages", StiCodePageHelper.getDBaseCodePageItems());
        parameters.put("csvCodePages", StiCodePageHelper.getCsvCodePageItems());
        parameters.put("textFormats", StiTextFormatHelper.getTextFormatItems());
        parameters.put("currencySymbols", StiTextFormatHelper.getCurrencySymbols());
        parameters.put("dateFormats", StiTextFormatHelper.getDateAndTimeFormats("date", (StiFormatService)new StiDateFormatService()));
        parameters.put("timeFormats", StiTextFormatHelper.getDateAndTimeFormats("time", (StiFormatService)new StiTimeFormatService()));
        parameters.put("customFormats", StiTextFormatHelper.getDateAndTimeFormats("custom", (StiFormatService)new StiCustomFormatService()));
        parameters.put("cultures", StiCultureHelper.getItems());
        parameters.put("fontIcons", StiWebFontIconsHelper.getIconItems());
        parameters.put("fontIconSets", StiWebFontIconsHelper.getIconSetItems());
        parameters.put("predefinedColors", StiColorHelper.getPredefinedColors());
        parameters.put("stimulsoftFontContent", StiReportResourceHelper.getStimulsoftFontBase64Data());
        parameters.put("showInsertButton", this.options.getToolbar().isShowInsertButton());
        parameters.put("showLayoutButton", this.options.getToolbar().isShowLayoutButton());
        parameters.put("showPageButton", this.options.getToolbar().isShowPageButton());
        parameters.put("showPreviewButton", this.options.getToolbar().isShowPreviewButton());
        parameters.put("showSaveButton", this.options.getToolbar().isShowSaveButton());
        parameters.put("showAboutButton", this.options.getToolbar().isShowAboutButton());
        parameters.put("showSetupToolboxButton", this.options.getToolbar().isShowSetupToolboxButton());
        parameters.put("showFileMenu", this.options.getFileMenu().isVisible());
        parameters.put("showFileMenuNew", this.options.getFileMenu().isShowNew());
        parameters.put("showFileMenuOpen", this.options.getFileMenu().isShowOpen());
        parameters.put("showFileMenuSave", this.options.getFileMenu().isShowSave());
        parameters.put("showFileMenuSaveAs", this.options.getFileMenu().isShowSaveAs());
        parameters.put("showFileMenuClose", this.options.getFileMenu().isShowClose());
        parameters.put("showFileMenuExit", this.options.getFileMenu().isShowExit());
        parameters.put("showFileMenuReportSetup", this.options.getFileMenu().isShowReportSetup());
        parameters.put("showFileMenuOptions", this.options.getFileMenu().isShowOptions());
        parameters.put("showFileMenuInfo", this.options.getFileMenu().isShowInfo());
        parameters.put("showFileMenuAbout", this.options.getFileMenu().isShowAbout());
        parameters.put("showFileMenuHelp", this.options.getFileMenu().isShowHelp());
        parameters.put("showNewPageButton", this.options.getPages().isShowNewPageButton());
        HashMap<String, Boolean> visibilityBands = new HashMap<String, Boolean>();
        parameters.put("visibilityBands", visibilityBands);
        visibilityBands.put("StiReportTitleBand", this.options.getBands().isShowReportTitleBand());
        visibilityBands.put("StiReportSummaryBand", this.options.getBands().isShowReportSummaryBand());
        visibilityBands.put("StiPageHeaderBand", this.options.getBands().isShowPageHeaderBand());
        visibilityBands.put("StiPageFooterBand", this.options.getBands().isShowPageFooterBand());
        visibilityBands.put("StiGroupHeaderBand", this.options.getBands().isShowGroupHeaderBand());
        visibilityBands.put("StiGroupFooterBand", this.options.getBands().isShowGroupFooterBand());
        visibilityBands.put("StiHeaderBand", this.options.getBands().isShowHeaderBand());
        visibilityBands.put("StiFooterBand", this.options.getBands().isShowFooterBand());
        visibilityBands.put("StiColumnHeaderBand", this.options.getBands().isShowColumnHeaderBand());
        visibilityBands.put("StiColumnFooterBand", this.options.getBands().isShowColumnFooterBand());
        visibilityBands.put("StiDataBand", this.options.getBands().isShowDataBand());
        visibilityBands.put("StiHierarchicalBand", this.options.getBands().isShowHierarchicalBand());
        visibilityBands.put("StiChildBand", this.options.getBands().isShowChildBand());
        visibilityBands.put("StiEmptyBand", this.options.getBands().isShowEmptyBand());
        visibilityBands.put("StiOverlayBand", this.options.getBands().isShowOverlayBand());
        visibilityBands.put("StiTable", this.options.getComponents().isShowTable());
        visibilityBands.put("StiTableOfContents", this.options.getBands().isShowTableOfContents());
        HashMap<String, Boolean> visibilityCrossBands = new HashMap<String, Boolean>();
        parameters.put("visibilityCrossBands", visibilityCrossBands);
        visibilityCrossBands.put("StiCrossTab", this.options.getComponents().isShowCrossTab());
        visibilityCrossBands.put("StiCrossGroupHeaderBand", this.options.getCrossBands().isShowCrossGroupHeaderBand());
        visibilityCrossBands.put("StiCrossGroupFooterBand", this.options.getCrossBands().isShowCrossGroupFooterBand());
        visibilityCrossBands.put("StiCrossHeaderBand", this.options.getCrossBands().isShowCrossHeaderBand());
        visibilityCrossBands.put("StiCrossFooterBand", this.options.getCrossBands().isShowCrossFooterBand());
        visibilityCrossBands.put("StiCrossDataBand", this.options.getCrossBands().isShowCrossDataBand());
        HashMap<String, Boolean> visibilityComponents = new HashMap<String, Boolean>();
        parameters.put("visibilityComponents", visibilityComponents);
        visibilityComponents.put("StiText", this.options.getComponents().isShowText());
        visibilityComponents.put("StiTextInCells", this.options.getComponents().isShowTextInCells());
        visibilityComponents.put("StiRichText", this.options.getComponents().isShowRichText());
        visibilityComponents.put("StiImage", this.options.getComponents().isShowImage());
        visibilityComponents.put("StiBarCode", this.options.getComponents().isShowBarCode());
        visibilityComponents.put("StiShape", this.options.getComponents().isShowShape());
        visibilityComponents.put("StiPanel", this.options.getComponents().isShowPanel());
        visibilityComponents.put("StiClone", this.options.getComponents().isShowClone());
        visibilityComponents.put("StiCheckBox", this.options.getComponents().isShowCheckBox());
        visibilityComponents.put("StiSubReport", this.options.getComponents().isShowSubReport());
        visibilityComponents.put("StiZipCode", this.options.getComponents().isShowZipCode());
        visibilityComponents.put("StiChart", this.options.getComponents().isShowChart());
        visibilityComponents.put("StiMap", this.options.getComponents().isShowMap());
        visibilityComponents.put("StiGauge", this.options.getComponents().isShowGauge());
        visibilityComponents.put("StiHorizontalLinePrimitive", this.options.getComponents().isShowHorizontalLinePrimitive());
        visibilityComponents.put("StiVerticalLinePrimitive", this.options.getComponents().isShowVerticalLinePrimitive());
        visibilityComponents.put("StiRectanglePrimitive", this.options.getComponents().isShowRectanglePrimitive());
        visibilityComponents.put("StiRoundedRectanglePrimitive", this.options.getComponents().isShowRoundedRectanglePrimitive());
        visibilityComponents.put("StiPdfDigitalSignature", this.options.getComponents().isShowPdfDigitalSignature());
        parameters.put("showNewDashboardButton", this.options.dashboards.isShowNewDashboardButton());
        HashMap<String, Boolean> visibilityDashboardElements = new HashMap<String, Boolean>();
        parameters.put("visibilityDashboardElements", visibilityDashboardElements);
        visibilityDashboardElements.put("StiTableElement", this.options.dashboardElements.isShowTableElement());
        visibilityDashboardElements.put("StiChartElement", this.options.dashboardElements.isShowChartElement());
        visibilityDashboardElements.put("StiGaugeElement", this.options.dashboardElements.isShowGaugeElement());
        visibilityDashboardElements.put("StiPivotElement", this.options.dashboardElements.isShowPivotElement());
        visibilityDashboardElements.put("StiIndicatorElement", this.options.dashboardElements.isShowIndicatorElement());
        visibilityDashboardElements.put("StiProgressElement", this.options.dashboardElements.isShowProgressElement());
        visibilityDashboardElements.put("StiRegionMapElement", this.options.dashboardElements.isShowRegionMapElement());
        visibilityDashboardElements.put("StiOnlineMapElement", this.options.dashboardElements.isShowOnlineMapElement());
        visibilityDashboardElements.put("StiImageElement", this.options.dashboardElements.isShowImageElement());
        visibilityDashboardElements.put("StiTextElement", this.options.dashboardElements.isShowTextElement());
        visibilityDashboardElements.put("StiPanelElement", this.options.dashboardElements.isShowPanelElement());
        visibilityDashboardElements.put("StiShapeElement", this.options.dashboardElements.isShowShapeElement());
        parameters.put("showPropertiesGrid", this.options.getPropertiesGrid().isVisible());
        parameters.put("propertiesGridWidth", this.options.getPropertiesGrid().getWidth());
        parameters.put("propertiesGridLabelWidth", this.options.getPropertiesGrid().getLabelWidth());
        parameters.put("showDictionary", this.options.getDictionary().isVisible());
        parameters.put("permissionDataSources", this.options.getDictionary().getPermissionDataSources().toString());
        parameters.put("permissionDataColumns", this.options.getDictionary().getPermissionDataColumns().toString());
        parameters.put("permissionDataRelations", this.options.getDictionary().getPermissionDataRelations().toString());
        parameters.put("permissionDataConnections", this.options.getDictionary().getPermissionDataConnections().toString());
        parameters.put("permissionBusinessObjects", this.options.getDictionary().getPermissionBusinessObjects().toString());
        parameters.put("permissionVariables", this.options.getDictionary().getPermissionVariables().toString());
        parameters.put("permissionResources", this.options.getDictionary().getPermissionResources().toString());
        parameters.put("permissionSqlParameters", this.options.getDictionary().getPermissionSqlParameters().toString());
        parameters.put("permissionUserFunctions", this.options.getDictionary().getPermissionUserFunctions().toString());
        parameters.put("isShowOnlyAliasForComponents", StiOptions.Dictionary.getShowOnlyAliasForComponents());
        parameters.put("isShowOnlyAliasForPages", StiOptions.Dictionary.getShowOnlyAliasForPages());
        parameters.put("isShowOnlyAliasForDatabase", StiOptions.Dictionary.ShowOnlyAliasForDatabase());
        parameters.put("isShowOnlyAliasForData", StiOptions.Dictionary.getShowOnlyAliasForData());
        parameters.put("isShowOnlyAliasForVariable", StiOptions.Dictionary.getShowOnlyAliasForVariable());
        parameters.put("isShowOnlyAliasForResource", StiOptions.Dictionary.isShowOnlyAliasForResource());
        parameters.put("isShowOnlyAliasForDataSource", StiOptions.Dictionary.getShowOnlyAliasForDataSource());
        parameters.put("isShowOnlyAliasForBusinessObject", StiOptions.Dictionary.getShowOnlyAliasForBusinessObject());
        parameters.put("isShowOnlyAliasForDataColumn", StiOptions.Dictionary.getShowOnlyAliasForDataColumn());
        parameters.put("isShowOnlyAliasForDataRelation", StiOptions.Dictionary.getShowOnlyAliasForDataRelation());
        parameters.put("showReportTree", this.options.getAppearance().isShowReportTree());
        parameters.put("urlCursorStyleSet", StiWebResourceHelper.getWebResourceUrl((String)url, (String)"webdesigner", (String)"/Images/Office2013/Cursors/StyleSet.cur"));
        parameters.put("urlCursorPen", StiWebResourceHelper.getWebResourceUrl((String)url, (String)"webdesigner", (String)"/Images/Office2013/Cursors/Pen.cur"));
        parameters.put("dashboardAssemblyLoaded", false);
        HashMap<String, String> actions = new HashMap<String, String>();
        actions.put("getReport", "GetReport");
        actions.put("openReport", "DesignerEvent");
        actions.put("createReport", "DesignerEvent");
        actions.put("saveReport", "DesignerEvent");
        actions.put("saveReportAs", "DesignerEvent");
        actions.put("previewReport", "DesignerEvent");
        actions.put("exportReport", "ExportReport");
        actions.put("exit", "ExitDesigner");
        actions.put("designerEvent", "DesignerEvent");
        parameters.put("actions", actions);
        StiWebDesigner.saveReportObject(request, report, this.id);
        StiCacheOptions.cache.storeObject(request, handler, this.id + "webdesigner_handler");
        return new JSONObject(parameters).toString();
    }

    private String getCurrentHelpLanguage() {
        return "ru".equals(StiLocalization.getLocalizationCultureName()) ? "ru" : "en";
    }

    public static String serialize(Document doc, boolean omitXMLDeclaration) throws IOException {
        try {
            TransformerFactory transFactory = TransformerFactory.newInstance();
            Transformer t = transFactory.newTransformer();
            t.setOutputProperty("method", "html");
            t.setOutputProperty("omit-xml-declaration", "yes");
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            t.transform(new DOMSource(doc), new StreamResult(new OutputStreamWriter((OutputStream)bos, "UTF-8")));
            bos.close();
            return new String(bos.toByteArray(), "UTF8");
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "", e);
            return "";
        }
    }

    public String getClientGuid() {
        if (this.clientGuid == null) {
            this.clientGuid = StiWebDesigner.getNewGuid();
        }
        return this.clientGuid;
    }

    public void setClientGuid(String clientGuid) {
        this.clientGuid = clientGuid;
    }
}

