/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.web.utils;

import com.stimulsoft.base.StiObjectConverter;
import com.stimulsoft.base.drawing.enums.StiHorAlignment;
import com.stimulsoft.base.exception.StiException;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.serializing.SerializeMode;
import com.stimulsoft.base.serializing.StiDeserializerControler;
import com.stimulsoft.base.serializing.interfaceobject.IStiSerializable;
import com.stimulsoft.lib.base64.StiBase64DecoderUtil;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.StiSerializeManager;
import com.stimulsoft.report.enums.StiExportFormat;
import com.stimulsoft.report.export.service.StiBmpExportService;
import com.stimulsoft.report.export.service.StiCsvExportService;
import com.stimulsoft.report.export.service.StiExcel2007ExportService;
import com.stimulsoft.report.export.service.StiExcelExportService;
import com.stimulsoft.report.export.service.StiExcelXmlExportService;
import com.stimulsoft.report.export.service.StiHtmlExportService;
import com.stimulsoft.report.export.service.StiJpegExportService;
import com.stimulsoft.report.export.service.StiOdsExportService;
import com.stimulsoft.report.export.service.StiOdtExportService;
import com.stimulsoft.report.export.service.StiPcxExportService;
import com.stimulsoft.report.export.service.StiPdfExportService;
import com.stimulsoft.report.export.service.StiPngExportService;
import com.stimulsoft.report.export.service.StiPpt2007ExportService;
import com.stimulsoft.report.export.service.StiRtfExportService;
import com.stimulsoft.report.export.service.StiSvgExportService;
import com.stimulsoft.report.export.service.StiSvgzExportService;
import com.stimulsoft.report.export.service.StiSylkExportService;
import com.stimulsoft.report.export.service.StiTxtExportService;
import com.stimulsoft.report.export.service.StiWord2007ExportService;
import com.stimulsoft.report.export.service.StiXmlExportService;
import com.stimulsoft.report.export.service.StiXpsExportService;
import com.stimulsoft.report.export.settings.StiDataExportSettings;
import com.stimulsoft.report.export.settings.StiExcelExportSettings;
import com.stimulsoft.report.export.settings.StiExportSettings;
import com.stimulsoft.report.export.settings.StiHtmlExportSettings;
import com.stimulsoft.report.export.settings.StiImageExportSettings;
import com.stimulsoft.report.export.settings.StiOdsExportSettings;
import com.stimulsoft.report.export.settings.StiOdtExportSettings;
import com.stimulsoft.report.export.settings.StiPdfExportSettings;
import com.stimulsoft.report.export.settings.StiPowerPointExportSettings;
import com.stimulsoft.report.export.settings.StiRtfExportSettings;
import com.stimulsoft.report.export.settings.StiTxtExportSettings;
import com.stimulsoft.report.export.settings.StiWordExportSettings;
import com.stimulsoft.report.export.settings.StiXmlExportSettings;
import com.stimulsoft.report.export.settings.StiXpsExportSettings;
import com.stimulsoft.report.export.tools.StiColorImageFormat;
import com.stimulsoft.report.export.tools.StiDataExportMode;
import com.stimulsoft.report.export.tools.StiDataType;
import com.stimulsoft.report.export.tools.StiExcelType;
import com.stimulsoft.report.export.tools.StiImageFormat;
import com.stimulsoft.report.export.tools.StiImageType;
import com.stimulsoft.report.export.tools.StiMonochromeDitheringType;
import com.stimulsoft.report.export.tools.StiPagesRange;
import com.stimulsoft.report.export.tools.StiPdfAllowEditable;
import com.stimulsoft.report.export.tools.StiPdfAutoPrintMode;
import com.stimulsoft.report.export.tools.StiRtfExportMode;
import com.stimulsoft.report.export.tools.StiTxtBorderType;
import com.stimulsoft.report.export.tools.StiUserAccessPrivileges;
import com.stimulsoft.report.export.tools.html.StiHtmlExportBookmarksMode;
import com.stimulsoft.report.export.tools.html.StiHtmlExportMode;
import com.stimulsoft.report.export.tools.html.StiHtmlExportQuality;
import com.stimulsoft.report.export.tools.pdf.StiPdfEncryptionKeyLength;
import com.stimulsoft.report.export.tools.pdf.StiPdfImageCompressionMethod;
import com.stimulsoft.report.saveLoad.StiDocument;
import com.stimulsoft.report.saveLoad.StiEncryptedDocumentSLService;
import com.stimulsoft.report.saveLoad.StiSLActions;
import com.stimulsoft.report.saveLoad.StiSLService;
import com.stimulsoft.web.helper.StiWebActionResult;
import com.stimulsoft.web.proxyee.StiHttpServletResponse;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.security.NoSuchAlgorithmException;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StiWebExportReportUtil {
    public static void export(HttpServletRequest request, StiHttpServletResponse response) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse((InputStream)request.getInputStream());
            NodeList nodeList = document.getChildNodes().item(0).getChildNodes();
            StiExportFormat exportFormat = StiExportFormat.valueOf((String)StiWebExportReportUtil.getNode(nodeList, "Format").getTextContent());
            StiExportSettings settings = StiWebExportReportUtil.getExportSettings(exportFormat, StiWebExportReportUtil.getNode(nodeList, "Settings"));
            StiDeserializerControler controler = new StiDeserializerControler(SerializeMode.document);
            byte[] docByte = StiBase64DecoderUtil.decode((String)StiWebExportReportUtil.getNode(nodeList, "ReportSnapshot").getChildNodes().item(0).getTextContent());
            StiDocument doc = StiSerializeManager.deserializeDocument((InputStream)new ByteArrayInputStream(docByte));
            controler.addReferences((IStiSerializable)doc, "0");
            controler.finish();
            doc.getReport().setIsRendered(true);
            doc.getReport().setNeedsCompiling(false);
            StiWebActionResult result = StiWebExportReportUtil.export(exportFormat, doc.getReport(), null, settings);
            result.writeFile(response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static StiWebActionResult export(StiExportFormat exportFormat, StiReport report, OutputStream stream, StiExportSettings settings) throws StiException, JSONException, IOException, NoSuchAlgorithmException {
        switch (exportFormat) {
            case Document: {
                return StiWebExportReportUtil.saveDocumentFile(report, stream);
            }
            case Pdf: {
                return StiWebExportReportUtil.exportAsPdf(report, (StiPdfExportSettings)settings, stream, true);
            }
            case Xps: {
                return StiWebExportReportUtil.exportAsXps(report, (StiXpsExportSettings)settings, stream, true);
            }
            case PowerPoint: {
                return StiWebExportReportUtil.exportAsPpt2007(report, (StiPowerPointExportSettings)settings, stream, true);
            }
            case Html: {
                return StiWebExportReportUtil.exportAsHtml(report, (StiHtmlExportSettings)settings, stream, true);
            }
            case Text: {
                return StiWebExportReportUtil.exportAsText(report, (StiTxtExportSettings)settings, stream);
            }
            case Rtf: {
                return StiWebExportReportUtil.exportAsRtf(report, (StiRtfExportSettings)settings, stream);
            }
            case Word: {
                return StiWebExportReportUtil.exportAsWord2007(report, (StiWordExportSettings)settings, stream);
            }
            case Odt: {
                return StiWebExportReportUtil.exportAsOdt(report, (StiOdtExportSettings)settings, stream);
            }
            case ExcelXml: {
                return StiWebExportReportUtil.exportAsExcelXml(report, (StiExcelExportSettings)settings, stream);
            }
            case Excel: 
            case Excel2007: {
                return StiWebExportReportUtil.exportAsExcel2007(report, (StiExcelExportSettings)settings, stream);
            }
            case Ods: {
                return StiWebExportReportUtil.exportAsOds(report, (StiOdsExportSettings)settings, stream);
            }
            case Csv: {
                return StiWebExportReportUtil.exportAsCsv(report, (StiDataExportSettings)settings, stream);
            }
            case Xml: {
                return StiWebExportReportUtil.exportAsXml(report, stream);
            }
            case Sylk: {
                return StiWebExportReportUtil.exportAsSylk(report, (StiDataExportSettings)settings, stream);
            }
            case ImageBmp: {
                return StiWebExportReportUtil.exportAsBmp(report, (StiImageExportSettings)settings, stream);
            }
            case ImageJpeg: {
                return StiWebExportReportUtil.exportAsJpeg(report, (StiImageExportSettings)settings, stream);
            }
            case ImagePcx: {
                return StiWebExportReportUtil.exportAsPcx(report, (StiImageExportSettings)settings, stream);
            }
            case ImagePng: {
                return StiWebExportReportUtil.exportAsPng(report, (StiImageExportSettings)settings, stream);
            }
            case ImageSvg: {
                return StiWebExportReportUtil.exportAsSvg(report, (StiImageExportSettings)settings, stream);
            }
            case ImageSvgz: {
                return StiWebExportReportUtil.exportAsSvgz(report, (StiImageExportSettings)settings, stream);
            }
        }
        return new StiWebActionResult();
    }

    public static String getReportFileName(StiReport report) {
        return report.getReportAlias() == null || report.getReportAlias().trim().length() == 0 ? (StiValidationUtil.isNotNullOrEmpty((String)report.getReportName()) ? report.getReportName() : "report") : report.getReportAlias();
    }

    private static String getReportFileExtension(StiExportFormat exportFormat) {
        switch (exportFormat) {
            case Document: {
                return "mdc";
            }
            case Excel: 
            case Excel2007: {
                return "xlsx";
            }
            case PowerPoint: {
                return "ppt";
            }
            case Text: {
                return "txt";
            }
            case Word: {
                return "docx";
            }
        }
        return exportFormat.toString().toLowerCase().replaceAll("image", "");
    }

    private static Node getNode(NodeList nodeList, String nodeName) {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (!nodeList.item(i).getNodeName().equals(nodeName)) continue;
            return nodeList.item(i);
        }
        return null;
    }

    public static StiWebActionResult saveDocumentFile(StiReport report, OutputStream stream) throws IOException, NoSuchAlgorithmException, JSONException {
        String format = "mdc";
        String password = "";
        boolean isStreamNull = false;
        if (stream == null) {
            isStreamNull = true;
            stream = new ByteArrayOutputStream();
        }
        StiSLService service = null;
        if ("mdc".equals(format)) {
            service = (StiSLService)StiSLService.getDocumentSLServices((StiSLActions)StiSLActions.Save).get(0);
        } else if ("mdz".equals(format)) {
            service = (StiSLService)StiSLService.getDocumentSLServices((StiSLActions)StiSLActions.Save).get(1);
        } else if ("mdx".equals(format)) {
            service = (StiSLService)StiSLService.getDocumentSLServices((StiSLActions)StiSLActions.Save).get(2);
        }
        if (service instanceof StiEncryptedDocumentSLService) {
            ((StiEncryptedDocumentSLService)service).setKey(password);
        }
        service.save(report, stream);
        if (isStreamNull) {
            return new StiWebActionResult((ByteArrayOutputStream)stream, StiWebExportReportUtil.getReportFileName(report) + "." + format, "application/xml");
        }
        return null;
    }

    private static StiWebActionResult exportAsPdf(StiReport report, StiPdfExportSettings settings, OutputStream stream, boolean saveFileDialog) throws StiException, JSONException, IOException {
        StiPdfExportService service = new StiPdfExportService();
        if (stream == null) {
            stream = new ByteArrayOutputStream();
            service.exportPdf(report, stream, settings);
            return new StiWebActionResult((ByteArrayOutputStream)stream, StiWebExportReportUtil.getReportFileName(report) + ".pdf", "application/pdf", saveFileDialog);
        }
        service.exportPdf(report, stream, settings);
        return null;
    }

    private static StiWebActionResult exportAsXps(StiReport report, StiXpsExportSettings settings, OutputStream stream, boolean saveFileDialog) throws StiException, IOException {
        StiXpsExportService service = new StiXpsExportService();
        if (stream == null) {
            stream = new ByteArrayOutputStream();
            service.exportXps(report, stream, (StiExportSettings)settings);
            return new StiWebActionResult((ByteArrayOutputStream)stream, StiWebExportReportUtil.getReportFileName(report) + ".xps", "application/vnd.ms-xpsdocument", saveFileDialog);
        }
        service.exportXps(report, stream, (StiExportSettings)settings);
        return null;
    }

    private static StiWebActionResult exportAsPpt2007(StiReport report, StiPowerPointExportSettings settings, OutputStream stream, boolean saveFileDialog) throws StiException, IOException {
        StiPpt2007ExportService service = new StiPpt2007ExportService();
        if (stream == null) {
            stream = new ByteArrayOutputStream();
            service.exportPowerPoint(report, stream, settings);
            return new StiWebActionResult((ByteArrayOutputStream)stream, StiWebExportReportUtil.getReportFileName(report) + ".pptx", "application/vnd.ms-powerpoint", saveFileDialog);
        }
        service.exportPowerPoint(report, stream, settings);
        return null;
    }

    private static StiWebActionResult exportAsHtml(StiReport report, StiHtmlExportSettings settings, OutputStream stream, boolean saveFileDialog) throws StiException, IOException {
        StiHtmlExportService service = new StiHtmlExportService();
        if (stream == null) {
            stream = new ByteArrayOutputStream();
            service.exportHtml(report, stream, settings);
            return new StiWebActionResult((ByteArrayOutputStream)stream, StiWebExportReportUtil.getReportFileName(report) + ".html", "text/html", saveFileDialog);
        }
        service.exportHtml(report, stream, settings);
        return null;
    }

    private static StiWebActionResult exportAsText(StiReport report, StiTxtExportSettings settings, OutputStream stream) throws JSONException, StiException, IOException {
        StiTxtExportService service = new StiTxtExportService();
        if (stream == null) {
            stream = new ByteArrayOutputStream();
            service.exportTxt(report, stream, settings);
            return new StiWebActionResult((ByteArrayOutputStream)stream, StiWebExportReportUtil.getReportFileName(report) + ".txt", "application/text");
        }
        service.exportTxt(report, stream, settings);
        return null;
    }

    private static StiWebActionResult exportAsRtf(StiReport report, StiRtfExportSettings settings, OutputStream stream) throws StiException, IOException, JSONException {
        StiRtfExportService service = new StiRtfExportService();
        if (stream == null) {
            stream = new ByteArrayOutputStream();
            service.exportRtf(report, stream, settings);
            return new StiWebActionResult((ByteArrayOutputStream)stream, StiWebExportReportUtil.getReportFileName(report) + ".rtf", "application/msword");
        }
        service.exportRtf(report, stream, settings);
        return null;
    }

    private static StiWebActionResult exportAsWord2007(StiReport report, StiWordExportSettings settings, OutputStream stream) throws JSONException, StiException, IOException {
        StiWord2007ExportService service = new StiWord2007ExportService();
        if (stream == null) {
            stream = new ByteArrayOutputStream();
            service.exportWord(report, stream, settings);
            return new StiWebActionResult((ByteArrayOutputStream)stream, StiWebExportReportUtil.getReportFileName(report) + ".docx", "application/msword");
        }
        service.exportWord(report, stream, settings);
        return null;
    }

    private static StiWebActionResult exportAsOdt(StiReport report, StiOdtExportSettings settings, OutputStream stream) throws JSONException, StiException, IOException {
        StiOdtExportService service = new StiOdtExportService();
        if (stream == null) {
            stream = new ByteArrayOutputStream();
            service.exportOdt(report, stream, settings);
            return new StiWebActionResult((ByteArrayOutputStream)stream, StiWebExportReportUtil.getReportFileName(report) + ".odt", "application/vnd.oasis.opendocument.text");
        }
        service.exportOdt(report, stream, settings);
        return null;
    }

    public static StiWebActionResult exportAsExcel(StiReport report, StiExcelExportSettings settings, OutputStream stream) throws JSONException, StiException, IOException {
        StiExcelExportService service = new StiExcelExportService();
        if (stream == null) {
            stream = new ByteArrayOutputStream();
            service.exportExcel(report, stream, (StiExportSettings)settings);
            return new StiWebActionResult((ByteArrayOutputStream)stream, StiWebExportReportUtil.getReportFileName(report) + ".xls", "application/excel");
        }
        service.exportExcel(report, stream, (StiExportSettings)settings);
        return null;
    }

    public static StiWebActionResult exportAsExcelXml(StiReport report, StiExcelExportSettings settings, OutputStream stream) throws JSONException, StiException, IOException {
        StiExcelXmlExportService service = new StiExcelXmlExportService();
        if (stream == null) {
            stream = new ByteArrayOutputStream();
            service.exportExcel(report, stream, settings);
            return new StiWebActionResult((ByteArrayOutputStream)stream, StiWebExportReportUtil.getReportFileName(report) + ".xls", "application/excel");
        }
        service.exportExcel(report, stream, settings);
        return null;
    }

    public static StiWebActionResult exportAsExcel2007(StiReport report, StiExcelExportSettings settings, OutputStream stream) throws JSONException, StiException, IOException {
        StiExcel2007ExportService service = new StiExcel2007ExportService();
        if (stream == null) {
            stream = new ByteArrayOutputStream();
            service.exportExcel(report, stream, settings);
            return new StiWebActionResult((ByteArrayOutputStream)stream, StiWebExportReportUtil.getReportFileName(report) + ".xlsx", "application/excel");
        }
        service.exportExcel(report, stream, settings);
        return null;
    }

    public static StiWebActionResult exportAsOds(StiReport report, StiOdsExportSettings settings, OutputStream stream) throws JSONException, StiException, IOException {
        StiOdsExportService service = new StiOdsExportService();
        if (stream == null) {
            stream = new ByteArrayOutputStream();
            service.exportOds(report, stream, settings);
            return new StiWebActionResult((ByteArrayOutputStream)stream, StiWebExportReportUtil.getReportFileName(report) + ".ods", "application/vnd.oasis.opendocument.spreadsheet");
        }
        service.exportOds(report, stream, settings);
        return null;
    }

    public static StiWebActionResult exportAsCsv(StiReport report, StiDataExportSettings settings, OutputStream stream) throws JSONException, StiException, IOException {
        StiCsvExportService service = new StiCsvExportService();
        if (stream == null) {
            stream = new ByteArrayOutputStream();
            service.exportCsv(report, stream, settings);
            return new StiWebActionResult((ByteArrayOutputStream)stream, StiWebExportReportUtil.getReportFileName(report) + ".csv", "application/excel");
        }
        service.exportCsv(report, stream, settings);
        return null;
    }

    public static StiWebActionResult exportAsXml(StiReport report, OutputStream stream) throws StiException, IOException {
        StiXmlExportService service = new StiXmlExportService();
        if (stream == null) {
            stream = new ByteArrayOutputStream();
            service.exportXml(report, stream, (StiExportSettings)new StiXmlExportSettings());
            return new StiWebActionResult((ByteArrayOutputStream)stream, StiWebExportReportUtil.getReportFileName(report) + ".xml", "application/xml");
        }
        service.exportXml(report, stream, (StiExportSettings)new StiXmlExportSettings());
        return null;
    }

    public static StiWebActionResult exportAsSylk(StiReport report, StiDataExportSettings settings, OutputStream stream) throws JSONException, IOException, StiException {
        StiSylkExportService service = new StiSylkExportService();
        if (stream == null) {
            stream = new ByteArrayOutputStream();
            service.exportSylk(report, stream, settings);
            return new StiWebActionResult((ByteArrayOutputStream)stream, StiWebExportReportUtil.getReportFileName(report) + ".sylk", "application/mixed");
        }
        service.exportSylk(report, stream, settings);
        return null;
    }

    public static StiWebActionResult exportAsBmp(StiReport report, StiImageExportSettings settings, OutputStream stream) throws JSONException, StiException, IOException {
        StiBmpExportService service = new StiBmpExportService();
        if (stream == null) {
            stream = new ByteArrayOutputStream();
            service.exportImage(report, stream, (StiExportSettings)settings);
            return new StiWebActionResult((ByteArrayOutputStream)stream, StiWebExportReportUtil.getReportFileName(report) + ".bmp", "application/bmp");
        }
        service.exportImage(report, stream, (StiExportSettings)settings);
        return null;
    }

    public static StiWebActionResult exportAsJpeg(StiReport report, StiImageExportSettings settings, OutputStream stream) throws JSONException, StiException, IOException {
        StiJpegExportService service = new StiJpegExportService();
        if (stream == null) {
            stream = new ByteArrayOutputStream();
            service.exportImage(report, stream, (StiExportSettings)settings);
            return new StiWebActionResult((ByteArrayOutputStream)stream, StiWebExportReportUtil.getReportFileName(report) + ".jpg", "application/jpeg");
        }
        service.exportImage(report, stream, (StiExportSettings)settings);
        return null;
    }

    public static StiWebActionResult exportAsPcx(StiReport report, StiImageExportSettings settings, OutputStream stream) throws JSONException, StiException, IOException {
        StiPcxExportService service = new StiPcxExportService();
        if (stream == null) {
            stream = new ByteArrayOutputStream();
            service.exportImage(report, stream, (StiExportSettings)settings);
            return new StiWebActionResult((ByteArrayOutputStream)stream, StiWebExportReportUtil.getReportFileName(report) + ".pcx", "application/pcx");
        }
        service.exportImage(report, stream, (StiExportSettings)settings);
        return null;
    }

    public static StiWebActionResult exportAsPng(StiReport report, StiImageExportSettings settings, OutputStream stream) throws JSONException, StiException, IOException {
        StiPngExportService service = new StiPngExportService();
        if (stream == null) {
            stream = new ByteArrayOutputStream();
            service.exportImage(report, stream, (StiExportSettings)settings);
            return new StiWebActionResult((ByteArrayOutputStream)stream, StiWebExportReportUtil.getReportFileName(report) + ".png", "application/png");
        }
        service.exportImage(report, stream, (StiExportSettings)settings);
        return null;
    }

    public static StiWebActionResult exportAsSvg(StiReport report, StiImageExportSettings settings, OutputStream stream) throws JSONException, StiException, IOException {
        StiSvgExportService service = new StiSvgExportService();
        if (stream == null) {
            stream = new ByteArrayOutputStream();
            service.exportImage(report, stream, (StiExportSettings)settings);
            return new StiWebActionResult((ByteArrayOutputStream)stream, StiWebExportReportUtil.getReportFileName(report) + ".svg", "application/mixed");
        }
        service.exportImage(report, stream, (StiExportSettings)settings);
        return null;
    }

    public static StiWebActionResult exportAsSvgz(StiReport report, StiImageExportSettings settings, OutputStream stream) throws JSONException, StiException, IOException {
        StiSvgzExportService service = new StiSvgzExportService();
        if (stream == null) {
            stream = new ByteArrayOutputStream();
            service.exportImage(report, stream, (StiExportSettings)settings);
            return new StiWebActionResult((ByteArrayOutputStream)stream, StiWebExportReportUtil.getReportFileName(report) + ".svgz", "application/mixed");
        }
        service.exportImage(report, stream, (StiExportSettings)settings);
        return null;
    }

    public static StiExportSettings getExportSettings(StiExportFormat exportFormat, Node settingsNode) {
        switch (exportFormat) {
            case Pdf: {
                return StiWebExportReportUtil.getPdfExportSettings(settingsNode);
            }
            case Xps: {
                return StiWebExportReportUtil.getXpsExportSettings(settingsNode);
            }
            case PowerPoint: {
                return StiWebExportReportUtil.getPpt2007ExportSettings(settingsNode);
            }
            case Text: {
                return StiWebExportReportUtil.getTextExportSettings(settingsNode);
            }
            case Rtf: {
                return StiWebExportReportUtil.getRtfExportSettings(settingsNode);
            }
            case Word: {
                return StiWebExportReportUtil.getWord2007ExportSettings(settingsNode);
            }
            case Odt: {
                return StiWebExportReportUtil.getOdtExportSettings(settingsNode, exportFormat);
            }
            case Ods: {
                return StiWebExportReportUtil.getOdsExportSettings(settingsNode, exportFormat);
            }
            case Html: 
            case Html5: 
            case Mht: {
                return StiWebExportReportUtil.getHtmlExportSettings(settingsNode);
            }
            case ExcelXml: 
            case Excel: 
            case Excel2007: {
                return StiWebExportReportUtil.getExcelExportSettings(settingsNode, exportFormat);
            }
            case Csv: 
            case Xml: 
            case Sylk: 
            case Dbf: 
            case Dif: {
                return StiWebExportReportUtil.getDataExportSettings(settingsNode);
            }
            case ImageBmp: 
            case ImageJpeg: 
            case ImagePcx: 
            case ImagePng: 
            case ImageSvg: 
            case ImageSvgz: 
            case ImageGif: 
            case ImageTiff: 
            case ImageEmf: {
                return StiWebExportReportUtil.getImageExportSettings(settingsNode);
            }
        }
        return null;
    }

    private static StiPdfExportSettings getPdfExportSettings(Node settingsNode) {
        StiPdfExportSettings settings = new StiPdfExportSettings();
        if (settingsNode != null) {
            for (int i = 0; i < settingsNode.getChildNodes().getLength(); ++i) {
                Node node = settingsNode.getChildNodes().item(i);
                if (node.getNodeName().equalsIgnoreCase("PagesRange")) {
                    settings.setPageRange(new StiPagesRange(node.getTextContent()));
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("ImageQuality")) {
                    settings.setImageQuality((float)StiObjectConverter.ConvertToDouble((Object)node.getTextContent()));
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("ImageResolution")) {
                    settings.setImageResolution((float)StiObjectConverter.ConvertToDouble((Object)node.getTextContent()));
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("EmbeddedFonts")) {
                    settings.setEmbeddedFonts(Boolean.valueOf(node.getTextContent()).booleanValue());
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("StandardPdfFonts")) {
                    settings.setStandardPdfFonts(Boolean.valueOf(node.getTextContent()).booleanValue());
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("Compressed")) continue;
                if (node.getNodeName().equalsIgnoreCase("ExportRtfTextAsImage")) {
                    settings.setExportRtfTextAsImage(Boolean.valueOf(node.getTextContent()).booleanValue());
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("PasswordInputUser")) {
                    settings.setPasswordInputUser(node.getTextContent());
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("PasswordInputOwner")) {
                    settings.setPasswordInputOwner(node.getTextContent());
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("UserAccessPrivileges")) {
                    int value = Integer.parseInt(node.getTextContent());
                    settings.setUserAccessPrivileges(StiUserAccessPrivileges.parseInt((int)value));
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("KeyLength")) {
                    settings.setKeyLength(StiPdfEncryptionKeyLength.valueOf((String)node.getTextContent()));
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("UseUnicode")) {
                    settings.setUseUnicode(Boolean.valueOf(node.getTextContent()).booleanValue());
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("UseDigitalSignature") || node.getNodeName().equalsIgnoreCase("GetCertificateFromCryptoUI") || node.getNodeName().equalsIgnoreCase("SubjectNameString") || node.getNodeName().equalsIgnoreCase("UseLocalMachineCertificates") || node.getNodeName().equalsIgnoreCase("CreatorString") || node.getNodeName().equalsIgnoreCase("KeywordsString")) continue;
                if (node.getNodeName().equalsIgnoreCase("ImageCompressionMethod")) {
                    settings.setImageCompressionMethod(StiPdfImageCompressionMethod.valueOf((String)node.getTextContent()));
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("ImageFormat")) {
                    settings.setImageFormat(StiColorImageFormat.valueOf((String)node.getTextContent()));
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("DitheringType")) {
                    settings.setDitheringType(StiMonochromeDitheringType.valueOf((String)node.getTextContent()));
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("PdfACompliance")) {
                    settings.setPdfACompliance(Boolean.valueOf(node.getTextContent()).booleanValue());
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("AutoPrintMode")) {
                    settings.setAutoPrintMode(StiPdfAutoPrintMode.valueOf((String)node.getTextContent()));
                    continue;
                }
                if (!node.getNodeName().equalsIgnoreCase("AllowEditable")) continue;
                settings.setAllowEditable(StiPdfAllowEditable.valueOf((String)node.getTextContent()));
            }
        }
        return settings;
    }

    private static StiXpsExportSettings getXpsExportSettings(Node settingsNode) {
        StiXpsExportSettings settings = new StiXpsExportSettings();
        if (settingsNode != null) {
            for (int i = 0; i < settingsNode.getChildNodes().getLength(); ++i) {
                Node node = settingsNode.getChildNodes().item(i);
                if (node.getNodeName().equalsIgnoreCase("PagesRange")) {
                    settings.setPageRange(new StiPagesRange(node.getTextContent()));
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("ImageResolution")) {
                    settings.setImageResolution((float)StiObjectConverter.ConvertToDouble((Object)node.getTextContent()));
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("ImageQuality")) {
                    settings.setImageQuality((float)StiObjectConverter.ConvertToDouble((Object)node.getTextContent()));
                    continue;
                }
                if (!node.getNodeName().equalsIgnoreCase("ExportRtfTextAsImage")) continue;
                settings.setExportRtfTextAsImage(Boolean.valueOf(node.getTextContent()).booleanValue());
            }
        }
        return settings;
    }

    private static StiPowerPointExportSettings getPpt2007ExportSettings(Node settingsNode) {
        StiPowerPointExportSettings settings = new StiPowerPointExportSettings();
        if (settingsNode != null) {
            for (int i = 0; i < settingsNode.getChildNodes().getLength(); ++i) {
                Node node = settingsNode.getChildNodes().item(i);
                if (node.getNodeName().equalsIgnoreCase("PagesRange")) {
                    settings.setPageRange(new StiPagesRange(node.getTextContent()));
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("ImageResolution")) {
                    settings.setImageResolution((float)StiObjectConverter.ConvertToDouble((Object)node.getTextContent()));
                    continue;
                }
                if (!node.getNodeName().equalsIgnoreCase("ImageQuality")) continue;
                settings.setImageQuality((float)StiObjectConverter.ConvertToDouble((Object)node.getTextContent()));
            }
        }
        return settings;
    }

    private static StiHtmlExportSettings getHtmlExportSettings(Node settingsNode) {
        StiHtmlExportSettings settings = new StiHtmlExportSettings();
        if (settingsNode != null) {
            for (int i = 0; i < settingsNode.getChildNodes().getLength(); ++i) {
                Node node = settingsNode.getChildNodes().item(i);
                if (node.getNodeName().equalsIgnoreCase("PagesRange")) {
                    settings.setPageRange(new StiPagesRange(node.getTextContent()));
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("ImageQuality")) {
                    settings.setImageQuality((float)StiObjectConverter.ConvertToDouble((Object)node.getTextContent()));
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("ImageResolution")) {
                    settings.setImageResolution((float)StiObjectConverter.ConvertToDouble((Object)node.getTextContent()));
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("Encoding")) {
                    settings.setEncoding(Charset.forName(node.getTextContent()));
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("Zoom")) {
                    settings.setZoom(StiObjectConverter.ConvertToDouble((Object)node.getTextContent()));
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("ExportMode")) {
                    settings.setExportMode(StiHtmlExportMode.valueOf((String)node.getTextContent()));
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("ExportQuality")) {
                    settings.setExportQuality(StiHtmlExportQuality.valueOf((String)node.getTextContent()));
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("AddPageBreaks")) {
                    settings.setAddPageBreaks(Boolean.valueOf(node.getTextContent()).booleanValue());
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("BookmarksTreeWidth")) {
                    settings.setBookmarksTreeWidth(Integer.valueOf(node.getTextContent()).intValue());
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("ExportBookmarksMode")) {
                    settings.setExportBookmarksMode(StiHtmlExportBookmarksMode.valueOf((String)node.getTextContent()));
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("UseStylesTable")) {
                    settings.setUseStylesTable(Boolean.valueOf(node.getTextContent()).booleanValue());
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("RemoveEmptySpaceAtBottom")) {
                    settings.setRemoveEmptySpaceAtBottom(Boolean.valueOf(node.getTextContent()).booleanValue());
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("PageHorAlignment")) {
                    settings.setPageHorAlignment(StiHorAlignment.valueOf((String)node.getTextContent()));
                    continue;
                }
                if (!node.getNodeName().equalsIgnoreCase("ImageFormat")) continue;
                if (node.getTextContent().equalsIgnoreCase("Bmp")) {
                    settings.setImageFormat(StiImageFormat.Bmp);
                    continue;
                }
                if (node.getTextContent().equalsIgnoreCase("Emf")) {
                    settings.setImageFormat(StiImageFormat.Emf);
                    continue;
                }
                if (node.getTextContent().equalsIgnoreCase("Gif")) {
                    settings.setImageFormat(StiImageFormat.Gif);
                    continue;
                }
                if (node.getTextContent().equalsIgnoreCase("Jpeg")) {
                    settings.setImageFormat(StiImageFormat.Jpeg);
                    continue;
                }
                if (node.getTextContent().equalsIgnoreCase("Png")) {
                    settings.setImageFormat(StiImageFormat.Png);
                    continue;
                }
                if (!node.getTextContent().equalsIgnoreCase("Tiff")) continue;
                settings.setImageFormat(StiImageFormat.Tiff);
            }
        }
        return settings;
    }

    private static StiTxtExportSettings getTextExportSettings(Node settingsNode) {
        StiTxtExportSettings settings = new StiTxtExportSettings();
        if (settingsNode != null) {
            for (int i = 0; i < settingsNode.getChildNodes().getLength(); ++i) {
                Node node = settingsNode.getChildNodes().item(i);
                if (node.getNodeName().equalsIgnoreCase("PagesRange")) {
                    settings.setPageRange(new StiPagesRange(node.getTextContent()));
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("Encoding")) {
                    settings.setEncoding(Charset.forName(node.getTextContent()));
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("DrawBorder")) {
                    settings.setDrawBorder(Boolean.valueOf(node.getTextContent()).booleanValue());
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("BorderType")) {
                    settings.setBorderType(StiTxtBorderType.valueOf((String)node.getTextContent()));
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("KillSpaceLines")) {
                    settings.setKillSpaceLines(Boolean.valueOf(node.getTextContent()).booleanValue());
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("KillSpaceGraphLines")) {
                    settings.setKillSpaceGraphLines(Boolean.valueOf(node.getTextContent()).booleanValue());
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("PutFeedPageCode")) {
                    settings.setPutFeedPageCode(Boolean.valueOf(node.getTextContent()).booleanValue());
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("CutLongLines")) {
                    settings.setCutLongLines(Boolean.valueOf(node.getTextContent()).booleanValue());
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("ZoomX")) {
                    settings.setZoomX((float)StiObjectConverter.ConvertToDouble((Object)node.getTextContent()));
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("ZoomY")) {
                    settings.setZoomY((float)StiObjectConverter.ConvertToDouble((Object)node.getTextContent()));
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("UseEscapeCodes")) {
                    settings.setUseEscapeCodes(Boolean.valueOf(node.getTextContent()).booleanValue());
                    continue;
                }
                if (!node.getNodeName().equalsIgnoreCase("EscapeCodesCollectionName")) continue;
                settings.setEscapeCodesCollectionName(node.getTextContent());
            }
        }
        return settings;
    }

    private static StiRtfExportSettings getRtfExportSettings(Node settingsNode) {
        StiRtfExportSettings settings = new StiRtfExportSettings();
        if (settingsNode != null) {
            for (int i = 0; i < settingsNode.getChildNodes().getLength(); ++i) {
                Node node = settingsNode.getChildNodes().item(i);
                if (node.getNodeName().equalsIgnoreCase("PagesRange")) {
                    settings.setPageRange(new StiPagesRange(node.getTextContent()));
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("CodePage")) {
                    settings.setCodePage(Integer.valueOf(node.getTextContent()).intValue());
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("ExportMode")) {
                    settings.setExportMode(StiRtfExportMode.valueOf((String)node.getTextContent()));
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("UsePageHeadersAndFooters")) {
                    settings.setUsePageHeadersAndFooters(Boolean.valueOf(node.getTextContent()).booleanValue());
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("ImageResolution")) {
                    settings.setImageResolution((float)StiObjectConverter.ConvertToDouble((Object)node.getTextContent()));
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("ImageQuality")) {
                    settings.setImageQuality((float)StiObjectConverter.ConvertToDouble((Object)node.getTextContent()));
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("RemoveEmptySpaceAtBottom")) {
                    settings.setRemoveEmptySpaceAtBottom(Boolean.valueOf(node.getTextContent()).booleanValue());
                    continue;
                }
                if (!node.getNodeName().equalsIgnoreCase("StoreImagesAsPng")) continue;
                settings.setStoreImagesAsPng(Boolean.valueOf(node.getTextContent()).booleanValue());
            }
        }
        return settings;
    }

    private static StiWordExportSettings getWord2007ExportSettings(Node settingsNode) {
        StiWordExportSettings settings = new StiWordExportSettings();
        if (settingsNode != null) {
            for (int i = 0; i < settingsNode.getChildNodes().getLength(); ++i) {
                Node node = settingsNode.getChildNodes().item(i);
                if (node.getNodeName().equalsIgnoreCase("PagesRange")) {
                    settings.setPageRange(new StiPagesRange(node.getTextContent()));
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("UsePageHeadersAndFooters")) {
                    settings.setUsePageHeadersAndFooters(Boolean.valueOf(node.getTextContent()).booleanValue());
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("ImageQuality")) {
                    settings.setImageQuality((float)StiObjectConverter.ConvertToDouble((Object)node.getTextContent()));
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("ImageResolution")) {
                    settings.setImageResolution((float)StiObjectConverter.ConvertToDouble((Object)node.getTextContent()));
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("RemoveEmptySpaceAtBottom")) {
                    settings.setRemoveEmptySpaceAtBottom(Boolean.valueOf(node.getTextContent()).booleanValue());
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("CompanyString")) {
                    settings.setCompanyString(node.getTextContent());
                    continue;
                }
                if (!node.getNodeName().equalsIgnoreCase("LastModifiedString")) continue;
                settings.setLastModifiedString(node.getTextContent());
            }
        }
        return settings;
    }

    private static StiExcelExportSettings getExcelExportSettings(Node settingsNode, StiExportFormat exportFormat) {
        StiExcelExportSettings settings = new StiExcelExportSettings(StiExcelType.Excel2007);
        if (settingsNode != null) {
            for (int i = 0; i < settingsNode.getChildNodes().getLength(); ++i) {
                Node node = settingsNode.getChildNodes().item(i);
                if (node.getNodeName().equalsIgnoreCase("PagesRange")) {
                    settings.setPageRange(new StiPagesRange(node.getTextContent()));
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("ExcelType")) {
                    settings.setExcelType(StiExcelType.valueOf((String)node.getTextContent()));
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("UseOnePageHeaderAndFooter")) {
                    settings.setUseOnePageHeaderAndFooter(Boolean.valueOf(node.getTextContent()).booleanValue());
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("ExportDataOnly")) {
                    settings.setExportDataOnly(Boolean.valueOf(node.getTextContent()).booleanValue());
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("ExportPageBreaks")) {
                    settings.setExportPageBreaks(Boolean.valueOf(node.getTextContent()).booleanValue());
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("ExportObjectFormatting")) {
                    settings.setExportObjectFormatting(Boolean.valueOf(node.getTextContent()).booleanValue());
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("ExportEachPageToSheet")) {
                    settings.setExportEachPageToSheet(Boolean.valueOf(node.getTextContent()).booleanValue());
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("ImageQuality")) {
                    settings.setImageQuality((float)StiObjectConverter.ConvertToDouble((Object)node.getTextContent()));
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("ImageResolution")) {
                    settings.setImageResolution((float)StiObjectConverter.ConvertToDouble((Object)node.getTextContent()));
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("CompanyString")) {
                    settings.setCompanyString(node.getTextContent());
                    continue;
                }
                if (!node.getNodeName().equalsIgnoreCase("LastModifiedString")) continue;
                settings.setLastModifiedString(node.getTextContent());
            }
        }
        return settings;
    }

    private static StiOdtExportSettings getOdtExportSettings(Node settingsNode, StiExportFormat exportFormat) {
        StiOdtExportSettings settings = new StiOdtExportSettings();
        if (settingsNode != null) {
            for (int i = 0; i < settingsNode.getChildNodes().getLength(); ++i) {
                Node node = settingsNode.getChildNodes().item(i);
                if (node.getNodeName().equalsIgnoreCase("PagesRange")) {
                    settings.setPageRange(new StiPagesRange(node.getTextContent()));
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("ImageQuality")) {
                    settings.setImageQuality((float)StiObjectConverter.ConvertToDouble((Object)node.getTextContent()));
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("ImageResolution")) {
                    settings.setImageResolution((float)StiObjectConverter.ConvertToDouble((Object)node.getTextContent()));
                    continue;
                }
                if (!node.getNodeName().equalsIgnoreCase("RemoveEmptySpaceAtBottom")) continue;
                settings.setRemoveEmptySpaceAtBottom(Boolean.valueOf(node.getTextContent()).booleanValue());
            }
        }
        return settings;
    }

    private static StiOdsExportSettings getOdsExportSettings(Node settingsNode, StiExportFormat exportFormat) {
        StiOdsExportSettings settings = new StiOdsExportSettings();
        if (settingsNode != null) {
            for (int i = 0; i < settingsNode.getChildNodes().getLength(); ++i) {
                Node node = settingsNode.getChildNodes().item(i);
                if (node.getNodeName().equalsIgnoreCase("PagesRange")) {
                    settings.setPageRange(new StiPagesRange(node.getTextContent()));
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("ImageQuality")) {
                    settings.setImageQuality((float)StiObjectConverter.ConvertToDouble((Object)node.getTextContent()));
                    continue;
                }
                if (!node.getNodeName().equalsIgnoreCase("ImageResolution")) continue;
                settings.setImageResolution((float)StiObjectConverter.ConvertToDouble((Object)node.getTextContent()));
            }
        }
        return settings;
    }

    private static StiDataExportSettings getDataExportSettings(Node settingsNode) {
        StiDataExportSettings settings = new StiDataExportSettings();
        if (settingsNode != null) {
            for (int i = 0; i < settingsNode.getChildNodes().getLength(); ++i) {
                Node node = settingsNode.getChildNodes().item(i);
                if (node.getNodeName().equalsIgnoreCase("PagesRange")) {
                    settings.setPageRange(new StiPagesRange(node.getTextContent()));
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("DataType")) {
                    settings.setDataType(StiDataType.valueOf((String)node.getTextContent()));
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("DataExportMode")) {
                    settings.setDataExportMode(StiDataExportMode.valueOf((String)node.getTextContent()));
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("Encoding")) {
                    settings.setEncoding(Charset.forName(node.getTextContent()));
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("ExportDataOnly")) {
                    settings.setExportDataOnly(Boolean.valueOf(node.getTextContent()).booleanValue());
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("Separator")) {
                    settings.setSeparator(node.getTextContent());
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("SkipColumnHeaders")) {
                    settings.setSkipColumnHeaders(Boolean.valueOf(node.getTextContent()).booleanValue());
                    continue;
                }
                if (!node.getNodeName().equalsIgnoreCase("UseDefaultSystemEncoding")) continue;
                settings.setUseDefaultSystemEncoding(Boolean.valueOf(node.getTextContent()).booleanValue());
            }
        }
        return settings;
    }

    private static StiImageExportSettings getImageExportSettings(Node settingsNode) {
        StiImageExportSettings settings = new StiImageExportSettings();
        if (settingsNode != null) {
            for (int i = 0; i < settingsNode.getChildNodes().getLength(); ++i) {
                Node node = settingsNode.getChildNodes().item(i);
                if (node.getNodeName().equalsIgnoreCase("PagesRange")) {
                    settings.setPageRange(new StiPagesRange(node.getTextContent()));
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("ImageType")) {
                    settings.setImageType(StiImageType.valueOf((String)node.getTextContent()));
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("ImageZoom")) {
                    settings.setImageZoom(StiObjectConverter.ConvertToDouble((Object)node.getTextContent()));
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("ImageResolution")) {
                    settings.setImageResolution(Integer.valueOf(node.getTextContent()).intValue());
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("CutEdges")) {
                    settings.setCutEdges(Boolean.valueOf(node.getTextContent()).booleanValue());
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("ImageFormat")) {
                    settings.setImageFormat(StiColorImageFormat.valueOf((String)node.getTextContent()));
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("MultipleFiles")) {
                    settings.setMultipleFiles(Boolean.valueOf(node.getTextContent()).booleanValue());
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("DitheringType")) {
                    settings.setDitheringType(StiMonochromeDitheringType.valueOf((String)node.getTextContent()));
                    continue;
                }
                if (!node.getNodeName().equalsIgnoreCase("TiffCompressionScheme")) continue;
            }
        }
        return settings;
    }
}

