/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.web.taglib.base;

import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.web.taglib.base.StiBaseTag;
import com.stimulsoft.web.utils.StiConstants;
import java.io.ByteArrayOutputStream;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;

public class StiBaseStiTag
extends StiBaseTag {
    private static final long serialVersionUID = 7966197609409332244L;
    private static final String ATTRIBUTE = "&{0}={1}";
    private static final String ATTRIBUTE_STR = "&{0}";
    private static final String REPORT = "?{0}={1}";
    private static final String MORE_THAN_ONE_SOURCE = "Two sources of report variables are specified, variableMap & variableStr. Only one must be left!";
    private static final String ATTRIBUTE_NOT_FOUND = "Attribute with name ''{0}'' not found.";
    private static final String ATTRIBUTE_NOT_MAP = "Attribute with name ''{0}'' is ''{1}'', but must implement interface Map. ";
    public static final String CUSTOM_PROPERTIES_PARAM = "properties";
    private String report;
    private String variableMap;
    private String variableStr;
    private String resourceKey;
    private Properties properties;
    private String globalization;

    @Override
    public void release() {
        super.release();
        this.report = null;
        this.variableMap = null;
        this.variableStr = null;
    }

    protected String generateHref() {
        this.valid();
        String src = this.getResource() + this.getReport() + this.getVariable();
        src = this.getPropertiesUrl(src);
        return src;
    }

    private String getPropertiesUrl(String src) {
        if (this.properties != null && !this.properties.isEmpty()) {
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                this.properties.store(bos, "");
                bos.close();
                return src + (StiValidationUtil.isNotEmpty((String)src) && src.contains("?") ? "&" : "?") + CUSTOM_PROPERTIES_PARAM + "=" + URLEncoder.encode(new String(bos.toByteArray(), "UTF-8"), "UTF-8");
            }
            catch (Exception e) {
                e.printStackTrace();
                return "";
            }
        }
        return src;
    }

    private String getVariable() {
        return StiValidationUtil.isNotBlank((String)this.report) ? this.prepareVariables() : "";
    }

    private String getReport() {
        return StiValidationUtil.isNotBlank((String)this.report) ? MessageFormat.format(REPORT, StiConstants.STIMULSOFT_REPORT_KEY.value, this.report) : "";
    }

    private String getResource() {
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        return request.getContextPath() + "/" + this.resourceKey;
    }

    private void valid() {
        if (this.variableMap != null && this.variableStr != null) {
            throw new IllegalArgumentException(MORE_THAN_ONE_SOURCE);
        }
        if (StiValidationUtil.isNotBlank((String)this.report) && StiValidationUtil.isNotBlank((String)this.variableMap)) {
            Object findAttribute = this.pageContext.findAttribute(this.variableMap);
            if (findAttribute == null) {
                throw new IllegalArgumentException(MessageFormat.format(ATTRIBUTE_NOT_FOUND, this.variableMap));
            }
            if (!(findAttribute instanceof Map)) {
                throw new IllegalArgumentException(MessageFormat.format(ATTRIBUTE_NOT_MAP, this.variableMap, findAttribute.getClass().toString()));
            }
        }
    }

    private String prepareVariables() {
        String result = "";
        if (this.variableStr != null) {
            result = MessageFormat.format(ATTRIBUTE_STR, this.variableStr);
        } else if (this.variableMap != null) {
            result = this.createVariableFromMap();
        }
        return result;
    }

    private String createVariableFromMap() {
        Map<String, String> map = this.findMap();
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> pair : map.entrySet()) {
            sb.append(MessageFormat.format(ATTRIBUTE, pair.getKey(), pair.getValue()));
        }
        if (StiValidationUtil.isNotEmpty((String)this.globalization)) {
            sb.append(MessageFormat.format(ATTRIBUTE, "globalization", this.globalization));
        }
        return sb.toString();
    }

    private Map<String, String> findMap() {
        return (Map)this.pageContext.findAttribute(this.variableMap);
    }

    protected void setResourceKey(String resourceKey) {
        this.resourceKey = resourceKey;
    }

    public String getVariableMap() {
        return this.variableMap;
    }

    public void setVariableMap(String variableMap) {
        this.variableMap = variableMap;
    }

    public String getVariableStr() {
        return this.variableStr;
    }

    public void setVariableStr(String variableStr) {
        this.variableStr = variableStr;
    }

    public void setReport(String report) {
        this.report = report;
    }

    public void setGlobalization(String globalization) {
        this.globalization = globalization;
    }

    public String getGlobalization() {
        return this.globalization;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }
}

