/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.web.helper;

import com.stimulsoft.base.utils.StiLoggingUtil;
import com.stimulsoft.base.utils.StiResourceUtil;
import com.stimulsoft.lib.base64.StiBase64EncoderUtil;
import com.stimulsoft.web.helper.StiWebResource;
import com.stimulsoft.web.servlet.StiWebResourceServletHelper;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class StiWebResourceHelper {
    private static HashMap<String, HashMap<String, String>> IMAGES = new HashMap();

    public static void getResources(Class<?> resourceClass, String component, String path, String url, String themeName, String subPath, HashMap<String, String> result) throws URISyntaxException, UnsupportedEncodingException, IOException {
        URL dirURL;
        Class<?> clazz = resourceClass;
        String subRes = "";
        String subScr = "";
        if (subPath != null) {
            path = path + (path.endsWith("/") ? "" : "/") + subPath;
            subRes = subRes + subPath + ".";
            subScr = subScr + subPath + "/";
        }
        if ((dirURL = clazz.getClassLoader().getResource(path)) != null && dirURL.getProtocol().equals("file")) {
            for (String filename : new File(dirURL.toURI()).list()) {
                if (filename.indexOf(46) < 0) {
                    StiWebResourceHelper.getResources(resourceClass, component, path, url, themeName, filename, result);
                    continue;
                }
                result.put(path + "/" + (String)filename, StiWebResourceHelper.getWebResourceUrl(url, component, "/Images/" + themeName + "/" + subScr + (String)filename));
            }
        }
        if (dirURL == null) {
            String me = clazz.getName().replace(".", "/") + ".class";
            dirURL = clazz.getClassLoader().getResource(me);
        }
        if (dirURL.getProtocol().endsWith("jar")) {
            String dirUrlPath = dirURL.getPath();
            String jarPath = dirUrlPath.substring(dirUrlPath.indexOf(":") + 1, dirUrlPath.indexOf("!"));
            JarFile jar = new JarFile(URLDecoder.decode(jarPath, "UTF-8"));
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                String name = entries.nextElement().getName();
                if (!name.startsWith(path)) continue;
                String entry = name;
                result.put(entry, StiWebResourceHelper.getWebResourceUrl(url, component, "/Images/" + themeName + "/" + entry));
            }
            jar.close();
        }
        if (result.size() == 0) {
            for (String key : StiWebResource.S.keySet()) {
                if (!key.startsWith(path)) continue;
                result.put(key, StiWebResourceHelper.getWebResourceUrl(url, component, "/Images/" + themeName + "/" + key));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getWebResourceUrl(String url, String component, String resourceName, String themeName) {
        String newResourceName = resourceName.replace("Images/", "Themes/" + themeName + "/Images/");
        InputStream is = StiResourceUtil.getStream((String)newResourceName);
        if (is != null) {
            try {
                String string = StiWebResourceHelper.getWebResourceUrl(url, component, newResourceName);
                return string;
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return StiWebResourceHelper.getWebResourceUrl(url, component, resourceName);
    }

    public static String getWebResourceUrl(String url, String component, String resourceName) {
        return url + "/" + StiWebResourceServletHelper.RESOURCE_SERVLET_MAPPING + StiWebResourceServletHelper.VERSION + "/" + component + resourceName;
    }

    public static HashMap<String, String> getImages(Class<?> resourceClass, String component, String path, String url, String themeName, boolean imagesInHTML) throws IOException {
        if (!IMAGES.containsValue(component)) {
            try {
                HashMap<String, String> result = new HashMap<String, String>();
                HashMap<String, String> images = new HashMap<String, String>();
                StiWebResourceHelper.getResources(resourceClass, component, path, url, themeName, null, result);
                for (String key : result.keySet()) {
                    if (key.endsWith("/")) continue;
                    try {
                        String skey = key.replaceAll(path + "/", "").replaceAll(path, "").replaceAll("/", ".");
                        key = key.replaceAll("//", "/");
                        if (imagesInHTML) {
                            ByteArrayOutputStream bos = new ByteArrayOutputStream();
                            StiBase64EncoderUtil.encode((InputStream)StiResourceUtil.getStream((String)("/" + key)), (OutputStream)bos);
                            images.put(skey, "data:image/" + skey.substring(skey.length() - 3) + ";base64," + new String(bos.toByteArray()));
                            continue;
                        }
                        images.put(skey, StiWebResourceHelper.getWebResourceUrl(url, component, key.replaceFirst(component, "")));
                    }
                    catch (Exception e) {
                        StiLoggingUtil.showWarning((String)("Unable to load stream: " + key), (Exception)e);
                    }
                }
                IMAGES.put(component, images);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return IMAGES.get(component);
    }
}

