/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.web.classes;

import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.utils.StiLoggingUtil;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.enums.StiExportFormat;
import com.stimulsoft.report.enums.StiHtmlChartType;
import com.stimulsoft.web.enums.StiAction;
import com.stimulsoft.web.enums.StiComponentType;
import com.stimulsoft.web.enums.StiDesignerCommand;
import com.stimulsoft.web.enums.StiPrintAction;
import com.stimulsoft.web.enums.StiReportDisplayMode;
import com.stimulsoft.web.enums.StiReportType;
import com.stimulsoft.web.enums.StiWebViewMode;
import com.stimulsoft.web.helper.StiCacheHelper;
import com.stimulsoft.web.proxyee.StiHttpServletRequest;
import com.stimulsoft.web.proxyee.StiHttpServletResponse;
import java.util.ArrayList;
import java.util.HashMap;

public class StiRequestParams {
    public HashMap<String, Object> all = new HashMap();
    public StiComponentType component;
    public StiAction action;
    public String resource;
    public byte[] data;
    public StiHttpServletRequest httpContext;
    public StiHttpServletResponse response;
    public StiReport report;
    public String id;
    public boolean hasParameters = false;
    public StiCacheParams cache;
    public StiInteractionParams interaction;
    public HashMap<String, Object> routes;
    public HashMap<String, String> formValues;
    public HashMap<String, String> exportSettings;
    public StiExportFormat exportFormat;
    public String localization = "default";
    public String theme;
    public String version = "";
    public StiViewerParams viewer;
    public StiDesignerParams designer;
    public StiDictionaryParams dictionary;
    public StiServerParams server;
    public boolean cloudMode = false;
    public HashMap<String, String> reportResourceParams = new HashMap();

    public String getString(String name) {
        if (this.all == null || !this.all.containsKey(name) || this.all.get(name) == null) {
            return null;
        }
        return String.valueOf(this.all.get(name));
    }

    public boolean getBoolean(String name) {
        return this.getString(name) != null ? Boolean.parseBoolean(this.getString(name).toLowerCase()) : false;
    }

    public int getInt(String name) {
        try {
            String str = this.getString(name);
            return Integer.parseInt(str != null ? str : "0");
        }
        catch (Exception e) {
            if (StiLoggingUtil.getLogLevel() >= 10) {
                e.printStackTrace();
            }
            return 0;
        }
    }

    public double getDouble(String name) {
        try {
            String str = this.getString(name);
            return Double.parseDouble(str != null ? str : "0");
        }
        catch (Exception e) {
            if (StiLoggingUtil.getLogLevel() >= 10) {
                e.printStackTrace();
            }
            return 0.0;
        }
    }

    public HashMap<String, String> getHashtable(String name) throws JSONException {
        if (!this.all.containsKey(name) || this.all.get(name) == null) {
            return null;
        }
        return this.all.get(name) instanceof HashMap ? (HashMap)this.all.get(name) : new HashMap();
    }

    public ArrayList<?> getArray(String name) throws JSONException {
        if (!this.all.containsKey(name) || this.all.get(name) == null) {
            return null;
        }
        return (ArrayList)this.all.get(name);
    }

    public <T extends Enum<T>> T getEnum(String name, Class<T> type, T def) {
        String value = this.getString(name);
        if (value == null || value.length() == 0) {
            return def;
        }
        try {
            return Enum.valueOf(type, value);
        }
        catch (Exception e) {
            try {
                return Enum.valueOf(type, value.substring(0, 1).toUpperCase() + value.substring(1));
            }
            catch (Exception e2) {
                return def;
            }
        }
    }

    public boolean contains(String name) {
        return this.all.containsKey(name);
    }

    public StiRequestParams() {
        this.cache = new StiCacheParams();
        this.interaction = new StiInteractionParams();
        this.routes = new HashMap();
        this.formValues = new HashMap();
        this.exportSettings = new HashMap();
        this.viewer = new StiViewerParams();
        this.designer = new StiDesignerParams();
        this.dictionary = new StiDictionaryParams();
        this.server = new StiServerParams();
    }

    public class StiServerParams {
        public boolean useRelativeUrls = true;
        public boolean useCompression = false;
        public boolean passQueryParametersForResources = true;
        public boolean passQueryParametersToReport = false;
    }

    public class StiDictionaryParams {
        public String connectionType;
        public String connectionString;
        public String query;
        public String userName;
        public String password;
        public String dataPath;
        public String schemaPath;
    }

    public class StiDesignerParams {
        public boolean isAutoSave = false;
        public boolean isNewReport = false;
        public boolean isSaveAs = false;
        public String fileName = null;
        public StiDesignerCommand command = StiDesignerCommand.Undefined;
        public String password = null;
        public String saveType;
        public int undoMaxLevel = 6;
        public boolean checkReportBeforePreview = true;
    }

    public class StiViewerParams {
        public int pageNumber;
        public double zoom = 1.0;
        public StiWebViewMode viewMode = StiWebViewMode.SinglePage;
        public boolean showBookmarks = true;
        public String openLinksWindow = "_blank";
        public StiHtmlChartType chartRenderType = StiHtmlChartType.AnimatedVector;
        public StiReportDisplayMode reportDisplayMode = StiReportDisplayMode.FromReport;
        public StiPrintAction printAction;
        public boolean bookmarksPrint = true;
        public String openingFileName;
        public String openingFilePassword;
        public boolean reportDesignerMode;
        public int dashboardWidth;
        public int dashboardHeight;
        public StiReportType reportType;
        public String elementName;
    }

    public class StiInteractionParams {
        public HashMap variables = new HashMap();
        public HashMap sorting = new HashMap();
        public HashMap collapsing = new HashMap();
        public ArrayList<HashMap<String, Object>> drillDown = new ArrayList();
        public HashMap editable = new HashMap();
    }

    public class StiCacheParams {
        public String clientGuid;
        public String drillDownGuid;
        public String mode = "ObjectSession";
        public Integer timeout = 20;
        public String priority = "Default";
        public boolean useLocalizedCache;
        public StiCacheHelper helper;
    }
}

