/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.viewer.requestfromuser.range;

import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.range.Range;
import com.stimulsoft.base.range.StringRange;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.dictionary.StiVariable;
import com.stimulsoft.report.dictionary.StiVariableItem;
import com.stimulsoft.report.dictionary.enums.StiVariableInitBy;
import com.stimulsoft.viewer.requestfromuser.StiDialogInfoRange;
import com.stimulsoft.viewer.requestfromuser.StiNewRequestFromUserDialogCreatingEventArgs;
import com.stimulsoft.viewer.requestfromuser.components.StiRequestLabel;
import com.stimulsoft.viewer.requestfromuser.components.StiRequestPanel;
import com.stimulsoft.viewer.requestfromuser.components.StiRequestTextField;
import com.stimulsoft.viewer.requestfromuser.controls.StiRequestFromUserDropDownButton;
import com.stimulsoft.viewer.requestfromuser.range.IStiRangeItemControl;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;

public class StiRangeStringItemControl
extends StiRequestPanel
implements IStiRangeItemControl {
    private static final long serialVersionUID = -6706183690815421537L;
    private StiRequestTextField textBoxTo;
    private StiRequestTextField textBoxFrom;
    private StiRequestLabel labelTo;
    private StiRequestLabel labelFrom;
    private StiRequestFromUserDropDownButton dropDownButton;

    public StiRangeStringItemControl(StiVariable variable, StiReport report) {
        Range range;
        this.setLayout(null);
        this.initializeComponent();
        this.labelFrom.setText(StiLocalization.getValue((String)"PropertyMain", (String)"RangeFrom"));
        this.labelTo.setText(StiLocalization.getValue((String)"PropertyMain", (String)"RangeTo"));
        this.locateComponents();
        List list = variable.getDialogInfoItems();
        ArrayList<StiDialogInfoRange> listRanges = new ArrayList<StiDialogInfoRange>();
        for (StiVariableItem item : list) {
            listRanges.add(new StiDialogInfoRange(item));
        }
        this.dropDownButton.setListRanges(listRanges);
        this.dropDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object object = ((JComboBox)e.getSource()).getSelectedItem();
                StiRangeStringItemControl.this.dropDownButtonItemChanged((StiDialogInfoRange)object);
            }
        });
        if (listRanges.size() == 0) {
            this.dropDownButton.setVisible(false);
        }
        if (!variable.getDialogInfo().getAllowUserValues()) {
            this.textBoxFrom.setEditable(false);
            this.textBoxTo.setEditable(false);
        }
        StiNewRequestFromUserDialogCreatingEventArgs arg = new StiNewRequestFromUserDialogCreatingEventArgs(variable, this.textBoxFrom.getWidth());
        this.textBoxFrom.setWidth(arg.getWidth());
        this.textBoxTo.setWidth(arg.getWidth());
        this.labelTo.setLeft(this.textBoxFrom.getRight() + 2);
        this.textBoxTo.setLeft(this.labelTo.getRight() + 2);
        if (this.dropDownButton.isVisible()) {
            this.dropDownButton.setLeft(this.textBoxTo.getRight() + 3);
        }
        this.setWidth(this.dropDownButton.isVisible() ? this.dropDownButton.getRight() + 2 : this.textBoxTo.getRight() + 2);
        Range range2 = range = variable.getValueObject() instanceof Range ? (Range)variable.getValueObject() : null;
        if (range != null) {
            this.textBoxFrom.setText(range.getFromObject().toString());
            this.textBoxTo.setText(range.getToObject().toString());
        } else {
            String rangeString = (String)variable.getValueObject();
            if (!StiValidationUtil.isNullOrEmpty((String)rangeString) && rangeString.contains("<<|>>") && variable.getInitBy() == StiVariableInitBy.Expression && range != null) {
                this.textBoxFrom.setText(range.getFromObject().toString());
                this.textBoxTo.setText(range.getToObject().toString());
            }
        }
    }

    @Override
    public Range getValue() {
        return new StringRange(this.textBoxFrom.getText(), this.textBoxTo.getText());
    }

    private void locateComponents() {
        this.textBoxFrom.setLeft(this.labelFrom.getRight() + 4);
        this.labelTo.setLeft(this.textBoxFrom.getRight() + 4);
        this.textBoxTo.setLeft(this.labelTo.getRight() + 4);
        this.dropDownButton.setLeft(this.textBoxTo.getRight() + 2);
        this.setWidth(this.dropDownButton.getRight() + 2);
    }

    private void dropDownButtonItemChanged(StiDialogInfoRange range) {
        if (range != null) {
            this.textBoxFrom.setText(range.getFrom().toString());
            this.textBoxTo.setText(range.getTo().toString());
        }
    }

    private void initializeComponent() {
        this.textBoxTo = new StiRequestTextField();
        this.textBoxFrom = new StiRequestTextField();
        this.labelTo = new StiRequestLabel("To");
        this.labelFrom = new StiRequestLabel("From");
        this.dropDownButton = new StiRequestFromUserDropDownButton();
        this.textBoxTo.setLocation(171, 0);
        this.textBoxTo.setName("textBoxTo");
        this.textBoxTo.setSize(100, 20);
        this.textBoxFrom.setLocation(39, 0);
        this.textBoxFrom.setName("textBoxFrom");
        this.textBoxFrom.setSize(100, 20);
        this.labelTo.setLocation(145, 4);
        this.labelTo.setName("labelTo");
        this.labelTo.setSize(20, 13);
        this.labelTo.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 2));
        this.labelFrom.setLocation(3, 4);
        this.labelFrom.setName("labelFrom");
        this.labelFrom.setSize(30, 13);
        this.dropDownButton.setHorizontalOffset(0);
        this.dropDownButton.setLocation(274, 0);
        this.dropDownButton.setName("dropDownButton");
        this.dropDownButton.setPopupHeight(200);
        this.dropDownButton.setPopupWidth(263);
        this.dropDownButton.setSize(20, 20);
        this.add(this.labelFrom);
        this.add(this.textBoxFrom);
        this.add(this.labelTo);
        this.add(this.textBoxTo);
        this.add((Component)((Object)this.dropDownButton));
        this.setName("StiRangeStringItemControl");
        this.setSize(310, 21);
    }
}

